/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab.internal;

import com.vladsch.flexmark.ext.gitlab.GitLabBlockQuote;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLabBlockQuoteParser
extends AbstractBlockParser {
    static Pattern GIT_LAB_BLOCK_START = Pattern.compile(">>>(\\s*$)");
    static Pattern GIT_LAB_BLOCK_END = Pattern.compile(">>>(\\s*$)");
    private final GitLabBlockQuote block = new GitLabBlockQuote();
    private BlockContent content = new BlockContent();
    private boolean hadClose = false;

    GitLabBlockQuoteParser(DataHolder options, BasedSequence openMarker, BasedSequence openTrailing) {
        this.block.setOpeningMarker(openMarker);
        this.block.setOpeningTrailing(openTrailing);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        BlockParser parser2;
        if (this.hadClose) {
            return BlockContinue.none();
        }
        int index = state.getIndex();
        BasedSequence line = state.getLineWithEOL();
        Matcher matcher = GIT_LAB_BLOCK_END.matcher((CharSequence)line.subSequence(index));
        if (!matcher.matches()) {
            return BlockContinue.atIndex(index);
        }
        Node lastChild = this.block.getLastChild();
        if (lastChild instanceof GitLabBlockQuote && (parser2 = state.getActiveBlockParser((Block)lastChild)) instanceof GitLabBlockQuoteParser && !((GitLabBlockQuoteParser)parser2).hadClose) {
            return BlockContinue.atIndex(index);
        }
        this.hadClose = true;
        this.block.setClosingMarker(state.getLine().subSequence(index, index + 3));
        this.block.setClosingTrailing(state.getLineWithEOL().subSequence(matcher.start(1), matcher.end(1)));
        return BlockContinue.atIndex(state.getLineEndIndex());
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setContent(this.content);
        this.block.setCharsFromContent();
        this.content = null;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final GitLabOptions options;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new GitLabOptions(options);
        }

        boolean haveBlockQuoteParser(ParserState state) {
            List<BlockParser> parsers = state.getActiveBlockParsers();
            int i = parsers.size();
            while (i-- > 0) {
                if (!(parsers.get(i) instanceof GitLabBlockQuoteParser)) continue;
                return true;
            }
            return false;
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence line;
            Matcher matcher;
            if ((this.options.nestedBlockQuotes || !this.haveBlockQuoteParser(state)) && (matcher = GIT_LAB_BLOCK_START.matcher(line = state.getLineWithEOL())).matches()) {
                return BlockStart.of(new GitLabBlockQuoteParser(state.getProperties(), line.subSequence(0, 3), line.subSequence(matcher.start(1), matcher.end(1)))).atIndex(state.getLineEndIndex());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

