/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.impl.YAMLKeyValueImpl;

public class YAMLKeyNavigationItem
implements NavigationItem {
    @NotNull
    private final Navigatable myNavigatable;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myName;
    @NotNull
    private final VirtualFile myFile;
    private final int myPosition;

    YAMLKeyNavigationItem(@NotNull Project project, @NotNull String name, @NotNull VirtualFile file, int position) {
        if (project == null) {
            YAMLKeyNavigationItem.$$$reportNull$$$0(0);
        }
        if (name == null) {
            YAMLKeyNavigationItem.$$$reportNull$$$0(1);
        }
        if (file == null) {
            YAMLKeyNavigationItem.$$$reportNull$$$0(2);
        }
        this.myNavigatable = PsiNavigationSupport.getInstance().createNavigatable(project, file, position);
        this.myProject = project;
        this.myName = name;
        this.myFile = file;
        this.myPosition = position;
    }

    public void navigate(boolean requestFocus) {
        this.myNavigatable.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            YAMLKeyNavigationItem.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            YAMLKeyNavigationItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            YAMLKeyNavigationItem.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String string = YAMLKeyNavigationItem.this.myName;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getLocationString() {
                String string = YAMLKeyNavigationItem.this.myFile.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon = YAMLKeyValueImpl.YAML_KEY_ICON;
                if (icon == null) {
                    1.$$$reportNull$$$0(2);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/yaml/navigation/YAMLKeyNavigationItem$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocationString";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YAMLKeyNavigationItem item = (YAMLKeyNavigationItem)o;
        return this.myPosition == item.myPosition && this.myName.equals(item.myName) && this.myFile.equals(item.myFile);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myFile, this.myPosition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/navigation/YAMLKeyNavigationItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/navigation/YAMLKeyNavigationItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

