/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.impl.YamlMetaUtil;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public abstract class YamlUnknownValuesInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        if (holder == null) {
            YamlUnknownValuesInspectionBase.$$$reportNull$$$0(0);
        }
        if (metaTypeProvider == null) {
            YamlUnknownValuesInspectionBase.$$$reportNull$$$0(1);
        }
        return new ValuesChecker(holder, metaTypeProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "metaTypeProvider";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/yaml/meta/impl/YamlUnknownValuesInspectionBase";
        objectArray[2] = "doBuildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class ValuesChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        public ValuesChecker(@NotNull ProblemsHolder problemsHolder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            if (problemsHolder == null) {
                ValuesChecker.$$$reportNull$$$0(0);
            }
            if (metaTypeProvider == null) {
                ValuesChecker.$$$reportNull$$$0(1);
            }
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLSequenceItem(@NotNull YAMLSequenceItem item) {
            YAMLValue value;
            if (item == null) {
                ValuesChecker.$$$reportNull$$$0(2);
            }
            if ((value = item.getValue()) == null) {
                return;
            }
            if (value instanceof YAMLKeyValue || value instanceof YAMLMapping) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getValueMetaType(value);
            if (meta != null && meta.getField().hasRelationSpecificType(Field.Relation.SEQUENCE_ITEM)) {
                meta.getMetaType().validateValue(value, this.myProblemsHolder);
            }
        }

        @Override
        protected void visitYAMLKeyValue(@NotNull YAMLKeyValue keyValue) {
            if (keyValue == null) {
                ValuesChecker.$$$reportNull$$$0(3);
            }
            if (keyValue.getKey() == null) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getKeyValueMetaType(keyValue);
            if (meta == null) {
                return;
            }
            YAMLValue value = keyValue.getValue();
            if (value == null || YamlMetaUtil.isNull(value)) {
                this.validateEmptyValue(meta.getField(), keyValue);
                return;
            }
            this.validateMultiplicity(meta, value);
            meta.getMetaType().validateKey(keyValue, this.myProblemsHolder);
            if (value instanceof YAMLMapping || value instanceof YAMLSequence) {
                return;
            }
            meta.getMetaType().validateValue(value, this.myProblemsHolder);
        }

        @Override
        protected void visitYAMLMapping(@NotNull YAMLMapping mapping) {
            YamlMetaTypeProvider.MetaTypeProxy meta;
            if (mapping == null) {
                ValuesChecker.$$$reportNull$$$0(4);
            }
            if ((meta = this.myMetaTypeProvider.getValueMetaType(mapping)) != null) {
                meta.getMetaType().validateValue(mapping, this.myProblemsHolder);
            }
        }

        protected void validateMultiplicity(@NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull YAMLValue value) {
            if (meta == null) {
                ValuesChecker.$$$reportNull$$$0(5);
            }
            if (value == null) {
                ValuesChecker.$$$reportNull$$$0(6);
            }
            if (meta.getField().isMany()) {
                this.requireMultiplicityMany(meta, value);
            } else {
                this.requireMultiplicityOne(meta, value);
            }
        }

        protected void requireMultiplicityOne(@NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull YAMLValue value) {
            if (meta == null) {
                ValuesChecker.$$$reportNull$$$0(7);
            }
            if (value == null) {
                ValuesChecker.$$$reportNull$$$0(8);
            }
            if (meta.getField().hasRelationSpecificType(Field.Relation.SEQUENCE_ITEM)) {
                return;
            }
            if (value instanceof YAMLSequence) {
                for (YAMLSequenceItem next : ((YAMLSequence)value).getItems()) {
                    if (next.getValue() == null || !next.getKeysValues().isEmpty()) continue;
                    this.myProblemsHolder.registerProblem((PsiElement)next.getValue(), YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.not.allowed", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }

        protected void requireMultiplicityMany(@NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull YAMLValue value) {
            boolean actuallyOne;
            if (meta == null) {
                ValuesChecker.$$$reportNull$$$0(9);
            }
            if (value == null) {
                ValuesChecker.$$$reportNull$$$0(10);
            }
            if (meta.getField().hasRelationSpecificType(Field.Relation.OBJECT_CONTENTS)) {
                return;
            }
            boolean bl = actuallyOne = value instanceof YAMLScalar || value instanceof YAMLMapping && !meta.getField().isAnyNameAllowed();
            if (actuallyOne) {
                this.myProblemsHolder.registerProblem((PsiElement)value, YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.is.required", new Object[0]), new LocalQuickFix[0]);
            }
        }

        protected void validateEmptyValue(@NotNull Field feature, @NotNull YAMLKeyValue withoutValue) {
            if (feature == null) {
                ValuesChecker.$$$reportNull$$$0(11);
            }
            if (withoutValue == null) {
                ValuesChecker.$$$reportNull$$$0(12);
            }
            assert (withoutValue.getKey() != null);
            if (!feature.isEmptyValueAllowed()) {
                InspectionManager manager = this.myProblemsHolder.getManager();
                YAMLValue value = withoutValue.getValue();
                ProblemDescriptor eolError = manager.createProblemDescriptor((PsiElement)(value == null ? withoutValue.getKey() : value), YAMLBundle.message("YamlUnknownValuesInspectionBase.error.value.is.required", ArrayUtil.EMPTY_OBJECT_ARRAY), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myProblemsHolder.isOnTheFly(), value == null);
                this.myProblemsHolder.registerProblem(eolError);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metaTypeProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyValue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "feature";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "withoutValue";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlUnknownValuesInspectionBase$ValuesChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYAMLSequenceItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYAMLKeyValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYAMLMapping";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateMultiplicity";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requireMultiplicityOne";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requireMultiplicityMany";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateEmptyValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

