/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.intellij.collaboration.api.dto.GraphQLFragment;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.data.GHNode;
import org.jetbrains.plugins.github.api.data.GHRepositoryOwnerName;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.pullrequest.GHGitRefName;

@GraphQLFragment(filePath="/graphql/fragment/repository.graphql")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001Bp\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u000b\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\u000b\u0010\u0012\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\u0013R\u0018\u0010\u0014\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0016\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0016\u0010\u0012\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0016\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/github/api/data/GHRepository;", "Lorg/jetbrains/plugins/github/api/data/GHNode;", "id", "", "owner", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;", "nameWithOwner", "Lcom/intellij/openapi/util/NlsSafe;", "viewerPermission", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryPermissionLevel;", "mergeCommitAllowed", "", "squashMergeAllowed", "rebaseMergeAllowed", "defaultBranchRef", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHGitRefName;", "isFork", "url", "sshUrl", "(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;Ljava/lang/String;Lorg/jetbrains/plugins/github/api/data/GHRepositoryPermissionLevel;ZZZLorg/jetbrains/plugins/github/api/data/pullrequest/GHGitRefName;ZLjava/lang/String;Ljava/lang/String;)V", "defaultBranch", "getDefaultBranch", "()Ljava/lang/String;", "getDefaultBranchRef", "()Lorg/jetbrains/plugins/github/api/data/pullrequest/GHGitRefName;", "()Z", "getMergeCommitAllowed", "getNameWithOwner", "getOwner", "()Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;", "path", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "getPath", "()Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "getRebaseMergeAllowed", "getSquashMergeAllowed", "getSshUrl", "getUrl", "getViewerPermission", "()Lorg/jetbrains/plugins/github/api/data/GHRepositoryPermissionLevel;", "intellij.vcs.github"})
public final class GHRepository
extends GHNode {
    @NotNull
    private final GHRepositoryOwnerName owner;
    @NotNull
    private final String nameWithOwner;
    @Nullable
    private final GHRepositoryPermissionLevel viewerPermission;
    private final boolean mergeCommitAllowed;
    private final boolean squashMergeAllowed;
    private final boolean rebaseMergeAllowed;
    @Nullable
    private final GHGitRefName defaultBranchRef;
    private final boolean isFork;
    @NotNull
    private final String url;
    @NotNull
    private final String sshUrl;
    @NotNull
    private final GHRepositoryPath path;
    @Nullable
    private final String defaultBranch;

    public GHRepository(@NotNull String id, @NotNull GHRepositoryOwnerName owner, @NotNull String nameWithOwner, @Nullable GHRepositoryPermissionLevel viewerPermission, boolean mergeCommitAllowed, boolean squashMergeAllowed, boolean rebaseMergeAllowed, @Nullable GHGitRefName defaultBranchRef, boolean isFork, @NotNull String url, @NotNull String sshUrl) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)nameWithOwner, (String)"nameWithOwner");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)sshUrl, (String)"sshUrl");
        super(id);
        this.owner = owner;
        this.nameWithOwner = nameWithOwner;
        this.viewerPermission = viewerPermission;
        this.mergeCommitAllowed = mergeCommitAllowed;
        this.squashMergeAllowed = squashMergeAllowed;
        this.rebaseMergeAllowed = rebaseMergeAllowed;
        this.defaultBranchRef = defaultBranchRef;
        this.isFork = isFork;
        this.url = url;
        this.sshUrl = sshUrl;
        GHGitRefName gHGitRefName = this.defaultBranchRef;
        this.defaultBranch = gHGitRefName != null ? gHGitRefName.getName() : null;
        char[] cArray = new char[]{'/'};
        List split = StringsKt.split$default((CharSequence)this.nameWithOwner, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        this.path = new GHRepositoryPath((String)split.get(0), (String)split.get(1));
    }

    @NotNull
    public final GHRepositoryOwnerName getOwner() {
        return this.owner;
    }

    @NotNull
    public final String getNameWithOwner() {
        return this.nameWithOwner;
    }

    @Nullable
    public final GHRepositoryPermissionLevel getViewerPermission() {
        return this.viewerPermission;
    }

    public final boolean getMergeCommitAllowed() {
        return this.mergeCommitAllowed;
    }

    public final boolean getSquashMergeAllowed() {
        return this.squashMergeAllowed;
    }

    public final boolean getRebaseMergeAllowed() {
        return this.rebaseMergeAllowed;
    }

    @Nullable
    public final GHGitRefName getDefaultBranchRef() {
        return this.defaultBranchRef;
    }

    public final boolean isFork() {
        return this.isFork;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getSshUrl() {
        return this.sshUrl;
    }

    @NotNull
    public final GHRepositoryPath getPath() {
        return this.path;
    }

    @Nullable
    public final String getDefaultBranch() {
        return this.defaultBranch;
    }
}

