/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchType;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchesDashboardUtil;
import git4idea.ui.branch.dashboard.IncomingOutgoing;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0004J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0004J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u001f\u001a\u00020\u000fJ\u0014\u0010 \u001a\u0004\u0018\u00010\u001e*\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000f\u00a8\u0006!"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardUtil;", "", "()V", "checkIsMyBranchesSynchronously", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "log", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "branchesToCheck", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findExclusiveCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "branchName", "", "repo", "Lgit4idea/repo/GitRepository;", "findMyCommits", "", "getLocalBranches", "project", "Lcom/intellij/openapi/project/Project;", "rootsToFilter", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRemoteBranches", "isMyBranch", "", "myCommits", "anyIncomingOutgoingState", "Lgit4idea/ui/branch/dashboard/IncomingOutgoing;", "localBranchName", "getIncomingOutgoingState", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesDashboardUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardUtil.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n31#2,2:144\n31#2,2:156\n125#3:146\n152#3,2:147\n154#3:155\n125#3:158\n152#3,2:159\n154#3:164\n1747#4,3:149\n1747#4,3:152\n1747#4,3:161\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardUtil.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardUtil\n*L\n35#1:144,2\n55#1:156,2\n36#1:146\n36#1:147,2\n36#1:155\n56#1:158\n56#1:159,2\n56#1:164\n37#1:149,3\n38#1:152,3\n58#1:161,3\n*E\n"})
public final class BranchesDashboardUtil {
    @NotNull
    public static final BranchesDashboardUtil INSTANCE = new BranchesDashboardUtil();

    private BranchesDashboardUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getLocalBranches(@NotNull Project project, @Nullable Set<? extends VirtualFile> rootsToFilter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map localMap = new LinkedHashMap();
        for (GitRepository repo : GitRepositoryManager.getInstance(project).getRepositories()) {
            if (rootsToFilter != null && !rootsToFilter.contains(repo.getRoot())) continue;
            for (GitLocalBranch branch : repo.getBranches().getLocalBranches()) {
                Intrinsics.checkNotNull((Object)repo);
                localMap.computeIfAbsent(branch, arg_0 -> BranchesDashboardUtil.getLocalBranches$lambda$0(getLocalBranches.1.INSTANCE, arg_0)).add(repo);
            }
            GitLocalBranch currentBranch = repo.getCurrentBranch();
            if (currentBranch == null) continue;
            Intrinsics.checkNotNull((Object)repo);
            localMap.computeIfAbsent(currentBranch, arg_0 -> BranchesDashboardUtil.getLocalBranches$lambda$1(getLocalBranches.2.INSTANCE, arg_0)).add(repo);
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        Map $this$map$iv = localMap;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            boolean bl2;
            GitBranch gitBranch;
            boolean bl3;
            Set repos;
            GitBranch branch;
            Collection collection;
            block11: {
                GitRepository it;
                boolean bl4;
                Iterable $this$any$iv;
                boolean $i$f$any;
                block10: {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    branch = (GitBranch)entry.getKey();
                    repos = (Set)entry.getValue();
                    Iterable iterable = repos;
                    bl3 = true;
                    gitBranch = branch;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (GitRepository)element$iv;
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)branch)) continue;
                            bl4 = true;
                            break block10;
                        }
                        bl4 = false;
                    }
                }
                bl2 = bl4;
                $this$any$iv = repos;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (GitRepository)element$iv;
                        boolean bl7 = false;
                        if (!gitBranchManager.isFavorite(GitBranchType.LOCAL, it, branch.getName())) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            boolean bl8 = bl;
            Collection collection2 = repos;
            String string = branch.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            List list2 = CollectionsKt.toList((Iterable)repos);
            IncomingOutgoing incomingOutgoing = INSTANCE.anyIncomingOutgoingState(collection2, string);
            boolean bl9 = bl8;
            boolean bl10 = bl2;
            boolean bl11 = bl3;
            GitBranch gitBranch2 = gitBranch;
            collection.add(new BranchInfo(gitBranch2, bl11, bl10, bl9, incomingOutgoing, list2));
        }
        HashSet local = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        return local;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getRemoteBranches(@NotNull Project project, @Nullable Set<? extends VirtualFile> rootsToFilter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map remoteMap = new LinkedHashMap();
        for (GitRepository repo : GitRepositoryManager.getInstance(project).getRepositories()) {
            if (rootsToFilter != null && !rootsToFilter.contains(repo.getRoot())) continue;
            for (GitRemoteBranch remoteBranch : repo.getBranches().getRemoteBranches()) {
                Intrinsics.checkNotNull((Object)repo);
                remoteMap.computeIfAbsent(remoteBranch, arg_0 -> BranchesDashboardUtil.getRemoteBranches$lambda$5(getRemoteBranches.1.INSTANCE, arg_0)).add(repo);
            }
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Object serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        Map $this$map$iv = remoteMap;
        boolean $i$f$map = false;
        serviceClass$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            GitBranch gitBranch;
            boolean bl2;
            boolean bl3;
            List repos;
            Collection collection;
            block7: {
                void $this$any$iv;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                GitBranch branch = (GitBranch)entry.getKey();
                repos = (List)entry.getValue();
                Iterable iterable = repos;
                bl3 = false;
                bl2 = false;
                gitBranch = branch;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl5 = false;
                        if (!gitBranchManager.isFavorite(GitBranchType.REMOTE, it, branch.getName())) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            boolean bl6 = bl;
            List list2 = repos;
            IncomingOutgoing incomingOutgoing = null;
            boolean bl7 = bl6;
            boolean bl8 = bl3;
            boolean bl9 = bl2;
            GitBranch gitBranch2 = gitBranch;
            collection.add(new BranchInfo(gitBranch2, bl9, bl8, bl7, incomingOutgoing, list2));
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Set<BranchInfo> checkIsMyBranchesSynchronously(@NotNull VcsProjectLog log, @NotNull Collection<BranchInfo> branchesToCheck, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(branchesToCheck, (String)"branchesToCheck");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Set<Integer> myCommits = this.findMyCommits(log);
        if (myCommits.isEmpty()) {
            return SetsKt.emptySet();
        }
        indicator.setIndeterminate(false);
        HashSet<BranchInfo> myBranches = new HashSet<BranchInfo>();
        Iterator<BranchInfo> iterator = branchesToCheck.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int step = n++;
            BranchInfo branch = iterator.next();
            indicator.setFraction((double)step / (double)branchesToCheck.size());
            for (GitRepository repo : branch.getRepositories()) {
                indicator.checkCanceled();
                if (!this.isMyBranch(log, branch.getBranchName(), repo, myCommits)) continue;
                myBranches.add(branch);
            }
        }
        return myBranches;
    }

    @Nullable
    public final IncomingOutgoing anyIncomingOutgoingState(@NotNull Collection<? extends GitRepository> $this$anyIncomingOutgoingState, @NotNull String localBranchName) {
        Intrinsics.checkNotNullParameter($this$anyIncomingOutgoingState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)localBranchName, (String)"localBranchName");
        for (GitRepository gitRepository : $this$anyIncomingOutgoingState) {
            IncomingOutgoing incomingOutgoingState = this.getIncomingOutgoingState(gitRepository, localBranchName);
            if (incomingOutgoingState == null) continue;
            return incomingOutgoingState;
        }
        return null;
    }

    @Nullable
    public final IncomingOutgoing getIncomingOutgoingState(@NotNull GitRepository $this$getIncomingOutgoingState, @NotNull String localBranchName) {
        Intrinsics.checkNotNullParameter((Object)$this$getIncomingOutgoingState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)localBranchName, (String)"localBranchName");
        GitBranchIncomingOutgoingManager $this$getIncomingOutgoingState_u24lambda_u248 = GitBranchIncomingOutgoingManager.getInstance($this$getIncomingOutgoingState.getProject());
        boolean bl = false;
        GitRepository repo = $this$getIncomingOutgoingState;
        boolean hasIncoming = $this$getIncomingOutgoingState_u24lambda_u248.hasIncomingFor(repo, localBranchName);
        boolean hasOutgoing = $this$getIncomingOutgoingState_u24lambda_u248.hasOutgoingFor(repo, localBranchName);
        return hasIncoming && hasOutgoing ? IncomingOutgoing.INCOMING_AND_OUTGOING : (hasIncoming ? IncomingOutgoing.INCOMING : (hasOutgoing ? IncomingOutgoing.OUTGOING : null));
    }

    private final Set<Integer> findMyCommits(VcsProjectLog log) {
        Collection collection = CollectionsKt.listOf((Object)"*");
        VcsLogData vcsLogData = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData);
        VcsLogUserFilter filterByMe = VcsLogFilterObject.fromUserNames((Collection)collection, (VcsLogData)vcsLogData);
        VcsLogData vcsLogData2 = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData2);
        IndexDataGetter indexDataGetter = vcsLogData2.getIndex().getDataGetter();
        Intrinsics.checkNotNull((Object)indexDataGetter);
        IntSet intSet = indexDataGetter.filter(CollectionsKt.listOf((Object)filterByMe));
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"filter(...)");
        return (Set)intSet;
    }

    private final boolean isMyBranch(VcsProjectLog log, String branchName, GitRepository repo, Set<Integer> myCommits) {
        IntSet intSet = this.findExclusiveCommits(log, branchName, repo);
        if (intSet == null) {
            return false;
        }
        IntSet exclusiveCommits = intSet;
        if (exclusiveCommits.isEmpty()) {
            return false;
        }
        for (Integer commit : exclusiveCommits) {
            if (myCommits.contains(commit)) continue;
            return false;
        }
        return true;
    }

    private final IntSet findExclusiveCommits(VcsProjectLog log, String branchName, GitRepository repo) {
        VcsLogData vcsLogData = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData);
        DataPack dataPack = vcsLogData.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"getDataPack(...)");
        DataPack dataPack2 = dataPack;
        VirtualFile virtualFile = repo.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VcsRef vcsRef = DataPackUtilKt.findBranch((DataPack)dataPack2, (String)branchName, (VirtualFile)virtualFile);
        if (vcsRef == null) {
            return null;
        }
        VcsRef ref = vcsRef;
        if (!ref.getType().isBranch()) {
            return null;
        }
        RefsModel refsModel = dataPack2.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
        VcsLogData vcsLogData2 = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData2);
        VcsLogStorage vcsLogStorage = vcsLogData2.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getStorage(...)");
        return DataPackUtilKt.exclusiveCommits((DataPack)dataPack2, (VcsRef)ref, (RefsModel)refsModel, (VcsLogStorage)vcsLogStorage);
    }

    private static final Set getLocalBranches$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set getLocalBranches$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final List getRemoteBranches$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

