/*
 * Decompiled with CFR 0.152.
 */
package git4idea.pull;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitPullSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialogKt;
import git4idea.merge.dialog.CmdLabel;
import git4idea.merge.dialog.FlatComboBoxUI;
import git4idea.merge.dialog.GitOptionsPanel;
import git4idea.merge.dialog.GitOptionsPopupBuilder;
import git4idea.merge.dialog.OptionInfo;
import git4idea.pull.GitPullDialog;
import git4idea.pull.GitPullOption;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.ComboBoxWithAutoCompletion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u001f*\u0001J\u0018\u0000 g2\u00020\u0001:\u0001gB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ;\u0010-\u001a5\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f\u0012#\u0012!\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u0012\u0012\u0012\u0012\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u00130\u00050\u00100\u0010H\u0002J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nH\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\u0015H\u0014J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020\u0015H\u0002J\u0018\u00106\u001a\u0012\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b807H\u0002J\b\u00109\u001a\u00020\u0015H\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0002J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00110%H\u0002J\u0016\u0010<\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0%H\u0002J\b\u0010=\u001a\u000201H\u0014J\b\u0010>\u001a\u00020?H\u0014J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u0005H\u0014J/\u0010B\u001a!\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u0012\u0012\u0012\u0012\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u00130\u00050\u00102\u0006\u0010C\u001a\u00020\u000fH\u0002J\u0014\u0010D\u001a\u0004\u0018\u00010\u00112\b\u0010C\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010E\u001a\u00020FH\u0002J\u0012\u0010G\u001a\f0\u000b\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\bHH\u0002J\u001d\u0010I\u001a\u00020J2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020\u000bH\u0014J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001c2\u0006\u0010O\u001a\u00020\u001bH\u0002J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0002J\u0016\u0010Q\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nH\u0016J\n\u0010R\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\u0011H\u0002J\u0006\u0010T\u001a\u00020\u0013J\u0006\u0010U\u001a\u00020\u0011J\n\u0010V\u001a\u0004\u0018\u00010\u000fH\u0002J\u000b\u0010W\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0012J\u0006\u0010X\u001a\u00020\u0019J\u0010\u0010Y\u001a\u00020\u00192\u0006\u0010O\u001a\u00020\u001bH\u0002J\u0010\u0010Z\u001a\u00020\u00192\u0006\u0010O\u001a\u00020\u001bH\u0002J\b\u0010[\u001a\u00020?H\u0002J\u0010\u0010\\\u001a\u00020?2\u0006\u0010O\u001a\u00020\u001bH\u0002J\b\u0010]\u001a\u00020?H\u0002J\b\u0010^\u001a\u00020?H\u0002J\b\u0010_\u001a\u00020\u0019H\u0002J\b\u0010`\u001a\u00020?H\u0002J\b\u0010a\u001a\u00020?H\u0002J\b\u0010b\u001a\u00020?H\u0002J\b\u0010c\u001a\u00020?H\u0002J\n\u0010d\u001a\u0004\u0018\u00010AH\u0002J\n\u0010e\u001a\u0004\u0018\u00010AH\u0002J\n\u0010f\u001a\u0004\u0018\u00010AH\u0002R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\r\u001a5\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f\u0012#\u0012!\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u0012\u0012\u0012\u0012\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u00130\u00050\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001c0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010&\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00050'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010(\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006h"}, d2={"Lgit4idea/pull/GitPullDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "defaultRoot", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "branchField", "Lgit4idea/ui/ComboBoxWithAutoCompletion;", "", "kotlin.jvm.PlatformType", "branches", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "Lorg/jetbrains/annotations/NotNull;", "Lgit4idea/GitRemoteBranch;", "commandPanel", "Ljavax/swing/JPanel;", "fetchSupport", "Lgit4idea/fetch/GitFetchSupport;", "isNoVerifySupported", "", "optionInfos", "Lgit4idea/pull/GitPullOption;", "Lgit4idea/merge/dialog/OptionInfo;", "optionsPanel", "Lgit4idea/merge/dialog/GitOptionsPanel;", "panel", "popupBuilder", "Lgit4idea/merge/dialog/GitOptionsPopupBuilder;", "pullSettings", "Lgit4idea/config/GitPullSettings;", "remoteField", "Lcom/intellij/openapi/ui/ComboBox;", "repositories", "", "repositoryField", "selectedOptions", "", "getSelectedOptions", "()Ljava/util/Set;", "collectBranches", "createBranchField", "createBranchFieldPopupComponent", "content", "Ljavax/swing/JComponent;", "createCenterPanel", "createCmdLabel", "Lgit4idea/merge/dialog/CmdLabel;", "createCommandPanel", "createOptionsDropDown", "Lcom/intellij/ui/components/DropDownLink;", "Lorg/jetbrains/annotations/Nls;", "createPanel", "createPopupBuilder", "createRemoteField", "createRepoField", "createSouthPanel", "doOKAction", "", "doValidateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getBranchesInRepo", "repository", "getCurrentOrDefaultRemote", "getFetchActionShortcut", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "getFetchActionShortcutText", "Lcom/intellij/openapi/util/NlsSafe;", "getFetchTask", "git4idea/pull/GitPullDialog$getFetchTask$1", "remote", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;)Lgit4idea/pull/GitPullDialog$getFetchTask$1;", "getHelpId", "getOptionInfo", "option", "getOptions", "getPreferredFocusedComponent", "getRemote", "getRemoteBranches", "getSelectedBranch", "getSelectedRemote", "getSelectedRepository", "gitRoot", "isCommitAfterMerge", "isOptionEnabled", "isOptionSelected", "loadSettings", "optionChosen", "performFetch", "saveSettings", "showRootField", "updateBranchesField", "updateRemotesField", "updateTitle", "updateUi", "validateBranchField", "validateRemoteField", "validateRepositoryField", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitPullDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPullDialog.kt\ngit4idea/pull/GitPullDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,433:1\n31#2,2:434\n1603#3,9:436\n1855#3:445\n1856#3:447\n1612#3:448\n1271#3,2:449\n1285#3,4:451\n1045#3:455\n1477#3:456\n1502#3,3:457\n1505#3,3:467\n1549#3:471\n1620#3,3:472\n1726#3,3:475\n1#4:446\n1#4:470\n372#5,7:460\n*S KotlinDebug\n*F\n+ 1 GitPullDialog.kt\ngit4idea/pull/GitPullDialog\n*L\n66#1:434,2\n112#1:436,9\n112#1:445\n112#1:447\n112#1:448\n148#1:449,2\n148#1:451,4\n151#1:455\n152#1:456\n152#1:457,3\n152#1:467,3\n205#1:471\n205#1:472,3\n290#1:475,3\n112#1:446\n152#1:460,7\n*E\n"})
public final class GitPullDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<VirtualFile> roots;
    @NotNull
    private final VirtualFile defaultRoot;
    @NotNull
    private final Set<GitPullOption> selectedOptions;
    @NotNull
    private final GitFetchSupport fetchSupport;
    @NotNull
    private final GitPullSettings pullSettings;
    private final List<GitRepository> repositories;
    @NotNull
    private final Map<GitRepository, Map<GitRemote, List<GitRemoteBranch>>> branches;
    @NotNull
    private final Map<GitPullOption, OptionInfo<GitPullOption>> optionInfos;
    @NotNull
    private final GitOptionsPopupBuilder<GitPullOption> popupBuilder;
    @NotNull
    private final ComboBox<GitRepository> repositoryField;
    @NotNull
    private final ComboBox<GitRemote> remoteField;
    @NotNull
    private final ComboBoxWithAutoCompletion<String> branchField;
    @NotNull
    private final JPanel commandPanel;
    @NotNull
    private final GitOptionsPanel<GitPullOption> optionsPanel;
    @NotNull
    private final JPanel panel;
    private final boolean isNoVerifySupported;
    @NotNull
    private static final CustomShortcutSet FETCH_ACTION_SHORTCUT = SystemInfo.isMac ? new CustomShortcutSet(KeyStroke.getKeyStroke(82, 256)) : new CustomShortcutSet(KeyStroke.getKeyStroke(116, 128));

    public GitPullDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, @NotNull VirtualFile defaultRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)defaultRoot, (String)"defaultRoot");
        super(project);
        this.project = project;
        this.roots = roots;
        this.defaultRoot = defaultRoot;
        this.selectedOptions = new LinkedHashSet();
        GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"fetchSupport(...)");
        this.fetchSupport = gitFetchSupport;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitPullSettings> serviceClass$iv = GitPullSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.pullSettings = (GitPullSettings)object;
        this.repositories = DvcsUtil.sortRepositories((Collection)GitRepositoryManager.getInstance(this.project).getRepositories());
        this.branches = MapsKt.toMutableMap(this.collectBranches());
        this.optionInfos = new LinkedHashMap();
        this.popupBuilder = this.createPopupBuilder();
        this.repositoryField = this.createRepoField();
        this.remoteField = this.createRemoteField();
        this.branchField = this.createBranchField();
        this.commandPanel = this.createCommandPanel();
        this.optionsPanel = new GitOptionsPanel((Function1)new Function1<GitPullOption, Unit>((Object)this){

            public final void invoke(@NotNull GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                GitPullDialog.access$optionChosen((GitPullDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitPullOption, OptionInfo<GitPullOption>>((Object)this){

            @NotNull
            public final OptionInfo<GitPullOption> invoke(@NotNull GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitPullDialog.access$getOptionInfo((GitPullDialog)((Object)this.receiver), p0);
            }
        });
        this.panel = this.createPanel();
        this.isNoVerifySupported = GitVersionSpecialty.NO_VERIFY_SUPPORTED.existsIn(GitExecutableManager.getInstance().getVersion(this.project));
        this.updateTitle();
        this.setOKButtonText(GitBundle.message("pull.button", new Object[0]));
        this.loadSettings();
        this.updateRemotesField();
        this.setAutoAdjustable(false);
        this.init();
        this.getWindow().setMinimumSize((Dimension)new JBDimension(200, 60));
        this.updateUi();
        this.validate();
        this.pack();
    }

    @NotNull
    public final Set<GitPullOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return this.panel;
    }

    @NotNull
    public ComboBoxWithAutoCompletion<String> getPreferredFocusedComponent() {
        return this.branchField;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createSouthPanel(...)");
        return GitMergeDialogKt.createSouthPanelWithOptionsDropDown(jComponent, this.createOptionsDropDown());
    }

    @NotNull
    protected String getHelpId() {
        return "reference.VersionControl.Git.Pull";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray = new KFunction[]{new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateRepositoryField((GitPullDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateRemoteField((GitPullDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>((Object)this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateBranchField((GitPullDialog)((Object)this.receiver));
            }
        }};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KFunction it = (KFunction)element$iv$iv;
            boolean bl2 = false;
            if ((ValidationInfo)((Function0)it).invoke() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOKAction() {
        try {
            this.saveSettings();
        }
        finally {
            super.doOKAction();
        }
    }

    @NotNull
    public final VirtualFile gitRoot() {
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null || (gitRepository = gitRepository.getRoot()) == null) {
            throw new IllegalStateException("No selected repository found".toString());
        }
        return gitRepository;
    }

    @NotNull
    public final GitRemote getSelectedRemote() {
        GitRemote gitRemote = (GitRemote)this.remoteField.getItem();
        if (gitRemote == null) {
            throw new IllegalStateException("No selected remote found".toString());
        }
        return gitRemote;
    }

    @NotNull
    public final GitRemoteBranch getSelectedBranch() {
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null) {
            throw new IllegalStateException("No selected repository found".toString());
        }
        GitRepository repository = gitRepository;
        GitRemote remote = this.getSelectedRemote();
        String branchName = remote.getName() + "/" + this.branchField.getItem();
        GitRemoteBranch gitRemoteBranch = repository.getBranches().findRemoteBranch(branchName);
        if (gitRemoteBranch == null) {
            throw new IllegalStateException(("Unable to find remote branch: " + branchName).toString());
        }
        return gitRemoteBranch;
    }

    public final boolean isCommitAfterMerge() {
        return !this.selectedOptions.contains((Object)GitPullOption.NO_COMMIT);
    }

    private final GitRemote getRemote() {
        return (GitRemote)this.remoteField.getItem();
    }

    private final void loadSettings() {
        Collection collection = this.selectedOptions;
        Set<GitPullOption> set = this.pullSettings.getOptions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getOptions(...)");
        CollectionsKt.addAll((Collection)collection, (Iterable)set);
    }

    private final void saveSettings() {
        this.pullSettings.setOptions(this.selectedOptions);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, Map<GitRemote, List<GitRemoteBranch>>> collectBranches() {
        List<GitRepository> list2 = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories");
        Iterable $this$associateWith$iv = list2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void repository;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)repository);
            Map<GitRemote, List<GitRemoteBranch>> map3 = this.getBranchesInRepo((GitRepository)repository);
            map2.put(t, map3);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRemote, List<GitRemoteBranch>> getBranchesInRepo(GitRepository repository) {
        void $this$groupByTo$iv$iv;
        Collection<GitRemoteBranch> collection = repository.getBranches().getRemoteBranches();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemoteBranches(...)");
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        Iterable $this$groupBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GitRemoteBranch branch = (GitRemoteBranch)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)branch.getNameForRemoteOperations());
                branch = (GitRemoteBranch)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)branch.getNameForRemoteOperations())));
            }
        });
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GitRemoteBranch branch = (GitRemoteBranch)element$iv$iv;
            boolean bl = false;
            GitRemote key$iv$iv = branch.getRemote();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final ValidationInfo validateRepositoryField() {
        return this.getSelectedRepository() != null ? null : new ValidationInfo(GitBundle.message("pull.repository.not.selected.error", new Object[0]), (JComponent)this.repositoryField);
    }

    private final ValidationInfo validateRemoteField() {
        return this.getRemote() != null ? null : new ValidationInfo(GitBundle.message("pull.remote.not.selected", new Object[0]), (JComponent)this.remoteField);
    }

    private final ValidationInfo validateBranchField() {
        String string = GitBundle.message("pull.branch.not.selected.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return GitMergeDialogKt.validateBranchExists(this.branchField, string);
    }

    private final GitRepository getSelectedRepository() {
        return (GitRepository)this.repositoryField.getItem();
    }

    private final void updateRemotesField() {
        GitRepository repository = this.getSelectedRepository();
        ComboBoxModel comboBoxModel = this.remoteField.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<@[FlexibleNullability] git4idea.repo.GitRemote?>");
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        Object object = repository;
        if (object == null || (object = object.getRemotes()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            object = CollectionsKt.emptyList();
        }
        model.update((List)object);
        model.setSelectedItem((Object)this.getCurrentOrDefaultRemote(repository));
    }

    private final void updateBranchesField() {
        Object object;
        Object branchToSelect = (String)this.branchField.getItem();
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        GitRemote gitRemote = this.getRemote();
        if (gitRemote == null) {
            return;
        }
        GitRemote remote = gitRemote;
        List<String> list2 = GitBranchUtil.sortBranchNames((Collection<String>)this.getRemoteBranches(repository, remote));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"sortBranchNames(...)");
        List<String> branches2 = list2;
        ComboBoxModel comboBoxModel = this.branchField.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<@[FlexibleNullability] kotlin.String?>");
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        model.update(branches2);
        if (!(branchToSelect != null && branches2.contains(branchToSelect) || (object = repository.getCurrentBranch()) != null && (object = ((GitLocalBranch)object).findTrackedBranch(repository)) != null && (object = ((GitRemoteBranch)object).getNameForRemoteOperations()) != null)) {
            Object v5;
            block6: {
                Iterable iterable = branches2;
                for (Object t : iterable) {
                    String branch = (String)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)branch, (Object)repository.getCurrentBranchName())) continue;
                    v5 = t;
                    break block6;
                }
                v5 = null;
            }
            if ((object = (String)v5) == null) {
                object = branchToSelect = "";
            }
        }
        if (((CharSequence)branchToSelect).length() == 0) {
            this.startTrackingValidation();
        }
        this.branchField.setSelectedItem(branchToSelect);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getRemoteBranches(GitRepository repository, GitRemote remote) {
        List list2;
        Map<GitRemote, List<GitRemoteBranch>> map2 = this.branches.get(repository);
        if (map2 != null && (map2 = map2.get(remote)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)((Object)map2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getNameForRemoteOperations();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameForRemoteOperations(...)");
                collection.add(string);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final GitRemote getCurrentOrDefaultRemote(GitRepository repository) {
        Object object = repository;
        if (object == null || (object = object.getRemotes()) == null) {
            return null;
        }
        Object remotes = object;
        if (remotes.isEmpty()) {
            return null;
        }
        Object object2 = GitUtil.getTrackInfoForCurrentBranch(repository);
        if (object2 == null || (object2 = ((GitBranchTrackInfo)object2).getRemote()) == null) {
            object2 = GitUtil.getDefaultOrFirstRemote((Collection<GitRemote>)remotes);
        }
        return object2;
    }

    private final void optionChosen(GitPullOption option) {
        if (!this.selectedOptions.contains((Object)option)) {
            ((Collection)this.selectedOptions).add(option);
        } else {
            ((Collection)this.selectedOptions).remove((Object)option);
        }
        this.updateUi();
        this.validate();
        this.pack();
    }

    private final void performFetch() {
        if (this.fetchSupport.isFetchRunning()) {
            return;
        }
        GitRepository repository = this.getSelectedRepository();
        GitRemote remote = this.getRemote();
        if (repository == null || remote == null) {
            VcsNotifier.getInstance((Project)this.project).notifyError("git.fetch.error", GitBundle.message("pull.fetch.failed.notification.title", new Object[0]), GitBundle.message("pull.fetch.failed.notification.text", new Object[0]));
            return;
        }
        GitVcs.runInBackground(this.getFetchTask(repository, remote));
    }

    private final getFetchTask.1 getFetchTask(GitRepository repository, GitRemote remote) {
        Project project = this.project;
        String string = GitBundle.message("fetching", new Object[0]);
        return new Task.Backgroundable(this, repository, remote, project, string){
            final /* synthetic */ GitPullDialog this$0;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitRemote $remote;
            {
                this.this$0 = $receiver;
                this.$repository = $repository;
                this.$remote = $remote;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitPullDialog.access$getFetchSupport$p(this.this$0).fetch(this.$repository, this.$remote);
            }

            public void onSuccess() {
                GitPullDialog.access$getBranches$p(this.this$0).put(this.$repository, GitPullDialog.access$getBranchesInRepo(this.this$0, this.$repository));
                if (Intrinsics.areEqual((Object)GitPullDialog.access$getSelectedRepository(this.this$0), (Object)this.$repository) && Intrinsics.areEqual((Object)GitPullDialog.access$getRemote(this.this$0), (Object)this.$remote)) {
                    GitPullDialog.access$updateBranchesField(this.this$0);
                }
            }
        };
    }

    private final GitOptionsPopupBuilder<GitPullOption> createPopupBuilder() {
        String string = GitBundle.message("pull.options.modify.popup.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new GitOptionsPopupBuilder<GitPullOption>(this.project, string, (Function0)new Function0<List<? extends GitPullOption>>((Object)this){

            @NotNull
            public final List<GitPullOption> invoke() {
                return GitPullDialog.access$getOptions((GitPullDialog)((Object)this.receiver));
            }
        }, (Function1)new Function1<GitPullOption, OptionInfo<GitPullOption>>((Object)this){

            @NotNull
            public final OptionInfo<GitPullOption> invoke(@NotNull GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitPullDialog.access$getOptionInfo((GitPullDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitPullOption, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitPullDialog.access$isOptionSelected((GitPullDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitPullOption, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitPullDialog.access$isOptionEnabled((GitPullDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitPullOption, Unit>((Object)this){

            public final void invoke(@NotNull GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                GitPullDialog.access$optionChosen((GitPullDialog)((Object)this.receiver), p0);
            }
        }, null, 128, null);
    }

    private final boolean isOptionSelected(GitPullOption option) {
        return this.selectedOptions.contains((Object)option);
    }

    private final DropDownLink<String> createOptionsDropDown() {
        DropDownLink dropDownLink;
        DropDownLink $this$createOptionsDropDown_u24lambda_u246 = dropDownLink = new DropDownLink((Object)GitBundle.message("merge.options.modify", new Object[0]), (Function1)new Function1<DropDownLink<String>, JBPopup>(this){
            final /* synthetic */ GitPullDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final JBPopup invoke(@NotNull DropDownLink<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (JBPopup)GitPullDialog.access$getPopupBuilder$p(this.this$0).createPopup();
            }
        });
        boolean bl = false;
        $this$createOptionsDropDown_u24lambda_u246.setMnemonic(77);
        return dropDownLink;
    }

    private final OptionInfo<GitPullOption> getOptionInfo(GitPullOption option) {
        OptionInfo optionInfo = this.optionInfos.computeIfAbsent(option, arg_0 -> GitPullDialog.getOptionInfo$lambda$7((Function1)new Function1<GitPullOption, OptionInfo<GitPullOption>>(option){
            final /* synthetic */ GitPullOption $option;
            {
                this.$option = $option;
                super(1);
            }

            @NotNull
            public final OptionInfo<GitPullOption> invoke(@NotNull GitPullOption it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return new OptionInfo<GitPullOption>(this.$option, this.$option.getOption(), this.$option.getDescription());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optionInfo, (String)"computeIfAbsent(...)");
        return optionInfo;
    }

    private final List<GitPullOption> getOptions() {
        List list2;
        List $this$getOptions_u24lambda_u248 = list2 = ArraysKt.toMutableList((Object[])GitPullOption.values());
        boolean bl = false;
        if (!this.isNoVerifySupported) {
            $this$getOptions_u24lambda_u248.remove((Object)GitPullOption.NO_VERIFY);
        }
        return list2;
    }

    private final void updateUi() {
        this.optionsPanel.rerender(this.selectedOptions);
        this.panel.invalidate();
    }

    private final boolean isOptionEnabled(GitPullOption option) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.selectedOptions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GitPullOption it = (GitPullOption)((Object)element$iv);
                    boolean bl2 = false;
                    if (it.isOptionSuitable(option)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void updateTitle() {
        String string;
        GitRepository gitRepository = this.getSelectedRepository();
        String currentBranchName = gitRepository != null ? gitRepository.getCurrentBranchName() : null;
        Object[] objectArray = (Object[])currentBranchName;
        if (objectArray == null || objectArray.length() == 0) {
            string = GitBundle.message("pull.dialog.title", new Object[0]);
        } else {
            objectArray = new Object[]{currentBranchName};
            string = GitBundle.message("pull.dialog.with.branch.title", objectArray);
        }
        this.setTitle(string);
    }

    private final JPanel createPanel() {
        JPanel jPanel;
        JPanel $this$createPanel_u24lambda_u2410 = jPanel = new JPanel();
        boolean bl = false;
        $this$createPanel_u24lambda_u2410.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3), new AC().grow()));
        $this$createPanel_u24lambda_u2410.add((Component)this.commandPanel, new CC().growX());
        $this$createPanel_u24lambda_u2410.add((Component)this.optionsPanel, new CC().newline().width("100%").alignY("top"));
        return jPanel;
    }

    private final boolean showRootField() {
        return this.roots.size() > 1;
    }

    private final JPanel createCommandPanel() {
        AC aC;
        JPanel jPanel;
        JPanel $this$createCommandPanel_u24lambda_u2411 = jPanel = new JPanel();
        boolean bl = false;
        if (this.showRootField()) {
            var4_4 = new int[]{0, 3};
            aC = new AC().grow(100.0f, var4_4);
        } else {
            var4_4 = new int[]{2};
            aC = new AC().grow(100.0f, var4_4);
        }
        AC colConstraints = aC;
        $this$createCommandPanel_u24lambda_u2411.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("0").gridGap("0", "0").noVisualPadding(), colConstraints));
        if (this.showRootField()) {
            $this$createCommandPanel_u24lambda_u2411.add((Component)this.repositoryField, new CC().gapAfter("0").minWidth("115").growX());
        }
        $this$createCommandPanel_u24lambda_u2411.add((Component)this.createCmdLabel(), new CC().gapAfter("0").alignY("top").minWidth("85"));
        $this$createCommandPanel_u24lambda_u2411.add((Component)this.remoteField, new CC().alignY("top").minWidth("90"));
        $this$createCommandPanel_u24lambda_u2411.add((Component)((Object)this.branchField), new CC().alignY("top").minWidth("250").growX());
        return jPanel;
    }

    private final CmdLabel createCmdLabel() {
        return new CmdLabel("git pull", new Insets(1, this.showRootField() ? 0 : 1, 1, 0), (Dimension)new JBDimension(JBUI.scale((int)85), this.branchField.getPreferredSize().height, true));
    }

    private final ComboBox<GitRepository> createRepoField() {
        ComboBox<GitRepository> comboBox;
        List<GitRepository> list2 = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories");
        ComboBox<GitRepository> $this$createRepoField_u24lambda_u2413 = comboBox = GitMergeDialogKt.createRepositoryField(list2, this.defaultRoot);
        boolean bl = false;
        $this$createRepoField_u24lambda_u2413.addActionListener(arg_0 -> GitPullDialog.createRepoField$lambda$13$lambda$12(this, arg_0));
        return comboBox;
    }

    private final ComboBox<GitRemote> createRemoteField() {
        ComboBox comboBox;
        ComboBox $this$createRemoteField_u24lambda_u2416 = comboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel());
        boolean bl = false;
        $this$createRemoteField_u24lambda_u2416.setSwingPopup(false);
        $this$createRemoteField_u24lambda_u2416.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)HtmlChunk.text((String)GitBundle.message("util.remote.renderer.none", new Object[0])).italic().wrapWith(HtmlChunk.Element.html()).toString(), arg_0 -> GitPullDialog.createRemoteField$lambda$16$lambda$14(createRemoteField.1.1.INSTANCE, arg_0)));
        Insets insets = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), 0);
        String string = GitBundle.message("pull.branch.no.matching.remotes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createRemoteField_u24lambda_u2416.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(null, insets, string, null, 9, null)));
        $this$createRemoteField_u24lambda_u2416.setItem((Object)this.getCurrentOrDefaultRemote(this.getSelectedRepository()));
        $this$createRemoteField_u24lambda_u2416.addItemListener(arg_0 -> GitPullDialog.createRemoteField$lambda$16$lambda$15(this, arg_0));
        return comboBox;
    }

    private final ComboBoxWithAutoCompletion<String> createBranchField() {
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion;
        ComboBoxWithAutoCompletion<String> $this$createBranchField_u24lambda_u2417 = comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>((ComboBoxModel)new MutableCollectionComboBoxModel((List)new ArrayList()), this.project);
        boolean bl = false;
        $this$createBranchField_u24lambda_u2417.setPrototypeDisplayValue("origin/long-enough-branch-name");
        String string = GitBundle.message("pull.branch.field.placeholder", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createBranchField_u24lambda_u2417.setPlaceholder(string);
        new RefreshAction($this$createBranchField_u24lambda_u2417, this){
            final /* synthetic */ ComboBoxWithAutoCompletion<String> $this_apply;
            final /* synthetic */ GitPullDialog this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ComboPopup comboPopup = this.$this_apply.getPopup();
                if (comboPopup != null) {
                    comboPopup.hide();
                }
                GitPullDialog.access$performFetch(this.this$0);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(true);
            }
        }.registerCustomShortcutSet(this.getFetchActionShortcut(), (JComponent)((Object)$this$createBranchField_u24lambda_u2417));
        Insets insets = new Insets(1, 0, 1, 1);
        Insets insets2 = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), DarculaUIUtil.BW.get());
        String string2 = GitBundle.message("pull.branch.nothing.to.pull", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$createBranchField_u24lambda_u2417.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(insets, insets2, string2, (Function1<? super JComponent, ? extends JComponent>)((Function1)new Function1<JComponent, JPanel>((Object)this){

            @NotNull
            public final JPanel invoke(@NotNull JComponent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GitPullDialog.access$createBranchFieldPopupComponent((GitPullDialog)((Object)this.receiver), p0);
            }
        }))));
        return comboBoxWithAutoCompletion;
    }

    private final JPanel createBranchFieldPopupComponent(JComponent content) {
        JPanel jPanel;
        JPanel $this$createBranchFieldPopupComponent_u24lambda_u2418 = jPanel = new JPanel();
        boolean bl = false;
        $this$createBranchFieldPopupComponent_u24lambda_u2418.setLayout((LayoutManager)new MigLayout(new LC().insets("0")));
        $this$createBranchFieldPopupComponent_u24lambda_u2418.add((Component)content, new CC().width("100%"));
        Object[] objectArray = new Object[]{this.getFetchActionShortcutText()};
        JLabel jLabel = HintUtil.createAdComponent((String)GitBundle.message("pull.dialog.fetch.shortcuts.hint", objectArray), (Border)JBUI.CurrentTheme.BigPopup.advertiserBorder(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"createAdComponent(...)");
        JLabel hintLabel = jLabel;
        hintLabel.setPreferredSize((Dimension)JBDimension.create((Dimension)hintLabel.getPreferredSize(), (boolean)true).withHeight(17));
        $this$createBranchFieldPopupComponent_u24lambda_u2418.add((Component)hintLabel, new CC().newline().width("100%"));
        return jPanel;
    }

    private final ShortcutSet getFetchActionShortcut() {
        ShortcutSet shortcutSet = ActionManager.getInstance().getAction("Refresh").getShortcutSet();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getShortcutSet(...)");
        ShortcutSet refreshActionShortcut = shortcutSet;
        Shortcut[] shortcutArray = refreshActionShortcut.getShortcuts();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        if (!(((Object[])shortcutArray).length == 0)) {
            return refreshActionShortcut;
        }
        return (ShortcutSet)FETCH_ACTION_SHORTCUT;
    }

    private final String getFetchActionShortcutText() {
        String string = KeymapUtil.getPreferredShortcutText((Shortcut[])this.getFetchActionShortcut().getShortcuts());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPreferredShortcutText(...)");
        return string;
    }

    private static final OptionInfo getOptionInfo$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OptionInfo)$tmp0.invoke(p0);
    }

    private static final void createRepoField$lambda$13$lambda$12(GitPullDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.updateTitle();
        this$0.updateRemotesField();
    }

    private static final String createRemoteField$lambda$16$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void createRemoteField$lambda$16$lambda$15(GitPullDialog this$0, ItemEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (e.getStateChange() == 1) {
            this$0.updateBranchesField();
        }
    }

    public static final /* synthetic */ ValidationInfo access$validateRepositoryField(GitPullDialog $this) {
        return $this.validateRepositoryField();
    }

    public static final /* synthetic */ ValidationInfo access$validateRemoteField(GitPullDialog $this) {
        return $this.validateRemoteField();
    }

    public static final /* synthetic */ ValidationInfo access$validateBranchField(GitPullDialog $this) {
        return $this.validateBranchField();
    }

    public static final /* synthetic */ GitFetchSupport access$getFetchSupport$p(GitPullDialog $this) {
        return $this.fetchSupport;
    }

    public static final /* synthetic */ Map access$getBranches$p(GitPullDialog $this) {
        return $this.branches;
    }

    public static final /* synthetic */ Map access$getBranchesInRepo(GitPullDialog $this, GitRepository repository) {
        return $this.getBranchesInRepo(repository);
    }

    public static final /* synthetic */ GitRepository access$getSelectedRepository(GitPullDialog $this) {
        return $this.getSelectedRepository();
    }

    public static final /* synthetic */ GitRemote access$getRemote(GitPullDialog $this) {
        return $this.getRemote();
    }

    public static final /* synthetic */ void access$updateBranchesField(GitPullDialog $this) {
        $this.updateBranchesField();
    }

    public static final /* synthetic */ List access$getOptions(GitPullDialog $this) {
        return $this.getOptions();
    }

    public static final /* synthetic */ OptionInfo access$getOptionInfo(GitPullDialog $this, GitPullOption option) {
        return $this.getOptionInfo(option);
    }

    public static final /* synthetic */ boolean access$isOptionSelected(GitPullDialog $this, GitPullOption option) {
        return $this.isOptionSelected(option);
    }

    public static final /* synthetic */ boolean access$isOptionEnabled(GitPullDialog $this, GitPullOption option) {
        return $this.isOptionEnabled(option);
    }

    public static final /* synthetic */ void access$optionChosen(GitPullDialog $this, GitPullOption option) {
        $this.optionChosen(option);
    }

    public static final /* synthetic */ GitOptionsPopupBuilder access$getPopupBuilder$p(GitPullDialog $this) {
        return $this.popupBuilder;
    }

    public static final /* synthetic */ void access$performFetch(GitPullDialog $this) {
        $this.performFetch();
    }

    public static final /* synthetic */ JPanel access$createBranchFieldPopupComponent(GitPullDialog $this, JComponent content) {
        return $this.createBranchFieldPopupComponent(content);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/pull/GitPullDialog$Companion;", "", "()V", "FETCH_ACTION_SHORTCUT", "Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

