/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.util;

import java.util.concurrent.Callable;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public final class LazyValue<T> {
    private final Callable<T> myProvider;
    private final Object myLock = new Object();
    private volatile Pair<T, Throwable> myResult;

    public LazyValue(@NotNull Callable<T> provider) {
        this.myProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() throws Exception {
        Pair result2 = this.myResult;
        if (result2 != null) {
            return this.unpack(result2);
        }
        Object object = this.myLock;
        synchronized (object) {
            result2 = this.myResult;
            if (result2 == null) {
                try {
                    T value = this.myProvider.call();
                    result2 = new Pair(value, null);
                }
                catch (Throwable t) {
                    result2 = new Pair(null, (Object)t);
                }
                this.myResult = result2;
            }
        }
        return this.unpack(result2);
    }

    private T unpack(@NotNull Pair<T, Throwable> result2) throws Exception {
        if (result2.getSecond() != null) {
            if (result2.getSecond() instanceof Exception) {
                throw (Exception)result2.getSecond();
            }
            if (result2.getSecond() instanceof Error) {
                throw (Error)result2.getSecond();
            }
            throw new RuntimeException("Rethrowing unknown Throwable", (Throwable)result2.getSecond());
        }
        return (T)result2.getFirst();
    }
}

