/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JsonSchemaVersion {
    SCHEMA_4,
    SCHEMA_6,
    SCHEMA_7;

    private static final String ourSchemaV4Schema = "http://json-schema.org/draft-04/schema";
    private static final String ourSchemaV6Schema = "http://json-schema.org/draft-06/schema";
    private static final String ourSchemaV7Schema = "http://json-schema.org/draft-07/schema";
    private static final String ourSchemaOrgPrefix = "http://json-schema.org/";

    public String toString() {
        Object[] objectArray = new Object[1];
        objectArray[0] = switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SCHEMA_4 -> 4;
            case SCHEMA_6 -> 6;
            case SCHEMA_7 -> 7;
        };
        return JsonBundle.message("schema.of.version", objectArray);
    }

    @Nullable
    public static JsonSchemaVersion byId(@NotNull String id) {
        if (id == null) {
            JsonSchemaVersion.$$$reportNull$$$0(0);
        }
        if (((String)id).startsWith("https://")) {
            id = "http://" + ((String)id).substring("https://".length());
        }
        return switch (StringUtil.trimEnd((String)id, (char)'#')) {
            case ourSchemaV4Schema -> SCHEMA_4;
            case ourSchemaV6Schema -> SCHEMA_6;
            case ourSchemaV7Schema -> SCHEMA_7;
            default -> ((String)id).startsWith(ourSchemaOrgPrefix) ? SCHEMA_7 : null;
        };
    }

    public static boolean isSchemaSchemaId(@Nullable String id) {
        return id != null && JsonSchemaVersion.byId(id) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/jsonSchema/impl/JsonSchemaVersion", "byId"));
    }
}

