/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsSharedProjectSettings;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.vcs.VcsSymlinkResolver;
import com.intellij.vcsUtil.VcsRunnable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@ApiStatus.NonExtendable
public final class VcsUtil {
    private static final char[] ourCharsToBeChopped = new char[]{'/', '\\'};
    private static final Logger LOG = Logger.getInstance(VcsUtil.class);
    @NonNls
    public static final String MAX_VCS_LOADED_SIZE_KB = "idea.max.vcs.loaded.size.kb";
    private static final int ourMaxLoadedFileSize = VcsUtil.computeLoadedFileSize();
    private static final int MAX_COMMIT_MESSAGE_LENGTH = 50000;
    private static final int MAX_COMMIT_MESSAGE_LINES = 3000;
    @NonNls
    private static final String ANNO_ASPECT = "show.vcs.annotation.aspect.";

    public static int getMaxVcsLoadedFileSize() {
        return ourMaxLoadedFileSize;
    }

    private static int computeLoadedFileSize() {
        long result2 = PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
        try {
            String userLimitKb = System.getProperty(MAX_VCS_LOADED_SIZE_KB);
            if (userLimitKb != null) {
                result2 = (long)Integer.parseInt(userLimitKb) * 1024L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return (int)Math.min(result2, Integer.MAX_VALUE);
    }

    public static boolean isFileUnderVcs(Project project2, @NotNull @NonNls String file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(0);
        }
        return VcsUtil.getVcsFor(project2, VcsUtil.getFilePath(file, false)) != null;
    }

    public static boolean isFileUnderVcs(Project project2, @NotNull FilePath file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(1);
        }
        return VcsUtil.getVcsFor(project2, file) != null;
    }

    public static boolean isFileForVcs(@NotNull VirtualFile file, @NotNull Project project2, @Nullable AbstractVcs host) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(3);
        }
        return VcsUtil.getVcsFor(project2, file) == host;
    }

    public static boolean isFileForVcs(@NotNull FilePath path2, @NotNull Project project2, @Nullable AbstractVcs host) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(5);
        }
        return VcsUtil.getVcsFor(project2, path2) == host;
    }

    public static boolean isFileForVcs(@NotNull @NonNls String path2, Project project2, AbstractVcs host) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(6);
        }
        return VcsUtil.getVcsFor(project2, VcsUtil.getFilePath(path2, false)) == host;
    }

    @Nullable
    public static AbstractVcs getVcsFor(@NotNull Project project2, @NotNull FilePath filePath) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(8);
        }
        return VcsUtil.computeValue(project2, manager -> manager.getVcsFor(filePath));
    }

    @Nullable
    public static AbstractVcs getVcsFor(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(10);
        }
        return VcsUtil.computeValue(project2, manager -> manager.getVcsFor(file));
    }

    @Nullable
    public static AbstractVcs findVcsByKey(@NotNull Project project2, @NotNull VcsKey key2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(11);
        }
        if (key2 == null) {
            VcsUtil.$$$reportNull$$$0(12);
        }
        return ProjectLevelVcsManager.getInstance(project2).findVcsByName(key2.getName());
    }

    @Nullable
    public static AbstractVcs findVcs(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(13);
        }
        if ((project2 = e.getProject()) == null) {
            return null;
        }
        VcsKey key2 = (VcsKey)e.getData(VcsDataKeys.VCS);
        if (key2 == null) {
            return null;
        }
        return VcsUtil.findVcsByKey(project2, key2);
    }

    @Nullable
    public static VirtualFile getVcsRootFor(@NotNull Project project2, @Nullable FilePath filePath) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(14);
        }
        return VcsUtil.computeValue(project2, manager -> manager.getVcsRootFor(filePath));
    }

    @Nullable
    public static VirtualFile getVcsRootFor(@NotNull Project project2, @Nullable VirtualFile file) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(15);
        }
        return VcsUtil.computeValue(project2, manager -> manager.getVcsRootFor(file));
    }

    @Nullable
    private static <T> T computeValue(@NotNull Project project2, @NotNull Function<? super ProjectLevelVcsManager, ? extends T> provider2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(16);
        }
        if (provider2 == null) {
            VcsUtil.$$$reportNull$$$0(17);
        }
        return (T)ReadAction.compute(() -> {
            Object result2 = null;
            if (!project2.isDisposed()) {
                ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project2);
                result2 = manager != null ? provider2.apply(manager) : null;
            }
            return result2;
        });
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull @NonNls String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(18);
        }
        return (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByPath(path2.replace(File.separatorChar, '/')));
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull File file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(19);
        }
        return (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByIoFile(file));
    }

    @Nullable
    public static VirtualFile getVirtualFileWithRefresh(@Nullable File file) {
        if (file == null) {
            return null;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile result2 = lfs.findFileByIoFile(file);
        if (result2 == null) {
            result2 = lfs.refreshAndFindFileByIoFile(file);
        }
        return result2;
    }

    @NlsSafe
    public static String getFileContent(@NotNull @NonNls String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(20);
        }
        return (String)ReadAction.compute(() -> {
            VirtualFile vFile = VcsUtil.getVirtualFile(path2);
            assert (vFile != null);
            return FileDocumentManager.getInstance().getDocument(vFile).getText();
        });
    }

    public static byte @Nullable [] getFileByteContent(@NotNull File file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(21);
        }
        try {
            return FileUtil.loadFileBytes((File)file);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Deprecated
    @NotNull
    public static FilePath getFilePath(@NotNull @NonNls String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(22);
        }
        return VcsUtil.getFilePath(new File(path2));
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(23);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(file);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(24);
        }
        return filePath;
    }

    @Deprecated
    @NotNull
    public static FilePath getFilePath(@NotNull File file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(25);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(file);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(26);
        }
        return filePath;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull Path path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(27);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePath(path2, isDirectory);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(28);
        }
        return filePath;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull @NonNls String path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(29);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePath(path2, isDirectory);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(30);
        }
        return filePath;
    }

    @NotNull
    public static FilePath getFilePathOnNonLocal(@NotNull @NonNls String path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(31);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePathOnNonLocal(path2, isDirectory);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(32);
        }
        return filePath;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull File file, boolean isDirectory) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(33);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(file, isDirectory);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(34);
        }
        return filePath;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static FilePath getFilePathForDeletedFile(@NotNull @NonNls String path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(35);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePath(path2, isDirectory);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(36);
        }
        return filePath;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull @NonNls String name) {
        if (parent == null) {
            VcsUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            VcsUtil.$$$reportNull$$$0(38);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(parent, name);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(39);
        }
        return filePath;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull @NonNls String fileName, boolean isDirectory) {
        if (parent == null) {
            VcsUtil.$$$reportNull$$$0(40);
        }
        if (fileName == null) {
            VcsUtil.$$$reportNull$$$0(41);
        }
        FilePath filePath = VcsContextFactory.getInstance().createFilePath(parent, fileName, isDirectory);
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(42);
        }
        return filePath;
    }

    @Nullable
    public static Icon getIcon(@Nullable Project project2, @NotNull FilePath filePath) {
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(43);
        }
        if (project2 != null && project2.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile != null) {
            return IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)project2);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(filePath.getName());
        return fileType.getIcon();
    }

    public static boolean isChangeForFolder(Change change) {
        ContentRevision revB = change.getBeforeRevision();
        ContentRevision revA = change.getAfterRevision();
        return revA != null && revA.getFile().isDirectory() || revB != null && revB.getFile().isDirectory();
    }

    public static FilePath[] sortPathsFromOutermost(FilePath[] files2) {
        return VcsUtil.sortPaths(files2, 1);
    }

    private static FilePath[] sortPaths(FilePath[] files2, int sign) {
        Arrays.sort(files2, (file1, file2) -> sign * file1.getPath().compareTo(file2.getPath()));
        return files2;
    }

    @Nullable
    public static VirtualFile getOneVirtualFile(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(44);
        }
        return (files2 = VcsUtil.getVirtualFiles(e)).length != 1 ? null : files2[0];
    }

    public static VirtualFile @NotNull [] getVirtualFiles(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(45);
        }
        VirtualFile[] virtualFileArray = (files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null ? VirtualFile.EMPTY_ARRAY : files2;
        if (virtualFileArray == null) {
            VcsUtil.$$$reportNull$$$0(46);
        }
        return virtualFileArray;
    }

    @Deprecated(forRemoval=true)
    public static boolean runVcsProcessWithProgress(@NotNull VcsRunnable runnable, @NotNull @NlsContexts.ProgressTitle String progressTitle, boolean canBeCanceled, @Nullable Project project2) throws VcsException {
        if (runnable == null) {
            VcsUtil.$$$reportNull$$$0(47);
        }
        if (progressTitle == null) {
            VcsUtil.$$$reportNull$$$0(48);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Ref ex = new Ref();
            boolean result2 = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    runnable.run();
                }
                catch (VcsException e) {
                    ex.set((Object)e);
                }
            }, progressTitle, canBeCanceled, project2);
            if (!ex.isNull()) {
                throw (VcsException)ex.get();
            }
            return result2;
        }
        runnable.run();
        return true;
    }

    public static <T> T computeWithModalProgress(@Nullable Project project2, @NotNull @NlsContexts.DialogTitle String title2, boolean canBeCancelled, final @NotNull ThrowableConvertor<? super ProgressIndicator, T, ? extends VcsException> computable) throws VcsException {
        if (title2 == null) {
            VcsUtil.$$$reportNull$$$0(49);
        }
        if (computable == null) {
            VcsUtil.$$$reportNull$$$0(50);
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, VcsException>(project2, title2, canBeCancelled){

            protected T compute(@NotNull ProgressIndicator indicator) throws VcsException {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return computable.convert((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcsUtil/VcsUtil$1", "compute"));
            }
        });
    }

    @NonNls
    public static String getCanonicalLocalPath(@NonNls String localPath) {
        if (((String)(localPath = VcsUtil.chopTrailingChars(((String)localPath).trim().replace('\\', '/'), ourCharsToBeChopped))).length() == 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)localPath)) {
            localPath = (String)localPath + "/";
        }
        return localPath;
    }

    @NonNls
    public static String getCanonicalPath(@NonNls String path2) {
        String canonPath;
        try {
            canonPath = new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = path2;
        }
        return canonPath;
    }

    @NonNls
    public static String getCanonicalPath(File file) {
        String canonPath;
        try {
            canonPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = file.getAbsolutePath();
        }
        return canonPath;
    }

    @NonNls
    public static String chopTrailingChars(@NonNls String source2, char[] chars) {
        boolean atLeastOneCharWasChopped;
        StringBuilder sb = new StringBuilder(source2);
        do {
            atLeastOneCharWasChopped = false;
            for (int i = 0; i < chars.length && sb.length() > 0; ++i) {
                if (sb.charAt(sb.length() - 1) != chars[i]) continue;
                sb.deleteCharAt(sb.length() - 1);
                atLeastOneCharWasChopped = true;
            }
        } while (atLeastOneCharWasChopped);
        return sb.toString();
    }

    @Nls
    public static String getShortRevisionString(@NotNull VcsRevisionNumber revision) {
        if (revision == null) {
            VcsUtil.$$$reportNull$$$0(51);
        }
        return revision instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revision).toShortString() : revision.asString();
    }

    public static boolean isAspectAvailableByDefault(@Nullable @NonNls String id) {
        return VcsUtil.isAspectAvailableByDefault(id, true);
    }

    public static boolean isAspectAvailableByDefault(@Nullable @NonNls String id, boolean defaultValue) {
        if (id == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(ANNO_ASPECT + id, defaultValue);
    }

    public static void setAspectAvailability(@Nullable @NonNls String aspectID, boolean showByDefault) {
        PropertiesComponent.getInstance().setValue(ANNO_ASPECT + aspectID, String.valueOf(showByDefault));
    }

    @Nls
    public static String getPathForProgressPresentation(@NotNull File file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(52);
        }
        return file.getName() + " (" + FileUtil.getLocationRelativeToUserHome((String)file.getParent()) + ")";
    }

    @NlsSafe
    @NotNull
    public static String getShortVcsRootName(@NotNull Project project2, @NotNull VirtualFile root) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(53);
        }
        if (root == null) {
            VcsUtil.$$$reportNull$$$0(54);
        }
        if (project2.isDisposed()) {
            String string2 = root.getName();
            if (string2 == null) {
                VcsUtil.$$$reportNull$$$0(55);
            }
            return string2;
        }
        String string3 = ProjectLevelVcsManager.getInstance(project2).getShortNameForVcsRoot(root);
        if (string3 == null) {
            VcsUtil.$$$reportNull$$$0(56);
        }
        return string3;
    }

    @NotNull
    @NlsSafe
    public static String getPresentablePath(@Nullable Project project2, @NotNull VirtualFile file, boolean useRelativeRootPaths, boolean acceptEmptyPath) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(57);
        }
        return VcsUtil.getPresentablePath(project2, VcsUtil.getFilePath(file), useRelativeRootPaths, acceptEmptyPath);
    }

    @NotNull
    @NlsSafe
    public static String getPresentablePath(@Nullable Project project2, @NotNull FilePath filePath, boolean useRelativeRootPaths, boolean acceptEmptyPath) {
        String projectDir;
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(58);
        }
        String string2 = projectDir = project2 != null ? project2.getBasePath() : null;
        if (projectDir != null) {
            String relativePath;
            if (useRelativeRootPaths && (relativePath = VcsUtil.getRootRelativePath(project2, projectDir, filePath, acceptEmptyPath)) != null) {
                String string3 = FileUtil.toSystemDependentName((String)relativePath);
                if (string3 == null) {
                    VcsUtil.$$$reportNull$$$0(59);
                }
                return string3;
            }
            String path2 = filePath.getPath();
            String relativePath2 = VcsUtil.getRelativePathIfSuccessor(projectDir, path2);
            if (relativePath2 != null) {
                String string4 = FileUtil.toSystemDependentName((String)VcsBundle.message("label.relative.project.path.presentation", relativePath2));
                if (string4 == null) {
                    VcsUtil.$$$reportNull$$$0(60);
                }
                return string4;
            }
        }
        String string5 = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)filePath.getPath()));
        if (string5 == null) {
            VcsUtil.$$$reportNull$$$0(61);
        }
        return string5;
    }

    @Nullable
    private static @SystemIndependent String getRootRelativePath(@NotNull Project project2, @NotNull String projectBaseDir, @NotNull FilePath filePath, boolean acceptEmptyPath) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(62);
        }
        if (projectBaseDir == null) {
            VcsUtil.$$$reportNull$$$0(63);
        }
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(64);
        }
        if (project2.isDisposed()) {
            return null;
        }
        String path2 = filePath.getPath();
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(project2);
        VirtualFile root = vcsManager2.getVcsRootFor(filePath);
        if (root == null) {
            return null;
        }
        String rootPath = root.getPath();
        VcsRoot[] roots = vcsManager2.getAllVcsRoots();
        if (roots.length == 1) {
            if (rootPath.equals(path2)) {
                return acceptEmptyPath ? "" : root.getName();
            }
            return VcsUtil.getRelativePathIfSuccessor(rootPath, path2);
        }
        if (projectBaseDir.equals(path2)) {
            return root.getName();
        }
        String relativePath = VcsUtil.getRelativePathIfSuccessor(projectBaseDir, path2);
        if (relativePath == null) {
            return null;
        }
        return projectBaseDir.equals(rootPath) ? root.getName() + "/" + relativePath : relativePath;
    }

    @Nullable
    private static String getRelativePathIfSuccessor(@NotNull String ancestor, @NotNull String path2) {
        if (ancestor == null) {
            VcsUtil.$$$reportNull$$$0(65);
        }
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(66);
        }
        return FileUtil.isAncestor((String)ancestor, (String)path2, (boolean)true) ? FileUtil.getRelativePath((String)ancestor, (String)path2, (char)'/') : null;
    }

    @NotNull
    public static <T> Map<VcsRoot, List<T>> groupByRoots(@NotNull Project project2, @NotNull Collection<? extends T> items2, @NotNull com.intellij.util.Function<? super T, ? extends FilePath> filePathMapper) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(67);
        }
        if (items2 == null) {
            VcsUtil.$$$reportNull$$$0(68);
        }
        if (filePathMapper == null) {
            VcsUtil.$$$reportNull$$$0(69);
        }
        return VcsUtil.groupByRoots(project2, items2, false, filePathMapper);
    }

    @NotNull
    public static <T> Map<VcsRoot, List<T>> groupByRoots(@NotNull Project project2, @NotNull Collection<? extends T> items2, boolean putNonVcs, @NotNull com.intellij.util.Function<? super T, ? extends FilePath> filePathMapper) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(70);
        }
        if (items2 == null) {
            VcsUtil.$$$reportNull$$$0(71);
        }
        if (filePathMapper == null) {
            VcsUtil.$$$reportNull$$$0(72);
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project2);
        HashMap<VcsRoot, List<T>> map2 = new HashMap<VcsRoot, List<T>>();
        for (T item2 : items2) {
            VcsRoot vcsRoot = manager.getVcsRootObjectFor((FilePath)filePathMapper.fun(item2));
            if (vcsRoot == null && !putNonVcs) continue;
            List list2 = map2.computeIfAbsent(vcsRoot, key2 -> new ArrayList());
            list2.add(item2);
        }
        HashMap<VcsRoot, List<T>> hashMap = map2;
        if (hashMap == null) {
            VcsUtil.$$$reportNull$$$0(73);
        }
        return hashMap;
    }

    @NotNull
    public static List<VcsDirectoryMapping> addMapping(@NotNull List<? extends VcsDirectoryMapping> existingMappings, @NotNull @NonNls String path2, @NotNull @NonNls String vcs) {
        if (existingMappings == null) {
            VcsUtil.$$$reportNull$$$0(74);
        }
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(75);
        }
        if (vcs == null) {
            VcsUtil.$$$reportNull$$$0(76);
        }
        return VcsUtil.addMapping(existingMappings, new VcsDirectoryMapping(path2, vcs));
    }

    @NotNull
    public static List<VcsDirectoryMapping> addMapping(@NotNull List<? extends VcsDirectoryMapping> existingMappings, @NotNull VcsDirectoryMapping newMapping) {
        if (existingMappings == null) {
            VcsUtil.$$$reportNull$$$0(77);
        }
        if (newMapping == null) {
            VcsUtil.$$$reportNull$$$0(78);
        }
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(existingMappings);
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            VcsDirectoryMapping mapping = (VcsDirectoryMapping)iterator.next();
            if (mapping.isDefaultMapping() && mapping.isNoneMapping()) {
                LOG.debug("Removing <Project> -> <None> mapping");
                iterator.remove();
                continue;
            }
            if (!FileUtil.pathsEqual((String)mapping.getDirectory(), (String)newMapping.getDirectory())) continue;
            if (!StringUtil.isEmptyOrSpaces((String)mapping.getVcs())) {
                if (mapping.getVcs().equals(newMapping.getVcs())) {
                    LOG.debug(String.format("Substituting existing mapping with identical [%s] -> [%s]", mapping.getDirectory(), mapping.getVcs()));
                } else {
                    LOG.warn(String.format("Substituting existing mapping [%s] -> [%s] with [%s]", mapping.getDirectory(), mapping.getVcs(), newMapping.getVcs()));
                }
            } else {
                LOG.debug(String.format("Removing [%s] -> <None> mapping", mapping.getDirectory()));
            }
            iterator.remove();
        }
        mappings.add(newMapping);
        ArrayList<VcsDirectoryMapping> arrayList = mappings;
        if (arrayList == null) {
            VcsUtil.$$$reportNull$$$0(79);
        }
        return arrayList;
    }

    @NotNull
    public static VirtualFile resolveSymlinkIfNeeded(@NotNull Project project2, @NotNull VirtualFile file) {
        VirtualFile symlink;
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(80);
        }
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(81);
        }
        VirtualFile virtualFile = (symlink = VcsUtil.resolveSymlink(project2, file)) != null ? symlink : file;
        if (virtualFile == null) {
            VcsUtil.$$$reportNull$$$0(82);
        }
        return virtualFile;
    }

    @Nullable
    public static VirtualFile resolveSymlink(@NotNull Project project2, @Nullable VirtualFile file) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(83);
        }
        if (file == null) {
            return null;
        }
        for (VcsSymlinkResolver resolver : VcsSymlinkResolver.EP_NAME.getExtensionList((AreaInstance)project2)) {
            VirtualFile symlink;
            if (!resolver.isEnabled() || (symlink = resolver.resolveSymlink(file)) == null) continue;
            return symlink;
        }
        return null;
    }

    @NotNull
    public static FilePath getLastCommitPath(@NotNull Project project2, @NotNull FilePath path2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(84);
        }
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(85);
        }
        if (project2.isDefault()) {
            FilePath filePath = path2;
            if (filePath == null) {
                VcsUtil.$$$reportNull$$$0(86);
            }
            return filePath;
        }
        Change change = ChangeListManager.getInstance(project2).getChange(path2);
        if (change == null || change.getType() != Change.Type.MOVED || change.getBeforeRevision() == null) {
            FilePath filePath = path2;
            if (filePath == null) {
                VcsUtil.$$$reportNull$$$0(87);
            }
            return filePath;
        }
        FilePath filePath = change.getBeforeRevision().getFile();
        if (filePath == null) {
            VcsUtil.$$$reportNull$$$0(88);
        }
        return filePath;
    }

    @NotNull
    public static Set<String> getVcsIgnoreFileNames(@NotNull Project project2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(89);
        }
        HashSet<String> set = new HashSet<String>();
        for (IgnoredFileContentProvider provider2 : IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.getExtensionList((AreaInstance)project2)) {
            set.add(provider2.getFileName());
        }
        HashSet<String> hashSet = set;
        if (hashSet == null) {
            VcsUtil.$$$reportNull$$$0(90);
        }
        return hashSet;
    }

    @Nls
    @NotNull
    public static String joinWithAnd(@NotNull List<@Nls String> strings, int limit) {
        int size;
        if (strings == null) {
            VcsUtil.$$$reportNull$$$0(91);
        }
        if ((size = strings.size()) == 0) {
            return "";
        }
        if (size == 1) {
            String string2 = strings.get(0);
            if (string2 == null) {
                VcsUtil.$$$reportNull$$$0(92);
            }
            return string2;
        }
        if (size == 2) {
            String string3 = VcsBundle.message("sequence.concatenation.a.and.b", strings.get(0), strings.get(1));
            if (string3 == null) {
                VcsUtil.$$$reportNull$$$0(93);
            }
            return string3;
        }
        boolean isLimited = limit >= 2 && limit < size;
        int listCount = (isLimited ? limit : size) - 1;
        @Nls StringBuilder sb = new StringBuilder();
        for (int i = 0; i < listCount; ++i) {
            if (i != 0) {
                sb.append(VcsBundle.message("sequence.concatenation.separator", new Object[0]));
            }
            sb.append(strings.get(i));
        }
        if (isLimited) {
            sb.append(VcsBundle.message("sequence.concatenation.tail.n.others", size - limit + 1));
        } else {
            sb.append(VcsBundle.message("sequence.concatenation.tail", strings.get(size - 1)));
        }
        String string4 = sb.toString();
        if (string4 == null) {
            VcsUtil.$$$reportNull$$$0(94);
        }
        return string4;
    }

    @NlsSafe
    @NotNull
    public static String trimCommitMessageToSaneSize(@NotNull @NlsSafe String message2) {
        int nthLine;
        if (message2 == null) {
            VcsUtil.$$$reportNull$$$0(95);
        }
        if ((nthLine = VcsUtil.nthIndexOf(message2, '\n', 3000)) != -1 && nthLine < 50000) {
            String string2 = VcsUtil.trimCommitMessageAt(message2, nthLine);
            if (string2 == null) {
                VcsUtil.$$$reportNull$$$0(96);
            }
            return string2;
        }
        if (message2.length() > 50050) {
            String string3 = VcsUtil.trimCommitMessageAt(message2, 50000);
            if (string3 == null) {
                VcsUtil.$$$reportNull$$$0(97);
            }
            return string3;
        }
        String string4 = message2;
        if (string4 == null) {
            VcsUtil.$$$reportNull$$$0(98);
        }
        return string4;
    }

    @NlsSafe
    private static String trimCommitMessageAt(@NotNull @NlsSafe String message2, int index) {
        if (message2 == null) {
            VcsUtil.$$$reportNull$$$0(99);
        }
        return VcsBundle.message("text.commit.message.truncated.by.ide.name", message2.substring(0, index), ApplicationNamesInfo.getInstance().getProductName());
    }

    private static int nthIndexOf(@NotNull @NonNls String text2, char c, int n) {
        if (text2 == null) {
            VcsUtil.$$$reportNull$$$0(100);
        }
        assert (n > 0);
        int length = text2.length();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (text2.charAt(i) != c || ++count != n) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean removeAllFromSet(@NotNull Set<T> set, @NotNull Collection<? extends T> toRemove) {
        if (set == null) {
            VcsUtil.$$$reportNull$$$0(101);
        }
        if (toRemove == null) {
            VcsUtil.$$$reportNull$$$0(102);
        }
        boolean modified = false;
        for (T value2 : toRemove) {
            modified |= set.remove(value2);
        }
        return modified;
    }

    public static boolean shouldDetectVcsMappingsFor(@NotNull Project project2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(103);
        }
        return Registry.is((String)"vcs.detect.vcs.mappings.automatically") && VcsSharedProjectSettings.getInstance(project2).isDetectVcsMappingsAutomatically();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 26, 28, 30, 32, 34, 36, 39, 42, 46, 55, 56, 59, 60, 61, 73, 79, 82, 86, 87, 88, 90, 92, 93, 94, 96, 97, 98 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 53: 
            case 62: 
            case 67: 
            case 70: 
            case 80: 
            case 83: 
            case 84: 
            case 89: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 35: 
            case 66: 
            case 75: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 43: 
            case 58: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 42: 
            case 46: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 73: 
            case 79: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsUtil";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBaseDir";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathMapper";
                break;
            }
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingMappings";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMapping";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsUtil";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 39: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathOnNonLocal";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathForDeletedFile";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortVcsRootName";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoots";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "addMapping";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlinkIfNeeded";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommitPath";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsIgnoreFileNames";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "joinWithAnd";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "trimCommitMessageToSaneSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderVcs";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileForVcs";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findVcsByKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findVcs";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootFor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeValue";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFileByteContent";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 42: 
            case 46: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 73: 
            case 79: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathOnNonLocal";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathForDeletedFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getOneVirtualFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFiles";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "runVcsProcessWithProgress";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "computeWithModalProgress";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getShortRevisionString";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPathForProgressPresentation";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getShortVcsRootName";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getRootRelativePath";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathIfSuccessor";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoots";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlinkIfNeeded";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommitPath";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getVcsIgnoreFileNames";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "joinWithAnd";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "trimCommitMessageToSaneSize";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "trimCommitMessageAt";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "nthIndexOf";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "removeAllFromSet";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "shouldDetectVcsMappingsFor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 24, 26, 28, 30, 32, 34, 36, 39, 42, 46, 55, 56, 59, 60, 61, 73, 79, 82, 86, 87, 88, 90, 92, 93, 94, 96, 97, 98 -> new IllegalStateException(string2);
        };
    }
}

