/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import java.awt.Color;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserLockedFoldersNode
extends ChangesBrowserNode<ChangesBrowserNode.Tag>
implements TreeLinkMouseListener.HaveTooltip {
    @NotNull
    private static final SimpleTextAttributes CLEANUP_LINK_ATTRIBUTES = new SimpleTextAttributes(16, (Color)JBColor.RED);
    @NotNull
    private final Project myProject;

    public ChangesBrowserLockedFoldersNode(@NotNull Project project2) {
        if (project2 == null) {
            ChangesBrowserLockedFoldersNode.$$$reportNull$$$0(0);
        }
        super(LOCKED_FOLDERS_TAG);
        this.myProject = project2;
    }

    @NotNull
    public String getTooltip() {
        String string2 = VcsBundle.message("changes.nodetitle.locked.folders.tooltip", new Object[0]);
        if (string2 == null) {
            ChangesBrowserLockedFoldersNode.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer2 == null) {
            ChangesBrowserLockedFoldersNode.$$$reportNull$$$0(2);
        }
        renderer2.append(LOCKED_FOLDERS_TAG.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer2.append(this.getCountText(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        renderer2.append(FontUtil.spaceAndThinSpace(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer2.append(VcsBundle.message("changes.do.cleanup", new Object[0]), CLEANUP_LINK_ATTRIBUTES, new CleanupWorker(this.myProject, this));
    }

    @Override
    @Nls
    public String getTextPresentation() {
        return LOCKED_FOLDERS_TAG.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static final class CleanupWorker
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        private CleanupWorker(@NotNull Project project2, @NotNull ChangesBrowserNode<?> node) {
            if (project2 == null) {
                CleanupWorker.$$$reportNull$$$0(0);
            }
            if (node == null) {
                CleanupWorker.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myNode = node;
        }

        @Override
        public void run() {
            ChangesUtil.processVirtualFilesByVcs(this.myProject, this.myNode.iterateFilesUnder().toList(), (vcs, files2) -> {
                ChangeProvider provider2 = vcs.getChangeProvider();
                if (provider2 != null) {
                    provider2.doCleanup(files2);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode$CleanupWorker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

