/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictDialog;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ChangelistConflictAccessProvider
extends WritingAccessProvider {
    private final Project myProject;

    ChangelistConflictAccessProvider(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            ChangelistConflictAccessProvider.$$$reportNull$$$0(0);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        ChangelistConflictTracker conflictTracker = ChangelistConflictTracker.getInstance(this.myProject);
        ChangelistConflictTracker.Options options = conflictTracker.getOptions();
        if (!options.SHOW_DIALOG) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                ChangelistConflictAccessProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            if (virtualFile == null || conflictTracker.isWritingAllowed(virtualFile)) continue;
            denied.add(virtualFile);
        }
        if (!denied.isEmpty()) {
            ChangelistConflictDialog dialog;
            HashSet<LocalChangeList> changeLists = new HashSet<LocalChangeList>();
            ArrayList<Change> arrayList = new ArrayList<Change>();
            for (VirtualFile file : denied) {
                changeLists.add(changeListManager.getChangeList(file));
                arrayList.add(changeListManager.getChange(file));
            }
            int savedEventCount = IdeEventQueue.getInstance().getEventCount();
            do {
                dialog = new ChangelistConflictDialog(this.myProject, new ArrayList<ChangeList>(changeLists), denied);
                dialog.show();
            } while (dialog.isOK() && !dialog.getResolution().resolveConflict(this.myProject, arrayList, null));
            IdeEventQueue.getInstance().setEventCount(savedEventCount);
            if (dialog.isOK()) {
                options.LAST_RESOLUTION = dialog.getResolution();
                List<VirtualFile> list3 = Collections.emptyList();
                if (list3 == null) {
                    ChangelistConflictAccessProvider.$$$reportNull$$$0(2);
                }
                return list3;
            }
        }
        ArrayList<VirtualFile> arrayList = denied;
        if (arrayList == null) {
            ChangelistConflictAccessProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWriting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }
}

