/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ShortNameType;
import com.intellij.openapi.vcs.actions.ShowShortenNames;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.awt.Color;
import java.awt.Cursor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AspectAnnotationFieldGutter
extends AnnotationFieldGutter {
    @NotNull
    protected final LineAnnotationAspect myAspect;
    private final boolean myIsGutterAction;

    public AspectAnnotationFieldGutter(@NotNull FileAnnotation annotation, @NotNull LineAnnotationAspect aspect, @NotNull TextAnnotationPresentation presentation2, @Nullable Couple<Map<VcsRevisionNumber, Color>> colorScheme) {
        if (annotation == null) {
            AspectAnnotationFieldGutter.$$$reportNull$$$0(0);
        }
        if (aspect == null) {
            AspectAnnotationFieldGutter.$$$reportNull$$$0(1);
        }
        if (presentation2 == null) {
            AspectAnnotationFieldGutter.$$$reportNull$$$0(2);
        }
        super(annotation, presentation2, colorScheme);
        this.myAspect = aspect;
        this.myIsGutterAction = this.myAspect instanceof EditorGutterAction;
    }

    @Override
    public boolean isGutterAction() {
        return this.myIsGutterAction;
    }

    public String getLineText(int line, Editor editor) {
        String value2;
        String string2 = value2 = this.isAvailable() ? this.myAspect.getValue(line) : "";
        if ("Author".equals(this.myAspect.getId())) {
            return ShortNameType.shorten(value2, ShowShortenNames.getType());
        }
        return value2;
    }

    @Override
    @Nullable
    public String getToolTip(int line, Editor editor) {
        String text2 = this.myAspect.getTooltipText(line);
        if (text2 != null) {
            return text2;
        }
        return this.isAvailable() ? this.myAnnotation.getHtmlToolTip(line) : null;
    }

    @Override
    public void doAction(int line) {
        if (this.myIsGutterAction) {
            ((EditorGutterAction)this.myAspect).doAction(line);
        }
    }

    @Override
    public Cursor getCursor(int line) {
        if (this.myIsGutterAction) {
            return ((EditorGutterAction)this.myAspect).getCursor(line);
        }
        return super.getCursor(line);
    }

    @Override
    public EditorFontType getStyle(int line, Editor editor) {
        EditorFontType style = this.myAspect.getStyle(line);
        if (style != null) {
            return style;
        }
        return super.getStyle(line, editor);
    }

    @Override
    @Nullable
    public ColorKey getColor(int line, Editor editor) {
        ColorKey color2 = this.myAspect.getColor(line);
        if (color2 != null) {
            return color2;
        }
        return super.getColor(line, editor);
    }

    @Override
    @Nullable
    public Color getBgColor(int line, Editor editor) {
        Color color2 = this.myAspect.getBgColor(line);
        if (color2 != null) {
            return color2;
        }
        return super.getBgColor(line, editor);
    }

    @Override
    public boolean isShowByDefault() {
        return this.myAspect.isShowByDefault();
    }

    @Override
    @Nullable
    public String getID() {
        return this.myAspect.getId();
    }

    @Override
    @NlsContexts.ListItem
    @Nullable
    public String getDisplayName() {
        return this.myAspect.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "annotation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "aspect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "presentation";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/actions/AspectAnnotationFieldGutter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

