/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.completion.ml.VcsFeatureProviderKt;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/completion/ml/VcsFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "intellij.platform.vcs.impl"})
public final class VcsFeatureProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "vcs";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Map features;
        block5: {
            PsiElement psi;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
            Integer changesCount = (Integer)contextFeatures.getUserData(VcsFeatureProviderKt.getChangesCountKey());
            if (changesCount == null || changesCount > 1000) {
                return MapsKt.emptyMap();
            }
            features = new LinkedHashMap();
            Project project2 = location.getProject();
            PsiElement psiElement = psi = element.getPsiElement();
            Object psiFile2 = psiElement != null ? psiElement.getContainingFile() : null;
            PsiFile psiFile3 = psiFile2;
            if (psiFile3 == null || (psiFile3 = psiFile3.getViewProvider()) == null || (psiFile3 = psiFile3.getVirtualFile()) == null) break block5;
            PsiFile file = psiFile3;
            boolean bl = false;
            ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            Change change = changeListManager2.getChange((VirtualFile)file);
            if (change != null) {
                Change change2 = change;
                boolean bl2 = false;
                features.put("file_state", MLFeatureValue.Companion.categorical((Enum)change2.getType()));
                if (change2.getType() == Change.Type.MODIFICATION && psi instanceof PsiNameIdentifierOwner) {
                    Document document2 = PsiDocumentManager.getInstance((Project)project2).getCachedDocument(psiFile2);
                    TextRange range = ((PsiNameIdentifierOwner)psi).getTextRange();
                    if (document2 != null && range != null && range.getEndOffset() <= document2.getTextLength()) {
                        Intrinsics.checkNotNull((Object)project2);
                        LineStatusTracker<?> lineStatusTracker = LineStatusTrackerManager.Companion.getInstance(project2).getLineStatusTracker(document2);
                        if (lineStatusTracker != null && lineStatusTracker.isValid() && lineStatusTracker.isRangeModified(document2.getLineNumber(range.getStartOffset()), document2.getLineNumber(range.getEndOffset()))) {
                            features.put("declaration_is_changed", MLFeatureValue.Companion.binary(true));
                        }
                    }
                }
            }
        }
        return features;
    }
}

