/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.patterns.standard;

import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.AhoCorasickPattern;
import ai.grazie.nlp.patterns.LambdaMatchPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.standard.StrictPatterns;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lai/grazie/nlp/patterns/standard/StrictPatterns;", "", "()V", "HasNoLetters", "Lai/grazie/nlp/patterns/LambdaMatchPattern;", "getHasNoLetters", "()Lai/grazie/nlp/patterns/LambdaMatchPattern;", "HasNumber", "getHasNumber", "IsApostrophe", "getIsApostrophe", "IsNumber", "getIsNumber", "IsTime", "Lai/grazie/nlp/patterns/AggregatedPattern;", "getIsTime", "()Lai/grazie/nlp/patterns/AggregatedPattern;", "IsUUID", "Lai/grazie/nlp/patterns/RegexPattern;", "getIsUUID", "()Lai/grazie/nlp/patterns/RegexPattern;", "LatinPhrase", "Lai/grazie/nlp/patterns/Pattern;", "getLatinPhrase", "()Lai/grazie/nlp/patterns/Pattern;", "nlp-patterns"})
public final class StrictPatterns {
    @NotNull
    public static final StrictPatterns INSTANCE = new StrictPatterns();
    @NotNull
    private static final LambdaMatchPattern IsNumber = new LambdaMatchPattern((Function1<? super CharSequence, Boolean>)((Function1)IsNumber.1.INSTANCE));
    @NotNull
    private static final LambdaMatchPattern IsApostrophe = new LambdaMatchPattern((Function1<? super CharSequence, Boolean>)((Function1)IsApostrophe.1.INSTANCE));
    @NotNull
    private static final LambdaMatchPattern HasNumber = new LambdaMatchPattern((Function1<? super CharSequence, Boolean>)((Function1)HasNumber.1.INSTANCE));
    @NotNull
    private static final LambdaMatchPattern HasNoLetters = new LambdaMatchPattern((Function1<? super CharSequence, Boolean>)((Function1)HasNoLetters.1.INSTANCE));
    @NotNull
    private static final RegexPattern IsUUID = new RegexPattern(new Regex("([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})"));
    @NotNull
    private static final AggregatedPattern IsTime;
    @NotNull
    private static final Pattern LatinPhrase;

    private StrictPatterns() {
    }

    @NotNull
    public final LambdaMatchPattern getIsNumber() {
        return IsNumber;
    }

    @NotNull
    public final LambdaMatchPattern getIsApostrophe() {
        return IsApostrophe;
    }

    @NotNull
    public final LambdaMatchPattern getHasNumber() {
        return HasNumber;
    }

    @NotNull
    public final LambdaMatchPattern getHasNoLetters() {
        return HasNoLetters;
    }

    @NotNull
    public final RegexPattern getIsUUID() {
        return IsUUID;
    }

    @NotNull
    public final AggregatedPattern getIsTime() {
        return IsTime;
    }

    @NotNull
    public final Pattern getLatinPhrase() {
        return LatinPhrase;
    }

    static {
        Object[] objectArray = new Pattern[]{new RegexPattern(new Regex("(0?[1-9]|1[0-2][:.][0-5][0-9])")).withWordBoundariesAround(), new RegexPattern(new Regex("(0?[1-9]|1[0-2][:.][0-5][0-9][:.][0-5][0-9])")).withWordBoundariesAround()};
        IsTime = new AggregatedPattern((Pattern[])objectArray);
        objectArray = new String[]{"cum laude", "de jure", "de facto", "in silico", "in vivo", "in vitro", "per capita"};
        LatinPhrase = new AhoCorasickPattern(CollectionsKt.listOf((Object[])objectArray)).withWordBoundariesAround();
    }
}

