/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.heuristics.list;

import ai.grazie.detector.DetectedLanguage;
import ai.grazie.detector.LanguageDetector;
import ai.grazie.detector.heuristics.list.ListDetector;
import ai.grazie.detector.heuristics.list.impl.ListProfile;
import ai.grazie.detector.heuristics.list.impl.ListProfileReader;
import ai.grazie.detector.utils.StatisticsKt;
import ai.grazie.detector.utils.UtilsKt;
import ai.grazie.nlp.langs.Language;
import ai.grazie.utils.mpp.DataLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0013\u0014B7\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/grazie/detector/heuristics/list/ListDetector;", "Lai/grazie/detector/LanguageDetector;", "", "languages", "Ljava/util/LinkedHashSet;", "Lai/grazie/nlp/langs/Language;", "Lkotlin/collections/LinkedHashSet;", "profiles", "", "Lkotlin/Pair;", "Lai/grazie/detector/heuristics/list/impl/ListProfile;", "(Ljava/util/LinkedHashSet;Ljava/util/List;)V", "getLanguages", "()Ljava/util/LinkedHashSet;", "detect", "Lai/grazie/detector/LanguageDetector$DetectionResult;", "input", "isReliable", "", "Companion", "Text", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nListDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListDetector.kt\nai/grazie/detector/heuristics/list/ListDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n483#2,7:74\n442#2:87\n392#2:88\n766#3:81\n857#3,2:82\n1045#3:84\n1054#3:85\n1054#3:86\n1238#3,4:89\n819#3:93\n847#3,2:94\n*S KotlinDebug\n*F\n+ 1 ListDetector.kt\nai/grazie/detector/heuristics/list/ListDetector\n*L\n53#1:74,7\n61#1:87\n61#1:88\n54#1:81\n54#1:82,2\n55#1:84\n56#1:85\n57#1:86\n61#1:89,4\n25#1:93\n25#1:94,2\n*E\n"})
public final class ListDetector
extends LanguageDetector<CharSequence> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final LinkedHashSet<Language> languages;
    @NotNull
    private final List<Pair<Language, ListProfile>> profiles;
    public static final double MINIMAL_MEANINGFUL = 0.5;
    public static final double MINIMAL_TO_DETECT = 0.6;
    @NotNull
    private static final List<Language> supported;

    public ListDetector(@NotNull LinkedHashSet<Language> languages, @NotNull List<? extends Pair<? extends Language, ListProfile>> profiles) {
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
        this.languages = languages;
        this.profiles = profiles;
    }

    @NotNull
    public final LinkedHashSet<Language> getLanguages() {
        return this.languages;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LanguageDetector.DetectionResult detect(@NotNull CharSequence input, boolean isReliable) {
        Iterable $this$sortedByDescending$iv;
        Iterable $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List<String> words2 = UtilsKt.wordsLower(input);
        if (isReliable && (words2.size() < 3 || words2.size() == 1 && input.length() < 10)) {
            return LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.List);
        }
        double minimalMeaningfulSize = (double)words2.size() * 0.5;
        double minimalToDetectSize = (double)words2.size() * 0.6;
        HashMap<Language, Integer> langCounts = new HashMap<Language, Integer>(this.languages.size());
        HashMap<Language, Double> langWeights = new HashMap<Language, Double>(this.languages.size());
        for (Pair<Language, ListProfile> pair : this.profiles) {
            Language lang = (Language)((Object)pair.component1());
            ListProfile profile = (ListProfile)pair.component2();
            for (String string2 : words2) {
                if (!profile.match(string2)) continue;
                langCounts.merge(lang, 1, (arg_0, arg_1) -> ListDetector.detect$lambda$0(detect.1.INSTANCE, arg_0, arg_1));
                langWeights.merge(lang, profile.weight(string2), (arg_0, arg_1) -> ListDetector.detect$lambda$1(detect.2.INSTANCE, arg_0, arg_1));
            }
        }
        Map $this$filterValues$iv = langCounts;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry2 : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry2.getValue()).intValue();
            boolean bl = false;
            if (!((double)it >= minimalMeaningfulSize)) continue;
            result$iv.put(entry2.getKey(), entry2.getValue());
        }
        Map probs = result$iv;
        Iterable $this$filter$iv = probs.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!((double)((Number)it.getValue()).intValue() >= minimalToDetectSize)) continue;
            collection.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((Language)((Object)it.getKey())).getIso());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((Language)((Object)it.getKey())).getIso())));
            }
        });
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(langWeights){
            final /* synthetic */ HashMap $langWeights$inlined;
            {
                this.$langWeights$inlined = hashMap;
            }

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                V v = this.$langWeights$inlined.get(it.getKey());
                Intrinsics.checkNotNull(v);
                it = (Map.Entry)a;
                Comparable comparable = (Double)v;
                bl = false;
                V v2 = this.$langWeights$inlined.get(it.getKey());
                Intrinsics.checkNotNull(v2);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Double)v2));
            }
        });
        $i$f$sortedByDescending = false;
        List pref = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
            }
        });
        if (pref.isEmpty()) {
            return LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.List);
        }
        Map $this$mapValues$iv = probs;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = map2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry4 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Object v = langWeights.get(it.getKey());
            Intrinsics.checkNotNull(v);
            Double d = (Double)v;
            map4.put(k, d);
        }
        DetectedLanguage[] detectedLanguages = StatisticsKt.toDetected(destination$iv$iv2);
        Map.Entry first = (Map.Entry)pref.get(0);
        if (pref.size() >= 2) {
            Map.Entry second = (Map.Entry)pref.get(1);
            if (((Number)first.getValue()).intValue() == ((Number)second.getValue()).intValue() && detectedLanguages[0].getProbability() - detectedLanguages[1].getProbability() < 0.05) {
                return LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.List);
            }
        }
        return new LanguageDetector.DetectionResult(LanguageDetector.Type.List, (Language)((Object)first.getKey()), detectedLanguages);
    }

    private static final Integer detect$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Double detect$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Double)$tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$filterNot$iv = Language.Companion.getAll();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            Language[] languageArray = new Language[]{Language.CHINESE, Language.JAPANESE, Language.KOREAN, Language.GREEK, Language.KHMER, Language.ASTURIAN};
            if (SetsKt.setOf((Object[])languageArray).contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        supported = (List)var3_3;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\b0\u000ej\b\u0012\u0004\u0012\u00020\b`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lai/grazie/detector/heuristics/list/ListDetector$Companion;", "", "()V", "MINIMAL_MEANINGFUL", "", "MINIMAL_TO_DETECT", "supported", "", "Lai/grazie/nlp/langs/Language;", "getSupported", "()Ljava/util/List;", "create", "Lai/grazie/detector/heuristics/list/ListDetector;", "languages", "Ljava/util/LinkedHashSet;", "Lai/grazie/utils/LinkedSet;", "loader", "Lai/grazie/utils/mpp/DataLoader;", "(Ljava/util/LinkedHashSet;Lai/grazie/utils/mpp/DataLoader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nlp-detect"})
    @SourceDebugExtension(value={"SMAP\nListDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListDetector.kt\nai/grazie/detector/heuristics/list/ListDetector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n766#2:74\n857#2,2:75\n1549#2:77\n1620#2,3:78\n*S KotlinDebug\n*F\n+ 1 ListDetector.kt\nai/grazie/detector/heuristics/list/ListDetector$Companion\n*L\n28#1:74\n28#1:75,2\n28#1:77\n28#1:78,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Language> getSupported() {
            return supported;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object create(@NotNull LinkedHashSet<Language> var1_1, @NotNull DataLoader var2_2, @NotNull Continuation<? super ListDetector> var3_3) {
            if (!(var3_3 instanceof create.1)) ** GOTO lbl-1000
            var17_4 = var3_3;
            if ((var17_4.label & -2147483648) != 0) {
                var17_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.create(null, null, (Continuation<? super ListDetector>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$filter$iv = languages;
                    $i$f$filter = false;
                    var7_9 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Language)element$iv$iv;
                        $i$a$-filter-ListDetector$Companion$create$profiles$1 = false;
                        if (!ListDetector.Companion.getSupported().contains((Object)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    var10_12 = $this$mapTo$iv$iv.iterator();
lbl30:
                    // 2 sources

                    while (var10_12.hasNext()) {
                        item$iv$iv = var10_12.next();
                        it = (Language)item$iv$iv;
                        var15_17 = destination$iv$iv;
                        $i$a$-map-ListDetector$Companion$create$profiles$2 = false;
                        var14_16 = it;
                        $continuation.L$0 = languages;
                        $continuation.L$1 = loader;
                        $continuation.L$2 = destination$iv$iv;
                        $continuation.L$3 = var10_12;
                        $continuation.L$4 = var14_16;
                        $continuation.L$5 = var15_17;
                        $continuation.label = 1;
                        v0 = ListProfileReader.INSTANCE.getProfile(it, loader, (Continuation<? super ListProfile>)$continuation);
                        if (v0 == var18_6) {
                            return var18_6;
                        }
                        ** GOTO lbl60
                    }
                    break;
                }
                case 1: {
                    $i$f$map = false;
                    $i$f$mapTo = false;
                    $i$a$-map-ListDetector$Companion$create$profiles$2 = false;
                    var15_17 = (Collection)$continuation.L$5;
                    var14_16 = (Language)$continuation.L$4;
                    var10_12 = (Iterator<T>)$continuation.L$3;
                    destination$iv$iv = (Collection)$continuation.L$2;
                    loader = (DataLoader)$continuation.L$1;
                    languages = (LinkedHashSet)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl60:
                    // 2 sources

                    var15_17.add(TuplesKt.to((Object)var14_16, (Object)v0));
                    ** GOTO lbl30
                }
            }
            profiles = (List)destination$iv$iv;
            return new ListDetector(languages, profiles);
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lai/grazie/detector/heuristics/list/ListDetector$Text;", "", "text", "", "words", "", "(Ljava/lang/String;Ljava/util/List;)V", "getText", "()Ljava/lang/String;", "getWords", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "nlp-detect"})
    public static final class Text {
        @NotNull
        private final String text;
        @NotNull
        private final List<String> words;

        public Text(@NotNull String text2, @NotNull List<String> words2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(words2, (String)"words");
            this.text = text2;
            this.words = words2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<String> getWords() {
            return this.words;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<String> component2() {
            return this.words;
        }

        @NotNull
        public final Text copy(@NotNull String text2, @NotNull List<String> words2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(words2, (String)"words");
            return new Text(text2, words2);
        }

        public static /* synthetic */ Text copy$default(Text text2, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = text2.text;
            }
            if ((n & 2) != 0) {
                list2 = text2.words;
            }
            return text2.copy(string2, list2);
        }

        @NotNull
        public String toString() {
            return "Text(text=" + this.text + ", words=" + this.words + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + ((Object)this.words).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Text)) {
                return false;
            }
            Text text2 = (Text)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)text2.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.words, text2.words);
        }
    }
}

