/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.remote.ProcessControlWithMappings;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PyTargetPositionConverters;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\"\u001a\u00020#H\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/run/ProcessHandlerWithPyPositionConverter;", "Lcom/intellij/execution/process/KillableProcessHandler;", "Lcom/jetbrains/python/debugger/PositionConverterProvider;", "Lcom/intellij/remote/ProcessControlWithMappings;", "Lcom/intellij/execution/process/AnsiEscapeDecoder$ColoredTextAcceptor;", "process", "Ljava/lang/Process;", "commandLine", "", "charset", "Ljava/nio/charset/Charset;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "isMostlySilentProcess", "", "(Ljava/lang/Process;Ljava/lang/String;Ljava/nio/charset/Charset;Lcom/jetbrains/python/remote/PyRemotePathMapper;Z)V", "myAnsiEscapeDecoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "coloredTextAvailable", "", "text", "attributes", "Lcom/intellij/openapi/util/Key;", "createPositionConverter", "Lcom/jetbrains/python/debugger/PyPositionConverter;", "debugProcess", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "getFileMappings", "", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "getMappingSettings", "Lcom/intellij/util/PathMapper;", "notifyTextAvailable", "outputType", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "intellij.python.community.impl"})
public final class ProcessHandlerWithPyPositionConverter
extends KillableProcessHandler
implements PositionConverterProvider,
ProcessControlWithMappings,
AnsiEscapeDecoder.ColoredTextAcceptor {
    @NotNull
    private final PyRemotePathMapper pathMapper;
    private final boolean isMostlySilentProcess;
    @NotNull
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;

    public ProcessHandlerWithPyPositionConverter(@NotNull Process process2, @NotNull String commandLine, @NotNull Charset charset, @NotNull PyRemotePathMapper pathMapper, boolean isMostlySilentProcess) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        super(process2, commandLine, charset);
        this.pathMapper = pathMapper;
        this.isMostlySilentProcess = isMostlySilentProcess;
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
    }

    @Override
    @NotNull
    public PyPositionConverter createPositionConverter(@NotNull PyDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        return PyTargetPositionConverters.createTargetedPositionConverter(debugProcess, this.pathMapper);
    }

    @NotNull
    public PathMapper getMappingSettings() {
        return (PathMapper)this.pathMapper;
    }

    @NotNull
    public List<PathMappingSettings.PathMapping> getFileMappings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options;
        if (this.isMostlySilentProcess && !this.hasPty()) {
            BaseOutputReader.Options options2 = BaseOutputReader.Options.forMostlySilentProcess();
            Intrinsics.checkNotNull((Object)options2);
            options = options2;
        } else {
            BaseOutputReader.Options options3 = super.readerOptions();
            Intrinsics.checkNotNull((Object)options3);
            options = options3;
        }
        return options;
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (this.hasPty()) {
            super.notifyTextAvailable(text, outputType);
        } else {
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
        }
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key<?> attributes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        super.notifyTextAvailable(text, attributes);
    }
}

