/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.dataframe;

import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.ColumnFilter;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.debugger.dataframe.DataFrameTableCellRenderer;
import com.jetbrains.python.debugger.dataframe.DataFrameTableModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jetbrains.annotations.NotNull;

public class DataFrameViewStrategy
extends DataViewStrategy {
    private final String myTypeName;

    @NotNull
    public static DataFrameViewStrategy createInstanceForDataFrame() {
        return new DataFrameViewStrategy("DataFrame");
    }

    @NotNull
    public static DataFrameViewStrategy createInstanceForGeoDataFrame() {
        return new DataFrameViewStrategy("GeoDataFrame");
    }

    protected DataFrameViewStrategy(@NotNull String typeName) {
        if (typeName == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(0);
        }
        this.myTypeName = typeName;
    }

    @Override
    public AsyncArrayTableModel createTableModel(int rowCount, int columnCount, @NotNull PyDataViewerPanel dataProvider, @NotNull PyDebugValue debugValue) {
        if (dataProvider == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(1);
        }
        if (debugValue == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(2);
        }
        return new DataFrameTableModel(rowCount, columnCount, dataProvider, debugValue, this);
    }

    @Override
    public ColoredCellRenderer createCellRenderer(double minValue, double maxValue, @NotNull ArrayChunk arrayChunk) {
        if (arrayChunk == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(3);
        }
        return new DataFrameTableCellRenderer();
    }

    @Override
    public boolean isNumeric(String dtypeKind) {
        return true;
    }

    @Override
    @NotNull
    public String sortModifier(@NotNull String varName, @NotNull RowSorter.SortKey key) {
        if (varName == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(4);
        }
        if (key == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(5);
        }
        String string = String.format("%s.sort_values(by=%s.columns[%d]%s)", varName, varName, key.getColumn(), key.getSortOrder() == SortOrder.ASCENDING ? "" : ", ascending=False");
        if (string == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String filterModifier(@NotNull String varName, @NotNull ColumnFilter filter) {
        if (varName == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(8);
        }
        if (filter.isSubstring()) {
            String string = String.format("%1$s[%1$s.iloc[:, %2$d].apply(str).str.contains('%3$s', regex=%4$s)]", varName, filter.getColumn(), filter.getFilter(), filter.isRegex() ? "True" : "False");
            if (string == null) {
                DataFrameViewStrategy.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = String.format("%1$s[%1$s.iloc[:, %2$d].apply(lambda %4$s: bool(%3$s))]", varName, filter.getColumn(), filter.getFilter(), "x");
        if (string == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getTypeName() {
        String string = this.myTypeName;
        if (string == null) {
            DataFrameViewStrategy.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayChunk";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/dataframe/DataFrameViewStrategy";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/dataframe/DataFrameViewStrategy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sortModifier";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterModifier";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTableModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCellRenderer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sortModifier";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

