/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.containerview.PyDataView;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PyDataViewDialog
extends DialogWrapper {
    private final JPanel myMainPanel;
    private static final int TABLE_DEFAULT_WIDTH = 700;
    private static final int TABLE_DEFAULT_HEIGHT = 500;
    private final Project myProject;
    private final PyDataViewerPanel myDataViewerPanel;

    public PyDataViewDialog(@NotNull Project project2, @NotNull PyDebugValue value) {
        if (project2 == null) {
            PyDataViewDialog.$$$reportNull$$$0(0);
        }
        if (value == null) {
            PyDataViewDialog.$$$reportNull$$$0(1);
        }
        super(project2, false);
        this.myProject = project2;
        this.setModal(false);
        this.setCancelButtonText(PyBundle.message("debugger.data.view.close", new Object[0]));
        this.setCrossClosesWindow(true);
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myDataViewerPanel = new PyDataViewerPanel(project2, value.getFrameAccessor());
        this.myDataViewerPanel.apply(value, false);
        this.myDataViewerPanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.myMainPanel.add((Component)this.myDataViewerPanel, this.createDataViewPanelConstraints());
        this.myDataViewerPanel.addListener(new PyDataViewerPanel.Listener(){

            @Override
            public void onNameChanged(@NlsContexts.TabTitle @NotNull String name2) {
                if (name2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyDataViewDialog.this.setTitle(name2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/containerview/PyDataViewDialog$1", "onNameChanged"));
            }
        });
        this.addBottomElements();
        this.setTitle(value.getFullName());
        this.init();
    }

    protected void addBottomElements() {
        final JBCheckBox colored = new JBCheckBox(PyBundle.message("debugger.data.view.colored.cells", new Object[0]));
        final JBCheckBox resize = new JBCheckBox(PyBundle.message("debugger.data.view.resize.automatically", new Object[0]));
        resize.setSelected(PyDataView.isAutoResizeEnabled(this.myProject));
        colored.setSelected(PyDataView.isColoringEnabled(this.myProject));
        colored.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyDataViewDialog.this.myDataViewerPanel.setColored(colored.isSelected());
                PyDataViewDialog.this.myDataViewerPanel.updateUI();
            }
        });
        resize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyDataViewDialog.this.myDataViewerPanel.resize(resize.isSelected());
                PyDataViewDialog.this.myDataViewerPanel.updateUI();
            }
        });
        GridBagConstraints checkBoxConstraints = this.createCheckBoxConstraints();
        checkBoxConstraints.gridy = 1;
        this.myMainPanel.add((Component)colored, checkBoxConstraints);
        checkBoxConstraints.gridy = 2;
        this.myMainPanel.add((Component)resize, checkBoxConstraints);
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        if (actionArray == null) {
            PyDataViewDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected GridBagConstraints createDataViewPanelConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.9;
        c.weighty = 0.9;
        return c;
    }

    protected GridBagConstraints createCheckBoxConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.05;
        c.anchor = 21;
        return c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/containerview/PyDataViewDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataViewDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

