/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import java.awt.Graphics2D;
import java.awt.Paint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.ui.GradientTextureCache;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u00a8\u0006\f"}, d2={"getBlockBackgroundPaint", "Ljava/awt/Paint;", "editor", "Lcom/intellij/openapi/editor/Editor;", "g2d", "Ljava/awt/Graphics2D;", "blockWidth", "", "gradientCache", "Lorg/jetbrains/plugins/terminal/exp/ui/GradientTextureCache;", "backgroundKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "intellij.terminal"})
public final class TerminalBlockBackgroundRendererKt {
    @Nullable
    public static final Paint getBlockBackgroundPaint(@NotNull Editor editor, @NotNull Graphics2D g2d, int blockWidth, @Nullable GradientTextureCache gradientCache, @Nullable ColorKey backgroundKey) {
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        if (gradientCache != null) {
            paint = gradientCache.getTexture(g2d, blockWidth);
        } else {
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            ColorKey colorKey = backgroundKey;
            Intrinsics.checkNotNull((Object)colorKey);
            paint = editorColorsScheme.getColor(colorKey);
        }
        return paint;
    }
}

