/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.execution.ParametersListUtil;
import com.jediterm.terminal.TerminalStarter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.exp.ShellCommandExecutionManager;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandManager;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000 +2\u00020\u0001:\u0003+,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0007J.\u0010\u001a\u001a\u00020\u000b2\u001c\u0010\u001b\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001c\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\nH\u0002J\u000e\u0010!\u001a\b\u0018\u00010\u0012R\u00020\u0000H\u0002J\b\u0010\"\u001a\u00020\u000bH\u0002J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$2\u0006\u0010%\u001a\u00020\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0'J\u000e\u0010(\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\nJ\u001e\u0010)\u001a\b\u0012\u0004\u0012\u0002H*0'\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0\u0014H\u0002R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0018\u00010\u0012R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager;", "", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "commandManager", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager;)V", "commandSentListeners", "", "Lkotlin/Function1;", "", "", "isCommandRunning", "", "isInitialized", "lock", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager$Lock;", "runningGenerator", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager$Generator;", "scheduledCommands", "Ljava/util/Queue;", "scheduledGenerators", "addCommandSentListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "cancelGenerators", "withoutLock", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/terminal/exp/WithoutLockRegistrar;", "receivedEvent", "doSendCommandToExecute", "shellCommand", "pollNextGeneratorToRun", "processQueueIfReady", "runGeneratorAsync", "Lkotlinx/coroutines/CompletableDeferred;", "generatorName", "generatorParameters", "", "sendCommandToExecute", "drainToList", "T", "Companion", "Generator", "Lock", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandExecutionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandExecutionManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1855#2,2:254\n*S KotlinDebug\n*F\n+ 1 ShellCommandExecutionManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager\n*L\n177#1:254,2\n*E\n"})
public final class ShellCommandExecutionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final Lock lock;
    @NotNull
    private final Queue<Generator> scheduledGenerators;
    @Nullable
    private Generator runningGenerator;
    @NotNull
    private final Queue<String> scheduledCommands;
    private boolean isInitialized;
    private boolean isCommandRunning;
    @NotNull
    private final List<Function1<String, Unit>> commandSentListeners;
    @NotNull
    private static final AtomicInteger NEXT_REQUEST_ID = new AtomicInteger(0);
    @NotNull
    private static final Map<Character, String> pwshCharsToEscape;

    public ShellCommandExecutionManager(@NotNull BlockTerminalSession session2, @NotNull ShellCommandManager commandManager) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        this.session = session2;
        this.lock = new Lock();
        this.scheduledGenerators = new LinkedList();
        this.scheduledCommands = new LinkedList();
        this.commandSentListeners = new CopyOnWriteArrayList();
        commandManager.addListener(new ShellCommandListener(){

            @Override
            public void initialized() {
                lock.withLock((Function1<? super Function1<? super Function0<Unit>, Unit>, Unit>)((Function1)new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(this){
                    final /* synthetic */ ShellCommandExecutionManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> withoutLock) {
                        Intrinsics.checkNotNullParameter(withoutLock, (String)"withoutLock");
                        ShellCommandExecutionManager.access$setInitialized$p(this.this$0, true);
                        ShellCommandExecutionManager.access$cancelGenerators(this.this$0, withoutLock, "initialized");
                    }
                }));
                this.processQueueIfReady();
            }

            @Override
            public void commandFinished(@NotNull CommandFinishedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                lock.withLock((Function1<? super Function1<? super Function0<Unit>, Unit>, Unit>)((Function1)new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(this){
                    final /* synthetic */ ShellCommandExecutionManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> withoutLock) {
                        Intrinsics.checkNotNullParameter(withoutLock, (String)"withoutLock");
                        if (!ShellCommandExecutionManager.access$isCommandRunning$p(this.this$0)) {
                            ShellCommandManager.Companion.getLOG$intellij_terminal().warn("Received command_finished event, but command wasn't started");
                        }
                        ShellCommandExecutionManager.access$setCommandRunning$p(this.this$0, false);
                        ShellCommandExecutionManager.access$cancelGenerators(this.this$0, withoutLock, "command_finished");
                    }
                }));
                this.processQueueIfReady();
            }

            @Override
            public void generatorFinished(int requestId, @NotNull String result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                lock.withLock((Function1<? super Function1<? super Function0<Unit>, Unit>, Unit>)((Function1)new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(this, requestId, result2){
                    final /* synthetic */ ShellCommandExecutionManager this$0;
                    final /* synthetic */ int $requestId;
                    final /* synthetic */ String $result;
                    {
                        this.this$0 = $receiver;
                        this.$requestId = $requestId;
                        this.$result = $result;
                        super(1);
                    }

                    public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> withoutLock) {
                        Intrinsics.checkNotNullParameter(withoutLock, (String)"withoutLock");
                        if (ShellCommandExecutionManager.access$getRunningGenerator$p(this.this$0) == null) {
                            ShellCommandManager.Companion.getLOG$intellij_terminal().warn("Received generator_finished event (request_id=" + this.$requestId + "), but no running generator");
                        } else {
                            Generator generator = ShellCommandExecutionManager.access$getRunningGenerator$p(this.this$0);
                            Intrinsics.checkNotNull((Object)generator);
                            Generator runningGeneratorLocal = generator;
                            ShellCommandExecutionManager.access$setRunningGenerator$p(this.this$0, null);
                            withoutLock.invoke((Object)new Function0<Unit>(this.$requestId, runningGeneratorLocal, this.$result){
                                final /* synthetic */ int $requestId;
                                final /* synthetic */ Generator $runningGeneratorLocal;
                                final /* synthetic */ String $result;
                                {
                                    this.$requestId = $requestId;
                                    this.$runningGeneratorLocal = $runningGeneratorLocal;
                                    this.$result = $result;
                                    super(0);
                                }

                                public final void invoke() {
                                    if (this.$requestId == this.$runningGeneratorLocal.getRequestId()) {
                                        this.$runningGeneratorLocal.getDeferred().complete((Object)this.$result);
                                    } else {
                                        String msg = "Received generator_finished event (request_id=" + this.$requestId + "), but " + this.$runningGeneratorLocal + " was expected";
                                        ShellCommandManager.Companion.getLOG$intellij_terminal().warn(msg);
                                        this.$runningGeneratorLocal.getDeferred().completeExceptionally((Throwable)new IllegalStateException(msg));
                                    }
                                }
                            });
                        }
                    }
                }));
                this.processQueueIfReady();
            }
        }, this.session);
    }

    private final void cancelGenerators(Function1<? super Function0<Unit>, Unit> withoutLock, String receivedEvent) {
        block1: {
            Generator generator = this.runningGenerator;
            if (generator != null) {
                Generator runningGenerator = generator;
                boolean bl = false;
                withoutLock.invoke((Object)new Function0<Unit>(runningGenerator, receivedEvent){
                    final /* synthetic */ Generator $runningGenerator;
                    final /* synthetic */ String $receivedEvent;
                    {
                        this.$runningGenerator = $runningGenerator;
                        this.$receivedEvent = $receivedEvent;
                        super(0);
                    }

                    public final void invoke() {
                        String msg = "Unexpectedly running " + this.$runningGenerator + " when " + this.$receivedEvent + " event received";
                        ShellCommandManager.Companion.getLOG$intellij_terminal().warn(msg);
                        this.$runningGenerator.getDeferred().completeExceptionally((Throwable)new IllegalStateException(msg));
                    }
                });
            }
            this.runningGenerator = null;
            List list = UtilKt.nullize(this.drainToList(this.scheduledGenerators));
            if (list == null) break block1;
            List cancelledGenerators = list;
            boolean bl = false;
            ShellCommandManager.Companion.getLOG$intellij_terminal().warn("Unexpected scheduled generators " + cancelledGenerators + " when " + receivedEvent + " event received");
            withoutLock.invoke((Object)new Function0<Unit>((List<Generator>)cancelledGenerators, receivedEvent){
                final /* synthetic */ List<Generator> $cancelledGenerators;
                final /* synthetic */ String $receivedEvent;
                {
                    this.$cancelledGenerators = $cancelledGenerators;
                    this.$receivedEvent = $receivedEvent;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    Iterable iterable = this.$cancelledGenerators;
                    String string = this.$receivedEvent;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Generator it = (Generator)element$iv;
                        boolean bl = false;
                        it.getDeferred().cancel(new CancellationException("Unexpectedly scheduled generator when " + string + " event received"));
                    }
                }
            });
        }
    }

    public final void sendCommandToExecute(@NotNull String shellCommand2) {
        Intrinsics.checkNotNullParameter((Object)shellCommand2, (String)"shellCommand");
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        String command = StringsKt.replace$default((String)shellCommand2, (String)"\n", (String)string, (boolean)false, (int)4, null);
        this.lock.withLock((Function1<? super Function1<? super Function0<Unit>, Unit>, Unit>)((Function1)new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(this, command){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            final /* synthetic */ String $command;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                super(1);
            }

            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (ShellCommandExecutionManager.access$isCommandRunning$p(this.this$0)) {
                    ShellCommandManager.Companion.getLOG$intellij_terminal().info("Command '" + this.$command + "' is postponed until currently running command is finished");
                }
                if (!ShellCommandExecutionManager.access$isInitialized$p(this.this$0)) {
                    ShellCommandManager.Companion.getLOG$intellij_terminal().info("Command '" + this.$command + "' is postponed until `initialized` event is received");
                }
                ShellCommandExecutionManager.access$getScheduledCommands$p(this.this$0).offer(this.$command);
            }
        }));
        this.processQueueIfReady();
    }

    @NotNull
    public final CompletableDeferred<String> runGeneratorAsync(@NotNull String generatorName, @NotNull List<String> generatorParameters) {
        Intrinsics.checkNotNullParameter((Object)generatorName, (String)"generatorName");
        Intrinsics.checkNotNullParameter(generatorParameters, (String)"generatorParameters");
        Generator generator = new Generator(generatorName, generatorParameters);
        this.lock.withLock((Function1<? super Function1<? super Function0<Unit>, Unit>, Unit>)((Function1)new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(this, generator){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            final /* synthetic */ Generator $generator;
            {
                this.this$0 = $receiver;
                this.$generator = $generator;
                super(1);
            }

            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> withoutLock) {
                String cancelReason;
                Intrinsics.checkNotNullParameter(withoutLock, (String)"withoutLock");
                String string = ShellCommandExecutionManager.access$isCommandRunning$p(this.this$0) ? "Generator shouldn't be scheduled when command is running" : (cancelReason = !ShellCommandExecutionManager.access$isInitialized$p(this.this$0) ? "Generator shouldn't be scheduled when session hasn't been initialized yet" : null);
                if (cancelReason != null) {
                    withoutLock.invoke((Object)new Function0<Unit>(this.$generator, cancelReason){
                        final /* synthetic */ Generator $generator;
                        final /* synthetic */ String $cancelReason;
                        {
                            this.$generator = $generator;
                            this.$cancelReason = $cancelReason;
                            super(0);
                        }

                        public final void invoke() {
                            this.$generator.getDeferred().completeExceptionally((Throwable)new IllegalStateException(this.$cancelReason));
                        }
                    });
                }
                ShellCommandExecutionManager.access$getScheduledGenerators$p(this.this$0).offer(this.$generator);
            }
        }));
        this.processQueueIfReady();
        return generator.getDeferred();
    }

    @TestOnly
    public final void addCommandSentListener(@NotNull Disposable disposable, @NotNull Function1<? super String, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        TerminalUtil.addItem(this.commandSentListeners, listener, disposable);
    }

    private final void processQueueIfReady() {
        this.lock.withLock((Function1<? super Function1<? super Function0<Unit>, Unit>, Unit>)((Function1)new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(this){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> withoutLock) {
                block3: {
                    Intrinsics.checkNotNullParameter(withoutLock, (String)"withoutLock");
                    if (ShellCommandExecutionManager.access$getRunningGenerator$p(this.this$0) != null || ShellCommandExecutionManager.access$isCommandRunning$p(this.this$0) || !ShellCommandExecutionManager.access$isInitialized$p(this.this$0)) break block3;
                    String string = (String)ShellCommandExecutionManager.access$getScheduledCommands$p(this.this$0).poll();
                    if (string != null) {
                        String string2 = string;
                        ShellCommandExecutionManager shellCommandExecutionManager = this.this$0;
                        String command = string2;
                        boolean bl = false;
                        List list = UtilKt.nullize((List)ShellCommandExecutionManager.access$drainToList(shellCommandExecutionManager, ShellCommandExecutionManager.access$getScheduledGenerators$p(shellCommandExecutionManager)));
                        if (list != null) {
                            List cancelledGenerators = list;
                            boolean bl2 = false;
                            withoutLock.invoke((Object)new Function0<Unit>((List<Generator>)cancelledGenerators){
                                final /* synthetic */ List<Generator> $cancelledGenerators;
                                {
                                    this.$cancelledGenerators = $cancelledGenerators;
                                    super(0);
                                }

                                public final void invoke() {
                                    Iterable $this$forEach$iv = this.$cancelledGenerators;
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        Generator it = (Generator)element$iv;
                                        boolean bl = false;
                                        it.getDeferred().cancel(new CancellationException("Generator cancelled because of executing command"));
                                    }
                                }
                            });
                        }
                        ShellCommandExecutionManager.access$setCommandRunning$p(shellCommandExecutionManager, true);
                        ShellCommandExecutionManager.access$doSendCommandToExecute(shellCommandExecutionManager, command);
                        return;
                    }
                    Generator generator = ShellCommandExecutionManager.access$pollNextGeneratorToRun(this.this$0);
                    if (generator != null) {
                        Generator generator2 = generator;
                        ShellCommandExecutionManager shellCommandExecutionManager = this.this$0;
                        Generator it = generator2;
                        boolean bl = false;
                        ShellCommandExecutionManager.access$setRunningGenerator$p(shellCommandExecutionManager, it);
                        ShellCommandExecutionManager.access$doSendCommandToExecute(shellCommandExecutionManager, it.shellCommand());
                    }
                }
            }
        }));
    }

    private final Generator pollNextGeneratorToRun() {
        Generator generator = null;
        while ((generator = this.scheduledGenerators.poll()) != null && !generator.getDeferred().isActive()) {
        }
        return generator;
    }

    private final <T> List<T> drainToList(Queue<T> $this$drainToList) {
        ArrayList<T> arrayList;
        ArrayList<T> it = arrayList = new ArrayList<T>($this$drainToList.size());
        boolean bl = false;
        while (!((Collection)$this$drainToList).isEmpty()) {
            T t = $this$drainToList.poll();
            Intrinsics.checkNotNull(t);
            it.add(t);
        }
        return arrayList;
    }

    private final void doSendCommandToExecute(String shellCommand2) {
        Iterable $this$forEach$iv = this.commandSentListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)shellCommand2);
        }
        this.session.getTerminalStarterFuture$intellij_terminal().thenAccept(arg_0 -> ShellCommandExecutionManager.doSendCommandToExecute$lambda$4((Function1)new Function1<TerminalStarter, Unit>(this, shellCommand2){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            final /* synthetic */ String $shellCommand;
            {
                this.this$0 = $receiver;
                this.$shellCommand = $shellCommand;
                super(1);
            }

            public final void invoke(@Nullable TerminalStarter starter) {
                String string;
                if (starter == null) {
                    return;
                }
                if (doSendCommandToExecute.WhenMappings.$EnumSwitchMapping$0[ShellCommandExecutionManager.access$getSession$p(this.this$0).getShellIntegration().getShellType().ordinal()] == 1) {
                    byte[] byArray = starter.getTerminal().getCodeForKey(36, 2);
                    Intrinsics.checkNotNull((Object)byArray);
                    string = new String(byArray, Charsets.UTF_8);
                } else {
                    string = "\u0015";
                }
                String clearPrompt = string;
                TerminalUtil.sendCommandToExecute(clearPrompt + this.$shellCommand, starter);
            }
        }, arg_0));
    }

    private static final void doSendCommandToExecute$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isCommandRunning$p(ShellCommandExecutionManager $this) {
        return $this.isCommandRunning;
    }

    public static final /* synthetic */ boolean access$isInitialized$p(ShellCommandExecutionManager $this) {
        return $this.isInitialized;
    }

    public static final /* synthetic */ Queue access$getScheduledCommands$p(ShellCommandExecutionManager $this) {
        return $this.scheduledCommands;
    }

    public static final /* synthetic */ Queue access$getScheduledGenerators$p(ShellCommandExecutionManager $this) {
        return $this.scheduledGenerators;
    }

    public static final /* synthetic */ Generator access$getRunningGenerator$p(ShellCommandExecutionManager $this) {
        return $this.runningGenerator;
    }

    public static final /* synthetic */ Generator access$pollNextGeneratorToRun(ShellCommandExecutionManager $this) {
        return $this.pollNextGeneratorToRun();
    }

    public static final /* synthetic */ List access$drainToList(ShellCommandExecutionManager $this, Queue $receiver) {
        return $this.drainToList($receiver);
    }

    public static final /* synthetic */ void access$setCommandRunning$p(ShellCommandExecutionManager $this, boolean bl) {
        $this.isCommandRunning = bl;
    }

    public static final /* synthetic */ void access$doSendCommandToExecute(ShellCommandExecutionManager $this, String shellCommand2) {
        $this.doSendCommandToExecute(shellCommand2);
    }

    public static final /* synthetic */ void access$setRunningGenerator$p(ShellCommandExecutionManager $this, Generator generator) {
        $this.runningGenerator = generator;
    }

    public static final /* synthetic */ void access$setInitialized$p(ShellCommandExecutionManager $this, boolean bl) {
        $this.isInitialized = bl;
    }

    public static final /* synthetic */ void access$cancelGenerators(ShellCommandExecutionManager $this, Function1 withoutLock, String receivedEvent) {
        $this.cancelGenerators((Function1<? super Function0<Unit>, Unit>)withoutLock, receivedEvent);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('`'), (Object)"``"), TuplesKt.to((Object)Character.valueOf('\"'), (Object)"`\""), TuplesKt.to((Object)Character.valueOf('\u0000'), (Object)"`0"), TuplesKt.to((Object)Character.valueOf('\u0007'), (Object)"`a"), TuplesKt.to((Object)Character.valueOf('\b'), (Object)"`b"), TuplesKt.to((Object)Character.valueOf('\f'), (Object)"`f"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"`n"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"`r"), TuplesKt.to((Object)Character.valueOf('\t'), (Object)"`t"), TuplesKt.to((Object)Character.valueOf('\u000b'), (Object)"'v"), TuplesKt.to((Object)Character.valueOf('$'), (Object)"`$")};
        pwshCharsToEscape = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager$Companion;", "", "()V", "NEXT_REQUEST_ID", "Ljava/util/concurrent/atomic/AtomicInteger;", "pwshCharsToEscape", "", "", "", "escapePowerShellParameter", "parameter", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        private final String escapePowerShellParameter(String parameter) {
            StringBuilder stringBuilder;
            int n = parameter.length();
            StringBuilder $this$escapePowerShellParameter_u24lambda_u240 = stringBuilder = new StringBuilder(n);
            boolean bl = false;
            int n2 = parameter.length();
            for (int i = 0; i < n2; ++i) {
                char ch = parameter.charAt(i);
                Object object = (String)pwshCharsToEscape.get(Character.valueOf(ch));
                if (object == null) {
                    object = Character.valueOf(ch);
                }
                $this$escapePowerShellParameter_u24lambda_u240.append(object);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public static final /* synthetic */ String access$escapePowerShellParameter(Companion $this, String parameter) {
            return $this.escapePowerShellParameter(parameter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0003J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager$Generator;", "", "name", "", "parameters", "", "(Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager;Ljava/lang/String;Ljava/util/List;)V", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "getDeferred", "()Lkotlinx/coroutines/CompletableDeferred;", "getName", "()Ljava/lang/String;", "getParameters", "()Ljava/util/List;", "requestId", "", "getRequestId", "()I", "shellCommand", "toString", "intellij.terminal"})
    private final class Generator {
        @NotNull
        private final String name;
        @NotNull
        private final List<String> parameters;
        private final int requestId;
        @NotNull
        private final CompletableDeferred<String> deferred;

        public Generator(@NotNull String name, List<String> parameters) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            this.name = name;
            this.parameters = parameters;
            this.requestId = NEXT_REQUEST_ID.incrementAndGet();
            this.deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<String> getParameters() {
            return this.parameters;
        }

        public final int getRequestId() {
            return this.requestId;
        }

        @NotNull
        public final CompletableDeferred<String> getDeferred() {
            return this.deferred;
        }

        @NotNull
        public final String shellCommand() {
            String string;
            if (WhenMappings.$EnumSwitchMapping$0[ShellCommandExecutionManager.this.session.getShellIntegration().getShellType().ordinal()] == 1) {
                string = CollectionsKt.joinToString$default((Iterable)this.parameters, (CharSequence)" ", null, null, (int)0, null, (Function1)shellCommand.joinedParams.1.INSTANCE, (int)30, null);
            } else {
                String string2 = ParametersListUtil.join(this.parameters);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
            }
            String joinedParams2 = string;
            return this.name + " " + this.requestId + " " + joinedParams2;
        }

        @NotNull
        public String toString() {
            return "Generator(" + this.name + ", parameters=" + this.parameters + ", requestId=" + this.requestId + ")";
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ShellType.values().length];
                try {
                    nArray[ShellType.POWERSHELL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0004\u001a\u00020\u00052(\u0010\u0006\u001a$\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0004\u0012\u00020\u00050\u0007j\u0002`\t\u0012\u0004\u0012\u00020\u00050\u0007R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager$Lock;", "", "()V", "lock", "withLock", "", "block", "Lkotlin/Function1;", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/terminal/exp/WithoutLockRegistrar;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandExecutionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandExecutionManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager$Lock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1855#2,2:254\n*S KotlinDebug\n*F\n+ 1 ShellCommandExecutionManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager$Lock\n*L\n221#1:254,2\n*E\n"})
    private static final class Lock {
        @NotNull
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void withLock(@NotNull Function1<? super Function1<? super Function0<Unit>, Unit>, Unit> block2) {
            Intrinsics.checkNotNullParameter(block2, (String)"block");
            List withoutLockBlocks = new ArrayList();
            try {
                Object object = this.lock;
                synchronized (object) {
                    boolean $i$a$-synchronized-ShellCommandExecutionManager$Lock$withLock$22 = false;
                    block2.invoke((Object)new Function1<Function0<? extends Unit>, Unit>((List<Function0<Unit>>)withoutLockBlocks){
                        final /* synthetic */ List<Function0<Unit>> $withoutLockBlocks;
                        {
                            this.$withoutLockBlocks = $withoutLockBlocks;
                            super(1);
                        }

                        public final void invoke(@NotNull Function0<Unit> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            this.$withoutLockBlocks.add(it);
                        }
                    });
                    Unit $i$a$-synchronized-ShellCommandExecutionManager$Lock$withLock$22 = Unit.INSTANCE;
                }
            }
            finally {
                Iterable $this$forEach$iv = withoutLockBlocks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
            }
        }
    }
}

