/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.DynamicBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.exp.feedback.BlockTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.fus.BlockTerminalSwitchPlace;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

public final class TerminalSettingsPanel {
    private JPanel myWholePanel;
    private TextFieldWithHistoryWithBrowseButton myShellPathField;
    private JBCheckBox mySoundBellCheckBox;
    private JBCheckBox myCloseSessionCheckBox;
    private JBCheckBox myMouseReportCheckBox;
    private JTextField myTabNameTextField;
    private JBCheckBox myPasteOnMiddleButtonCheckBox;
    private JBCheckBox myCopyOnSelectionCheckBox;
    private JBCheckBox myOverrideIdeShortcuts;
    private JBCheckBox myShellIntegration;
    private TextFieldWithBrowseButton myStartDirectoryField;
    private JPanel myProjectSettingsPanel;
    private JPanel myGlobalSettingsPanel;
    private JPanel myConfigurablesPanel;
    private JBCheckBox myHighlightHyperlinks;
    private EnvironmentVariablesTextFieldWithBrowseButton myEnvVarField;
    private ActionLink myConfigureTerminalKeybindingsActionLink;
    private ComboBox<TerminalUiSettingsManager.CursorShape> myCursorShape;
    private JBCheckBox myUseOptionAsMetaKey;
    private JPanel myNewUiPanel;
    private JBCheckBox myNewUiCheckbox;
    private JBLabel myBetaLabel;
    private Project myProject;
    private TerminalOptionsProvider myOptionsProvider;
    private TerminalProjectOptionsProvider myProjectOptionsProvider;
    private final List<UnnamedConfigurable> myConfigurables;

    public TerminalSettingsPanel() {
        this.$$$setupUI$$$();
        this.myConfigurables = new ArrayList<UnnamedConfigurable>();
    }

    /*
     * WARNING - void declaration
     */
    public JComponent createPanel(@NotNull Project project, @NotNull TerminalOptionsProvider provider, @NotNull TerminalProjectOptionsProvider projectOptionsProvider) {
        void var7_10;
        if (project == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(1);
        }
        if (projectOptionsProvider == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myOptionsProvider = provider;
        this.myProjectOptionsProvider = projectOptionsProvider;
        this.myNewUiPanel.setVisible(ExperimentalUI.isNewUI());
        this.myBetaLabel.setIcon(AllIcons.General.Beta);
        this.myProjectSettingsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)TerminalBundle.message("settings.terminal.project.settings", new Object[0])));
        this.myGlobalSettingsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)TerminalBundle.message("settings.terminal.application.settings", new Object[0])));
        this.configureShellPathField();
        this.configureStartDirectoryField();
        ArrayList<JComponent> customComponents = new ArrayList<JComponent>();
        LocalTerminalCustomizer[] localTerminalCustomizerArray = (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions();
        int n = localTerminalCustomizerArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            LocalTerminalCustomizer c = localTerminalCustomizerArray[var7_10];
            UnnamedConfigurable configurable = c.getConfigurable(projectOptionsProvider.getProject());
            if (configurable != null) {
                this.myConfigurables.add(configurable);
                JComponent component2 = configurable.createComponent();
                if (component2 != null) {
                    customComponents.add(component2);
                }
            }
            ++var7_10;
        }
        if (!customComponents.isEmpty()) {
            this.myConfigurablesPanel.setLayout((LayoutManager)new GridLayoutManager(customComponents.size(), 1));
            int i = 0;
            for (Component component2 : customComponents) {
                this.myConfigurablesPanel.add(component2, new GridConstraints(i++, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, -1), new Dimension(-1, -1), new Dimension(-1, -1), 0, false));
            }
        }
        this.myUseOptionAsMetaKey.getParent().setVisible(SystemInfo.isMac);
        return this.myWholePanel;
    }

    private void configureStartDirectoryField() {
        this.myStartDirectoryField.addBrowseFolderListener("", TerminalBundle.message("settings.start.directory.browseFolder.description", new Object[0]), null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.setupTextFieldDefaultValue(this.myStartDirectoryField.getTextField(), () -> this.myProjectOptionsProvider.getDefaultStartingDirectory());
    }

    private void configureShellPathField() {
        this.myShellPathField.addBrowseFolderListener("", TerminalBundle.message("settings.terminal.shell.executable.path.browseFolder.description", new Object[0]), null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        this.setupTextFieldDefaultValue(((TextFieldWithHistory)this.myShellPathField.getChildComponent()).getTextEditor(), () -> this.myProjectOptionsProvider.defaultShellPath());
    }

    private void setupTextFieldDefaultValue(final @NotNull JTextField textField2, @NotNull Supplier<@NlsSafe String> defaultValueSupplier) {
        String defaultShellPath2;
        if (textField2 == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(3);
        }
        if (defaultValueSupplier == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)(defaultShellPath2 = defaultValueSupplier.get()))) {
            return;
        }
        textField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                textField2.setForeground(defaultShellPath2.equals(textField2.getText()) ? TerminalSettingsPanel.this.getDefaultValueColor() : TerminalSettingsPanel.this.getChangedValueColor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/terminal/TerminalSettingsPanel$1", "textChanged"));
            }
        });
        if (textField2 instanceof JBTextField) {
            ((JBTextField)textField2).getEmptyText().setText(defaultShellPath2);
        }
    }

    public boolean isModified() {
        return this.myNewUiCheckbox.isSelected() != Registry.is((String)"terminal.new.ui") || !Objects.equals(this.myShellPathField.getText(), this.myProjectOptionsProvider.getShellPath()) || !Objects.equals(this.myStartDirectoryField.getText(), StringUtil.notNullize((String)this.myProjectOptionsProvider.getStartingDirectory())) || !Objects.equals(this.myTabNameTextField.getText(), this.myOptionsProvider.getTabName()) || this.myCloseSessionCheckBox.isSelected() != this.myOptionsProvider.getCloseSessionOnLogout() || this.myMouseReportCheckBox.isSelected() != this.myOptionsProvider.getMouseReporting() || this.mySoundBellCheckBox.isSelected() != this.myOptionsProvider.getAudibleBell() || this.myCopyOnSelectionCheckBox.isSelected() != this.myOptionsProvider.getCopyOnSelection() || this.myPasteOnMiddleButtonCheckBox.isSelected() != this.myOptionsProvider.getPasteOnMiddleMouseButton() || this.myOverrideIdeShortcuts.isSelected() != this.myOptionsProvider.getOverrideIdeShortcuts() || this.myShellIntegration.isSelected() != this.myOptionsProvider.getShellIntegration() || this.myHighlightHyperlinks.isSelected() != this.myOptionsProvider.getHighlightHyperlinks() || this.myUseOptionAsMetaKey.isSelected() != this.myOptionsProvider.getUseOptionAsMetaKey() || this.myConfigurables.stream().anyMatch(c -> c.isModified()) || !Comparing.equal((Object)this.myEnvVarField.getData(), (Object)this.myProjectOptionsProvider.getEnvData()) || this.myCursorShape.getItem() != this.myOptionsProvider.getCursorShape();
    }

    public void apply() {
        RegistryValue blockTerminalSetting = Registry.get((String)"terminal.new.ui");
        if (blockTerminalSetting.asBoolean() != this.myNewUiCheckbox.isSelected()) {
            blockTerminalSetting.setValue(this.myNewUiCheckbox.isSelected());
            TerminalUsageTriggerCollector.triggerBlockTerminalSwitched$intellij_terminal(this.myProject, this.myNewUiCheckbox.isSelected(), BlockTerminalSwitchPlace.SETTINGS);
            if (!this.myNewUiCheckbox.isSelected()) {
                ApplicationManager.getApplication().invokeLater(() -> BlockTerminalFeedbackSurveyKt.showBlockTerminalFeedbackNotification(this.myProject), ModalityState.nonModal());
            }
        }
        this.myProjectOptionsProvider.setStartingDirectory(this.myStartDirectoryField.getText());
        this.myProjectOptionsProvider.setShellPath(this.myShellPathField.getText());
        this.myOptionsProvider.setTabName(this.myTabNameTextField.getText());
        this.myOptionsProvider.setCloseSessionOnLogout(this.myCloseSessionCheckBox.isSelected());
        this.myOptionsProvider.setMouseReporting(this.myMouseReportCheckBox.isSelected());
        this.myOptionsProvider.setAudibleBell(this.mySoundBellCheckBox.isSelected());
        this.myOptionsProvider.setCopyOnSelection(this.myCopyOnSelectionCheckBox.isSelected());
        this.myOptionsProvider.setPasteOnMiddleMouseButton(this.myPasteOnMiddleButtonCheckBox.isSelected());
        this.myOptionsProvider.setOverrideIdeShortcuts(this.myOverrideIdeShortcuts.isSelected());
        this.myOptionsProvider.setShellIntegration(this.myShellIntegration.isSelected());
        this.myOptionsProvider.setHighlightHyperlinks(this.myHighlightHyperlinks.isSelected());
        this.myOptionsProvider.setUseOptionAsMetaKey(this.myUseOptionAsMetaKey.isSelected());
        this.myConfigurables.forEach(c -> {
            try {
                c.apply();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        });
        this.myProjectOptionsProvider.setEnvData(this.myEnvVarField.getData());
        this.myOptionsProvider.setCursorShape((TerminalUiSettingsManager.CursorShape)ObjectUtils.notNull((Object)((TerminalUiSettingsManager.CursorShape)this.myCursorShape.getItem()), (Object)TerminalUiSettingsManager.CursorShape.BLOCK));
    }

    public void reset() {
        this.myNewUiCheckbox.setSelected(Registry.is((String)"terminal.new.ui"));
        this.myShellPathField.setText(this.myProjectOptionsProvider.getShellPath());
        this.myStartDirectoryField.setText(this.myProjectOptionsProvider.getStartingDirectory());
        this.myTabNameTextField.setText(this.myOptionsProvider.getTabName());
        this.myCloseSessionCheckBox.setSelected(this.myOptionsProvider.getCloseSessionOnLogout());
        this.myMouseReportCheckBox.setSelected(this.myOptionsProvider.getMouseReporting());
        this.mySoundBellCheckBox.setSelected(this.myOptionsProvider.getAudibleBell());
        this.myCopyOnSelectionCheckBox.setSelected(this.myOptionsProvider.getCopyOnSelection());
        this.myPasteOnMiddleButtonCheckBox.setSelected(this.myOptionsProvider.getPasteOnMiddleMouseButton());
        this.myOverrideIdeShortcuts.setSelected(this.myOptionsProvider.getOverrideIdeShortcuts());
        this.myShellIntegration.setSelected(this.myOptionsProvider.getShellIntegration());
        this.myHighlightHyperlinks.setSelected(this.myOptionsProvider.getHighlightHyperlinks());
        this.myUseOptionAsMetaKey.setSelected(this.myOptionsProvider.getUseOptionAsMetaKey());
        this.myConfigurables.forEach(c -> c.reset());
        this.myEnvVarField.setData(this.myProjectOptionsProvider.getEnvData());
        this.myCursorShape.setItem((Object)this.myOptionsProvider.getCursorShape());
        this.myEnvVarField.setEnabled(TrustedProjects.isTrusted((Project)this.myProject));
    }

    public Color getDefaultValueColor() {
        return TerminalSettingsPanel.findColorByKey("TextField.inactiveForeground", "nimbusDisabledText");
    }

    private void createUIComponents() {
        this.myConfigureTerminalKeybindingsActionLink = new ActionLink("", e -> {
            Settings settings = (Settings)DataManager.getInstance().getDataContext((Component)((ActionLink)e.getSource())).getData(Settings.KEY);
            if (settings != null) {
                Configurable configurable = settings.find("preferences.keymap");
                settings.select(configurable, "Terminal").doWhenDone(() -> EdtExecutorService.getScheduledExecutorInstance().schedule(() -> settings.select(configurable, "Terminal"), 100L, TimeUnit.MILLISECONDS));
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myConfigureTerminalKeybindingsActionLink);
        this.myCursorShape = new ComboBox((Object[])TerminalUiSettingsManager.CursorShape.values());
        this.myCursorShape.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> label.setText(value.getText())));
        this.myShellPathField = this.createShellPath();
    }

    @NotNull
    private TextFieldWithHistoryWithBrowseButton createShellPath() {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                return new JBTextField();
            }
        });
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> this.detectShells());
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(5);
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    @NotNull
    private List<String> detectShells() {
        ArrayList<String> shells = new ArrayList<String>();
        if (SystemInfo.isUnix) {
            TerminalSettingsPanel.addIfExists(shells, "/bin/bash");
            TerminalSettingsPanel.addIfExists(shells, "/usr/bin/zsh");
            TerminalSettingsPanel.addIfExists(shells, "/usr/local/bin/zsh");
            TerminalSettingsPanel.addIfExists(shells, "/usr/bin/fish");
            TerminalSettingsPanel.addIfExists(shells, "/usr/local/bin/fish");
        } else if (SystemInfo.isWindows) {
            String cmderRoot;
            File gitBash;
            File pwsh;
            File cmd;
            File powershell = PathEnvironmentVariableUtil.findInPath((String)"powershell.exe");
            if (powershell != null && StringUtil.startsWithIgnoreCase((String)powershell.getAbsolutePath(), (String)"C:\\Windows\\System32\\WindowsPowerShell\\")) {
                shells.add(powershell.getAbsolutePath());
            }
            if ((cmd = PathEnvironmentVariableUtil.findInPath((String)"cmd.exe")) != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\")) {
                shells.add(cmd.getAbsolutePath());
            }
            if ((pwsh = PathEnvironmentVariableUtil.findInPath((String)"pwsh.exe")) != null && StringUtil.startsWithIgnoreCase((String)pwsh.getAbsolutePath(), (String)"C:\\Program Files\\PowerShell\\")) {
                shells.add(pwsh.getAbsolutePath());
            }
            if ((gitBash = new File("C:\\Program Files\\Git\\bin\\bash.exe")).isFile()) {
                shells.add(gitBash.getAbsolutePath());
            }
            if ((cmderRoot = EnvironmentUtil.getValue((String)"CMDER_ROOT")) == null) {
                cmderRoot = (String)this.myEnvVarField.getEnvs().get("CMDER_ROOT");
            }
            if (cmderRoot != null && cmd != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\")) {
                shells.add("cmd.exe /k \"%CMDER_ROOT%\\vendor\\init.bat\"");
            }
        }
        ArrayList<String> arrayList = shells;
        if (arrayList == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void addIfExists(@NotNull List<String> shells, @NotNull String filePath) {
        if (shells == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(8);
        }
        if (Files.exists(Path.of(filePath, new String[0]), new LinkOption[0])) {
            shells.add(filePath);
        }
    }

    @NotNull
    private static Color findColorByKey(String ... colorKeys) {
        String key;
        Color c = null;
        String[] stringArray = colorKeys;
        int n = stringArray.length;
        for (int i = 0; i < n && (c = UIManager.getColor(key = stringArray[i])) == null; ++i) {
        }
        assert (c != null) : "Can't find color for keys " + Arrays.toString(colorKeys);
        Color color = c;
        if (color == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(9);
        }
        return color;
    }

    public Color getChangedValueColor() {
        return TerminalSettingsPanel.findColorByKey("TextField.foreground");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBCheckBox jBCheckBox7;
        JBCheckBox jBCheckBox8;
        JBCheckBox jBCheckBox9;
        JBCheckBox jBCheckBox10;
        JTextField jTextField;
        JPanel jPanel3;
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myWholePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(10, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(3, 0, 7, 4, 0, 2, 1, 6, null, null, null));
        this.myProjectSettingsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.start.directory"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStartDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.environment.variables"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvVarField = environmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        environmentVariablesTextFieldWithBrowseButton.setText("");
        jPanel4.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGlobalSettingsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(12, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.tab.name"));
        jPanel7.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTabNameTextField = jTextField = new JTextField();
        jPanel7.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.shell.path"));
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = this.myShellPathField;
        jPanel7.add((Component)textFieldWithHistoryWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySoundBellCheckBox = jBCheckBox10 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox10, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.audible.bell"));
        jPanel8.add((Component)jBCheckBox10, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel9, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCloseSessionCheckBox = jBCheckBox9 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox9, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.close.session.when.it.ends"));
        jPanel9.add((Component)jBCheckBox9, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel9.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel10, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMouseReportCheckBox = jBCheckBox8 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox8, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.mouse.reporting"));
        jPanel10.add((Component)jBCheckBox8, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel10.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel11, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCopyOnSelectionCheckBox = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.copy.to.clipboard.on.selection"));
        jPanel11.add((Component)jBCheckBox7, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel11.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel12, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPasteOnMiddleButtonCheckBox = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.paste.on.middle.mouse.button.click"));
        jPanel12.add((Component)jBCheckBox6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel12.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel13, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOverrideIdeShortcuts = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.override.ide.shortcuts"));
        jPanel13.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel13.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ActionLink actionLink = this.myConfigureTerminalKeybindingsActionLink;
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.configure.terminal.keybindings"));
        actionLink.setToolTipText(DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.keymap.plugins.terminal"));
        jPanel13.add((Component)actionLink, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel14, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShellIntegration = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.shell.integration"));
        jPanel14.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel14.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConfigurablesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(10, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel15, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHighlightHyperlinks = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.highlight.hyperlinks"));
        jPanel15.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel15.add((Component)spacer9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel16, new GridConstraints(11, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.cursor.shape.label"));
        jPanel16.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel16.add((Component)spacer10, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ComboBox<TerminalUiSettingsManager.CursorShape> comboBox = this.myCursorShape;
        jPanel16.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel17, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseOptionAsMetaKey = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.use.option.as.meta.key.label"));
        jPanel17.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer11 = new Spacer();
        jPanel17.add((Component)spacer11, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myNewUiPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myNewUiCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.enable.new.ui"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBetaLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer12 = new Spacer();
        jPanel.add((Component)spacer12, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor((Component)environmentVariablesTextFieldWithBrowseButton);
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor((Component)textFieldWithHistoryWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectOptionsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueSupplier";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalSettingsPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shells";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalSettingsPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectShells";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findColorByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupTextFieldDefaultValue";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addIfExists";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

