/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMixedListInfo;
import com.intellij.ide.actions.searcheverywhere.SearchRestartReason;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.searchEverywhereMl.SearchEverywhereMlExperiment;
import com.intellij.searchEverywhereMl.ranking.core.FeaturesLoggingRandomisation;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereFoundElementInfoWithMl;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMLContextInfo;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMLSearchSession;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMLStatisticsCollector;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlFeaturesCache;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlSearchState;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCacheDataProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereContributorStatisticianKt;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereStatisticianService;
import com.intellij.searchEverywhereMl.ranking.core.id.MissingKeyProviderCollector;
import com.intellij.searchEverywhereMl.ranking.core.id.SearchEverywhereMlOrderedItemIdProvider;
import com.intellij.searchEverywhereMl.ranking.core.model.SearchEverywhereModelProvider;
import com.intellij.searchEverywhereMl.ranking.core.performance.PerformanceTracker;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u0004\u0018\u00010\u0011J\u0006\u0010%\u001a\u00020&JJ\u0010'\u001a\u00020&2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00010-2\u0006\u0010.\u001a\u00020/2\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020-01J,\u00103\u001a\u00020&2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020)2\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020-01Jn\u00104\u001a\u00020&2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020)2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u0002082\u0012\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020-012\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020/R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "mixedListInfo", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "sessionId", "", "loggingRandomisation", "Lcom/intellij/searchEverywhereMl/ranking/core/FeaturesLoggingRandomisation;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;ILcom/intellij/searchEverywhereMl/ranking/core/FeaturesLoggingRandomisation;)V", "cachedContextInfo", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLContextInfo;", "getCachedContextInfo", "()Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLContextInfo;", "currentSearchState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMlSearchState;", "featureCache", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMlFeaturesCache;", "itemIdProvider", "Lcom/intellij/searchEverywhereMl/ranking/core/id/SearchEverywhereMlOrderedItemIdProvider;", "getItemIdProvider", "()Lcom/intellij/searchEverywhereMl/ranking/core/id/SearchEverywhereMlOrderedItemIdProvider;", "logger", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLStatisticsCollector;", "getMixedListInfo", "()Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "modelProviderWithCache", "Lcom/intellij/searchEverywhereMl/ranking/core/model/SearchEverywhereModelProvider;", "performanceTracker", "Lcom/intellij/searchEverywhereMl/ranking/core/performance/PerformanceTracker;", "providersCache", "Lcom/intellij/searchEverywhereMl/ranking/core/features/FeaturesProviderCache;", "sessionStartTime", "", "getCurrentSearchState", "notifySearchResultsUpdated", "", "onItemSelected", "experimentStrategy", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment;", "indexes", "", "selectedItems", "", "closePopup", "", "elementsProvider", "Lkotlin/Function0;", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereFoundElementInfoWithMl;", "onSearchFinished", "onSearchRestart", "reason", "Lcom/intellij/ide/actions/searcheverywhere/SearchRestartReason;", "tabId", "", "orderByMl", "keysTyped", "backspacesTyped", "searchQuery", "previousElementsProvider", "searchScope", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "isSearchEverywhere", "intellij.searchEverywhereMl.ranking.core"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereMLSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereMLSearchSession.kt\ncom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n42#2,3:146\n1855#3,2:149\n1855#3,2:151\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereMLSearchSession.kt\ncom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession\n*L\n88#1:146,3\n89#1:149,2\n94#1:151,2\n*E\n"})
public final class SearchEverywhereMLSearchSession {
    @NotNull
    private final SearchEverywhereMixedListInfo mixedListInfo;
    private final int sessionId;
    @NotNull
    private final FeaturesLoggingRandomisation loggingRandomisation;
    @NotNull
    private final SearchEverywhereMlOrderedItemIdProvider itemIdProvider;
    private final long sessionStartTime;
    @Nullable
    private final FeaturesProviderCache providersCache;
    @NotNull
    private final SearchEverywhereModelProvider modelProviderWithCache;
    @NotNull
    private final SearchEverywhereMlFeaturesCache featureCache;
    @NotNull
    private final SearchEverywhereMLContextInfo cachedContextInfo;
    @NotNull
    private final AtomicReference<SearchEverywhereMlSearchState> currentSearchState;
    @NotNull
    private final SearchEverywhereMLStatisticsCollector logger;
    @NotNull
    private final PerformanceTracker performanceTracker;

    public SearchEverywhereMLSearchSession(@Nullable Project project, @NotNull SearchEverywhereMixedListInfo mixedListInfo, int sessionId, @NotNull FeaturesLoggingRandomisation loggingRandomisation) {
        Intrinsics.checkNotNullParameter((Object)mixedListInfo, (String)"mixedListInfo");
        Intrinsics.checkNotNullParameter((Object)loggingRandomisation, (String)"loggingRandomisation");
        this.mixedListInfo = mixedListInfo;
        this.sessionId = sessionId;
        this.loggingRandomisation = loggingRandomisation;
        this.itemIdProvider = new SearchEverywhereMlOrderedItemIdProvider((Function1<Object, Unit>)((Function1)itemIdProvider.1.INSTANCE));
        this.sessionStartTime = System.currentTimeMillis();
        this.providersCache = new FeaturesProviderCacheDataProvider().getDataToCache(project);
        this.modelProviderWithCache = new SearchEverywhereModelProvider();
        this.featureCache = new SearchEverywhereMlFeaturesCache();
        this.cachedContextInfo = new SearchEverywhereMLContextInfo(project);
        this.currentSearchState = new AtomicReference();
        this.logger = SearchEverywhereMLStatisticsCollector.INSTANCE;
        this.performanceTracker = new PerformanceTracker();
    }

    @NotNull
    public final SearchEverywhereMixedListInfo getMixedListInfo() {
        return this.mixedListInfo;
    }

    @NotNull
    public final SearchEverywhereMlOrderedItemIdProvider getItemIdProvider() {
        return this.itemIdProvider;
    }

    @NotNull
    public final SearchEverywhereMLContextInfo getCachedContextInfo() {
        return this.cachedContextInfo;
    }

    public final void onSearchRestart(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull SearchRestartReason reason, @NotNull String tabId, boolean orderByMl, int keysTyped, int backspacesTyped, @NotNull String searchQuery, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> previousElementsProvider, @Nullable ScopeDescriptor searchScope, boolean isSearchEverywhere) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter(previousElementsProvider, (String)"previousElementsProvider");
        int prevTimeToResult = this.performanceTracker.getTimeElapsed();
        SearchEverywhereMlSearchState prevState = this.currentSearchState.getAndUpdate(arg_0 -> SearchEverywhereMLSearchSession.onSearchRestart$lambda$0(reason, experimentStrategy, this, tabId, orderByMl, keysTyped, backspacesTyped, searchQuery, project, searchScope, isSearchEverywhere, arg_0));
        if (prevState != null && experimentStrategy.isLoggingEnabledForTab(prevState.getTabId())) {
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(prevState.getTabId());
            this.logger.onSearchRestarted$intellij_searchEverywhereMl_ranking_core(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, this.cachedContextInfo, prevState, this.featureCache, prevTimeToResult, this.mixedListInfo, previousElementsProvider);
        }
    }

    public final void onItemSelected(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull int[] indexes, @NotNull List<? extends Object> selectedItems, boolean closePopup, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> elementsProvider) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
        Intrinsics.checkNotNullParameter(elementsProvider, (String)"elementsProvider");
        SearchEverywhereMlSearchState state = this.getCurrentSearchState();
        if (state != null && experimentStrategy.isLoggingEnabledForTab(state.getTabId())) {
            if (project != null) {
                Object it;
                boolean $i$f$service = false;
                Class<SearchEverywhereStatisticianService> serviceClass$iv = SearchEverywhereStatisticianService.class;
                Iterator iterator = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (iterator == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                SearchEverywhereStatisticianService statisticianService = (SearchEverywhereStatisticianService)((Object)iterator);
                Iterable $this$forEach$iv = selectedItems;
                boolean $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    it = element$iv = iterator.next();
                    boolean bl = false;
                    statisticianService.increaseUseCount(it);
                }
                if (Intrinsics.areEqual((Object)state.getTabId(), (Object)"SearchEverywhereContributor.All")) {
                    $this$forEach$iv = CollectionsKt.slice((List)((List)elementsProvider.invoke()), (Iterable)ArraysKt.asIterable((int[])indexes));
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (SearchEverywhereFoundElementInfoWithMl)((Object)element$iv);
                        boolean bl = false;
                        String string = ((SearchEverywhereFoundElementInfoWithMl)((Object)it)).contributor.getSearchProviderId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchProviderId(...)");
                        SearchEverywhereContributorStatisticianKt.increaseContributorUseCount(string);
                    }
                }
            }
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(state.getTabId());
            this.logger.onItemSelected$intellij_searchEverywhereMl_ranking_core(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, state, this.featureCache, indexes, selectedItems, closePopup, this.performanceTracker.getTimeElapsed(), this.mixedListInfo, elementsProvider);
        }
        if (closePopup) {
            MissingKeyProviderCollector.INSTANCE.report(this.sessionId);
        }
    }

    public final void onSearchFinished(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> elementsProvider) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter(elementsProvider, (String)"elementsProvider");
        SearchEverywhereMlSearchState state = this.getCurrentSearchState();
        if (state != null && experimentStrategy.isLoggingEnabledForTab(state.getTabId())) {
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(state.getTabId());
            this.logger.onSearchFinished$intellij_searchEverywhereMl_ranking_core(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, state, this.featureCache, this.performanceTracker.getTimeElapsed(), this.mixedListInfo, elementsProvider);
        }
        MissingKeyProviderCollector.INSTANCE.report(this.sessionId);
    }

    public final void notifySearchResultsUpdated() {
        this.performanceTracker.stop();
    }

    @Nullable
    public final SearchEverywhereMlSearchState getCurrentSearchState() {
        return this.currentSearchState.get();
    }

    private static final SearchEverywhereMlSearchState onSearchRestart$lambda$0(SearchRestartReason $reason, SearchEverywhereMlExperiment $experimentStrategy, SearchEverywhereMLSearchSession this$0, String $tabId, boolean $orderByMl, int $keysTyped, int $backspacesTyped, String $searchQuery, Project $project, ScopeDescriptor $searchScope, boolean $isSearchEverywhere, SearchEverywhereMlSearchState prevState) {
        Intrinsics.checkNotNullParameter((Object)$reason, (String)"$reason");
        Intrinsics.checkNotNullParameter((Object)$experimentStrategy, (String)"$experimentStrategy");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tabId, (String)"$tabId");
        Intrinsics.checkNotNullParameter((Object)$searchQuery, (String)"$searchQuery");
        long startTime = System.currentTimeMillis();
        SearchRestartReason searchReason = prevState == null ? SearchRestartReason.SEARCH_STARTED : $reason;
        SearchEverywhereMlSearchState searchEverywhereMlSearchState = prevState;
        int nextSearchIndex = (searchEverywhereMlSearchState != null ? searchEverywhereMlSearchState.getSearchIndex() : 0) + 1;
        int experimentGroup = $experimentStrategy.getExperimentGroup();
        this$0.performanceTracker.start();
        return new SearchEverywhereMlSearchState(this$0.sessionStartTime, startTime, nextSearchIndex, searchReason, $tabId, experimentGroup, $orderByMl, $keysTyped, $backspacesTyped, $searchQuery, this$0.modelProviderWithCache, this$0.providersCache, $project, $searchScope, $isSearchEverywhere);
    }
}

