/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.util;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0017\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0017\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "frontendAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "Lcom/intellij/openapi/actionSystem/DataContext;", "getFrontendAppSession", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/client/ClientAppSession;", "frontendProjectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "getFrontendProjectSession", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/client/ClientProjectSession;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/project/Project;", "intellij.rd.platform"})
public final class DataContextKt {
    @NotNull
    private static final Logger logger;

    @Nullable
    public static final Project getProject(@NotNull DataContext $this$project) {
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"<this>");
        return (Project)CommonDataKeys.PROJECT.getData($this$project);
    }

    @Nullable
    public static final ClientProjectSession getFrontendProjectSession(@NotNull DataContext $this$frontendProjectSession) {
        Intrinsics.checkNotNullParameter((Object)$this$frontendProjectSession, (String)"<this>");
        Project project = DataContextKt.getProject($this$frontendProjectSession);
        if (project == null || project.isDefault()) {
            return null;
        }
        List sessions = ClientSessionsManager.Companion.getProjectSessions(project, ClientKind.FRONTEND);
        return (ClientProjectSession)CollectionsKt.singleOrNull((List)sessions);
    }

    @Nullable
    public static final ClientAppSession getFrontendAppSession(@NotNull DataContext $this$frontendAppSession) {
        Intrinsics.checkNotNullParameter((Object)$this$frontendAppSession, (String)"<this>");
        ClientProjectSession projectSession = DataContextKt.getFrontendProjectSession($this$frontendAppSession);
        if (projectSession != null) {
            return projectSession.getAppSession();
        }
        List sessions = ClientSessionsManager.Companion.getAppSessions(ClientKind.FRONTEND);
        if (sessions.size() > 1) {
            logger.error("There are more then one session, but there is no project in data context: " + $this$frontendAppSession);
            return (ClientAppSession)CollectionsKt.firstOrNull((List)sessions);
        }
        return (ClientAppSession)CollectionsKt.singleOrNull((List)sessions);
    }

    static {
        Logger logger = Logger.getInstance((String)"frontendSession Data Rule");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DataContextKt.logger = logger;
    }
}

