/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ForkedDebuggerHelper {
    public static final String DEBUG_SOCKET = "-debugSocket";
    private int myDebugPort = -1;
    private Socket myDebugSocket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int findAvailableSocketPort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int port = serverSocket.getLocalPort();
            ServerSocket serverSocket2 = serverSocket;
            synchronized (serverSocket2) {
                try {
                    serverSocket.wait(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            int n = port;
            return n;
        }
    }

    public void setupDebugger(List<String> parameters) throws IOException {
        if (this.myDebugPort > -1) {
            int debugAddress = ForkedDebuggerHelper.findAvailableSocketPort();
            boolean found2 = false;
            for (int i = 0; i < parameters.size(); ++i) {
                String parameter = parameters.get(i);
                int indexOf = Math.max(parameter.indexOf("transport=dt_socket"), parameter.indexOf("transport=dt_shmem"));
                if (indexOf < 0) continue;
                if (debugAddress > -1) {
                    parameter = parameter.substring(0, indexOf) + "transport=dt_socket,server=n,suspend=y,address=" + debugAddress;
                    parameters.set(i, parameter);
                    found2 = true;
                    break;
                }
                parameters.remove(parameter);
                break;
            }
            if (!found2) {
                parameters.add("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + debugAddress);
            }
            if (debugAddress > -1) {
                Socket socket = this.getDebugSocket();
                DataOutputStream stream = new DataOutputStream(socket.getOutputStream());
                stream.writeInt(debugAddress);
                int n = socket.getInputStream().read();
            }
        }
    }

    protected Socket getDebugSocket() throws IOException {
        if (this.myDebugSocket == null) {
            this.myDebugSocket = new Socket("127.0.0.1", this.myDebugPort);
        }
        return this.myDebugSocket;
    }

    public String[] excludeDebugPortFromArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith(DEBUG_SOCKET)) continue;
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
            list.remove(arg);
            args = list.toArray(new String[0]);
            this.myDebugPort = Integer.parseInt(arg.substring(DEBUG_SOCKET.length()));
            break;
        }
        return args;
    }

    public void closeDebugSocket() throws IOException {
        if (this.myDebugSocket != null) {
            this.myDebugSocket.close();
        }
    }
}

