/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sinh(-2.0) => -3.6268604
 * sinh(-0.6666667) => -0.7171585
 * sinh(0.6666667) => 0.7171585
 * sinh(2.0) => 3.6268604
 */
#version 150

void main()
{
  float[distance(sinh(-2.0), -3.6268604) <= 0.0036268604 ? 1 : -1] array0;
  float[distance(sinh(-0.6666667), -0.7171585) <= 0.0007171585 ? 1 : -1] array1;
  float[distance(sinh(0.6666667), 0.7171585) <= 0.0007171585 ? 1 : -1] array2;
  float[distance(sinh(2.0), 3.6268604) <= 0.0036268604 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
