/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 + vec3(-0.03, -0.85, -0.94)) => vec3(-0.03, -0.85, -0.94)
 * (0.0 + vec3(1.67, 0.66, 1.87)) => vec3(1.67, 0.66, 1.87)
 * (-1.33 + vec3(-0.03, -0.85, -0.94)) => vec3(-1.36, -2.18, -2.27)
 * (-1.33 + vec3(1.67, 0.66, 1.87)) => vec3(0.3399999, -0.67, 0.53999996)
 * (0.85 + vec3(-0.03, -0.85, -0.94)) => vec3(0.82000005, 0.0, -0.089999974)
 * (0.85 + vec3(1.67, 0.66, 1.87)) => vec3(2.52, 1.51, 2.72)
 */
#version 120

void main()
{
  float[distance((0.0 + vec3(-0.03, -0.85, -0.94)), vec3(-0.03, -0.85, -0.94)) <= 1.2676751e-05 ? 1 : -1] array0;
  float[distance((0.0 + vec3(1.67, 0.66, 1.87)), vec3(1.67, 0.66, 1.87)) <= 2.5925663e-05 ? 1 : -1] array1;
  float[distance((-1.33 + vec3(-0.03, -0.85, -0.94)), vec3(-1.36, -2.18, -2.27)) <= 3.4285422e-05 ? 1 : -1] array2;
  float[distance((-1.33 + vec3(1.67, 0.66, 1.87)), vec3(0.3399999, -0.67, 0.53999996)) <= 9.252567e-06 ? 1 : -1] array3;
  float[distance((0.85 + vec3(-0.03, -0.85, -0.94)), vec3(0.82000005, 0.0, -0.089999974)) <= 8.2492425e-06 ? 1 : -1] array4;
  float[distance((0.85 + vec3(1.67, 0.66, 1.87)), vec3(2.52, 1.51, 2.72)) <= 4.003611e-05 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
