"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createGeospatialCluster;
var _geospatial_plugin = _interopRequireDefault(require("./geospatial_plugin"));
var _constants = require("../services/utils/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createGeospatialCluster(core, globalConfig) {
  const {
    customHeaders,
    ...rest
  } = globalConfig.opensearch;
  return core.opensearch.legacy.createClient(_constants.CLUSTER.GEOSPATIAL, {
    plugins: [_geospatial_plugin.default],
    // Currently we are overriding any headers with our own since we explicitly required User-Agent to be OpenSearch Dashboards
    // for integration with our backend plugin.
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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