/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.stream.MapStream;
import aQute.lib.collections.MultiMap;
import aQute.lib.io.IO;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Instructions
implements Map<Instruction, Attrs> {
    private LinkedHashMap<Instruction, Attrs> map;
    public static Instructions ALWAYS = new Instructions();
    static Map<Instruction, Attrs> EMPTY = Collections.emptyMap();

    public Instructions(Instructions other) {
        if (other.map != null && !other.map.isEmpty()) {
            this.map = new LinkedHashMap<Instruction, Attrs>(other.map);
        }
    }

    public Instructions(Collection<String> other) {
        if (other != null) {
            for (String s : other) {
                this.put(new Instruction(s), null);
            }
        }
    }

    public Instructions() {
    }

    public Instructions(Parameters contained) {
        this.append(contained);
    }

    public Instructions(String h) {
        this(new Parameters(h));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Instruction name) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(name);
    }

    @Override
    @Deprecated
    public boolean containsKey(Object name) {
        assert (name instanceof Instruction);
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(name);
    }

    public boolean containsValue(Attrs value) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsValue(value);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object value) {
        assert (value instanceof Attrs);
        if (this.map == null) {
            return false;
        }
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Instruction, Attrs>> entrySet() {
        if (this.map == null) {
            return EMPTY.entrySet();
        }
        return this.map.entrySet();
    }

    public MapStream<Instruction, Attrs> stream() {
        return MapStream.of(this);
    }

    @Override
    @Deprecated
    public Attrs get(Object key) {
        assert (key instanceof Instruction);
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    public Attrs get(Instruction key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    @Override
    public Set<Instruction> keySet() {
        if (this.map == null) {
            return EMPTY.keySet();
        }
        return this.map.keySet();
    }

    @Override
    public Attrs put(Instruction key, Attrs value) {
        if (this.map == null) {
            this.map = new LinkedHashMap();
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Instruction, ? extends Attrs> map) {
        if (this.map == null) {
            if (map.isEmpty()) {
                return;
            }
            this.map = new LinkedHashMap();
        }
        this.map.putAll(map);
    }

    @Override
    @Deprecated
    public Attrs remove(Object var0) {
        assert (var0 instanceof Instruction);
        if (this.map == null) {
            return null;
        }
        return (Attrs)this.map.remove(var0);
    }

    public Attrs remove(Instruction var0) {
        if (this.map == null) {
            return null;
        }
        return (Attrs)this.map.remove(var0);
    }

    @Override
    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    @Override
    public Collection<Attrs> values() {
        if (this.map == null) {
            return EMPTY.values();
        }
        return this.map.values();
    }

    public String toString() {
        return this.map == null ? "{}" : this.map.toString();
    }

    public void append(Parameters other) {
        other.stream().mapKey(Instruction::new).forEachOrdered(this::put);
    }

    public void appendIfAbsent(Parameters other) {
        Set present = this.keySet().stream().map(Instruction::getInput).collect(Collectors.toSet());
        other.stream().filterKey(k -> !present.contains(k)).mapKey(Instruction::new).forEachOrdered(this::put);
    }

    public <T> Collection<T> select(Collection<T> set, boolean emptyIsAll) {
        return this.select(set, null, emptyIsAll);
    }

    public <T> Collection<T> select(Collection<T> set, Set<Instruction> unused, boolean emptyIsAll) {
        ArrayList<T> input = new ArrayList<T>(set);
        if (emptyIsAll && this.isEmpty()) {
            return input;
        }
        ArrayList result = new ArrayList();
        for (Instruction instruction : this.keySet()) {
            boolean used = false;
            Iterator o = input.iterator();
            while (o.hasNext()) {
                Object oo = o.next();
                String s = oo.toString();
                if (!instruction.matches(s)) continue;
                if (!instruction.isNegated()) {
                    result.add(oo);
                }
                o.remove();
                used = true;
            }
            if (used || unused == null) continue;
            unused.add(instruction);
        }
        return result;
    }

    public <T> Collection<T> reject(Collection<T> set) {
        ArrayList<T> input = new ArrayList<T>(set);
        ArrayList result = new ArrayList();
        for (Instruction instruction : this.keySet()) {
            Iterator o = input.iterator();
            while (o.hasNext()) {
                Object oo = o.next();
                String s = oo.toString();
                if (instruction.matches(s)) {
                    if (instruction.isNegated()) {
                        result.add(oo);
                    }
                    o.remove();
                    continue;
                }
                result.add(oo);
            }
        }
        return result;
    }

    public Instruction matcher(String value) {
        for (Instruction i : this.keySet()) {
            if (!i.matches(value)) continue;
            return i;
        }
        return null;
    }

    public Instruction finder(String value) {
        for (Instruction i : this.keySet()) {
            if (!i.finds(value)) continue;
            return i;
        }
        return null;
    }

    public boolean matches(String value) {
        if (this.isEmpty()) {
            return true;
        }
        Instruction instr = this.matcher(value);
        return instr != null && !instr.isNegated();
    }

    public MapStream<Instruction, Attrs> matchesStream(String value) {
        Objects.requireNonNull(value);
        AtomicBoolean negated = new AtomicBoolean(false);
        return this.stream().filterKey(instruction -> {
            if (negated.get() || !instruction.matches(value)) {
                return false;
            }
            if (instruction.isNegated()) {
                negated.set(true);
                return false;
            }
            return true;
        });
    }

    public Map<File, List<Attrs>> select(File base, Function<String, String> mapper, Set<Instruction> missing) {
        Objects.requireNonNull(mapper);
        MultiMap<File, Attrs> result = new MultiMap<File, Attrs>();
        for (Map.Entry<Instruction, Attrs> instr : this.entrySet()) {
            String name;
            if (!instr.getKey().isLiteral() || instr.getKey().isNegated() || (name = mapper.apply(instr.getKey().getLiteral())) == null) continue;
            File f = IO.getFile(base, name);
            if (f.isFile()) {
                result.add(f, instr.getValue());
                continue;
            }
            if (missing == null) continue;
            missing.add(instr.getKey());
        }
        if (base != null) {
            block1: for (File f : base.listFiles()) {
                for (Map.Entry<Instruction, Attrs> instr : this.entrySet()) {
                    if (instr.getKey().isLiteral()) continue;
                    String name = f.getName();
                    if (!instr.getKey().matches(name)) continue;
                    if (instr.getKey().isNegated()) continue block1;
                    result.add(f, instr.getValue());
                    continue block1;
                }
            }
        }
        return result;
    }

    public void decorate(Parameters parameters) {
        this.decorate(parameters, false);
    }

    public void decorate(Parameters parameters, boolean addLiterals) {
        Iterator<Map.Entry<String, Attrs>> it = parameters.entrySet().iterator();
        HashSet<Instruction> used = new HashSet<Instruction>(this.keySet());
        while (it.hasNext()) {
            Map.Entry<String, Attrs> next = it.next();
            Instruction matching = this.matcher(next.getKey());
            if (matching == null) continue;
            used.remove(matching);
            if (matching.isNegated()) {
                it.remove();
                continue;
            }
            next.getValue().putAll(this.get(matching));
        }
        if (addLiterals) {
            used.stream().filter(Instruction::isLiteral).forEach((? super T i) -> parameters.put(i.getLiteral(), new Attrs(this.get((Instruction)i))));
        }
    }
}

