/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

@JRubyClass(name={"Nokogiri::XML::DocumentFragment"}, parent="Nokogiri::XML::Node")
public class XmlDocumentFragment
extends XmlNode {
    private static final long serialVersionUID = 1L;
    private static final ByteList TAG_BEG = ByteList.create((CharSequence)"<");
    private static final ByteList TAG_END = ByteList.create((CharSequence)">");
    private static final Pattern QNAME_RE = Pattern.compile("[^</:>\\s]+:[^</:>=\\s]+");
    private static final Pattern START_TAG_RE = Pattern.compile("<[^</>]+>");

    public XmlDocumentFragment(Ruby ruby) {
        this(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::DocumentFragment"));
    }

    public XmlDocumentFragment(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"new"}, meta=true, required=1, optional=3)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        XmlDocumentFragment xmlDocumentFragment;
        if (iRubyObjectArray.length < 1) {
            throw threadContext.runtime.newArgumentError(iRubyObjectArray.length, 1);
        }
        if (!(iRubyObjectArray[0] instanceof XmlDocument)) {
            throw threadContext.runtime.newArgumentError("first parameter must be a Nokogiri::XML::Document instance");
        }
        XmlDocument xmlDocument = (XmlDocument)iRubyObjectArray[0];
        if (iRubyObjectArray.length > 1 && iRubyObjectArray[1] instanceof RubyString && XmlDocumentFragment.isTag((RubyString)(xmlDocumentFragment = (RubyString)iRubyObjectArray[1]))) {
            iRubyObjectArray[1] = RubyString.newString((Ruby)threadContext.runtime, (String)XmlDocumentFragment.addNamespaceDeclIfNeeded(xmlDocument, NokogiriHelpers.rubyStringToString((RubyString)xmlDocumentFragment)));
        }
        xmlDocumentFragment = (XmlDocumentFragment)NokogiriService.XML_DOCUMENT_FRAGMENT_ALLOCATOR.allocate(threadContext.runtime, (RubyClass)iRubyObject);
        xmlDocumentFragment.setDocument(threadContext, xmlDocument);
        xmlDocumentFragment.setNode(threadContext.runtime, xmlDocument.getDocument().createDocumentFragment());
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)xmlDocumentFragment, (String)"initialize", (IRubyObject[])iRubyObjectArray, (Block)block);
        return xmlDocumentFragment;
    }

    private static boolean isTag(RubyString rubyString) {
        return rubyString.getByteList().startsWith(TAG_BEG) && rubyString.getByteList().endsWith(TAG_END);
    }

    private static boolean isNamespaceDefined(String string, NamedNodeMap namedNodeMap) {
        if (NokogiriHelpers.isNamespace(string.intern())) {
            return true;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!NokogiriHelpers.isNamespace(attr.getNodeName())) continue;
            String string2 = NokogiriHelpers.getLocalNameForNamespace(attr.getNodeName(), null);
            if (!NokogiriHelpers.getPrefix(string).equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static String addNamespaceDeclIfNeeded(XmlDocument xmlDocument, String string) {
        if (xmlDocument.getDocument() == null) {
            return string;
        }
        if (xmlDocument.getDocument().getDocumentElement() == null) {
            return string;
        }
        Matcher matcher = START_TAG_RE.matcher(string);
        HashMap<String, StringBuilder> hashMap = null;
        while (matcher.find()) {
            String string2 = matcher.group();
            Matcher object = QNAME_RE.matcher(string2);
            while (object.find()) {
                CharSequence charSequence;
                NamedNodeMap namedNodeMap;
                String string3 = object.group();
                if (!XmlDocumentFragment.isNamespaceDefined(string3, namedNodeMap = xmlDocument.getDocument().getDocumentElement().getAttributes()) || (charSequence = XmlDocumentFragment.getNamespaceDecl(NokogiriHelpers.getPrefix(string3), namedNodeMap)) == null) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, StringBuilder>(8, 1.0f);
                }
                StringBuilder stringBuilder = new StringBuilder(string3.length() + charSequence.length() + 3);
                String string4 = stringBuilder.append('<').append(string3).append('>').toString();
                stringBuilder.setCharAt(string4.length() - 1, ' ');
                hashMap.put(string4, stringBuilder.append(charSequence).append('>'));
            }
        }
        if (hashMap != null) {
            for (Map.Entry entry : hashMap.entrySet()) {
                string = string.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return string;
    }

    private static CharSequence getNamespaceDecl(String string, NamedNodeMap namedNodeMap) {
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!string.equals(attr.getLocalName())) continue;
            return new StringBuilder().append(attr.getName()).append('=').append('\"').append(attr.getValue()).append('\"');
        }
        return null;
    }

    @Override
    public void relink_namespace(ThreadContext threadContext) {
        XmlDocumentFragment.relink_namespace(threadContext, this.getChildren());
    }
}

