/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;

public class CssMathFunction
extends CssCheckableValue {
    public static final int type = 24;
    public static final CssIdent[] rounding_values;
    ApplContext ac;
    int computed_type = -1;
    ArrayList<CssValue> values = null;
    String prefix = null;
    String _toString = null;

    @Override
    public final int getRawType() {
        return 24;
    }

    @Override
    public final int getType() {
        if (this.computed_type == 24) {
            return 24;
        }
        return this.computed_type;
    }

    public static final boolean isAllowedRounding(CssIdent ident) {
        for (CssIdent id : rounding_values) {
            if (!id.equals(ident)) continue;
            return true;
        }
        return false;
    }

    public CssMathFunction(String prefix) {
        this.prefix = prefix.toLowerCase(Locale.ENGLISH);
    }

    public CssMathFunction(ApplContext ac, String prefix) {
        this(ac, prefix, null);
    }

    public CssMathFunction(String prefix, CssValue value) {
        this(null, prefix, value);
    }

    public CssMathFunction(ApplContext ac, String prefix, CssValue value) {
        if (ac != null) {
            this.ac = ac;
        }
        if (prefix != null) {
            this.prefix = prefix.toLowerCase(Locale.ENGLISH);
        }
        if (value != null) {
            this.computed_type = value.getType();
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            try {
                this.computed_type = this._checkAcceptableType(value.getType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        throw new InvalidParamException("unrecognize", s, ac);
    }

    @Override
    public void setValue(BigDecimal d) {
    }

    public CssMathFunction addValue(CssValue value) throws InvalidParamException {
        boolean first = false;
        if (this.values == null) {
            this.values = new ArrayList();
            first = true;
        }
        this.values.add(value);
        this._computeResultingType(false);
        return this;
    }

    public void validate() throws InvalidParamException {
        this._computeResultingType(true);
    }

    private int _checkAcceptableType(int type) throws InvalidParamException {
        if (type != 4 && type != 6 && type != 5 && type != 7 && type != 9 && type != 8) {
            throw new InvalidParamException("invalidtype", this.toStringUnprefixed(), this.ac);
        }
        return type;
    }

    private void _computeResultingType(boolean is_final) throws InvalidParamException {
        switch (this.prefix) {
            case "clamp(": 
            case "min(": 
            case "max(": 
            case "hypot(": {
                this._computeResultingTypeList(is_final);
                break;
            }
            case "sin(": 
            case "cos(": 
            case "tan(": 
            case "asin(": 
            case "acos(": 
            case "atan(": {
                if (!is_final) break;
                this._computeResultingTypeTrig(is_final);
                break;
            }
            case "exp(": 
            case "sqrt(": {
                this._computeResultingTypeOneNum(is_final);
                break;
            }
            case "pow(": {
                if (!is_final) break;
                this._computeResultingTypeTwoNum(is_final);
                break;
            }
            case "log(": {
                if (!is_final) break;
                this._computeResultingTypeTwoNumOpt(is_final);
                break;
            }
            case "mod(": 
            case "rem(": {
                if (!is_final) break;
                this._computeResultingTypeTwoAny(is_final);
                break;
            }
            case "abs(": {
                this._computeResultingTypeOneAny(is_final);
                break;
            }
            case "atan2(": {
                if (!is_final) break;
                this._computeResultingTypeAtan2(is_final);
                break;
            }
            case "sign(": {
                if (!is_final) break;
                this._computeResultingTypeSign(is_final);
                break;
            }
            case "round(": {
                if (!is_final) break;
                this._computeResultingTypeRound(is_final);
                break;
            }
            default: {
                throw new InvalidParamException("unrecognize", this.ac);
            }
        }
    }

    private void _computeResultingTypeOneNum(boolean is_final) throws InvalidParamException {
        if (this.values.size() > 1) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        int valtype = this.values.get(0).getType();
        if (valtype != 5) {
            throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
        }
        this.computed_type = 5;
    }

    private void _computeResultingTypeTwoNum(boolean is_final) throws InvalidParamException {
        if (this.values.size() != 2) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        int valtype1 = this.values.get(0).getType();
        int valtype2 = this.values.get(1).getType();
        if (valtype1 != 5 || valtype2 != 5) {
            throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
        }
        this.computed_type = 5;
    }

    private void _computeResultingTypeTwoNumOpt(boolean is_final) throws InvalidParamException {
        if (this.values.size() > 2) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        int valtype = this.values.get(0).getType();
        if (valtype != 5) {
            throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
        }
        if (this.values.size() > 1 && (valtype = this.values.get(1).getType()) != 5) {
            throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
        }
        this.computed_type = 5;
    }

    private void _computeResultingTypeAtan2(boolean is_final) throws InvalidParamException {
        int valtype2;
        if (this.values.size() != 2) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        int valtype1 = this.values.get(0).getType();
        if (valtype1 != (valtype2 = this.values.get(1).getType())) {
            throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
        }
        this.computed_type = 7;
    }

    private void _computeResultingTypeRound(boolean is_final) throws InvalidParamException {
        int valtype2;
        int valtype1;
        int vsize = this.values.size();
        if (vsize < 2 || vsize > 3) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        if (vsize == 2) {
            valtype1 = this.values.get(0).getType();
            if (valtype1 == 0) {
                try {
                    CssNumber n = new CssNumber();
                    n.set(this.values.get(0).getIdent().toString(), this.ac);
                    valtype1 = 5;
                }
                catch (Exception n) {
                    // empty catch block
                }
            }
            valtype2 = this.values.get(1).getType();
        } else {
            CssValue v = this.values.get(0);
            if (v.getType() != 0) {
                throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
            }
            if (!CssMathFunction.isAllowedRounding(v.getIdent())) {
                throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
            }
            valtype1 = this.values.get(1).getType();
            valtype2 = this.values.get(2).getType();
        }
        if (valtype1 != valtype2) {
            throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
        }
        this.computed_type = valtype1;
    }

    private void _computeResultingTypeSign(boolean is_final) throws InvalidParamException {
        if (this.values.size() > 1) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        this.computed_type = 5;
    }

    private void _computeResultingTypeOneAny(boolean is_final) throws InvalidParamException {
        int valtype;
        if (this.values.size() > 1) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        this.computed_type = valtype = this.values.get(0).getType();
    }

    private void _computeResultingTypeTwoAny(boolean is_final) throws InvalidParamException {
        int valtype2;
        if (this.values.size() != 2) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        int valtype1 = this.values.get(0).getType();
        if (valtype1 != (valtype2 = this.values.get(1).getType())) {
            throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
        }
        this.computed_type = valtype1;
    }

    private void _computeResultingTypeTrig(boolean is_final) throws InvalidParamException {
        if (this.values.size() > 1) {
            throw new InvalidParamException("unrecognize", this.ac);
        }
        int valtype = this.values.get(0).getType();
        if (valtype == 5 || valtype == 7) {
            this.computed_type = this.prefix.startsWith("a") ? 7 : 5;
        } else {
            throw new InvalidParamException("incompatibletypes", this.toString(), this.ac);
        }
    }

    private void _computeResultingTypeList(boolean is_final) throws InvalidParamException {
        int valtype = 24;
        boolean firstVal = true;
        CssValue prevVal = null;
        for (CssValue v : this.values) {
            if (firstVal) {
                valtype = v.getType();
                this._checkAcceptableType(valtype);
                this.computed_type = valtype;
                firstVal = false;
                prevVal = v;
                continue;
            }
            if (valtype == v.getType()) {
                prevVal = v;
                continue;
            }
            if (valtype == 4) {
                valtype = this._checkAcceptableType(v.getType());
                prevVal = v;
                continue;
            }
            if (v.getType() == 4) continue;
            if (valtype == 5 && prevVal.getNumber().isZero()) {
                valtype = this._checkAcceptableType(v.getType());
                prevVal = v;
                continue;
            }
            if (v.getType() == 5 && v.getNumber().isZero()) continue;
            throw new InvalidParamException("incompatibletypes", this.toStringUnprefixed(), this.ac);
        }
        this.computed_type = valtype;
    }

    @Override
    public Object get() {
        return this.toString();
    }

    protected String toStringUnprefixed() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (CssValue v : this.values) {
            if (!isFirst) {
                sb.append(", ");
            } else {
                isFirst = false;
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public String toString() {
        if (this._toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.prefix).append(this.toStringUnprefixed()).append(')');
            this._toString = sb.toString();
        }
        return this._toString;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isPositive() {
        return false;
    }

    @Override
    public boolean isStrictlyPositive() {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Object value) {
        if (!(value instanceof CssMathFunction)) {
            return false;
        }
        CssMathFunction other = (CssMathFunction)value;
        for (CssValue v : this.values) {
            boolean match = false;
            for (CssValue ov : other.values) {
                if (!v.equals(ov)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkPositiveness(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void checkStrictPositiveness(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void checkInteger(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public boolean warnPositiveness(ApplContext ac, String callername) {
        return true;
    }

    @Override
    public CssLength getLength() throws InvalidParamException {
        if (this.computed_type == 6) {
            for (CssValue v : this.values) {
                if (v.getType() != 6) continue;
                return v.getLength();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssPercentage getPercentage() throws InvalidParamException {
        if (this.computed_type == 4) {
            for (CssValue v : this.values) {
                if (v.getType() != 4) continue;
                return v.getPercentage();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssNumber getNumber() throws InvalidParamException {
        if (this.computed_type == 5) {
            for (CssValue v : this.values) {
                if (v.getType() != 5) continue;
                return v.getNumber();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssTime getTime() throws InvalidParamException {
        if (this.computed_type == 8) {
            for (CssValue v : this.values) {
                if (v.getType() != 8) continue;
                return v.getTime();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssAngle getAngle() throws InvalidParamException {
        if (this.computed_type == 7) {
            for (CssValue v : this.values) {
                if (v.getType() != 7) continue;
                return v.getAngle();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssFrequency getFrequency() throws InvalidParamException {
        if (this.computed_type == 9) {
            for (CssValue v : this.values) {
                if (v.getType() != 9) continue;
                return v.getFrequency();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public void checkEqualsZero(ApplContext ac, String callername) throws InvalidParamException {
        this.warnEqualsZero(ac, callername);
    }

    @Override
    public boolean warnEqualsZero(ApplContext ac, String callername) {
        if (!this.isZero()) {
            ac.getFrame().addWarning("dynamic", this.toString());
            return false;
        }
        return true;
    }

    static {
        String[] _allowed_rounding_values = new String[]{"nearest", "up", "down", "to-zero"};
        int i = 0;
        rounding_values = new CssIdent[_allowed_rounding_values.length];
        for (String s : _allowed_rounding_values) {
            CssMathFunction.rounding_values[i++] = CssIdent.getIdent(s);
        }
    }
}

