/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Strings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.FcmOptions;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import com.google.firebase.messaging.WebpushConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MulticastMessage {
    private final List<String> tokens;
    private final Map<String, String> data;
    private final Notification notification;
    private final AndroidConfig androidConfig;
    private final WebpushConfig webpushConfig;
    private final ApnsConfig apnsConfig;
    private final FcmOptions fcmOptions;

    private MulticastMessage(Builder builder) {
        this.tokens = builder.tokens.build();
        Preconditions.checkArgument((!this.tokens.isEmpty() ? 1 : 0) != 0, (Object)"at least one token must be specified");
        Preconditions.checkArgument((this.tokens.size() <= 500 ? 1 : 0) != 0, (Object)"no more than 500 tokens can be specified");
        for (String token : this.tokens) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0, (Object)"none of the tokens can be null or empty");
        }
        this.data = builder.data.isEmpty() ? null : ImmutableMap.copyOf((Map)builder.data);
        this.notification = builder.notification;
        this.androidConfig = builder.androidConfig;
        this.webpushConfig = builder.webpushConfig;
        this.apnsConfig = builder.apnsConfig;
        this.fcmOptions = builder.fcmOptions;
    }

    List<Message> getMessageList() {
        Message.Builder builder = Message.builder().setNotification(this.notification).setAndroidConfig(this.androidConfig).setApnsConfig(this.apnsConfig).setWebpushConfig(this.webpushConfig).setFcmOptions(this.fcmOptions);
        if (this.data != null) {
            builder.putAllData(this.data);
        }
        ImmutableList.Builder messages = ImmutableList.builder();
        for (String token : this.tokens) {
            messages.add((Object)builder.setToken(token).build());
        }
        return messages.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<String> tokens = ImmutableList.builder();
        private final Map<String, String> data = new HashMap<String, String>();
        private Notification notification;
        private AndroidConfig androidConfig;
        private WebpushConfig webpushConfig;
        private ApnsConfig apnsConfig;
        private FcmOptions fcmOptions;

        private Builder() {
        }

        public Builder addToken(@NonNull String token) {
            this.tokens.add((Object)token);
            return this;
        }

        public Builder addAllTokens(@NonNull Collection<String> tokens) {
            this.tokens.addAll(tokens);
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setAndroidConfig(AndroidConfig androidConfig) {
            this.androidConfig = androidConfig;
            return this;
        }

        public Builder setWebpushConfig(WebpushConfig webpushConfig) {
            this.webpushConfig = webpushConfig;
            return this;
        }

        public Builder setApnsConfig(ApnsConfig apnsConfig) {
            this.apnsConfig = apnsConfig;
            return this;
        }

        public Builder setFcmOptions(FcmOptions fcmOptions) {
            this.fcmOptions = fcmOptions;
            return this;
        }

        public Builder putData(@NonNull String key, @NonNull String value) {
            this.data.put(key, value);
            return this;
        }

        public Builder putAllData(@NonNull Map<String, String> map) {
            this.data.putAll(map);
            return this;
        }

        public MulticastMessage build() {
            return new MulticastMessage(this);
        }
    }
}

