/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.traccar.model.BaseModel;
import org.traccar.session.cache.CacheKey;
import org.traccar.session.cache.CacheNode;
import org.traccar.session.cache.WeakValueMap;

public class CacheGraph {
    private final Map<CacheKey, CacheNode> roots = new HashMap<CacheKey, CacheNode>();
    private final WeakValueMap<CacheKey, CacheNode> nodes = new WeakValueMap();

    void addObject(BaseModel value) {
        CacheKey key = new CacheKey(value);
        CacheNode node = new CacheNode(value);
        this.roots.put(key, node);
        this.nodes.put(key, node);
    }

    void removeObject(Class<? extends BaseModel> clazz, long id) {
        CacheKey key = new CacheKey(clazz, id);
        CacheNode node = this.nodes.remove(key);
        if (node != null) {
            node.getAllLinks(false).forEach(child -> child.getLinks(key.clazz(), true).remove(node));
        }
        this.roots.remove(key);
    }

    <T extends BaseModel> T getObject(Class<T> clazz, long id) {
        CacheNode node = this.nodes.get(new CacheKey(clazz, id));
        return (T)(node != null ? node.getValue() : null);
    }

    <T extends BaseModel> Stream<T> getObjects(Class<? extends BaseModel> fromClass, long fromId, Class<T> clazz, Set<Class<? extends BaseModel>> proxies, boolean forward) {
        CacheNode rootNode = this.nodes.get(new CacheKey(fromClass, fromId));
        if (rootNode != null) {
            return this.getObjectStream(rootNode, clazz, proxies, forward);
        }
        return Stream.empty();
    }

    private <T extends BaseModel> Stream<T> getObjectStream(CacheNode rootNode, Class<T> clazz, Set<Class<? extends BaseModel>> proxies, boolean forward) {
        if (proxies.contains(clazz)) {
            return Stream.empty();
        }
        Stream<BaseModel> directSteam = rootNode.getLinks(clazz, forward).stream().map(node -> node.getValue());
        Stream proxyStream = proxies.stream().flatMap(proxyClass -> rootNode.getLinks((Class<? extends BaseModel>)proxyClass, forward).stream().flatMap(node -> this.getObjectStream((CacheNode)node, clazz, proxies, forward)));
        return Stream.concat(directSteam, proxyStream);
    }

    void updateObject(BaseModel value) {
        CacheNode node = this.nodes.get(new CacheKey(value));
        if (node != null) {
            node.setValue(value);
        }
    }

    boolean addLink(Class<? extends BaseModel> fromClazz, long fromId, BaseModel toValue) {
        boolean stop = true;
        CacheNode fromNode = this.nodes.get(new CacheKey(fromClazz, fromId));
        if (fromNode != null) {
            CacheKey toKey = new CacheKey(toValue);
            CacheNode toNode = this.nodes.get(toKey);
            if (toNode == null) {
                stop = false;
                toNode = new CacheNode(toValue);
                this.nodes.put(toKey, toNode);
            }
            fromNode.getLinks(toValue.getClass(), true).add(toNode);
            toNode.getLinks(fromClazz, false).add(fromNode);
        }
        return stop;
    }

    void removeLink(Class<? extends BaseModel> fromClazz, long fromId, Class<? extends BaseModel> toClazz, long toId) {
        CacheNode toNode;
        CacheNode fromNode = this.nodes.get(new CacheKey(fromClazz, fromId));
        if (fromNode != null && (toNode = this.nodes.get(new CacheKey(toClazz, toId))) != null) {
            fromNode.getLinks(toClazz, true).remove(toNode);
            toNode.getLinks(fromClazz, false).remove(fromNode);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CacheNode node : this.roots.values()) {
            this.printNode(stringBuilder, node, "");
        }
        return stringBuilder.toString().trim();
    }

    private void printNode(StringBuilder stringBuilder, CacheNode node, String indentation) {
        stringBuilder.append('\n').append(indentation).append(node.getValue().getClass().getSimpleName()).append('(').append(node.getValue().getId()).append(')');
        node.getAllLinks(true).forEach(child -> this.printNode(stringBuilder, (CacheNode)child, indentation + "  "));
    }
}

