/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorsPreFlightCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorsPreFlightCheck.class);
    private static final String PRE_FLIGHT_ATTRIBUTE_VALUE = "PRE_FLIGHT";
    private static final List<String> CORS_PRE_FLIGHT_HEADERS = new ArrayList<String>(Arrays.asList("Access-Control-Request-Method", "Access-Control-Request-Headers", "Origin"));

    private CorsPreFlightCheck() {
    }

    public static boolean isPreflight(HttpServletRequest request) {
        String corsRequestType = (String)request.getAttribute("cors.request.type");
        LOGGER.debug("[waffle.util.CorsPreflightCheck] Request is CORS preflight; continue filter chain");
        String method = request.getMethod();
        if (method == null || !method.equalsIgnoreCase("OPTIONS")) {
            return false;
        }
        LOGGER.debug("[waffle.util.CorsPreflightCheck] check for PRE_FLIGHT Attribute");
        if (corsRequestType != null && corsRequestType.equalsIgnoreCase(PRE_FLIGHT_ATTRIBUTE_VALUE)) {
            return true;
        }
        LOGGER.debug("[waffle.util.CorsPreflightCheck] check headers");
        for (String header : CORS_PRE_FLIGHT_HEADERS) {
            String headerValue = request.getHeader(header);
            LOGGER.debug("[waffle.util.CorsPreflightCheck] {}", (Object)header);
            if (headerValue != null) continue;
            return false;
        }
        LOGGER.debug("[waffle.util.CorsPreflightCheck] is preflight");
        return true;
    }
}

