/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.util.response;

import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ResponseFingerprint {
    private final List<ProtocolMessage> messageList;
    private final List<AbstractRecord> recordList;
    private final SocketState socketState;

    public ResponseFingerprint(List<ProtocolMessage> messageList, List<AbstractRecord> recordList, SocketState socketState) {
        this.messageList = messageList;
        this.recordList = recordList;
        this.socketState = socketState;
    }

    public SocketState getSocketState() {
        return this.socketState;
    }

    public List<AbstractRecord> getRecordList() {
        return this.recordList;
    }

    public List<ProtocolMessage> getMessageList() {
        return this.messageList;
    }

    public String toString() {
        StringBuilder messages = new StringBuilder();
        for (ProtocolMessage someMessage : this.messageList) {
            messages.append(someMessage.toCompactString()).append(",");
        }
        StringBuilder records = new StringBuilder();
        for (AbstractRecord someRecord : this.getRecordList()) {
            records.append(someRecord.getClass().getSimpleName()).append(",");
        }
        return "ResponseFingerprint[ Messages=[" + messages.toString() + "], Reccords=[" + records.toString() + "], SocketState=" + (Object)((Object)this.socketState) + ']';
    }

    public String toHumanReadable() {
        StringBuilder resultString = new StringBuilder();
        for (ProtocolMessage message : this.messageList) {
            switch (message.getProtocolMessageType()) {
                case ALERT: {
                    AlertMessage alert = (AlertMessage)message;
                    AlertDescription alertDescription = AlertDescription.getAlertDescription((Byte)alert.getDescription().getValue());
                    AlertLevel alertLevel = AlertLevel.getAlertLevel((Byte)alert.getLevel().getValue());
                    if (alertDescription != null && alertLevel != null && alertLevel != AlertLevel.UNDEFINED) {
                        if (alertLevel == AlertLevel.FATAL) {
                            resultString.append("[").append(alertDescription.name()).append("]");
                            break;
                        }
                        resultString.append("(").append(alertDescription.name()).append(")");
                        break;
                    }
                    resultString.append("{ALERT-").append(alert.getDescription().getValue()).append("-").append(alert.getLevel()).append("}");
                    break;
                }
                case APPLICATION_DATA: {
                    resultString.append("{APP}");
                    break;
                }
                case CHANGE_CIPHER_SPEC: {
                    resultString.append("{CCS}");
                    break;
                }
                case HANDSHAKE: {
                    if (message instanceof FinishedMessage) {
                        resultString.append("{FIN}");
                        break;
                    }
                    resultString.append("{" + message.toCompactString() + "}");
                    break;
                }
                case HEARTBEAT: {
                    resultString.append("{HEARTBEAT}");
                    break;
                }
                case UNKNOWN: {
                    resultString.append("{UNKNOWN}");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown ProtocolMessageType");
                }
            }
            resultString.append(" ");
        }
        if (this.recordList != null && this.recordList.size() > 0) {
            resultString.append(" [");
            for (AbstractRecord record : this.recordList) {
                if (record instanceof Record) {
                    resultString.append("R(" + ((Record)record).getLength().getValue() + "),");
                    continue;
                }
                resultString.append("B(" + ((Record)record).getLength().getValue() + "),");
            }
            resultString.deleteCharAt(resultString.length() - 1);
            resultString.append("]");
        }
        resultString.append(" ");
        if (this.socketState != null) {
            switch (this.socketState) {
                case CLOSED: {
                    resultString.append("X");
                    break;
                }
                case DATA_AVAILABLE: {
                    resultString.append("$$$");
                    break;
                }
                case IO_EXCEPTION: {
                    resultString.append("\u00a7");
                    break;
                }
                case SOCKET_EXCEPTION: {
                    resultString.append("@");
                    break;
                }
                case TIMEOUT: {
                    resultString.append("T");
                    break;
                }
                case UP: {
                    resultString.append("U");
                }
            }
        }
        return resultString.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.messageList);
        hash = 29 * hash + Objects.hashCode(this.recordList);
        hash = 29 * hash + Objects.hashCode((Object)this.socketState);
        return hash;
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseFingerprint other = (ResponseFingerprint)obj;
        if (this.messageList.size() == other.messageList.size()) {
            for (i = 0; i < this.messageList.size(); ++i) {
                if (this.messageList.get(i).toCompactString().equals(other.messageList.get(i).toCompactString())) continue;
                return false;
            }
        } else {
            return false;
        }
        if (this.recordList != null && other.recordList != null) {
            if (this.recordList.size() == other.recordList.size()) {
                for (i = 0; i < this.recordList.size(); ++i) {
                    if (!this.recordList.get(i).getClass().equals(other.recordList.get(i).getClass())) {
                        return false;
                    }
                    if (((byte[])this.recordList.get(i).getCompleteRecordBytes().getValue()).length != ((byte[])other.recordList.get(i).getCompleteRecordBytes().getValue()).length) {
                        return false;
                    }
                    if (this.recordList.get(i) instanceof Record && other.recordList.get(i) instanceof Record) {
                        Record thisRecord = (Record)this.getRecordList().get(i);
                        Record otherRecord = (Record)other.getRecordList().get(i);
                        if (thisRecord.getContentMessageType().getValue() != otherRecord.getContentMessageType().getValue()) {
                            return false;
                        }
                        if (Arrays.equals((byte[])thisRecord.getProtocolVersion().getValue(), (byte[])otherRecord.getProtocolVersion().getValue())) continue;
                        return false;
                    }
                    if (!Arrays.equals((byte[])this.getRecordList().get(i).getCompleteRecordBytes().getValue(), (byte[])other.getRecordList().get(i).getCompleteRecordBytes().getValue())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return this.socketState == other.socketState;
    }

    public boolean areCompatible(ResponseFingerprint fingerprint) {
        if (this.socketState != SocketState.TIMEOUT && fingerprint.getSocketState() != SocketState.TIMEOUT && fingerprint.getSocketState() != this.socketState) {
            return false;
        }
        int minNumberOfMessages = fingerprint.getMessageList().size();
        if (this.messageList.size() < minNumberOfMessages) {
            minNumberOfMessages = this.messageList.size();
        }
        for (int i = 0; i < minNumberOfMessages; ++i) {
            ProtocolMessage messageTwo;
            ProtocolMessage messageOne = this.getMessageList().get(i);
            if (this.checkMessagesAreRoughlyEqual(messageOne, messageTwo = fingerprint.getMessageList().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkMessagesAreRoughlyEqual(ProtocolMessage messageOne, ProtocolMessage messageTwo) {
        if (!messageOne.getClass().equals(messageTwo.getClass())) {
            return false;
        }
        if (messageOne instanceof AlertMessage && messageTwo instanceof AlertMessage) {
            AlertMessage alertOne = (AlertMessage)messageOne;
            AlertMessage alertTwo = (AlertMessage)messageTwo;
            if (alertOne.getDescription().getValue() != alertTwo.getDescription().getValue() || alertOne.getLevel().getValue() != alertTwo.getLevel().getValue()) {
                return false;
            }
        }
        return true;
    }
}

