/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.task;

import de.rub.nds.tlsattacker.core.exceptions.TransportHandlerConnectException;
import de.rub.nds.tlsattacker.core.workflow.task.ITask;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TlsTask
implements ITask,
Callable<ITask> {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean hasError = false;
    private final int reexecutions;
    private final long additionalSleepTime;
    private final boolean increasingSleepTimes;
    private final long additionalTcpTimeout;

    public TlsTask(int reexecutions) {
        this.reexecutions = reexecutions;
        this.additionalSleepTime = 1000L;
        this.increasingSleepTimes = true;
        this.additionalTcpTimeout = 5000L;
    }

    public TlsTask(int reexecutions, long additionalSleepTime, boolean increasingSleepTimes, long additionalTcpTimeout) {
        this.reexecutions = reexecutions;
        this.additionalSleepTime = additionalSleepTime;
        this.increasingSleepTimes = increasingSleepTimes;
        this.additionalTcpTimeout = additionalTcpTimeout;
    }

    @Override
    public ITask call() {
        Exception exception = null;
        long sleepTime = 0L;
        for (int i = 0; i < this.reexecutions + 1; ++i) {
            try {
                boolean executionSuccess;
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                if (executionSuccess = this.execute()) {
                    this.hasError = false;
                    break;
                }
                if (this.increasingSleepTimes) {
                    sleepTime += this.additionalSleepTime;
                }
                this.hasError = true;
            }
            catch (TransportHandlerConnectException E) {
                LOGGER.warn("Could not connect to target. Sleep and Retry");
                try {
                    Thread.sleep(this.additionalTcpTimeout);
                }
                catch (InterruptedException ex) {
                    LOGGER.error("Interrupted during sleep", (Throwable)ex);
                }
                this.hasError = true;
                exception = E;
            }
            catch (Exception E) {
                LOGGER.error("Encountered an exception during the execution", (Throwable)E);
                this.hasError = true;
                if (this.increasingSleepTimes) {
                    sleepTime += this.additionalSleepTime;
                }
                exception = E;
            }
            if (i >= this.reexecutions) continue;
            this.reset();
        }
        if (this.hasError) {
            LOGGER.warn("Could not execute Workflow.", exception);
        }
        return this;
    }

    public boolean isHasError() {
        return this.hasError;
    }

    public abstract void reset();
}

