/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EncryptedServerNameIndicationExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.EncryptedServerNameIndicationExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.EncryptedServerNameIndicationExtensionSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedServerNameIndicationExtensionHandler
extends ExtensionHandler<EncryptedServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EncryptedServerNameIndicationExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public ExtensionParser getParser(byte[] message, int pointer) {
        return new EncryptedServerNameIndicationExtensionParser(pointer, message);
    }

    @Override
    public ExtensionPreparator getPreparator(EncryptedServerNameIndicationExtensionMessage message) {
        return new EncryptedServerNameIndicationExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    @Override
    public ExtensionSerializer getSerializer(EncryptedServerNameIndicationExtensionMessage message) {
        return new EncryptedServerNameIndicationExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(EncryptedServerNameIndicationExtensionMessage message) {
        if (message.getClientEsniInner().getClientNonce() != null) {
            this.context.setEsniClientNonce((byte[])message.getClientEsniInner().getClientNonce().getValue());
        }
        if (message.getServerNonce() != null) {
            this.context.setEsniServerNonce((byte[])message.getServerNonce().getValue());
        }
    }
}

