/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.SrpServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SrpServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SrpServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpServerKeyExchangeHandler
extends ServerKeyExchangeHandler<SrpServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrpServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public SrpServerKeyExchangeParser getParser(byte[] message, int pointer) {
        return new SrpServerKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public SrpServerKeyExchangePreparator getPreparator(SrpServerKeyExchangeMessage message) {
        return new SrpServerKeyExchangePreparator(this.tlsContext.getChooser(), message);
    }

    public SrpServerKeyExchangeSerializer getSerializer(SrpServerKeyExchangeMessage message) {
        return new SrpServerKeyExchangeSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(SrpServerKeyExchangeMessage message) {
        this.adjustSRPGenerator(message);
        this.adjustSRPModulus(message);
        this.adjustSalt(message);
        this.adjustServerPublicKey(message);
        if (message.getComputations() != null && message.getComputations().getPrivateKey() != null) {
            this.adjustServerPrivateKey(message);
        }
    }

    private void adjustSRPGenerator(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setSRPGenerator(new BigInteger(1, (byte[])message.getGenerator().getValue()));
        LOGGER.debug("SRP Generator: " + this.tlsContext.getSRPGenerator());
    }

    private void adjustSRPModulus(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setSRPModulus(new BigInteger(1, (byte[])message.getModulus().getValue()));
        LOGGER.debug("SRP Modulus: " + this.tlsContext.getSRPModulus());
    }

    private void adjustServerPublicKey(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setServerSRPPublicKey(new BigInteger(1, (byte[])message.getPublicKey().getValue()));
        LOGGER.debug("Server PublicKey: " + this.tlsContext.getServerSRPPublicKey());
    }

    private void adjustServerPrivateKey(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setServerSRPPrivateKey((BigInteger)message.getComputations().getPrivateKey().getValue());
        LOGGER.debug("Server PrivateKey: " + this.tlsContext.getServerSRPPrivateKey());
    }

    private void adjustSalt(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setSRPServerSalt((byte[])message.getSalt().getValue());
        LOGGER.debug("SRP Salt: " + ArrayConverter.bytesToHexString((byte[])this.tlsContext.getSRPServerSalt()));
    }
}

