/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.dtls.MessageFragmenter;
import de.rub.nds.tlsattacker.core.exceptions.AdjustmentException;
import de.rub.nds.tlsattacker.core.protocol.handler.Handler;
import de.rub.nds.tlsattacker.core.protocol.message.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import de.rub.nds.tlsattacker.core.protocol.parser.ParserResult;
import de.rub.nds.tlsattacker.core.protocol.parser.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.Preparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ProtocolMessageHandler<Message extends ProtocolMessage>
extends Handler<Message> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final TlsContext tlsContext;

    public ProtocolMessageHandler(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    public byte[] prepareMessage(Message message) {
        return this.prepareMessage(message, true);
    }

    public byte[] prepareMessage(Message message, boolean withPrepare) {
        if (withPrepare) {
            ProtocolMessagePreparator preparator = this.getPreparator(message);
            ((Preparator)preparator).prepare();
            preparator.afterPrepare();
            ProtocolMessageSerializer serializer = this.getSerializer(message);
            byte[] completeMessage = serializer.serialize();
            ((ProtocolMessage)message).setCompleteResultingMessage(completeMessage);
        }
        try {
            if (((ProtocolMessage)message).getAdjustContext() && this.tlsContext.getConfig().getDefaultSelectedProtocolVersion().isDTLS() && ((ProtocolMessage)message).isHandshakeMessage() && !((ProtocolMessage)message).isDtlsHandshakeMessageFragment()) {
                this.tlsContext.increaseDtlsWriteHandshakeMessageSequence();
            }
            this.updateDigest((ProtocolMessage)message);
            if (((ProtocolMessage)message).getAdjustContext()) {
                this.adjustTLSContext(message);
            }
        }
        catch (AdjustmentException E) {
            LOGGER.warn("Could not adjust TLSContext");
            LOGGER.debug((Object)E);
        }
        return (byte[])((ProtocolMessage)message).getCompleteResultingMessage().getValue();
    }

    public ParserResult parseMessage(byte[] message, int pointer, boolean onlyParse) {
        ProtocolMessageParser parser = this.getParser(message, pointer);
        ProtocolMessage parsedMessage = (ProtocolMessage)((Parser)parser).parse();
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS() && parsedMessage instanceof HandshakeMessage && !(parsedMessage instanceof DtlsHandshakeMessageFragment)) {
            ((HandshakeMessage)parsedMessage).setMessageSequence(this.tlsContext.getDtlsReadHandshakeMessageSequence());
        }
        try {
            if (!onlyParse) {
                this.prepareAfterParse(parsedMessage);
                this.updateDigest(parsedMessage);
                this.adjustTLSContext(parsedMessage);
            }
        }
        catch (AdjustmentException | UnsupportedOperationException E) {
            LOGGER.warn("Could not adjust TLSContext");
            LOGGER.debug((Object)E);
        }
        return new ParserResult(parsedMessage, parser.getPointer());
    }

    private void updateDigest(ProtocolMessage message) {
        if (message.isHandshakeMessage() && ((HandshakeMessage)message).getIncludeInDigest()) {
            if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS()) {
                DtlsHandshakeMessageFragment fragment = new MessageFragmenter(this.tlsContext.getConfig().getDtlsMaximumFragmentLength()).wrapInSingleFragment((HandshakeMessage)message, this.tlsContext);
                this.tlsContext.getDigest().append((byte[])fragment.getCompleteResultingMessage().getValue());
            } else {
                this.tlsContext.getDigest().append((byte[])message.getCompleteResultingMessage().getValue());
            }
            LOGGER.debug("Included in digest: " + message.toCompactString());
        }
    }

    @Override
    public abstract ProtocolMessageParser getParser(byte[] var1, int var2);

    public abstract ProtocolMessagePreparator getPreparator(Message var1);

    public abstract ProtocolMessageSerializer getSerializer(Message var1);

    public abstract void adjustTLSContext(Message var1);

    public void adjustTlsContextAfterSerialize(Message message) {
    }

    public void prepareAfterParse(Message message) {
        ProtocolMessagePreparator prep = this.getPreparator(message);
        prep.prepareAfterParse(this.tlsContext.isReversePrepareAfterParse());
    }

    @Override
    protected final void adjustContext(Message message) {
        this.adjustTLSContext(message);
    }
}

