/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

final class ViewTooltips
extends MouseAdapter
implements MouseMotionListener {
    private static ViewTooltips INSTANCE = null;
    private int refcount = 0;
    private JComponent inner = null;
    private int row = -1;
    private Popup[] popups = new Popup[2];
    private ImgComp painter = new ImgComp();
    private Hider hider = null;

    private ViewTooltips() {
    }

    static void register(JComponent jComponent) {
        if (INSTANCE == null) {
            INSTANCE = new ViewTooltips();
        }
        INSTANCE.attachTo(jComponent);
    }

    static void unregister(JComponent jComponent) {
        assert (INSTANCE != null) : "Unregister asymmetrically called";
        if (INSTANCE.detachFrom(jComponent) == 0) {
            INSTANCE.hide();
            INSTANCE = null;
        }
    }

    private void attachTo(JComponent jComponent) {
        assert (jComponent instanceof JTree || jComponent instanceof JList);
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
        ++this.refcount;
    }

    private int detachFrom(JComponent jComponent) {
        assert (jComponent instanceof JTree || jComponent instanceof JList);
        jComponent.removeMouseMotionListener(this);
        jComponent.removeMouseListener(this);
        return this.refcount--;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jComponent);
        if (jScrollPane != null) {
            point = SwingUtilities.convertPoint(jComponent, point, jScrollPane);
            this.show(jScrollPane, point);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.hide();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.hide();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.hide();
    }

    void show(JScrollPane jScrollPane, Point point) {
        if (jScrollPane.getViewport().getView() instanceof JTree) {
            this.showJTree(jScrollPane, point);
        } else if (jScrollPane.getViewport().getView() instanceof JList) {
            this.showJList(jScrollPane, point);
        } else assert (false) : "Bad component type registered: " + jScrollPane.getViewport().getView();
    }

    private void showJList(JScrollPane jScrollPane, Point point) {
        Point point2;
        JList jList = (JList)jScrollPane.getViewport().getView();
        int n = jList.locationToIndex(point2 = SwingUtilities.convertPoint(jScrollPane, point.x, point.y, jList));
        if (n == -1) {
            this.hide();
            return;
        }
        Rectangle rectangle = jList.getCellBounds(n, n);
        ListCellRenderer listCellRenderer = jList.getCellRenderer();
        Dimension dimension = listCellRenderer.getListCellRendererComponent(jList, jList.getModel().getElementAt(n), n, false, false).getPreferredSize();
        rectangle.width = dimension.width;
        if (rectangle == null || !rectangle.contains(point2)) {
            this.hide();
            return;
        }
        if (this.setCompAndRow(jList, n)) {
            Rectangle rectangle2 = this.getShowingRect(jScrollPane);
            Rectangle[] rectangleArray = ViewTooltips.getRects(rectangle, rectangle2);
            if (rectangleArray.length > 0) {
                this.ensureOldPopupsHidden();
                this.painter.configure(jList.getModel().getElementAt(n), jScrollPane, jList, n);
                this.showPopups(rectangleArray, rectangle, rectangle2, jList, jScrollPane);
            } else {
                this.hide();
            }
        }
    }

    private void showJTree(JScrollPane jScrollPane, Point point) {
        JTree jTree = (JTree)jScrollPane.getViewport().getView();
        Point point2 = SwingUtilities.convertPoint(jScrollPane, point.x, point.y, jTree);
        int n = jTree.getClosestRowForLocation(point2.x, point2.y);
        TreePath treePath = jTree.getClosestPathForLocation(point2.x, point2.y);
        Rectangle rectangle = jTree.getPathBounds(treePath);
        if (rectangle == null || !rectangle.contains(point2)) {
            this.hide();
            return;
        }
        if (this.setCompAndRow(jTree, n)) {
            Rectangle rectangle2 = this.getShowingRect(jScrollPane);
            Rectangle[] rectangleArray = ViewTooltips.getRects(rectangle, rectangle2);
            if (rectangleArray.length > 0) {
                this.ensureOldPopupsHidden();
                this.painter.configure(treePath.getLastPathComponent(), jScrollPane, jTree, treePath, n);
                this.showPopups(rectangleArray, rectangle, rectangle2, jTree, jScrollPane);
            } else {
                this.hide();
            }
        }
    }

    private boolean setCompAndRow(JComponent jComponent, int n) {
        boolean bl = n != this.row;
        boolean bl2 = jComponent != this.inner;
        this.inner = jComponent;
        this.row = n;
        return bl || bl2;
    }

    void hide() {
        this.ensureOldPopupsHidden();
        if (this.painter != null) {
            this.painter.clear();
        }
        this.setHideComponent(null, null);
        this.inner = null;
        this.row = -1;
    }

    private void ensureOldPopupsHidden() {
        for (int i = 0; i < this.popups.length; ++i) {
            if (this.popups[i] == null) continue;
            this.popups[i].hide();
            this.popups[i] = null;
        }
    }

    private Rectangle getShowingRect(JScrollPane jScrollPane) {
        Insets insets = jScrollPane.getViewport().getInsets();
        Border border = jScrollPane.getViewportBorder();
        Insets insets2 = border != null ? border.getBorderInsets(jScrollPane) : new Insets(0, 0, 0, 0);
        Insets insets3 = new Insets(0, 0, 0, 0);
        if (jScrollPane.getBorder() != null) {
            insets3 = jScrollPane.getBorder().getBorderInsets(jScrollPane);
        }
        Rectangle rectangle = jScrollPane.getViewportBorderBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        rectangle.width -= insets.left + insets.right;
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets.top + insets.bottom;
        rectangle.height -= insets2.top + insets2.bottom;
        rectangle.x -= insets2.left;
        rectangle.x -= insets3.left;
        Point point = jScrollPane.getViewport().getViewPosition();
        rectangle.translate(point.x, point.y);
        rectangle = SwingUtilities.convertRectangle(jScrollPane.getViewport(), rectangle, jScrollPane);
        return rectangle;
    }

    private static final Rectangle[] getRects(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle[] rectangleArray;
        if (rectangle2.contains(rectangle)) {
            rectangleArray = new Rectangle[]{};
        } else if (rectangle.x < rectangle2.x && rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
            Rectangle rectangle4 = new Rectangle(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
            rectangleArray = new Rectangle[]{rectangle3, rectangle4};
        } else {
            rectangleArray = rectangle.x < rectangle2.x ? new Rectangle[]{new Rectangle(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height)} : (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width ? new Rectangle[]{new Rectangle(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height)} : new Rectangle[]{});
        }
        return rectangleArray;
    }

    private void showPopups(Rectangle[] rectangleArray, Rectangle rectangle, Rectangle rectangle2, JComponent jComponent, JScrollPane jScrollPane) {
        boolean bl = false;
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle3 = rectangleArray[i];
            rectangle3.translate(-rectangle.x, -rectangle.y);
            ImgComp imgComp = this.painter.getPartial(rectangle3, rectangle.x + rectangleArray[i].x < rectangle2.x);
            Point point = new Point(rectangle.x + rectangleArray[i].x, rectangle.y + rectangleArray[i].y);
            SwingUtilities.convertPointToScreen(point, jComponent);
            if (jComponent instanceof JList) {
                --point.y;
            }
            if (point.x <= 0) continue;
            this.popups[i] = ViewTooltips.getPopupFactory().getPopup(jScrollPane, imgComp, point.x, point.y);
            this.popups[i].show();
            bl = true;
        }
        if (bl) {
            this.setHideComponent(jComponent, jScrollPane);
        } else {
            this.setHideComponent(null, null);
        }
    }

    private static PopupFactory getPopupFactory() {
        if (Utilities.isMac()) {
            PopupFactory popupFactory = (PopupFactory)Lookup.getDefault().lookup(PopupFactory.class);
            return popupFactory == null ? PopupFactory.getSharedInstance() : popupFactory;
        }
        return PopupFactory.getSharedInstance();
    }

    private void setHideComponent(JComponent jComponent, JScrollPane jScrollPane) {
        if (this.hider != null && this.hider.isListeningTo(jComponent)) {
            return;
        }
        if (this.hider != null) {
            this.hider.detach();
        }
        this.hider = jComponent != null ? new Hider(jComponent, jScrollPane) : null;
    }

    private static final class Hider
    implements ChangeListener,
    PropertyChangeListener,
    TreeModelListener,
    TreeSelectionListener,
    HierarchyListener,
    HierarchyBoundsListener,
    ListSelectionListener,
    ListDataListener,
    ComponentListener {
        private final JTree tree;
        private JScrollPane pane;
        private final JList list;
        private boolean detached = false;

        public Hider(JComponent jComponent, JScrollPane jScrollPane) {
            if (jComponent instanceof JTree) {
                this.tree = (JTree)jComponent;
                this.list = null;
            } else {
                this.list = (JList)jComponent;
                this.tree = null;
            }
            assert (this.tree != null || this.list != null);
            this.pane = jScrollPane;
            this.attach();
        }

        private boolean isListeningTo(JComponent jComponent) {
            return !this.detached && (jComponent == this.list || jComponent == this.tree);
        }

        private void attach() {
            if (this.tree != null) {
                this.tree.getModel().addTreeModelListener(this);
                this.tree.getSelectionModel().addTreeSelectionListener(this);
                this.tree.addHierarchyBoundsListener(this);
                this.tree.addHierarchyListener(this);
                this.tree.addComponentListener(this);
            } else {
                this.list.getSelectionModel().addListSelectionListener(this);
                this.list.getModel().addListDataListener(this);
                this.list.addHierarchyBoundsListener(this);
                this.list.addHierarchyListener(this);
                this.list.addComponentListener(this);
            }
            this.pane.getHorizontalScrollBar().getModel().addChangeListener(this);
            this.pane.getVerticalScrollBar().getModel().addChangeListener(this);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
        }

        private void detach() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
            if (this.tree != null) {
                this.tree.getSelectionModel().removeTreeSelectionListener(this);
                this.tree.getModel().removeTreeModelListener(this);
                this.tree.removeHierarchyBoundsListener(this);
                this.tree.removeHierarchyListener(this);
                this.tree.removeComponentListener(this);
            } else {
                this.list.getSelectionModel().removeListSelectionListener(this);
                this.list.getModel().removeListDataListener(this);
                this.list.removeHierarchyBoundsListener(this);
                this.list.removeHierarchyListener(this);
                this.list.removeComponentListener(this);
            }
            this.pane.getHorizontalScrollBar().getModel().removeChangeListener(this);
            this.pane.getVerticalScrollBar().getModel().removeChangeListener(this);
            this.detached = true;
        }

        private void change() {
            if (INSTANCE != null) {
                INSTANCE.hide();
            }
            this.detach();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.change();
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.change();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.change();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.change();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.change();
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            this.change();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.change();
        }

        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            this.change();
        }

        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            this.change();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.change();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.change();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.change();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.change();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.change();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.change();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.change();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.change();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.change();
        }
    }

    private static final class ImgComp
    extends JComponent {
        private BufferedImage img;
        private Dimension d = null;
        private Color bg = Color.WHITE;
        private JScrollPane comp = null;
        private Object node = null;
        private AffineTransform at = AffineTransform.getTranslateInstance(0.0, 0.0);
        boolean isRight = false;

        ImgComp() {
        }

        ImgComp(BufferedImage bufferedImage, Rectangle rectangle, boolean bl) {
            this.img = bufferedImage;
            this.at = AffineTransform.getTranslateInstance(-rectangle.x, 0.0);
            this.d = new Dimension(rectangle.width, rectangle.height);
            this.isRight = bl;
        }

        public ImgComp getPartial(Rectangle rectangle, boolean bl) {
            assert (this.img != null);
            return new ImgComp(this.img, rectangle, bl);
        }

        public boolean configure(Object object, JScrollPane jScrollPane, JTree jTree, TreePath treePath, int n) {
            boolean bl = this.setLastRendereredObject(object);
            boolean bl2 = this.setLastRenderedScrollPane(jScrollPane);
            Component component = null;
            this.bg = jTree.getBackground();
            boolean bl3 = jTree.isSelectionEmpty() ? false : jTree.getSelectionModel().isPathSelected(treePath);
            boolean bl4 = jTree.isExpanded(treePath);
            boolean bl5 = !bl4 && jTree.getModel().isLeaf(object);
            boolean bl6 = treePath.equals(jTree.getSelectionModel().getLeadSelectionPath());
            component = jTree.getCellRenderer().getTreeCellRendererComponent(jTree, object, bl3, bl4, bl5, n, bl6);
            if (component != null) {
                this.setComponent(component);
            }
            return true;
        }

        public boolean configure(Object object, JScrollPane jScrollPane, JList jList, int n) {
            boolean bl = this.setLastRendereredObject(object);
            boolean bl2 = this.setLastRenderedScrollPane(jScrollPane);
            Component component = null;
            this.bg = jList.getBackground();
            boolean bl3 = jList.isSelectionEmpty() ? false : jList.getSelectionModel().isSelectedIndex(n);
            component = jList.getCellRenderer().getListCellRendererComponent(jList, object, n, bl3, false);
            if (component != null) {
                this.setComponent(component);
            }
            return true;
        }

        private boolean setLastRenderedScrollPane(JScrollPane jScrollPane) {
            boolean bl = jScrollPane != this.comp;
            this.comp = jScrollPane;
            return bl;
        }

        private boolean setLastRendereredObject(Object object) {
            boolean bl;
            boolean bl2 = bl = this.node != object;
            if (bl) {
                this.node = object;
            }
            return bl;
        }

        void clear() {
            this.comp = null;
            this.node = null;
        }

        public void setComponent(Component component) {
            Dimension dimension = component.getPreferredSize();
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height + 2, 3);
            SwingUtilities.paintComponent(bufferedImage.getGraphics(), component, this, 0, 0, dimension.width, dimension.height + 2);
            this.setImage(bufferedImage);
        }

        public Rectangle getBounds() {
            Dimension dimension = this.getPreferredSize();
            return new Rectangle(0, 0, dimension.width, dimension.height);
        }

        private void setImage(BufferedImage bufferedImage) {
            this.img = bufferedImage;
            this.d = null;
        }

        public Dimension getPreferredSize() {
            if (this.d == null) {
                this.d = new Dimension(this.img.getWidth(), this.img.getHeight());
            }
            return this.d;
        }

        public Dimension getSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.bg);
            graphics.fillRect(0, 0, this.d.width, this.d.height);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawRenderedImage(this.img, this.at);
            graphics.setColor(Color.GRAY);
            graphics.drawLine(0, 0, this.d.width, 0);
            graphics.drawLine(0, this.d.height - 1, this.d.width, this.d.height - 1);
            if (this.isRight) {
                graphics.drawLine(0, 0, 0, this.d.height - 1);
            } else {
                graphics.drawLine(this.d.width - 1, 0, this.d.width - 1, this.d.height - 1);
            }
        }

        public void firePropertyChange(String string, Object object, Object object2) {
        }

        public void invalidate() {
        }

        public void validate() {
        }

        public void revalidate() {
        }
    }
}

