/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.QueryTimeout;
import org.apache.solr.request.SolrQueryRequest;

public class SolrQueryTimeoutImpl
implements QueryTimeout {
    private static final ThreadLocal<Long> timeoutAt = new ThreadLocal();
    private static final SolrQueryTimeoutImpl instance = new SolrQueryTimeoutImpl();

    private SolrQueryTimeoutImpl() {
    }

    public static SolrQueryTimeoutImpl getInstance() {
        return instance;
    }

    public static Long getTimeoutAtNs() {
        return timeoutAt.get();
    }

    public boolean isTimeoutEnabled() {
        return SolrQueryTimeoutImpl.getTimeoutAtNs() != null;
    }

    public boolean shouldExit() {
        Long timeoutAt = SolrQueryTimeoutImpl.getTimeoutAtNs();
        if (timeoutAt == null) {
            return false;
        }
        return timeoutAt - System.nanoTime() < 0L;
    }

    public static void set(SolrQueryRequest req) {
        long timeAllowed = req.getParams().getLong("timeAllowed", -1L);
        if (timeAllowed >= 0L) {
            SolrQueryTimeoutImpl.set(timeAllowed - (long)req.getRequestTimer().getTime());
        } else {
            SolrQueryTimeoutImpl.reset();
        }
    }

    public static void set(long timeAllowed) {
        long time = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAllowed, TimeUnit.MILLISECONDS);
        timeoutAt.set(time);
    }

    public static void reset() {
        timeoutAt.remove();
    }

    public String toString() {
        return "timeoutAt: " + SolrQueryTimeoutImpl.getTimeoutAtNs() + " (System.nanoTime(): " + System.nanoTime() + ")";
    }
}

