/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.AnalyticsQuery;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class SignificantTermsQParserPlugin
extends QParserPlugin {
    public static final String NAME = "significantTerms";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new SignifcantTermsQParser(qstr, localParams, params, req);
    }

    private static class TermWithScore
    implements Comparable<TermWithScore> {
        public final String term;
        public final double score;

        public TermWithScore(String term, double score) {
            this.term = term;
            this.score = score;
        }

        public int hashCode() {
            return this.term.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TermWithScore)) {
                return false;
            }
            TermWithScore other = (TermWithScore)obj;
            return Objects.equals(this.term, other.term);
        }

        @Override
        public int compareTo(TermWithScore o) {
            int cmp = Double.compare(this.score, o.score);
            if (cmp == 0) {
                return this.term.compareTo(o.term);
            }
            return cmp;
        }
    }

    private static class SignifcantTermsCollector
    extends DelegatingCollector {
        private String field;
        private IndexSearcher searcher;
        private ResponseBuilder rb;
        private int numTerms;
        private SparseFixedBitSet docs;
        private int numDocs;
        private float minDocs;
        private float maxDocs;
        private int count;
        private int minTermLength;
        private int highestCollected;

        public SignifcantTermsCollector(ResponseBuilder rb, IndexSearcher searcher, String field, int numTerms, float minDocs, float maxDocs, int minTermLength) {
            this.rb = rb;
            this.searcher = searcher;
            this.field = field;
            this.numTerms = numTerms;
            this.docs = new SparseFixedBitSet(searcher.getIndexReader().maxDoc());
            this.numDocs = searcher.getIndexReader().numDocs();
            this.minDocs = minDocs;
            this.maxDocs = maxDocs;
            this.minTermLength = minTermLength;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
        }

        @Override
        public void collect(int doc) throws IOException {
            super.collect(doc);
            this.highestCollected = this.context.docBase + doc;
            this.docs.set(this.highestCollected);
            ++this.count;
        }

        @Override
        public void finish() throws IOException {
            BytesRef term;
            ArrayList<String> outTerms = new ArrayList<String>();
            ArrayList<Integer> outFreq = new ArrayList<Integer>();
            ArrayList<Integer> outQueryFreq = new ArrayList<Integer>();
            ArrayList<Double> scores = new ArrayList<Double>();
            NamedList allFreq = new NamedList();
            NamedList allQueryFreq = new NamedList();
            LinkedHashMap<String, Serializable> response = new LinkedHashMap<String, Serializable>();
            this.rb.rsp.add(SignificantTermsQParserPlugin.NAME, response);
            response.put("numDocs", Integer.valueOf(this.numDocs));
            response.put("sterms", outTerms);
            response.put("scores", scores);
            response.put("docFreq", outFreq);
            response.put("queryDocFreq", outQueryFreq);
            TreeSet<TermWithScore> topTerms = new TreeSet<TermWithScore>();
            Terms terms = ((SolrIndexSearcher)this.searcher).getSlowAtomicReader().terms(this.field);
            TermsEnum termsEnum = terms == null ? TermsEnum.EMPTY : terms.iterator();
            PostingsEnum postingsEnum = null;
            while ((term = termsEnum.next()) != null) {
                int docId;
                int docFreq = termsEnum.docFreq();
                if ((!((double)this.minDocs < 1.0) ? (float)docFreq < this.minDocs : (float)docFreq / (float)this.numDocs < this.minDocs) || (!((double)this.maxDocs < 1.0) ? (float)docFreq > this.maxDocs : (float)docFreq / (float)this.numDocs > this.maxDocs) || term.length < this.minTermLength) continue;
                int tf = 0;
                postingsEnum = termsEnum.postings(postingsEnum);
                while (postingsEnum.nextDoc() != Integer.MAX_VALUE && (docId = postingsEnum.docID()) <= this.highestCollected) {
                    if (!this.docs.get(docId)) continue;
                    ++tf;
                }
                if (tf == 0) continue;
                float score = (float)Math.log(tf) * (float)(Math.log((float)(this.numDocs + 1) / (float)(docFreq + 1)) + 1.0);
                String t = term.utf8ToString();
                allFreq.add(t, (Object)docFreq);
                allQueryFreq.add(t, (Object)tf);
                if (topTerms.size() < this.numTerms) {
                    topTerms.add(new TermWithScore(term.utf8ToString(), score));
                    continue;
                }
                if (!(((TermWithScore)topTerms.first()).score < (double)score)) continue;
                topTerms.pollFirst();
                topTerms.add(new TermWithScore(term.utf8ToString(), score));
            }
            for (TermWithScore topTerm : topTerms) {
                outTerms.add(topTerm.term);
                scores.add(topTerm.score);
                outFreq.add((Integer)allFreq.get(topTerm.term));
                outQueryFreq.add((Integer)allQueryFreq.get(topTerm.term));
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private static class NoOpTermsCollector
    extends DelegatingCollector {
        private ResponseBuilder rb;

        private NoOpTermsCollector(ResponseBuilder rb) {
            this.rb = rb;
        }

        @Override
        public void collect(int doc) throws IOException {
        }

        @Override
        public void finish() throws IOException {
            ArrayList outTerms = new ArrayList();
            ArrayList outFreq = new ArrayList();
            ArrayList outQueryFreq = new ArrayList();
            ArrayList scores = new ArrayList();
            LinkedHashMap<String, Serializable> response = new LinkedHashMap<String, Serializable>();
            this.rb.rsp.add(SignificantTermsQParserPlugin.NAME, response);
            response.put("numDocs", Integer.valueOf(0));
            response.put("sterms", outTerms);
            response.put("scores", scores);
            response.put("docFreq", outFreq);
            response.put("queryDocFreq", outQueryFreq);
        }
    }

    private static class SignificantTermsQuery
    extends AnalyticsQuery {
        private String field;
        private int numTerms;
        private float maxDocs;
        private float minDocs;
        private int minTermLength;

        public SignificantTermsQuery(String field, int numTerms, float minDocs, float maxDocs, int minTermLength) {
            this.field = field;
            this.numTerms = numTerms;
            this.minDocs = minDocs;
            this.maxDocs = maxDocs;
            this.minTermLength = minTermLength;
        }

        @Override
        public DelegatingCollector getAnalyticsCollector(ResponseBuilder rb, IndexSearcher searcher) {
            if (searcher.getIndexReader().maxDoc() <= 0) {
                return new NoOpTermsCollector(rb);
            }
            return new SignifcantTermsCollector(rb, searcher, this.field, this.numTerms, this.minDocs, this.maxDocs, this.minTermLength);
        }
    }

    private static class SignifcantTermsQParser
    extends QParser {
        public SignifcantTermsQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String field = this.getParam("field");
            int numTerms = Integer.parseInt(this.getParamWithDefault("numTerms", "20"));
            float minDocs = Float.parseFloat(this.getParamWithDefault("minDocFreq", "5"));
            float maxDocs = Float.parseFloat(this.getParamWithDefault("maxDocFreq", ".3"));
            int minTermLength = Integer.parseInt(this.getParamWithDefault("minTermLength", "4"));
            return new SignificantTermsQuery(field, numTerms, minDocs, maxDocs, minTermLength);
        }

        private String getParamWithDefault(String paramName, String defaultValue) {
            String result = this.getParam(paramName);
            return result != null ? result : defaultValue;
        }
    }
}

