/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.ExternalFileField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.function.FileFloatSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFileFieldReloader
extends AbstractSolrEventListener {
    private String datadir;
    private List<FileFloatSource> fieldSources = new ArrayList<FileFloatSource>();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ExternalFileFieldReloader(SolrCore core) {
        super(core);
        this.datadir = core.getDataDir();
    }

    @Override
    public void init(NamedList<?> args) {
        this.cacheFieldSources(this.getCore().getLatestSchema());
    }

    @Override
    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        if (null == currentSearcher || newSearcher.getSchema() != currentSearcher.getSchema()) {
            this.cacheFieldSources(newSearcher.getSchema());
        }
        DirectoryReader reader = newSearcher.getIndexReader();
        for (FileFloatSource fieldSource : this.fieldSources) {
            fieldSource.refreshCache((IndexReader)reader);
        }
    }

    public void cacheFieldSources(IndexSchema schema) {
        this.fieldSources.clear();
        for (SchemaField field : schema.getFields().values()) {
            FieldType type = field.getType();
            if (!(type instanceof ExternalFileField)) continue;
            ExternalFileField eff = (ExternalFileField)type;
            this.fieldSources.add(eff.getFileFloatSource(field, this.datadir));
            if (!log.isInfoEnabled()) continue;
            log.info("Adding ExternalFileFieldReloader listener for field {}", (Object)field.getName());
        }
    }
}

