/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.misc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.internal.misc.Lists;

public class JsonNodeComparator
implements Comparator<JsonNode>,
Serializable {
    private static final JsonNodeComparator defaultInstance = new JsonNodeComparator();
    private static JsonNodeType[][] ordering = new JsonNodeType[][]{{JsonNodeType.NULL, JsonNodeType.MISSING}, {JsonNodeType.BOOLEAN}, {JsonNodeType.NUMBER}, {JsonNodeType.STRING, JsonNodeType.BINARY}, {JsonNodeType.ARRAY}, {JsonNodeType.OBJECT}};
    private static Map<JsonNodeType, Integer> orderValues = new HashMap<JsonNodeType, Integer>();

    public static JsonNodeComparator getInstance() {
        return defaultInstance;
    }

    private static int orderValue(JsonNode node) {
        if (node == null) {
            return 0;
        }
        return JsonNodeComparator.orderValue(node.getNodeType());
    }

    private static int orderValue(JsonNodeType type) {
        Integer value = orderValues.get(type);
        if (value == null) {
            throw new IllegalArgumentException("Unknown JsonNodeType: " + type);
        }
        return value;
    }

    @Override
    public int compare(JsonNode o1, JsonNode o2) {
        JsonNodeType type;
        int r = JsonNodeComparator.orderValue(o1) - JsonNodeComparator.orderValue(o2);
        if (r != 0) {
            return r;
        }
        JsonNodeType jsonNodeType = type = o1 != null ? o1.getNodeType() : null;
        if (type == null || type == JsonNodeType.MISSING || type == JsonNodeType.NULL) {
            return 0;
        }
        if (type == JsonNodeType.BOOLEAN) {
            return Boolean.compare(o1.asBoolean(), o2.asBoolean());
        }
        if (type == JsonNodeType.NUMBER) {
            return Double.compare(o1.asDouble(), o2.asDouble());
        }
        if (type == JsonNodeType.STRING || type == JsonNodeType.BINARY) {
            return o1.asText().compareTo(o2.asText());
        }
        if (type == JsonNodeType.ARRAY) {
            int s1 = o1.size();
            int s2 = o2.size();
            int s = Math.min(s1, s2);
            for (int i = 0; i < s; ++i) {
                int rr = this.compare(o1.get(i), o2.get(i));
                if (rr == 0) continue;
                return rr;
            }
            return Integer.compare(s1, s2);
        }
        if (type == JsonNodeType.OBJECT) {
            List<String> names1 = Lists.newArrayList(o1.fieldNames());
            List names2 = Lists.newArrayList(o2.fieldNames());
            Collections.sort(names1);
            Collections.sort(names2);
            int s = Math.min(names1.size(), names2.size());
            for (int i = 0; i < s; ++i) {
                int rr = names1.get(i).compareTo((String)names2.get(i));
                if (rr == 0) continue;
                return rr;
            }
            int rr = Integer.compare(names1.size(), names2.size());
            if (rr != 0) {
                return rr;
            }
            for (String name : names1) {
                int rrr = this.compare(o1.get(name), o2.get(name));
                if (rrr == 0) continue;
                return rrr;
            }
            return 0;
        }
        throw new IllegalArgumentException("Unknown JsonNodeType: " + type);
    }

    static {
        for (int i = 0; i < ordering.length; ++i) {
            for (JsonNodeType type : ordering[i]) {
                orderValues.put(type, i);
            }
        }
    }
}

