/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.interleaving.algorithms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.apache.solr.ltr.interleaving.Interleaving;
import org.apache.solr.ltr.interleaving.InterleavingResult;

public class TeamDraftInterleaving
implements Interleaving {
    public static Random RANDOM;

    @Override
    public InterleavingResult interleave(ScoreDoc[] rerankedA, ScoreDoc[] rerankedB) {
        ArrayList<ScoreDoc> interleavedResults = new ArrayList<ScoreDoc>();
        HashSet<Integer> alreadyAdded = new HashSet<Integer>();
        ScoreDoc[] interleavedResultArray = new ScoreDoc[rerankedA.length];
        ArrayList<Set<Integer>> interleavingPicks = new ArrayList<Set<Integer>>(2);
        HashSet<Integer> teamA = new HashSet<Integer>();
        HashSet<Integer> teamB = new HashSet<Integer>();
        int topN = rerankedA.length;
        int indexA = 0;
        int indexB = 0;
        while (interleavedResults.size() < topN && indexA < rerankedA.length && indexB < rerankedB.length) {
            if (teamA.size() < teamB.size() || teamA.size() == teamB.size() && !RANDOM.nextBoolean()) {
                indexA = this.updateIndex(alreadyAdded, indexA, rerankedA);
                interleavedResults.add(rerankedA[indexA]);
                alreadyAdded.add(rerankedA[indexA].doc);
                teamA.add(rerankedA[indexA].doc);
                ++indexA;
                continue;
            }
            indexB = this.updateIndex(alreadyAdded, indexB, rerankedB);
            interleavedResults.add(rerankedB[indexB]);
            alreadyAdded.add(rerankedB[indexB].doc);
            teamB.add(rerankedB[indexB].doc);
            ++indexB;
        }
        interleavingPicks.add(teamA);
        interleavingPicks.add(teamB);
        interleavedResultArray = interleavedResults.toArray(interleavedResultArray);
        return new InterleavingResult(interleavedResultArray, interleavingPicks);
    }

    private int updateIndex(HashSet<Integer> alreadyAdded, int index, ScoreDoc[] reranked) {
        boolean foundElementToAdd = false;
        while (index < reranked.length && !foundElementToAdd) {
            ScoreDoc elementToCheck = reranked[index];
            if (alreadyAdded.contains(elementToCheck.doc)) {
                ++index;
                continue;
            }
            foundElementToAdd = true;
        }
        return index;
    }

    public static void setRANDOM(Random RANDOM) {
        TeamDraftInterleaving.RANDOM = RANDOM;
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
    }
}

