/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.semver4j.RangesExpression;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;
import org.semver4j.internal.Coerce;
import org.semver4j.internal.Comparator;
import org.semver4j.internal.Differ;
import org.semver4j.internal.Modifier;
import org.semver4j.internal.StrictParser;

public class Semver
implements Comparable<Semver> {
    public static final Semver ZERO = new Semver("0.0.0");
    private final String originalVersion;
    private final int major;
    private final int minor;
    private final int patch;
    private final List<String> preRelease;
    private final List<String> build;
    private final String version;

    public Semver(String version) {
        this.originalVersion = version.trim();
        StrictParser.Version parsedVersion = new StrictParser().parse(this.originalVersion);
        this.major = parsedVersion.getMajor();
        this.minor = parsedVersion.getMinor();
        this.patch = parsedVersion.getPatch();
        this.preRelease = parsedVersion.getPreRelease();
        this.build = parsedVersion.getBuild();
        String resultVersion = String.format(Locale.ROOT, "%d.%d.%d", this.major, this.minor, this.patch);
        if (!this.preRelease.isEmpty()) {
            resultVersion = resultVersion + "-" + String.join((CharSequence)".", this.preRelease);
        }
        if (!this.build.isEmpty()) {
            resultVersion = resultVersion + "+" + String.join((CharSequence)".", this.build);
        }
        this.version = resultVersion;
    }

    public static Semver parse(String version) {
        try {
            return new Semver(version);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Semver coerce(String version) {
        Semver semver = Semver.parse(version);
        if (semver != null) {
            return semver;
        }
        String coerce = Coerce.coerce(version);
        return Semver.parse(coerce);
    }

    public static boolean isValid(String version) {
        return Semver.parse(version) != null;
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public List<String> getPreRelease() {
        return this.preRelease;
    }

    public List<String> getBuild() {
        return this.build;
    }

    public boolean isStable() {
        return this.major > 0 && this.preRelease.isEmpty();
    }

    public Semver nextMajor() {
        return new Modifier(this).nextMajor();
    }

    public Semver withIncMajor() {
        return this.withIncMajor(1);
    }

    public Semver withIncMajor(int number) {
        return new Modifier(this).withIncMajor(number);
    }

    public Semver nextMinor() {
        return new Modifier(this).nextMinor();
    }

    public Semver withIncMinor() {
        return this.withIncMinor(1);
    }

    public Semver withIncMinor(int number) {
        return new Modifier(this).withIncMinor(number);
    }

    public Semver nextPatch() {
        return new Modifier(this).nextPatch();
    }

    public Semver withIncPatch() {
        return this.withIncPatch(1);
    }

    public Semver withIncPatch(int number) {
        return new Modifier(this).withIncPatch(number);
    }

    public Semver withPreRelease(String preRelease) {
        return new Modifier(this).withPreRelease(preRelease);
    }

    public Semver withBuild(String build) {
        return new Modifier(this).withBuild(build);
    }

    public Semver withClearedPreRelease() {
        return new Modifier(this).withClearedPreRelease();
    }

    public Semver withClearedBuild() {
        return new Modifier(this).withClearedBuild();
    }

    public Semver withClearedPreReleaseAndBuild() {
        return new Modifier(this).withClearedPreReleaseAndBuild();
    }

    @Override
    public int compareTo(Semver other) {
        return new Comparator(this).compareTo(other);
    }

    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(new Semver(version));
    }

    public boolean isGreaterThan(Semver version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterThanOrEqualTo(String version) {
        return this.isGreaterThanOrEqualTo(new Semver(version));
    }

    public boolean isGreaterThanOrEqualTo(Semver version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLowerThan(String version) {
        return this.isLowerThan(new Semver(version));
    }

    public boolean isLowerThan(Semver version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLowerThanOrEqualTo(String version) {
        return this.isLowerThanOrEqualTo(new Semver(version));
    }

    public boolean isLowerThanOrEqualTo(Semver version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isEqualTo(String version) {
        return this.isEqualTo(new Semver(version));
    }

    public boolean isEqualTo(Semver version) {
        return this.equals(version);
    }

    public boolean isEquivalentTo(String version) {
        return this.isEquivalentTo(new Semver(version));
    }

    public boolean isEquivalentTo(Semver version) {
        return this.compareTo(version) == 0;
    }

    public VersionDiff diff(String version) {
        return this.diff(new Semver(version));
    }

    public VersionDiff diff(Semver version) {
        return new Differ(this).diff(version);
    }

    public boolean satisfies(String range) {
        RangesList rangesList = RangesListFactory.create(range);
        return this.satisfies(rangesList);
    }

    public boolean satisfies(RangesExpression rangesExpression) {
        RangesList rangesList = RangesListFactory.create(rangesExpression);
        return this.satisfies(rangesList);
    }

    public boolean satisfies(RangesList rangesList) {
        return rangesList.isSatisfiedBy(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Semver semver = (Semver)o;
        return Objects.equals(this.originalVersion, semver.originalVersion);
    }

    public int hashCode() {
        return Objects.hash(this.originalVersion);
    }

    public String toString() {
        return this.getVersion();
    }

    public static enum VersionDiff {
        NONE,
        MAJOR,
        MINOR,
        PATCH,
        PRE_RELEASE,
        BUILD;

    }
}

