/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.profile.EventType;
import dotty.tools.dotc.profile.EventType$;
import dotty.tools.dotc.profile.GcEventData;
import dotty.tools.dotc.profile.ProfileRange;
import dotty.tools.dotc.profile.ProfileReporter;
import dotty.tools.dotc.profile.RealProfiler;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;

public class StreamProfileReporter
implements ProfileReporter {
    private final PrintWriter out;

    public StreamProfileReporter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void header(RealProfiler profiler) {
        this.out.println(new StringBuilder(28).append("info, ").append(profiler.id()).append(", version, 2, output, ").append(profiler.outDir()).toString());
        this.out.println("header(main/background),startNs,endNs,runId,phaseId,phaseName,purpose,task-count,threadId,threadName,runNs,idleNs,cpuTimeNs,userTimeNs,allocatedByte,heapSize");
        this.out.println("header(GC),startNs,endNs,startMs,endMs,name,action,cause,threads");
    }

    @Override
    public void reportBackground(RealProfiler profiler, ProfileRange threadRange) {
        this.reportCommon(EventType$.MODULE$.BACKGROUND(), profiler, threadRange);
    }

    @Override
    public void reportForeground(RealProfiler profiler, ProfileRange threadRange) {
        this.reportCommon(EventType$.MODULE$.MAIN(), profiler, threadRange);
    }

    private void reportCommon(EventType tpe, RealProfiler profiler, ProfileRange threadRange) {
        this.out.println(new StringBuilder(16).append(tpe).append(",").append(threadRange.start().snapTimeNanos()).append(",").append(threadRange.end().snapTimeNanos()).append(",").append(profiler.id()).append(",").append(threadRange.phase().id()).append(",").append(threadRange.phase().phaseName().replace(',', ' ')).append(",").append(threadRange.purpose()).append(",").append(threadRange.taskCount()).append(",").append(threadRange.thread().getId()).append(",").append(threadRange.thread().getName()).append(",").append(threadRange.runNs()).append(",").append(threadRange.idleNs()).append(",").append(threadRange.cpuNs()).append(",").append(threadRange.userNs()).append(",").append(threadRange.allocatedBytes()).append(",").append(threadRange.end().heapBytes()).append(" ").toString());
    }

    @Override
    public void reportGc(GcEventData data) {
        long duration = TimeUnit.MILLISECONDS.toNanos(data.gcEndMillis() - data.gcStartMillis() + 1L);
        long start = data.reportTimeNs() - duration;
        this.out.println(new StringBuilder(9).append(EventType$.MODULE$.GC()).append(",").append(start).append(",").append(data.reportTimeNs()).append(",").append(data.gcStartMillis()).append(", ").append(data.gcEndMillis()).append(",").append(data.name()).append(",").append(data.action()).append(",").append(data.cause()).append(",").append(data.threads()).toString());
    }

    @Override
    public void close(RealProfiler profiler) {
        this.out.flush();
        this.out.close();
    }
}

