/*! For license information please see main.min.js.LICENSE.txt */
(()=>{"use strict";var __webpack_modules__={"./js/app.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _helpers_Autocompletion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers/Autocompletion */ \"./js/helpers/Autocompletion.js\");\n/* harmony import */ var _layout_ContainerZone__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./layout/ContainerZone */ \"./js/layout/ContainerZone.js\");\n/* harmony import */ var _layout_Layouts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./layout/Layouts */ \"./js/layout/Layouts.js\");\n/* harmony import */ var _widgets_WidgetFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./widgets/WidgetFactory */ \"./js/widgets/WidgetFactory.js\");\n/* harmony import */ var _widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./widgets/Widgets */ \"./js/widgets/Widgets.js\");\n\n\n\n\n\n\n\n\n\n\nlet inColor = true;\nlet twice = false;\n\n/** Entry point */\nfunction ready() {\n\tif (twice) {\n\t\treturn;\n\t}\n\ttwice = true;\n\n\t// Loading configuration from localStorage (see widgetSettings)\n\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.loadAll();\n\n\t// Define Widget container\n\tconst factory = new _widgets_WidgetFactory__WEBPACK_IMPORTED_MODULE_5__.WidgetFactory();\n\t_core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.init(factory, 'content', 'ruler', 'title');\n\t// widgetContainer.fallbackWidget(() => { factory.get(Widgets.DISASSEMBLY).draw(); });\n\n\t// Default situation\n\t// factory.get(Factory.OVERVIEW).draw();\n\t_core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.OVERVIEW);\n\n\t// Left menu\n\tonClick('demo_avatar', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.OVERVIEW));\n\tonClick('menu_overview', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.OVERVIEW));\n\tonClick('menu_disasm', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.DISASSEMBLY));\n\tonClick('menu_hexdump', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.HEXDUMP));\n\tonClick('menu_debug', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.DEBUGGER));\n\tonClick('menu_functions', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.FUNCTIONS));\n\tonClick('menu_classes', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.CLASSES));\n\tonClick('menu_flags', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.FLAGS));\n\tonClick('menu_search', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.SEARCH));\n\tonClick('menu_script', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.SCRIPTS));\n\tonClick('menu_comments', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.COMMENTS));\n\tonClick('menu_help', () => alert('todo'));\n\n\t// Left sub-menu\n\t// onClick('menu_project_save', saveProject);\n\t// onClick('menu_project_delete', deleteProject);\n\t// onClick('menu_project_close', closeProject);\n\n\t// Right menu\n\tonClick('menu_seek', () => _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Wrapper.seek());\n\tonClick('menu_settings2', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.SETTINGS));\n\tonClick('menu_settings', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.SETTINGS));\n\tonClick('menu_about', () => {\n\t\tr2.cmd('?V', function(version) {\n\t\t\talert('radare2 material webui by --pancake @ 2015-2017\\n\\n' + version.trim());\n\t\t});\n\t});\n\tonClick('menu_mail', function() {\n\t\twindow.location = 'mailto:pancake@nopcode.org';\n\t});\n\n\t// Layout\n\tonClick('layout_single', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.merge());\n\tonClick('layout_vertical', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.split(_layout_Layouts__WEBPACK_IMPORTED_MODULE_4__.Layouts.VERTICAL));\n\n\t// Set autocompletion\n\tconst autocompletion = new _helpers_Autocompletion__WEBPACK_IMPORTED_MODULE_2__.Autocompletion('search', 'search_autocomplete', 'fs *;fj');\n\tautocompletion.setPrepareView(function() {\n\t\t// If not splitted we split the view\n\t\tif (!_core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.isSplitted) {\n\t\t\t_core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.split(_layout_Layouts__WEBPACK_IMPORTED_MODULE_4__.Layouts.VERTICAL);\n\t\t}\n\t\t_core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.DISASSEMBLY);\n\t});\n\n\t// Close the drawer on click with small screens\n\tdocument.querySelector('.mdl-layout__drawer').addEventListener('click', function() {\n\t\tdocument.querySelector('.mdl-layout__obfuscator').classList.remove('is-visible');\n\t\tthis.classList.remove('is-visible');\n\t}, false);\n}\n\nwindow.onload = ready;\n\ndocument.addEventListener('DOMContentLoaded', ready, false);\n\ndocument.body.onkeypress = function(e) {\n\tif (e.ctrlKey) {\n\t\tconst keys = [\n\t\t\t// panelConsole,\n\t\t\t// panelDisasm,\n\t\t\t// panelDebug,\n\t\t\t// panelHexdump,\n\t\t\t// panelFunctions,\n\t\t\t// panelFlags,\n\t\t\t// panelOverview,\n\t\t\t// panelSettings,\n\t\t\t// panelSearch\n\t\t];\n\t\tif (e.charCode === 'o'.charCodeAt(0)) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Wrapper.seek();\n\t\t}\n\t\tlet k = e.charCode - 0x30;\n\t\tif (k >= 0 && k < keys.length) {\n\t\t\tlet fn = keys[k];\n\t\t\tif (fn) {\n\t\t\t\tfn();\n\t\t\t}\n\t\t}\n\t}\n};\n\n/**\n * Add an onClick listener\n * @param {string} nodeId Node concerned\n * @param {function} fn Callback function\n */\nfunction onClick(nodeId, fn) {\n\tconst h = document.getElementById(nodeId);\n\tif (h) {\n\t\th.addEventListener('click', function() {\n\t\t\tfn();\n\t\t});\n\t} else {\n\t\tconsole.error('onclick-error', nodeId);\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/app.js?")},"./js/core/BlockNavigator.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BlockNavigator\": () => (/* binding */ BlockNavigator)\n/* harmony export */ });\n/* harmony import */ var _ChunkStatus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ChunkStatus */ \"./js/core/ChunkStatus.js\");\n/* harmony import */ var _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./NavigatorDirection */ \"./js/core/NavigatorDirection.js\");\n\n\n\nclass BlockNavigator {\n\n\tconstructor() { }\n\n\tinit() {\n\t\tif (typeof this.providerWorker === 'undefined') {\n\t\t\tconsole.log('provider worker should be defined');\n\t\t\treturn;\n\t\t}\n\n\t\tthis.configureWorker_();\n\t}\n\n\tconfigureWorker_() {\n\t\tvar _this = this;\n\t\tthis.providerWorker.onmessage = function(e) {\n\t\t\tif (e.data.dir === _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.CURRENT) {\n\t\t\t\tif (typeof _this.curChunk.data.callback !== 'undefined') {\n\t\t\t\t\tfor (var i = 0 ; i < _this.curChunk.data.callback.length ; i++) {\n\t\t\t\t\t\t_this.curChunk.data.callback[i](e.data);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t_this.curChunk.data = e.data;\n\t\t\t\t_this.curChunk.data.status = _ChunkStatus__WEBPACK_IMPORTED_MODULE_0__.ChunkStatus.COMPLETED;\n\t\t\t} else {\n\t\t\t\tvar dir = (e.data.dir === _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE) ? 'prev' : 'next';\n\n\t\t\t\tvar item = _this.curChunk;\n\t\t\t\twhile (typeof item[dir] !== 'undefined') {\n\t\t\t\t\titem = item[dir];\n\t\t\t\t\tif (item.data.offset === e.data.offset) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (item === _this.curChunk) {\n\t\t\t\t\tconsole.log('Error, history corrupted');\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (typeof item.data.callback !== 'undefined') {\n\t\t\t\t\tfor (var i = 0 ; i < item.data.callback.length ; i++) {\n\t\t\t\t\t\titem.data.callback[i](e.data);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\titem.data = e.data;\n\t\t\t\titem.data.status = _ChunkStatus__WEBPACK_IMPORTED_MODULE_0__.ChunkStatus.COMPLETED;\n\t\t\t}\n\t\t};\n\t}\n\n\treset() {\n\t\tthis.curChunk = undefined;\n\t}\n\n\tgo(where) {\n\t\tvar goNext = (where === _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.AFTER);\n\t\tvar dir = (goNext) ? 'next' : 'prev';\n\t\tvar howMany = this.gap;\n\n\t\tif (typeof this.curChunk[dir] !== 'undefined') {\n\t\t\tthis.curChunk = this.curChunk[dir];\n\t\t\tthis.currentOffset = this.curChunk.data.offset;\n\t\t\t// Should check (or not?) for negative offset\n\t\t} else {\n\t\t\tthis.currentOffset = this.currentOffset + where * this.gap;\n\n\t\t\tvar req = {\n\t\t\t\tdir: where,\n\t\t\t\toffset: this.currentOffset,\n\t\t\t\tstatus: _ChunkStatus__WEBPACK_IMPORTED_MODULE_0__.ChunkStatus.LAUNCHED,\n\t\t\t\tcallback: []\n\t\t\t};\n\n\t\t\tif (this.currentOffset < 0) {\n\t\t\t\treq.substract = this.currentOffset * -1;\n\t\t\t\treq.offset = 0;\n\t\t\t\tthis.currentOffset = 0;\n\t\t\t}\n\n\t\t\tvar newChunk = {\n\t\t\t\tdata: req,\n\t\t\t\tprev: (goNext) ? this.curChunk : undefined,\n\t\t\t\tnext: (!goNext) ? this.curChunk : undefined\n\t\t\t};\n\n\t\t\tthis.curChunk[dir] = newChunk;\n\t\t\tthis.curChunk = newChunk;\n\n\t\t\tthis.providerWorker.postMessage(req);\n\t\t}\n\t}\n\n\tget(which, callback, force) {\n\t\tvar dir = (which === _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE) ? 'prev' : 'next';\n\n\t\tvar item;\n\t\tif (which === _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.CURRENT) {\n\t\t\titem = this.curChunk;\n\t\t} else {\n\t\t\tif (typeof this.curChunk === 'undefined') {\n\t\t\t\titem = undefined;\n\t\t\t} else {\n\t\t\t\titem = this.curChunk[dir];\n\t\t\t}\n\t\t}\n\n\t\t// If there is a miss (when we start)\n\t\tvar req;\n\t\tif (typeof item === 'undefined') {\n\t\t\tif (which === _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.CURRENT) {\n\t\t\t\treq = {\n\t\t\t\t\tdir: _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.CURRENT,\n\t\t\t\t\toffset: this.currentOffset,\n\t\t\t\t\tstatus: _ChunkStatus__WEBPACK_IMPORTED_MODULE_0__.ChunkStatus.LAUNCHED,\n\t\t\t\t\tcallback: []\n\t\t\t\t};\n\t\t\t\tthis.curChunk = {\n\t\t\t\t\tdata: req,\n\t\t\t\t\tprev: undefined,\n\t\t\t\t\tnext: undefined\n\t\t\t\t};\n\t\t\t\titem = this.curChunk;\n\t\t\t\tthis.providerWorker.postMessage(req);\n\t\t\t} else {\n\t\t\t\treq = {\n\t\t\t\t\tdir: which,\n\t\t\t\t\toffset: this.currentOffset + (which * this.gap),\n\t\t\t\t\tstatus: _ChunkStatus__WEBPACK_IMPORTED_MODULE_0__.ChunkStatus.LAUNCHED,\n\t\t\t\t\tcallback: []\n\t\t\t\t};\n\t\t\t\tthis.curChunk[dir] = {\n\t\t\t\t\tdata: req,\n\t\t\t\t\tprev: (which === _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.AFTER) ? this.curChunk : undefined,\n\t\t\t\t\tnext: (which === _NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE) ? this.curChunk : undefined\n\t\t\t\t};\n\t\t\t\titem = this.curChunk[dir];\n\t\t\t\tthis.providerWorker.postMessage(req);\n\t\t\t}\n\t\t} else if (force === true) {\n\t\t\titem.data.status = _ChunkStatus__WEBPACK_IMPORTED_MODULE_0__.ChunkStatus.LAUNCHED;\n\t\t\tthis.providerWorker.postMessage(item.data);\n\t\t}\n\n\t\t// We infer the data is here\n\t\tif (item.data.status !== _ChunkStatus__WEBPACK_IMPORTED_MODULE_0__.ChunkStatus.LAUNCHED) {\n\t\t\treturn callback(item.data);\n\t\t} else { // Data isn't here, we deffer our callback\n\t\t\tif (typeof item.data.callback === 'undefined') {\n\t\t\t\titem.data.callback = [];\n\t\t\t}\n\t\t\titem.data.callback.push(callback);\n\t\t\treturn;\n\t\t}\n\t}\n\n\tisInside_(chunk, offset) {\n\t\tvar start = chunk.offset;\n\t\tvar end = start + this.gap;\n\t\treturn (start <= offset && end >= offset);\n\t}\n\n\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/core/BlockNavigator.js?")},"./js/core/ChunkStatus.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "ChunkStatus": () => (/* binding */ ChunkStatus)\n/* harmony export */ });\nconst ChunkStatus = {\n\tLAUNCHED: 0,\n\tCOMPLETED: 1\n};\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/core/ChunkStatus.js?')},"./js/core/NavigatorDirection.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "NavigatorDirection": () => (/* binding */ NavigatorDirection)\n/* harmony export */ });\nconst NavigatorDirection = {\n\tBEFORE: -1,\n\tCURRENT: 0,\n\tAFTER: 1\n};\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/core/NavigatorDirection.js?')},"./js/core/R2Wrapper.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"R2Actions\": () => (/* binding */ R2Actions),\n/* harmony export */   \"r2Settings\": () => (/* binding */ r2Settings),\n/* harmony export */   \"r2Wrapper\": () => (/* binding */ r2Wrapper)\n/* harmony export */ });\n/* harmony import */ var _SettingsManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SettingsManager */ \"./js/core/SettingsManager.js\");\n/* harmony import */ var _UIContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./UIContext */ \"./js/core/UIContext.js\");\n\n\n\n/**\n * Group of actions to listen to some events (seek, analyze...)\n * @class R2Actions\n */\nconst R2Actions = {\n\tSEEK: 'seek'\n}\n\nclass R2Wrapper {\n\n\tconstructor() {\n\t\tthis.listeners = [];\n\n\t\tObject.keys(R2Actions).forEach((action, index) => {\n\t\t\tthis.listeners[R2Actions[action]] = [];\n\t\t});\n\t}\n\n\t/**\n\t * Seek the value provided.\n\t * If widget is set, will navigate to it.\n\t * Notify all registered observers about seek action. \n\t * @param {any} value The value to seek\n\t * @param {any} [widget=null] Optional widget for navigation\n\t */\n\tseek(value, widget = null) {\n\t\t// TODO fetch s++ / s-- cmd\n\t\t// TODO keep track of current offset\n\t\tlet addr = value;\n\t\tif (typeof value === 'undefined') {\n\t\t\taddr = prompt('address');\n\t\t} else if (typeof value === 'number') {\n\t\t\taddr = '0x' + value.toString(16);\n\t\t}\n\n\t\tif (!addr || addr.trim() === '') {\n\t\t\treturn;\n\t\t}\n\n\t\tr2.cmd('s ' + addr, () => {\n\t\t\twidget && _UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(widget);\n\t\t\tthis.notifyAction(R2Actions.SEEK);\n\t\t});\n\t}\n\n\t/**\n\t * Add a listener to a specific action.\n\t * @param {R2Actions} action \n\t * @param {any} fn \n\t */\n\tregisterListener(action, fn) {\n\t\tthis.listeners[action].push(fn);\n\t}\n\n\t/**\n\t * Trigger all listeners for specified action\n\t * @param {R2Actions} action \n\t */\n\tnotifyAction(action) {\n\t\tthis.listeners[action].forEach(fn => fn());\n\t}\n}\n\nconst r2Wrapper = new R2Wrapper();\n\nconst SettingItems = {\n\tPLATFORM: 'platform',\n\tBITS: 'bits',\n\tUTF8: 'utf8',\n\tUCASE: 'ucase',\n\tDESCRIBE: 'describe',\n\tBYTES: 'bytes',\n\tOS: 'os',\n\tSIZE: 'size',\n\tDECODING: 'decoding',\n\tMODE: 'mode',\n\tANAL_HAS_NEXT: 'analHasNext',\n\tANAL_SKIP_NOPS: 'analSkipNops',\n\tANAL_NON_CODE: 'analNonCode',\n\tCOLORS: 'colors',\n\tUSE_TTS: 'useTTS',\n\tTHEME: 'theme',\n\tASMEMU: 'asmemu',\n\tASMEMUSTR: 'asmemustr'\n};\n\n\n\nlet r2Conf = {};\nr2Conf[SettingItems.PLATFORM] = { name: 'platform', defVal: 'x86', apply: function(p) { r2.cmd('e asm.arch=' + p); } };\nr2Conf[SettingItems.BITS] = { name: 'bits', defVal: '32', apply: function(p) { r2.cmd('e asm.bits=' + p); } };\nr2Conf[SettingItems.UTF8] = { name: 'utf8', defVal: 'true', apply: function(p) { r2.cmd('e scr.utf8=' + p); } };\nr2Conf[SettingItems.UCASE] = { name: 'ucase', defVal: 'false', apply: function(p) { r2.cmd('e asm.ucase=' + p); } };\nr2Conf[SettingItems.DESCRIBE] = { name: 'describe', defVal: 'false', apply: function(p) { r2.cmd('e asm.describe=' + p); } };\nr2Conf[SettingItems.BYTES] = { name: 'bytes', defVal: 'false', apply: function(p) { r2.cmd('e asm.bytes=' + p); } };\nr2Conf[SettingItems.OS] = { name: 'os', defVal: 'Linux', apply: function(p) { console.log('OS is now: ' + p); } }; // missing\nr2Conf[SettingItems.ASMEMU] = { name: 'asmemu', defVal: 'false', apply: function(p) {  r2.cmd('e asm.emu=' + p); } };\nr2Conf[SettingItems.ASMEMUSTR] = { name: 'asmemustr', defVal: 'false', apply: function(p) { r2.cmd('e emu.str=' + p); } };\nr2Conf[SettingItems.SIZE] = { name: 'size', defVal: 'S', apply: function(p) {\n\tswitch (p) {\n\tcase 'S':\n\t\tr2.cmd('e asm.bytes=false');\n\t\tr2.cmd('e asm.lines=false');\n\t\tr2.cmd('e asm.cmt.right=false');\n\t\tbreak;\n\tcase 'M':\n\t\tr2.cmd('e asm.bytes=false');\n\t\tr2.cmd('e asm.lines=true');\n\t\tr2.cmd('e asm.lines.width=8');\n\t\tr2.cmd('e asm.cmt.right=true');\n\t\tbreak;\n\tcase 'L':\n\t\tr2.cmd('e asm.bytes=true');\n\t\tr2.cmd('e asm.lines=true');\n\t\tr2.cmd('e asm.lines.width=12');\n\t\tr2.cmd('e asm.cmt.right=true');\n\t\tbreak;\n\t};\n}};\nr2Conf[SettingItems.DECODING] = { name: 'decoding', defVal: 'Pseudo', apply: function(p) {\n\tswitch (p) {\n\tcase 'Pseudo':\n\t\tr2.cmd('e asm.pseudo=true');\n\t\tr2.cmd('e asm.syntax=intel');\n\t\tbreak;\n\tcase 'Opcodes':\n\t\tr2.cmd('e asm.pseudo=false');\n\t\tr2.cmd('e asm.syntax=intel');\n\t\tbreak;\n\tcase 'ATT':\n\t\tr2.cmd('e asm.pseudo=false');\n\t\tr2.cmd('e asm.syntax=att');\n\t\tbreak;\n\t};\n}};\nr2Conf[SettingItems.MODE] = { name: 'mode', defVal: 'PA', apply: function(p) {\n\tswitch (p) {\n\tcase 'PA':\n\t\tr2.cmd('e io.va=false');\n\t\tr2.cmd('e io.pava=false');\n\t\tbreak;\n\tcase 'VA':\n\t\tr2.cmd('e io.va=true');\n\t\tr2.cmd('e io.pava=false');\n\t\tbreak;\n\tcase 'PAVA':\n\t\tr2.cmd('e io.pava=true');\n\t\tbreak;\n\tcase 'Debug':\n\t\tr2.cmd('e io.va=true');\n\t\tr2.cmd('e io.debug=true');\n\t\tr2.cmd('e io.pava=false');\n\t\tbreak;\n\t};\n}};\nr2Conf[SettingItems.ANAL_HAS_NEXT] = { name: 'analHasNext', defVal: true, apply: function(p) { console.log('analHasNext is ' + p); } };\nr2Conf[SettingItems.ANAL_SKIP_NOPS] = { name: 'analSkipNops', defVal: true, apply: function(p) { console.log('analSkipNops is ' + p); } };\nr2Conf[SettingItems.ANAL_NON_CODE] = { name: 'analNonCode', defVal: false, apply: function(p) { console.log('analNonCode is ' + p); } };\nr2Conf[SettingItems.COLORS] = { name: 'colors', defVal: 3, apply: function(p) { inColor = p; r2.cmd('e scr.color=' + p);} };\nr2Conf[SettingItems.THEME] = { name: 'theme', defVal: 'none', apply: function(p) { r2.cmd('eco ' + p); } }; // TODO\nr2Conf[SettingItems.USE_TTS] = { name: 'tts', defVal: true, apply: () => { } }; // TODO: not a r2Lib conf, should be externalized in an UI settings set\n\nconst r2Settings = new _SettingsManager__WEBPACK_IMPORTED_MODULE_0__.SettingsManager(SettingItems, r2Conf);\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/core/R2Wrapper.js?")},"./js/core/SettingsManager.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"SettingsManager\": () => (/* binding */ SettingsManager)\n/* harmony export */ });\nclass SettingsManager {\n\n\tget keys() { return this.itemKeys };\n\n\tconstructor(keys, baseConf) {\n\t\tthis.itemKeys = keys;\n\t\tthis.conf = baseConf;\n\t}\n\n\tloadAll(force = false) {\n\t\tfor (let key in this.conf) {\n\t\t\tconst curValue = this.getItem(key);\n\t\t\tconst defaultValue = this.getItemDefaultValue(key);\n\t\t\tif ((!force && curValue !== defaultValue) || force) {\n\t\t\t\tthis.conf[key].apply(curValue);\n\t\t\t}\n\t\t}\n\t}\n\n\tresetAll() {\n\t\tfor (let key in this.conf)\n\t\t\tlocalStorage.removeItem(key);\n\t\tthis.loadAll(true);\n\t}\n\n\tgetItem(key) {\n\t\tif (!this.keyExists(key)) throw new Error(`ConfKey ${key} doesn't exist!`);\n\t\t\n\t\tvar local = localStorage.getItem(key);\n\t\tif (local !== null) {\n\t\t\tif (local === 'false') {\n\t\t\t\tlocal = false;\n\t\t\t} else if (local === 'true') {\n\t\t\t\tlocal = true;\n\t\t\t}\n\t\t\treturn local;\n\t\t} else {\n\t\t\treturn this.getItemDefaultValue(key);\n\t\t}\n\t}\n\n\tsetItem(key, value) {\n\t\tif (!this.keyExists(key)) throw new Error(`ConfKey ${key} doesn't exist!`);\n\t\t\n\t\tlocalStorage.setItem(key, value);\n\t\tthis.conf[key].apply(value);\n\t}\n\n\tgetItemDefaultValue(key) {\n\t\tif (!this.keyExists(key)) throw new Error(`ConfKey ${key} doesn't exist!`);\n\n\t\treturn this.conf[key].defVal;\n\t}\n\n\t/** Tell if the key is defined in the declared item keys */\n\tkeyExists(key) {\n\t\treturn (typeof this.conf[key]) !== 'undefined';\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/core/SettingsManager.js?")},"./js/core/UIContext.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"uiContext\": () => (/* binding */ uiContext)\n/* harmony export */ });\n/* harmony import */ var _layout_Layouts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../layout/Layouts */ \"./js/layout/Layouts.js\");\n/* harmony import */ var _layout_Ruler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../layout/Ruler */ \"./js/layout/Ruler.js\");\n\n\n\n// Determine maximum widget displayable at same time\nconst MAX_WIDGETS = 2;\n\n// Define margin to apply both side of the ruler\nconst RULER_GAP = 0.001;\n\n/** Define the global UI context to switch between widgets */\nclass UIContext {\n\n\t/**\tBoolean to check focus on first widget */\n\tget isFirstWidgetFocused() { return this.focusedWidget === this.displayedWidgets[0]; }\n\n\t/** Tells if current layout is splitted */\n\tget isSplitted() { return this.currentLayout !== _layout_Layouts__WEBPACK_IMPORTED_MODULE_0__.Layouts.FULL; }\n\n\t/** Should be only one UIContext */\n\tconstructor() {\n\t\tthis.initialized = false;\n\t}\n\n\t/** Bind current widget factory and UI main nodes */\n\tinit(widgetFactory, contentNodeId, rulerNodeId, titleNodeId) {\n\t\tif (this.initialized) {\n\t\t\tconsole.error('UIContext shouldn\\'t be initialized more than once.');\n\t\t}\n\n\t\t// References to factory and DOM\n\t\tthis.initialized = true;\n\t\tthis.widgetFactory = widgetFactory;\n\t\tthis.contentNode = document.getElementById(contentNodeId);\n\t\tthis.rulerNode = document.getElementById(rulerNodeId);\n\t\tthis.titleNode = document.getElementById(titleNodeId);\n\n\t\t// Allocating content node with focus listeners\n\t\tfor (let i = 0 ; i < MAX_WIDGETS ; i++) {\n\t\t\tconst node = document.createElement('div');\n\t\t\tnode.addEventListener('click', () => this.setFocusAt(i));\n\t\t\tthis.contentNode.appendChild(node);\n\t\t}\n\n\t\t// Building the ruler\n\t\tthis.ruler = new _layout_Ruler__WEBPACK_IMPORTED_MODULE_1__.Ruler(this.contentNode, this.rulerNode);\n\t\tthis.ruler.hide();\n\t\tthis.currentLayout = _layout_Layouts__WEBPACK_IMPORTED_MODULE_0__.Layouts.FULL;\n\n\t\t// Listening to ruler moves\n\t\tthis.ruler.addListeners((position) => {\n\t\t\tthis.resizeTo(position);\n\t\t});\n\n\t\t// Tracking widget state: focus and display (following only from Widgets, no reference)\n\t\tthis.displayedWidgets = []; // order is important\n\t\tthis.focusedWidget;\n\t}\n\n\t/**\n\t * Set focus on current widget\n\t * @param {any} offset \n\t */\n\tsetFocusAt(offset) {\n\t\tif (~this.displayedWidgets.indexOf(offset)) {\n\t\t\tconsole.error('UIContext: focus offset isn\\'t correct');\n\t\t\treturn;\n\t\t}\n\t\tif (this.displayedWidgets[offset] === this.focusedWidget) {\n\t\t\treturn;\n\t\t}\n\n\t\tconst losingFocus = this.focusedWidget;\n\t\tconst gainingFocus = this.displayedWidgets[offset];\n\n\t\tthis.widgetFactory.get(losingFocus).lostFocus();\n\t\tthis.widgetFactory.get(gainingFocus).gotFocus();\n\n\t\tthis.focusedWidget = this.displayedWidgets[offset];\n\n\t\tthis.drawTitle();\n\t}\n\n\t/**\n\t * Navigate to specified widget by replacing currently focused widget\n\t * @param {Widgets} widget Widget reference\n\t * @param {...*} args\n\t */\n\tnavigateTo(widget, ...args) {\n\t\tconst destinationNode = this.getSlot(widget);\n\t\tthis.widgetFactory.get(widget).drawWidget(destinationNode, ...args);\n\t\tthis.applyLayout(destinationNode);\n\t\tthis.focusedWidget = widget;\n\t\tthis.drawTitle();\n\t}\n\n\t/** Provide a slot (node) for specified widget */\n\tgetSlot(widget) {\n\t\tlet widgetIndex = this.displayedWidgets.indexOf(widget);\n\t\tif (~widgetIndex) { // We want a slot for an already displayed widget\n\t\t\treturn this.contentNode.children[widgetIndex];\n\t\t}\n\n\t\tlet replacedWidget;\n\t\tif (this.currentLayout === _layout_Layouts__WEBPACK_IMPORTED_MODULE_0__.Layouts.FULL) {\n\t\t\t// There is already a widget\n\t\t\tif (typeof this.displayedWidgets.length !== 0) {\n\t\t\t\treplacedWidget = this.displayedWidgets[0];\n\t\t\t}\n\t\t\tthis.displayedWidgets = [widget];\n\t\t\twidgetIndex = 0;\n\t\t} else if (this.displayedWidgets.length === 1) {\n\t\t\t// Just merged, second part is free\n\t\t\tthis.displayedWidgets.push(widget);\n\t\t\twidgetIndex = 1;\n\t\t} else {\n\t\t\tif (this.isFirstWidgetFocused) {\n\t\t\t\treplacedWidget = this.displayedWidgets.shift();\n\t\t\t\tthis.displayedWidgets.unshift(widget);\n\t\t\t\twidgetIndex = 0;\n\t\t\t} else {\n\t\t\t\treplacedWidget = this.displayedWidgets.pop();\n\t\t\t\tthis.displayedWidgets.push(widget);\n\t\t\t\twidgetIndex = 1;\n\t\t\t}\n\t\t}\n\n\t\t// Notify previously displayed widget that it has been unplugged\n\t\tif (typeof replacedWidget !== 'undefined') {\n\t\t\tthis.widgetFactory.get(replacedWidget).lostDisplay();\n\t\t}\n\n\t\tthis.setFocusAt(widgetIndex);\n\t\treturn this.contentNode.children[widgetIndex];\n\t}\n\n\t/** Draw title with displayed instances */\n\tdrawTitle(separator = ' & ') {\n\t\tthis.titleNode.innerHTML = '';\n\t\tfor (let i = 0 ; i < this.displayedWidgets.length ; i++) {\n\t\t\tconst widget = this.displayedWidgets[i];\n\t\t\tconst isActiveOne = widget === this.focusedWidget && this.displayedWidgets.length > 1;\n\t\t\tconst node = document.createElement(isActiveOne ? 'strong' : 'span');\n\t\t\tnode.textContent = this.widgetFactory.get(widget).name;\n\t\t\tnode.addEventListener('click', () => this.setFocusAt(i));\n\n\t\t\tif (i !== 0) {\n\t\t\t\tthis.titleNode.appendChild(\n\t\t\t\t\tdocument.createTextNode(separator)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\tthis.titleNode.appendChild(node);\n\t\t}\n\t}\n\n\t/**\n\t * Apply classes to render current layout\n\t * @param {any} node \n\t */\n\tapplyLayout(node) {\n\t\tif (this.currentLayout === _layout_Layouts__WEBPACK_IMPORTED_MODULE_0__.Layouts.VERTICAL) {\n\t\t\tnode.classList.add('vertical');\n\t\t}\n\t}\n\n\t/** Resize a splitted layout between [0;1]% */\n\tresizeTo(position) {\n\t\tif (!this.isSplitted) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.contentNode.children[0].style.width = (position - RULER_GAP) * 100 + '%';\n\t\tthis.contentNode.children[1].style.width = (1 - position - RULER_GAP) * 100 + '%';\n\t}\n\n\t/**\n\t * Split current layout\n\t * @param {Layouts} layout Layout to use\n\t */\n\tsplit(layout) {\n\t\tif (this.isSplitted) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (layout !== _layout_Layouts__WEBPACK_IMPORTED_MODULE_0__.Layouts.VERTICAL) {\n\t\t\tconsole.error('Not supported layout.');\n\t\t}\n\n\t\tthis.currentLayout = layout;\n\t\tthis.ruler.show();\n\n\t\tfor (const child of this.contentNode.children) {\n\t\t\tthis.applyLayout(child);\n\t\t}\n\t}\n\n\t/** Merge current layout, we keep currently focused */\n\tmerge() {\n\t\tif (!this.isSplitted) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.ruler.reset();\n\t\tthis.ruler.hide();\n\t\tthis.currentLayout = _layout_Layouts__WEBPACK_IMPORTED_MODULE_0__.Layouts.FULL;\n\n\t\tconst focusedNode = this.isFirstWidgetFocused ? this.contentNode.children[0] : this.contentNode.children[1];\n\t\tconst otherNode = this.isFirstWidgetFocused ? this.contentNode.children[1] : this.contentNode.children[0];\n\n\t\t// We updates styles accordingly (we don't rewrite className for the focused one to keep eventual classes)\n\t\totherNode.className = 'rwidget';\n\t\tfocusedNode.classList.remove('vertical');\n\t\tfocusedNode.classList.remove('horizontal');\n\t\tfocusedNode.classList.add('full');\n\n\t\t// We swap first and second child if second one was the focused one\n\t\tif (focusedNode !== this.contentNode.children[0]) {\n\t\t\tfocusedNode.parentNode.insertBefore(otherNode, focusedNode);\n\t\t}\n\t}\n}\n\nconst uiContext = new UIContext();\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/core/UIContext.js?")},"./js/helpers/Autocompletion.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Autocompletion\": () => (/* binding */ Autocompletion)\n/* harmony export */ });\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n/* harmony import */ var _widgets_Widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../widgets/Widgets */ \"./js/widgets/Widgets.js\");\n\n\n\nconst ACKeys = {\n\tUP: 38,\n\tDOWN: 40,\n\tENTER: 13\n}\n\nconst ACNodes = {\n\tEMPTY: {pos: -1, offset: 0, length: 0, name: 'No match!'}\n}\n\n/**\n * Autocompletion classe, define a way to build an autocompletion process\n * with a fixed set of entries.\n */\nclass Autocompletion {\n\n\t/**\n\t * @param {String} formId - Literal DOM id #field\n\t * @param {String} choicesId - Literal DOM id #dropdown\n\t * @param {String} cmd - run into r2 to populate the autocompletion, eg. 'fs *;fj'\n\t * @param {integer} minChar - number of charcaters to start autocompletion\n\t * @param {integer} maxProp - maximum propositions to offer\n\t */\n\tconstructor(formId, choicesId, cmd, minChar, maxProp) {\n\t\tthis.form_ = formId;\n\t\tthis.dropdown_ = choicesId;\n\t\tthis.cmd_ = cmd;\n\t\tthis.minChar_ = minChar || 2;\n\t\tthis.maxProp_ = maxProp || 10;\n\t\tthis.init_();\n\t}\n\n\tinit_() {\n\t\tthis.form_ = document.getElementById(this.form_);\n\t\tthis.dropdown_ = document.getElementById(this.dropdown_);\n\n\t\tvar boundKeyUpHandler = this.keyHandler.bind(this);\n\t\tthis.form_.addEventListener('keyup', boundKeyUpHandler);\n\n\t\tvar _this = this;\n\t\tthis.form_.addEventListener('focus', function() {\n\t\t\tif (_this.prevLength_ >= _this.minChar_) {\n\t\t\t\t_this.show();\n\t\t\t}\n\t\t});\n\n\t\tthis.form_.addEventListener('blur', function() {\n\t\t\t_this.hide();\n\t\t});\n\n\t\tthis.flags_;\n\t\tthis.activeChoice_ = 0;\n\t\tthis.prevLength_ = 0;\n\t\tthis.list_;\n\t\tthis.completions_;\n\n\t\tthis.populate_();\n\t}\n\n\tpopulate_() {\n\t\tvar _this = this;\n\t\tr2.cmdj(this.cmd_, function(f) {\n\t\t\t_this.flags_ = f;\n\t\t});\n\t}\n\n\tprocess_(str) {\n\t\tvar selectedFlags = [];\n\n\t\tvar howMany = 0;\n\t\tfor (var i = 0 ; i < this.flags_.length ; i++) {\n\t\t\tvar offset = this.flags_[i].name.indexOf(str, 0);\n\t\t\tif (offset !== -1) {\n\t\t\t\tselectedFlags.push({\n\t\t\t\t\tpos: howMany++,\n\t\t\t\t\toffset: offset,\n\t\t\t\t\tlength: str.length,\n\t\t\t\t\tname: this.flags_[i].name\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (howMany === this.maxProp_) {\n\t\t\t\treturn selectedFlags;\n\t\t\t}\n\t\t}\n\t\treturn selectedFlags;\n\t}\n\n\taddNode_(item, active) {\n\t\tconst node = document.createElement('li');\n\t\tif (active) {\n\t\t\tnode.className = 'active';\n\t\t}\n\n\t\tnode.addEventListener('mouseover', () => this.setActiveChoice(item.pos));\n\n\t\tnode.addEventListener('mousedown', () => {\n\t\t\tthis.setActiveChoice(item.pos);\n\t\t\tthis.valid();\n\t\t});\n\n\t\tconst emphasis = document.createElement('strong');\n\t\temphasis.appendChild(document.createTextNode(item.name.substr(item.offset, item.length)));\n\n\t\tnode.appendChild(\n\t\t\tdocument.createTextNode(\n\t\t\t\titem.name.substr(0, item.offset)));\n\t\tnode.appendChild(emphasis);\n\t\tnode.appendChild(\n\t\t\tdocument.createTextNode(\n\t\t\t\titem.name.substr(item.offset + item.length, item.name.length - (item.offset + item.length))));\n\t\tthis.dropdown_.appendChild(node);\n\t\tconsole.log(node);\n\t}\n\n\tcleanChoices_() {\n\t\t// Cleaning old completion\n\t\twhile (this.dropdown_.firstChild) {\n\t\t\tthis.dropdown_.removeChild(this.dropdown_.firstChild);\n\t\t}\n\t}\n\n\tsetActiveChoice(newActive) {\n\t\tlet i = 0;\n\t\tfor (let child of this.dropdown_.children) {\n\t\t\tchild.className = i === newActive ? 'active' : '';\n\t\t\ti += 1;\n\t\t}\n\t\tthis.activeChoice_ = newActive;\n\t}\n\n\tkeyMovement_(key) {\n\t\tif (key === ACKeys.UP && this.activeChoice_ > 0) {\n\t\t\tconsole.log('UP');\n\t\t\tthis.setActiveChoice(this.activeChoice_ - 1);\n\t\t}\n\n\t\tif (key === ACKeys.DOWN && this.activeChoice_ < this.dropdown_.childNodes.length - 1) {\n\t\t\tconsole.log('DOWN');\n\t\t\tthis.setActiveChoice(this.activeChoice_ + 1);\n\t\t}\n\t}\n\n\tvalid() {\n\t\tif (this.activeChoice_ === -1 || this.dropdown_.childNodes.length <= this.activeChoice_) {\n\t\t\treturn;\n\t\t}\n\t\tthis.hide();\n\t\tthis.prepareView();\n\t\treturn _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Wrapper.seek(this.completions_[this.activeChoice_].name, _widgets_Widgets__WEBPACK_IMPORTED_MODULE_1__.Widgets.DISASSEMBLY);\n\t}\n\n\tshow() {\n\t\tthis.dropdown_.style.display = 'block';\n\t}\n\n\thide() {\n\t\tthis.dropdown_.style.display = 'none';\n\t}\n\n\tkeyHandler(e) {\n\t\tif (e.keyCode === ACKeys.UP || e.keyCode === ACKeys.DOWN) {\n\t\t\treturn this.keyMovement_(e.keyCode);\n\t\t}\n\n\t\tif (e.keyCode === ACKeys.ENTER) {\n\t\t\tthis.hide();\n\t\t\treturn this.valid();\n\t\t}\n\n\t\tvar value = e.target.value;\n\t\tthis.cleanChoices_();\n\n\t\tif (value.length >= 2) {\n\t\t\tthis.show();\n\t\t\tthis.completions_ = this.process_(value);\n\t\t\tif (this.prevLength_ !== value.length) {\n\t\t\t\tthis.activeChoice_ = 0;\n\t\t\t}\n\n\t\t\t// Add them to dropdown\n\t\t\tif (this.completions_.length === 0) {\n\t\t\t\tthis.addNode_(ACNodes.EMPTY, false);\n\t\t\t} else {\n\t\t\t\tfor (var i in this.completions_) {\n\t\t\t\t\t// TODO add eventthis.list_ener (hover) for this.activeChoice_\n\t\t\t\t\tthis.addNode_(this.completions_[i], i === this.activeChoice_);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis.prevLength_ = value.length;\n\t\t} else {\n\t\t\tthis.hide();\n\t\t}\n\t}\n\n\tsetPrepareView(callback) {\n\t\tthis.preparationCallback = callback;\n\t}\n\n\t/**\n\t * Prepare view to show the result\n\t */\n\tprepareView() {\n\t\tif (typeof this.preparationCallback === 'undefined') {\n\t\t\treturn;\n\t\t}\n\t\tthis.preparationCallback();\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/helpers/Autocompletion.js?")},"./js/helpers/Format.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"applySeek\": () => (/* binding */ applySeek),\n/* harmony export */   \"formatOffset\": () => (/* binding */ formatOffset),\n/* harmony export */   \"formatOffsets\": () => (/* binding */ formatOffsets)\n/* harmony export */ });\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\nconst offsetRegex = new RegExp(/(0x[a-zA-Z0-9]+|(?:sym|fcn|str)\\.[\\.a-zA-Z0-9_]+)/, \"g\");\n\n/** Takes a block and makes all offsets clickables */\nfunction formatOffsets(str, navigateTo = null) {\n\tconst chunks = str.split(offsetRegex);\n\tconst node = document.createElement('span');\n\n\tfor (const chunk of chunks) {\n\t\tnode.appendChild(formatOffset(chunk, navigateTo));\n\t}\n\n\treturn node;\n}\n\n/** Read the value and format if it's exactly an offset */\nfunction formatOffset(str, navigateTo = null) {\n\tlet chunkNode;\n\tif (offsetRegex.test(str)) {\n\t\tchunkNode = document.createElement('a');\n\t\tchunkNode.innerHTML = str;\n\t\tapplySeek(chunkNode, str, navigateTo);\n\t} else {\n\t\tchunkNode = document.createElement('span');\n\t\tchunkNode.innerHTML = str;\n\t}\n\n\treturn chunkNode;\n}\n\n/** Consider node's content as seekable, apply events to trigger seek event */\nfunction applySeek(node, dest = null, navigateTo = null) {\n\tdest = dest || node.textContent;\n\tnode.addEventListener('click', () => _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Wrapper.seek(dest, navigateTo));\n\tnode.title = 'Seek ' + dest;\n\tnode.href = '#' + dest;\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/helpers/Format.js?")},"./js/helpers/InfiniteScrolling.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "InfiniteScrolling": () => (/* binding */ InfiniteScrolling)\n/* harmony export */ });\n/**\n * domTarget must have a "measurable" height\n * limit, when there is less than {limit}% available to scroll\n * we call the associated event\n */\nclass InfiniteScrolling {\n\n\tconstructor(domTarget, howManyScreens, limit) {\n\t\tthis.domTarget = domTarget;\n\t\tthis.limit = limit;\n\t\tthis.howManyScreens = howManyScreens;\n\t\tthis.screenProportion = 1.0 / this.howManyScreens;\n\t\tthis.pauseScrollEvent = false;\n\t\tthis.prevScroll = 0.;\n\n\t\tvar _this = this;\n\t\tthis.domTarget.addEventListener(\'scroll\', function(e) {\n\t\t\t_this.scrollEvent_(e);\n\t\t});\n\t}\n\n\tsetTopEvent(fct) {\n\t\tthis.ontop = fct;\n\t}\n\n\tsetBottomEvent(fct) {\n\t\tthis.onbottom = fct;\n\t}\n\n\tscrollEvent_(e) {\n\t\tvar _this = this;\n\t\tif (this.pauseScrollEvent) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar height = e.target.scrollHeight - e.target.offsetHeight;\n\t\tvar p = e.target.scrollTop  / height;\n\n\t\tif (!this.isTopMax && p < this.limit && this.prevScroll > p) {\n\t\t\tthis.pauseScrollEvent = true;\n\t\t\tvar pos = Math.floor(((this.limit + (p - this.limit)) + this.screenProportion) * height);\n\t\t\tthis.ontop(pos, function(isTopMax) {\n\t\t\t\t_this.pauseScrollEvent = false;\n\t\t\t});\n\t\t}\n\n\t\tif (p > (1 - this.limit) && this.prevScroll < p) {\n\t\t\tthis.pauseScrollEvent = true;\n\t\t\tvar pos = Math.floor((((1 - this.limit) + (p - (1 - this.limit))) - this.screenProportion) * height);\n\t\t\tthis.onbottom(pos, function(isTopMax) {\n\t\t\t\t_this.pauseScrollEvent = false;\n\t\t\t});\n\t\t}\n\n\t\tthis.prevScroll = p;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/helpers/InfiniteScrolling.js?')},"./js/helpers/Inputs.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Inputs\": () => (/* binding */ Inputs)\n/* harmony export */ });\n// TODO, progressive rewriting from ui.legacy.js\n\nconst MARGIN = '3px';\n\nfunction pictogramInputButton(iconName, name, onclick = null) {\n\tconst button = document.createElement('a');\n\tbutton.className = 'mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect';\n\tbutton.style.margin = MARGIN;\n\tconst icon = document.createElement('i')\n\ticon.className = 'material-icons';\n\ticon.innerHTML = iconName;\n\tbutton.appendChild(icon);\n\tbutton.appendChild(document.createTextNode(name));\n\tif (onclick !== null) button.addEventListener('click', onclick);\n\treturn button;\n}\n\nfunction inputButton(name, onclick = null) {\n\tconst button = document.createElement('a');\n\tbutton.className = 'mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect';\n\tbutton.style.margin = MARGIN;\n\tbutton.textContent = name;\n\tif (onclick !== null) button.addEventListener('click', onclick);\n\treturn button;\n}\n\nfunction imgButton(iconName, title, onclick = null) {\n\tconst button = document.createElement('button');\n\tbutton.className = 'mdl-button mdl-js-button mdl-button--fab mdl-js-ripple-effect';\n\tbutton.style.margin = MARGIN;\n\tbutton.title = title;\n\tconst icon = document.createElement('i')\n\ticon.className = 'material-icons';\n\ticon.textContent = iconName;\n\tbutton.appendChild(icon);\n\tif (onclick !== null) button.addEventListener('click', onclick);\n\treturn button;\n}\n\nfunction iconButton(iconName, title, onclick = null) {\n\tconst button = document.createElement('button');\n\tbutton.className = 'mdl-button mdl-js-button mdl-button--fab mdl-button--mini-fab mdl-js-ripple-effect';\n\tbutton.style.margin = MARGIN;\n\tbutton.title = title;\n\tconst icon = document.createElement('i')\n\ticon.className = 'material-icons md-dark';\n\ticon.innerHTML = iconName;\n\tbutton.appendChild(icon);\n\tif (onclick !== null) button.addEventListener('click', onclick);\n\treturn button;\n}\n\nconst Inputs = {\n\tbutton: inputButton,\n\timgButton: imgButton,\n\ticonButton: iconButton,\n\tpictogramInputButton: pictogramInputButton\n};\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/helpers/Inputs.js?")},"./js/helpers/Speak.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"speak\": () => (/* binding */ speak)\n/* harmony export */ });\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\nfunction speak(text, callback) {\n\tif (!_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.USE_TTS)) {\n\t\treturn;\n\t}\n\n\tif (typeof SpeechSynthesisUtterance === 'undefined') {\n\t\treturn;\n\t}\n\t\n\tvar u = new SpeechSynthesisUtterance();\n\tu.text = text;\n\tu.lang = 'en-US';\n\n\tu.onend = function() {\n\t\tif (callback) {\n\t\t\tcallback();\n\t\t}\n\t};\n\n\tu.onerror = function(e) {\n\t\tif (callback) {\n\t\t\tcallback(e);\n\t\t}\n\t};\n\n\tspeechSynthesis.speak(u);\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/helpers/Speak.js?")},"./js/helpers/Table.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Table\": () => (/* binding */ Table)\n/* harmony export */ });\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/Format */ \"./js/helpers/Format.js\");\n\n\n/**\n * Handling DataTables with jQuery plugin\n *\n * @param {Array} cols - List of columns, add \"+\" at beginning to specify a clickable field (seek method)\n * @param {Array} nonum - List of booleans, set true if non-numeric\n * @param {String} id - Id (DOM) of the current table, internal usage for DataTable plugin\n */\nclass Table {\n\tconstructor(cols, nonum, id, onChange, seekNavigation = null) {\n\t\tthis.cols = cols;\n\t\tthis.nonum = nonum;\n\t\tthis.clickableOffset = new Array(cols.length);\n\t\tthis.clickableOffset.fill(false);\n\t\tthis.contentEditable = new Array(cols.length);\n\t\tthis.contentEditable.fill(false);\n\t\tthis.onChange = onChange;\n\t\tthis.seekNavigation = seekNavigation;\n\t\tthis.id = id || false;\n\n\t\tthis.init();\n\t}\n\n\tinit() {\n\t\tthis.root = document.createElement('table');\n\t\tthis.root.className = 'mdl-data-table mdl-data-table--selectable mdl-shadow--2dp';\n\t\tif (this.root.id !== false) {\n\t\t\tthis.root.id = this.id;\n\t\t}\n\n\t\tthis.thead = document.createElement('thead');\n\t\tthis.root.appendChild(this.thead);\n\t\tthis.tbody = document.createElement('tbody');\n\t\tthis.root.appendChild(this.tbody);\n\n\t\tvar tr = document.createElement('tr');\n\t\tthis.thead.appendChild(tr);\n\n\t\tfor (var c in this.cols) {\n\t\t\tif (this.cols[c][0] == '+') {\n\t\t\t\tthis.clickableOffset[c] = true;\n\t\t\t\tthis.cols[c] = this.cols[c].substr(1);\n\t\t\t} else if (this.cols[c][0] == '~') {\n\t\t\t\tthis.contentEditable[c] = true;\n\t\t\t}\n\n\t\t\tvar th = document.createElement('th');\n\t\t\tth.appendChild(document.createTextNode(this.cols[c]));\n\t\t\tif (this.nonum[c]) {\n\t\t\t\tth.className = 'mdl-data-table__cell--non-numeric';\n\t\t\t}\n\t\t\ttr.appendChild(th);\n\t\t}\n\t}\n\n\tgetRows() {\n\t\treturn Array.prototype.slice.call(this.tbody.children);\n\t}\n\n\taddRow(cells) {\n\t\tvar tr = document.createElement('tr');\n\t\tthis.tbody.appendChild(tr);\n\n\t\tfor (var i = 0; i < cells.length; i++) {\n\t\t\tvar td = document.createElement('td');\n\t\t\tif (this.clickableOffset[i]) {\n\t\t\t\tconst a = document.createElement('a');\n\t\t\t\ta.innerHTML = cells[i];\n\t\t\t\ttd.appendChild(a);\n\t\t\t\t(0,_helpers_Format__WEBPACK_IMPORTED_MODULE_0__.applySeek)(a, cells[i], this.seekNavigation);\t\t\t\t\n\t\t\t} else if (typeof cells[i] === 'object') {\n\t\t\t\ttd.appendChild(cells[i]);\n\t\t\t} else {\n\t\t\t\ttd.innerHTML = cells[i];\n\t\t\t}\n\n\t\t\tif (this.contentEditable[i]) {\n\t\t\t\tvar _this = this;\n\t\t\t\ttd.initVal = td.innerHTML;\n\t\t\t\ttd.contentEditable = true;\n\t\t\t\ttd.busy = false;\n\n\t\t\t\ttd.addEventListener('blur', function (evt) {\n\t\t\t\t\tif (evt.target.busy) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tif (evt.target.initVal === evt.target.innerHTML) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tevt.target.busy = true;\n\t\t\t\t\t_this.onChange(cells, evt.target.innerHTML);\n\t\t\t\t\tevt.target.initVal = evt.target.innerHTML;\n\t\t\t\t\tevt.target.busy = false;\n\t\t\t\t});\n\n\t\t\t\ttd.addEventListener('keydown', function (evt) {\n\t\t\t\t\tif (evt.keyCode !== 13 || evt.target.busy) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tif (evt.target.initVal === evt.target.innerHTML) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tevt.preventDefault();\n\t\t\t\t\tevt.target.busy = true;\n\t\t\t\t\t_this.onChange(cells, evt.target.innerHTML);\n\t\t\t\t\tevt.target.initVal = evt.target.innerHTML;\n\t\t\t\t\tevt.target.busy = false;\n\t\t\t\t\tevt.target.blur();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\ttr.appendChild(td);\n\t\t}\n\t\treturn tr;\n\t}\n\n\tinsertInto(node) {\n\t\tnode.appendChild(this.root);\n\t\tif (this.id !== false) {\n\t\t\t$('#' + this.id).DataTable();\n\t\t}\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/helpers/Table.js?")},"./js/helpers/UpdateManager.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"UpdateManager\": () => (/* binding */ UpdateManager)\n/* harmony export */ });\nclass UpdateManager {\n\n\tconstructor() {\n\t\tthis.updateMethods = [{}, {}];\n\t\tthis.currentFocus;\n\t}\n\n\tregisterMethod(offset, method) {\n\t\tthis.updateMethods[offset] = method;\n\t}\n\n\tfocusHasChanged(offset) {\n\t\tthis.currentFocus = offset;\n\t}\n\n\tapply() {\n\t\tif (typeof this.currentFocus === 'undefined') {\n\t\t\treturn;\n\t\t}\n\t\tthis.updateMethods[this.currentFocus]();\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/helpers/UpdateManager.js?")},"./js/layout/ContainerZone.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ContainerZone\": () => (/* binding */ ContainerZone)\n/* harmony export */ });\n/* harmony import */ var _helpers_UpdateManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/UpdateManager */ \"./js/helpers/UpdateManager.js\");\n/* harmony import */ var _Layouts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Layouts */ \"./js/layout/Layouts.js\");\n\n\n\n/**\n * Making a splittable container zone\n */\nclass ContainerZone {\n\t\n\tconstructor(containerNode, rulerNode, titleNode) {\n\t\tthis.container = document.getElementById(containerNode);\n\t\tthis.ruler = document.getElementById(rulerNode);\n\t\tthis.title = document.getElementById(titleNode);\n\t\tthis.currentLayout = _Layouts__WEBPACK_IMPORTED_MODULE_1__.Layouts.FULL;\n\t\tthis.widgets = [];\n\t\tthis.populatedWidgets = [];\n\t\tthis.initRuler();\n\n\t\tthis.focus_ = 0;\n\t\tthis.focusListeners = [];\n\n\t\tvar _this = this;\n\t\tthis.fallback = function() {\n\t\t\tvar emptyWidget = _this.getWidget('New Widget', false);\n\t\t\temptyWidget.setHTMLContent('<p class=\"mdl-typography--text-center\">Ready !</p>');\n\t\t\t_this.add(emptyWidget);\n\t\t};\n\n\t\tthis.updateManagers = {};\n\t\tthis.updateManagers.updates = new _helpers_UpdateManager__WEBPACK_IMPORTED_MODULE_0__.UpdateManager();\n\t\tthis.updateManagers.lastViews = new _helpers_UpdateManager__WEBPACK_IMPORTED_MODULE_0__.UpdateManager();\n\n\t\tthis.addFocusListener(this.updateManagers.updates);\n\t\tthis.addFocusListener(this.updateManagers.lastViews);\n\t}\n\t\n\t/**\n\t * Define the widget method that would be called when splitting\n\t */\n\tfallbackWidget(callback) {\n\t\tthis.fallback = callback;\n\t}\n\n\tinitRuler() {\n\t\tvar context = {};\n\t\tvar _this = this;\n\n\t\tthis.rulerProp = {\n\t\t\tgap: 0.005, // 0.5% margin between two panels\n\t\t\tpos: 0.5\n\t\t};\n\n\t\tvar initDrag = function(e) {\n\t\t\tcontext = {\n\t\t\t\tstartX: e.clientX,\n\t\t\t\tstartWidth: parseInt(document.defaultView.getComputedStyle(_this.ruler).width, 10),\n\t\t\t\tinterval: (e.clientX - _this.ruler.offsetLeft)\n\t\t\t};\n\t\t\tdocument.documentElement.addEventListener('mousemove', doDrag, false);\n\t\t\tdocument.documentElement.addEventListener('mouseup', stopDrag, false);\n\n\t\t\t// Prevent selecting text\n\t\t\te.preventDefault();\n\t\t};\n\n\t\tvar doDrag = function(e) {\n\t\t\tvar relativePosition = (e.clientX - context.interval) / _this.container.offsetWidth;\n\t\t\t_this.rulerProp.pos = relativePosition;\n\t\t\t_this.container.children[0].style.width = (relativePosition - _this.rulerProp.gap) * 100 + '%';\n\t\t\t_this.container.children[1].style.width = ((1 - relativePosition) - _this.rulerProp.gap) * 100 + '%';\n\t\t\t_this.ruler.style.marginLeft = relativePosition * 100 + '%';\n\t\t};\n\n\t\tvar stopDrag = function() {\n\t\t\tdocument.documentElement.removeEventListener('mousemove', doDrag, false);\n\t\t\tdocument.documentElement.removeEventListener('mouseup', stopDrag, false);\n\t\t};\n\n\t\tthis.ruler.addEventListener('mousedown', initDrag);\n\t}\n\n\tsetFocus(focus) {\n\t\tthis.focus_ = focus;\n\t\tfor (var i = 0 ; i < this.focusListeners.length ; i++) {\n\t\t\tthis.focusListeners[i].focusHasChanged(focus);\n\t\t}\n\t}\n\n\tgetFocus() {\n\t\treturn this.focus_;\n\t}\n\n\t/**\n\t * Autobinding implies the widget to be populated as is\n\t * Will be completed by the user manipulating the widget\n\t */\n\tgetWidget(name, autobinding) {\n\t\tvar autobinding = (typeof autobinding === 'undefined'); // Default is true\n\n\t\tfor (var i = 0 ; i < this.widgets.length ; i++) {\n\t\t\tif (this.widgets[i].getName() === name) {\n\t\t\t\tif (autobinding) { // Autobinding\n\t\t\t\t\tthis.add(this.widgets[i]);\n\t\t\t\t}\n\t\t\t\treturn this.widgets[i];\n\t\t\t}\n\t\t}\n\n\t\tvar newWidget = new Widget(name);\n\t\tthis.widgets.push(newWidget);\n\n\t\tif (autobinding) {\n\t\t\tthis.add(newWidget);\n\t\t}\n\n\t\treturn newWidget;\n\t}\n\n\tgetWidgetDOMWrapper(widget) {\n\t\tvar offset = this.populatedWidgets.indexOf(widget);\n\t\tif (offset === -1) {\n\t\t\tconsole.log('Can\\'t get DOM wrapper of a non-populated widget');\n\t\t\treturn;\n\t\t}\n\n\t\treturn this.container.children[offset];\n\t}\n\n\tisSplitted() {\n\t\treturn this.currentLayout !== _Layouts__WEBPACK_IMPORTED_MODULE_1__.Layouts.FULL;\n\t}\n\n\tmerge() {\n\t\tif (!this.isSplitted()) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Reset and clear\n\t\tthis.ruler.style.marginLeft = '50%';\n\t\tthis.ruler.style.display = 'none';\n\t\tthis.rulerProp.pos = 0.5;\n\n\t\tvar keep = this.getWidgetDOMWrapper(this.populatedWidgets[this.getFocus()]);\n\t\tkeep.className = 'rwidget full focus';\n\t\tkeep.style.width = 'auto';\n\n\t\tfor (var i = 0 ; i < this.container.children.length ; i++) {\n\t\t\tif (i !== this.getFocus()) {\n\t\t\t\tthis.container.removeChild(this.container.children[i]);\n\t\t\t\tthis.populatedWidgets.splice(i, 1);\n\t\t\t}\n\t\t}\n\n\t\tthis.setFocus(0);\n\t\tthis.currentLayout = _Layouts__WEBPACK_IMPORTED_MODULE_1__.Layouts.FULL;\n\t\tthis.drawTitle();\n\t}\n\n\tsplit(layout) {\n\t\tif (this.isSplitted()) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.ruler.style.display = 'block';\n\t\tthis.container.children[0].style.width = (this.rulerProp.pos - this.rulerProp.gap) * 100 + '%';\n\n\t\tfor (var i = 0 ; i < this.populatedWidgets.length ; i++) {\n\t\t\tthis.getWidgetDOMWrapper(this.populatedWidgets[i]).classList.remove('full');\n\t\t\tthis.getWidgetDOMWrapper(this.populatedWidgets[i]).classList.add(layout);\n\t\t}\n\n\t\tthis.currentLayout = layout;\n\n\t\tif (this.populatedWidgets.length <= 1) {\n\t\t\t// We pop the fallback widget\n\t\t\tthis.fallback();\n\t\t}\n\n\t\t// We want to set the focus on the space\n\t\tthis.setFocus(1);\n\t\tthis.drawTitle();\n\t}\n\n\t/**\n\t * Tell if the widget is currently displayed (careful to case sensitivity)\n\t */\n\tgetCurrentlyDrawn() {\n\t\tvar list = [];\n\t\tfor (var i = 0 ; i < this.populatedWidgets.length ; i++) {\n\t\t\tlist.push(this.populatedWidgets[i].name);\n\t\t}\n\t\treturn list;\n\t}\n\n\tadd(widget) {\n\t\tif (this.populatedWidgets.indexOf(widget) !== -1) {\n\t\t\t// Can't open the same panel more than once: draw() should be called\n\t\t\treturn;\n\t\t}\n\n\t\t// Special case at beginning when the widget is already loaded\n\t\tif (widget.isAlreadyThere()) {\n\t\t\tthis.populatedWidgets.push(widget);\n\t\t\tthis.applyFocusEvent_(widget);\n\t\t\treturn;\n\t\t}\n\n\t\tvar widgetElement = document.createElement('div');\n\t\twidgetElement.classList.add('rwidget');\n\t\twidgetElement.classList.add(this.currentLayout);\n\t\twidget.binding(widgetElement);\n\n\t\tif (this.isSplitted()) {\n\t\t\tvar layoutFull = this.populatedWidgets.length >= 2;\n\n\t\t\t// If the container is full, we remove the active widget\n\t\t\tif (layoutFull) {\n\t\t\t\t// TODO, handle default width 50% -> doesn't consider previous resizing\n\t\t\t\tthis.container.removeChild(this.container.children[this.getFocus()]); // from DOM\n\t\t\t\tthis.populatedWidgets.splice(this.getFocus(), 1);\n\t\t\t}\n\n\t\t\tif (this.getFocus() === 0 && layoutFull) { // Poping first\n\t\t\t\tthis.populatedWidgets.unshift(widget);\n\t\t\t\tif (!widget.isAlreadyThere()) {\n\t\t\t\t\tthis.container.insertBefore(widgetElement, this.container.children[0]);\n\t\t\t\t\tthis.container.children[0].style.width = (this.rulerProp.pos - this.rulerProp.gap) * 100 + '%';\n\t\t\t\t}\n\t\t\t} else { // Second panel\n\t\t\t\tthis.populatedWidgets.push(widget);\n\t\t\t\tif (!widget.isAlreadyThere()) {\n\t\t\t\t\tthis.container.appendChild(widgetElement);\n\t\t\t\t\tthis.container.children[1].style.width = ((1 - this.rulerProp.pos) - this.rulerProp.gap) * 100 + '%';\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\tif (this.populatedWidgets.length >= 1) {\n\t\t\t\tthis.container.removeChild(this.container.children[this.getFocus()]); // from DOM\n\t\t\t}\n\t\t\tthis.populatedWidgets = [widget];\n\t\t\tif (!widget.isAlreadyThere()) {\n\t\t\t\tthis.container.appendChild(widgetElement);\n\t\t\t\tthis.container.children[0].style.width = 'auto';\n\t\t\t}\n\t\t}\n\n\t\tthis.moveFocusOnWidget(widget);\n\t\tthis.applyFocusEvent_(widget);\n\t\twidget.setOffset(this.getFocus());\n\t\tthis.drawTitle();\n\t}\n\n\tmoveFocusOnWidget(widget) {\n\t\tthis.setFocus(this.populatedWidgets.indexOf(widget));\n\t\tthis.container.children[this.getFocus()].classList.add('focus');\n\n\t\tif (this.isSplitted()) {\n\t\t\tthis.container.children[(this.getFocus() + 1) % 2 ].classList.remove('focus');\n\t\t}\n\n\t\tthis.drawTitle();\n\t}\n\n\tdrawTitle() {\n\t\tif (this.currentLayout === _Layouts__WEBPACK_IMPORTED_MODULE_1__.Layouts.FULL || this.populatedWidgets.length === 1) {\n\t\t\tthis.title.innerHTML = this.populatedWidgets[0].getName();\n\t\t} else {\n\t\t\tvar titles = [];\n\t\t\tfor (var i = 0 ; i < this.populatedWidgets.length ; i++) {\n\t\t\t\tif (this.getFocus() === i) {\n\t\t\t\t\ttitles.push('<strong>' + this.populatedWidgets[i].getName() + '</strong>');\n\t\t\t\t} else {\n\t\t\t\t\ttitles.push(this.populatedWidgets[i].getName());\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis.title.innerHTML = titles.join(' & ');\n\t\t}\n\t}\n\n\tapplyFocusEvent_(widget) {\n\t\tvar _this = this;\n\t\tvar element = this.getWidgetDOMWrapper(widget);\n\t\telement.addEventListener('mousedown', function() {\n\t\t\t_this.moveFocusOnWidget(widget);\n\t\t});\n\t}\n\n\taddFocusListener(obj) {\n\t\tthis.focusListeners.push(obj);\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/layout/ContainerZone.js?")},"./js/layout/FlexContainer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FlexContainer\": () => (/* binding */ FlexContainer)\n/* harmony export */ });\n/**\n * Define a container in absolute position\n * Create two area: control + body\n */\nclass FlexContainer {\n\t\n\tconstructor(dom, classes) {\n\t\tthis.classes = (typeof classes === 'undefined') ? '' : classes;\n\t\tthis.init(dom);\n\t}\n\n\tinit(dom) {\n\t\tthis.container = dom;\n\t\tthis.container.innerHTML = '';\n\n\t\tthis.controls = document.createElement('div');\n\t\tthis.body = document.createElement('div');\n\n\t\tthis.controls.className = 'flex flex-controls ' + this.classes;\n\t\tthis.body.className = 'flex flex-body ' + this.classes;\n\n\t\tthis.container.appendChild(this.controls);\n\t\tthis.container.appendChild(this.body);\n\t}\n\n\treplug(dom) {\n\t\tthis.container = dom;\n\t\tthis.container.innerHTML = '';\n\t\tthis.container.appendChild(this.controls);\n\t\tthis.container.appendChild(this.body);\n\t}\n\n\treset() {\n\t\tthis.init(this.container);\n\t}\n\n\tgetControls() {\n\t\treturn this.controls;\n\t}\n\n\tdrawControls(callback) {\n\t\tthis.controls.innerHTML = '';\n\t\tcallback(this.controls);\n\t}\n\n\tgetBody() {\n\t\treturn this.body;\n\t}\n\n\tdrawBody(callback) {\n\t\tthis.body.innerHTML = '';\n\t\tcallback(this.body);\n\t}\n\n\tpause(msg) {\n\t\tif (!this.dialogHasBeenDrawn) {\n\t\t\tthis.drawEmptyDialog();\n\t\t}\n\n\t\tthis.textDialog.innerHTML = msg;\n\t\tthis.dialog.showModal();\n\t}\n\n\tdrawEmptyDialog() {\n\t\tvar _this = this;\n\t\tthis.dialog = document.createElement('dialog');\n\t\tthis.dialog.className = 'mdl-dialog';\n\n\t\tif (!this.dialog.showModal) {\n\t\t\tdialogPolyfill.registerDialog(this.dialog);\n\t\t}\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.className = 'mdl-dialog__content';\n\t\tthis.dialog.appendChild(content);\n\n\t\tvar icon = document.createElement('p');\n\t\ticon.className = 'mdl-typography--text-center';\n\t\tcontent.appendChild(icon);\n\n\t\tvar iIcon = document.createElement('i');\n\t\tiIcon.className = 'material-icons';\n\t\tiIcon.style.fontSize = '54px';\n\t\tiIcon.innerHTML = 'error_outline';\n\t\ticon.appendChild(iIcon);\n\n\t\tthis.textDialog = document.createElement('p');\n\t\tcontent.appendChild(this.textDialog);\n\n\t\tvar actions = document.createElement('div');\n\t\tactions.className = 'mdl-dialog__actions';\n\t\tthis.dialog.appendChild(actions);\n\n\t\tvar saveButton = document.createElement('button');\n\t\tsaveButton.className = 'mdl-button';\n\t\tsaveButton.innerHTML = 'Cancel';\n\t\tsaveButton.addEventListener('click', function() {\n\t\t\t_this.dialog.close();\n\t\t});\n\t\tactions.appendChild(saveButton);\n\n\t\tdocument.body.appendChild(this.dialog);\n\t\tcomponentHandler.upgradeDom();\n\t}\n\n\tresume() {\n\t\tthis.dialog.close();\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/layout/FlexContainer.js?")},"./js/layout/Layouts.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Layouts\": () => (/* binding */ Layouts)\n/* harmony export */ });\nconst Layouts = {\n\tFULL: 'full',\n\tHORIZONTAL: 'horizontal',\n\tVERTICAL: 'vertical'\n};\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/layout/Layouts.js?")},"./js/layout/RadareInfiniteBlock.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "RadareInfiniteBlock": () => (/* binding */ RadareInfiniteBlock),\n/* harmony export */   "defaultHeightProvisioning": () => (/* binding */ defaultHeightProvisioning)\n/* harmony export */ });\n/* harmony import */ var _core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/NavigatorDirection */ "./js/core/NavigatorDirection.js");\n/* harmony import */ var _helpers_InfiniteScrolling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/InfiniteScrolling */ "./js/helpers/InfiniteScrolling.js");\n\n\n\n/**  How many screen we want to retrieve in one round-trip with r2 */\nconst defaultHeightProvisioning = 3;\n\nclass RadareInfiniteBlock {\n\n\tconstructor(heightProvisioning = defaultHeightProvisioning) {\n\t\tthis.heightProvisioning = heightProvisioning\n\t}\n\n\t/**\n\t * Helper to delay drawing\n\t */\n\tgetCurChunk() {\n\t\treturn this.curChunk;\n\t}\n\n\t/**\n\t * Helper for dynamic callback at first drawing\n\t * Allows to place the scroll on current chunk.\n\t */\n\tgetFirstElement() {\n\t\treturn this.firstElement;\n\t}\n\n\t/**\n\t * Load the *new* initial offset from the "s" value\n\t */\n\trefreshInitialOffset() {\n\t\tr2.cmd(\'s\', (offset) => {\n\t\t\tthis.initialOffset = parseInt(offset, 16);\n\t\t});\n\t}\n\n\t/**\n\t * Gather data and set event to configure infinite scrolling\n\t */\n\tdefineInfiniteParams(trigger) {\n\t\tvar height = (this.container.getBody().offsetHeight === 0) ? 800 : this.container.getBody().offsetHeight;\n\t\tthis.howManyLines = Math.floor(height / this.lineHeight * this.heightProvisioning);\n\n\t\tvar infiniteScrolling = new _helpers_InfiniteScrolling__WEBPACK_IMPORTED_MODULE_1__.InfiniteScrolling(\n\t\t\tthis.container.getBody(),\n\t\t\t3, /* before, current, after */\n\t\t\t(typeof trigger !== \'undefined\') ? trigger : 0.20 /* when there less than 1/5 visible */\n\t\t);\n\n\t\tinfiniteScrolling.setTopEvent((pos, endCallback) => {\n\t\t\tthis.nav.go(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_0__.NavigatorDirection.BEFORE);\n\t\t\tthis.infiniteDrawingContent(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_0__.NavigatorDirection.BEFORE, pos, endCallback);\n\t\t});\n\n\t\tinfiniteScrolling.setBottomEvent((pos, endCallback) => {\n\t\t\tthis.nav.go(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_0__.NavigatorDirection.AFTER);\n\t\t\tthis.infiniteDrawingContent(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_0__.NavigatorDirection.AFTER, pos, endCallback);\n\t\t});\n\t}\n\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/layout/RadareInfiniteBlock.js?')},"./js/layout/Ruler.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Ruler\": () => (/* binding */ Ruler)\n/* harmony export */ });\n/** Ruler component for splitted layout */\nclass Ruler {\n\n\tget position() { return this._position; }\n\tset position(value) {\n\t\tthis._position = value;\n\t\tthis.triggerListeners();\n\t}\n\n\tconstructor(containerNode, rulerNode) {\n\t\tthis.containerNode = containerNode;\n\t\tthis.rulerNode = rulerNode;\n\n\t\tthis.listeners = [];\n\t\tthis.moving = false;\n\t\tthis.position = 0.5;\n\n\t\tthis.init();\n\t\tthis.reset();\n\n\t\tthis.addListeners((position) => this.move(position));\n\t}\n\n\t/** Add events listeners on the node */\n\tinit() {\n\t\tconst doDrag = (e) => {\n\t\t\te.preventDefault();\n\t\t\tconst containerBoundingBox = this.containerNode.getBoundingClientRect();\n\t\t\tthis.position = (e.clientX - containerBoundingBox.left) / containerBoundingBox.width;\n\t\t};\n\n\t\tconst stopDrag = () => {\n\t\t\tdocument.documentElement.removeEventListener('mousemove', doDrag, false);\n\t\t\tdocument.documentElement.removeEventListener('mouseup', stopDrag, false);\n\t\t};\n\n\t\tthis.rulerNode.addEventListener('mousedown', (e) => {\n\t\t\tdocument.documentElement.addEventListener('mousemove', doDrag, false);\n\t\t\tdocument.documentElement.addEventListener('mouseup', stopDrag, false);\n\t\t});\n\t}\n\n\t/** Invoke listener with new position */\n\ttriggerListeners() {\n\t\tthis.listeners.forEach(l => l(this.position));\n\t}\n\n\taddListeners(fn) {\n\t\tthis.listeners.push(fn);\n\t}\n\n\t/** Move the ruler between [0;1] */\n\tmove(position) {\n\t\tthis.rulerNode.style.marginLeft = (position) * 100 + '%';\n\t}\n\n\t/** Place the ruler in the middle (doesn't change display mode) */\n\treset() {\n\t\tthis.position = 0.5;\n\t\tthis.move(0.5);\n\t}\n\n\tshow() {\n\t\tthis.rulerNode.style.display = 'block';\n\t}\n\n\thide() {\n\t\tthis.rulerNode.style.display = 'none';\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/layout/Ruler.js?")},"./js/modules/disasm/Disassembly.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Disassembly\": () => (/* binding */ Disassembly)\n/* harmony export */ });\n/* harmony import */ var _DisassemblyNavigator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DisassemblyNavigator */ \"./js/modules/disasm/DisassemblyNavigator.js\");\n/* harmony import */ var _layout_RadareInfiniteBlock__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../layout/RadareInfiniteBlock */ \"./js/layout/RadareInfiniteBlock.js\");\n/* harmony import */ var _layout_FlexContainer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../layout/FlexContainer */ \"./js/layout/FlexContainer.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../widgets/Widgets */ \"./js/widgets/Widgets.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../helpers/Format */ \"./js/helpers/Format.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n\n\n\n\n\n\nclass Disassembly extends _layout_RadareInfiniteBlock__WEBPACK_IMPORTED_MODULE_1__.RadareInfiniteBlock {\n\n\tconstructor(containerElement, lineHeight) {\n\t\tsuper();\n\t\tthis.container = new _layout_FlexContainer__WEBPACK_IMPORTED_MODULE_2__.FlexContainer(containerElement, 'disasm');\n\t\tthis.lineHeight = lineHeight;\n\t\tthis.init();\n\t}\n\n\tinit() {\n\t\tvar _this = this;\n\t\tthis.refreshInitialOffset();\n\n\t\tthis.drawContextualMenu();\n\t\tthis.drawAnalysisDialog();\n\t\t// 5% (default is 20%) : dynamic sized content, re-drawn\n\t\tthis.defineInfiniteParams(0.05);\n\n\t\tthis.container.pause('Crunching some data...');\n\t\tthis.nav.crunchingData(function() {\n\t\t\t_this.container.resume();\n\t\t});\n\n\t\tthis.indexOffsetHistory = 0;\n\t\tthis.offsetHistory = [];\n\t\tthis.onSeek();\n\t}\n\n\t/** Trigger when widget is displayed and seek is called */\n\tonSeek() {\n\t\tconst currentOffset = (typeof this.initialOffset === 'number') ? int2fixedHex(this.initialOffset, 8) : this.initialOffset;\n\n\t\tif (currentOffset === this.offsetHistory[this.offsetHistory.length - 1]) {\n\t\t\tthis.indexOffsetHistory = this.offsetHistory.length - 1;\n\t\t\tthis.drawControls(this.container.getControls());\n\t\t\treturn;\n\t\t}\n\n\t\tconst indexOffset = this.offsetHistory.indexOf(currentOffset);\n\t\tif (~indexOffset) { // offset is already in the history\n\t\t\tthis.indexOffsetHistory = indexOffset;\n\t\t\tthis.drawControls(this.container.getControls());\n\t\t\treturn;\n\t\t} \n\t\t\n\t\t// Previous offset is set before last element of history\n\t\t// FIRST CALL\n\t\tconst previousOffset = this.offsetHistory[this.offsetHistory.length - 1];\n\t\tif (this.indexOffsetHistory < this.offsetHistory.length - 1) {\n\t\t\t// We keep only first part\n\t\t\tthis.offsetHistory = this.offsetHistory.slice(0, this.indexOffsetHistory + 1);\n\t\t}\n\n\t\tthis.offsetHistory.push(currentOffset);\n\t\tthis.indexOffsetHistory = this.offsetHistory.length - 1;\n\t\tthis.drawControls(this.container.getControls());\n\t}\n\n\tresetContainer(container) {\n\t\t// TODO: cache, faster\n\t\tthis.container.replug(container);\n\t\tthis.container.reset();\n\t\tthis.refreshInitialOffset();\n\t\tthis.defineInfiniteParams(0.05);\n\t}\n\n\t/**\n\t * Gather data and set event to configure infinite scrolling\n\t */\n\tdefineInfiniteParams(trigger) {\n\t\tsuper.defineInfiniteParams(trigger);\n\t\tthis.nav = new _DisassemblyNavigator__WEBPACK_IMPORTED_MODULE_0__.DisassemblyNavigator(this.howManyLines, this.initialOffset);\n\t}\n\n\tdraw(callback) {\n\t\tvar _this = this;\n\t\tthis.drawControls(this.container.getControls());\n\t\tthis.container.drawBody(function(element) {\n\t\t\t_this.drawContent(element, function() {\n\t\t\t\t_this.replaceScrollPosition(_this.nav.currentOffset);\n\t\t\t\tif (typeof callback !== 'undefined') {\n\t\t\t\t\tcallback();\n\t\t\t\t}\n\t\t\t});\n\t\t});\n\t}\n\n\n\t/**\n\t * Will trigger analysis from checked analysis method\n\t * of the analysis dialog (<=> analysisMethod by offset)\n\t */\n\tprocessChosenAnalysis(endCallback) {\n\t\tfor (var i = 0 ; i < this.analysisMethods.length ; i++) {\n\t\t\tthis.analysisMethods[i].action(this.analysisMethods[i].active);\n\t\t}\n\n\t\t/* TODO, adapt to overview panel context\n\t\t\tupdateFortune();\n\t\t\tupdateInfo();\n\t\t\tupdateEntropy();\n\t\t*/\n\n\t\t// Reprocessing\n\t\tvar _this = this;\n\t\tthis.nav.crunchingData(function() {\n\t\t\t// After, we refresh the current display\n\t\t\t_this.draw(endCallback);\n\t\t});\n\t}\n\n\tdrawAnalysisDialog() {\n\t\tthis.analysisMethods = [{\n\t\t\tname: 'Analyse current offset',\n\t\t\tugly: 'curoffset',\n\t\t\tactive: true,\n\t\t\taction: function(active) {\n\t\t\t\tif (!active) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tr2.cmd('af');\n\t\t\t}\n\t\t},{\n\t\t\tname: 'Analyze symbols',\n\t\t\tugly: 'symbols',\n\t\t\tactive: false,\n\t\t\taction: function(active) {\n\t\t\t\tif (!active) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tr2.cmd('aa');\n\t\t\t}\n\t\t},{\n\t\t\tname: 'Analyse calls',\n\t\t\tugly: 'calls',\n\t\t\tactive: false,\n\t\t\taction: function(active) {\n\t\t\t\tif (active) {\n\t\t\t\t\tr2.cmd('e anal.calls=true;aac');\n\t\t\t\t} else {\n\t\t\t\t\tr2.cmd('e anal.calls=false');\n\t\t\t\t}\n\t\t\t}\n\t\t},{\n\t\t\tname: 'Analyse reference',\n\t\t\tugly: 'ref',\n\t\t\tactive: false,\n\t\t\taction: function(active) {\n\t\t\t\tif (!active) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tr2.cmd('aar');\n\t\t\t}\n\t\t},{\n\t\t\tname: 'Emulate code',\n\t\t\tugly: 'code',\n\t\t\tactive: false,\n\t\t\taction: function(active) {\n\t\t\t\tif (active) {\n\t\t\t\t\tr2.cmd('e asm.emu=1;aae');\n\t\t\t\t} else {\n\t\t\t\t\tr2.cmd('e asm.emu=false');\n\t\t\t\t}\n\t\t\t}\n\t\t},{\n\t\t\tname: 'Find preludes',\n\t\t\tugly: 'preludes',\n\t\t\tactive: false,\n\t\t\taction: function(active) {\n\t\t\t\tr2.cmd('aap');\n\t\t\t}\n\t\t},{\n\t\t\tname: 'Autoname functions',\n\t\t\tugly: 'fcts',\n\t\t\tactive: false,\n\t\t\taction: function(active) {\n\t\t\t\tif (!active) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tr2.cmd('aan');\n\t\t\t}\n\t\t}];\n\n\t\tvar _this = this;\n\t\tthis.analysisDialog = document.createElement('dialog');\n\t\tthis.analysisDialog.className = 'mdl-dialog';\n\n\t\tif (!this.analysisDialog.showModal) {\n\t\t\tdialogPolyfill.registerDialog(this.analysisDialog);\n\t\t}\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.className = 'mdl-dialog__content';\n\t\tthis.analysisDialog.appendChild(content);\n\n\t\tvar title = document.createElement('h6');\n\t\ttitle.appendChild(document.createTextNode('Analysis...'));\n\t\ttitle.className = 'mdl-dialog__title';\n\t\tcontent.appendChild(title);\n\n\t\tvar methods = document.createElement('ul');\n\t\tmethods.className = 'mdl-card__supporting-text';\n\t\tthis.analysisDialog.appendChild(methods);\n\n\t\tfor (var i = 0 ; i < this.analysisMethods.length ; i++) {\n\t\t\tvar li = document.createElement('li');\n\t\t\tmethods.appendChild(li);\n\n\t\t\tvar wrappingLabel = document.createElement('label');\n\t\t\twrappingLabel.for = this.analysisMethods[i].ugly;\n\t\t\twrappingLabel.className = 'mdl-checkbox mdl-js-checkbox mdl-js-ripple-effect';\n\t\t\tli.appendChild(wrappingLabel);\n\n\t\t\tvar input = document.createElement('input');\n\t\t\tinput.type = 'checkbox';\n\t\t\tinput.offset = i;\n\t\t\tinput.id = this.analysisMethods[i].ugly;\n\t\t\tinput.checked = this.analysisMethods[i].active;\n\t\t\tinput.className = 'mdl-checkbox__input';\n\t\t\twrappingLabel.appendChild(input);\n\n\t\t\tinput.addEventListener('change', function(evt) {\n\t\t\t\t_this.analysisMethods[evt.target.offset].active = evt.target.checked;\n\t\t\t});\n\n\t\t\tvar name = document.createElement('span');\n\t\t\tname.className = 'mdl-checkbox__label';\n\t\t\tname.appendChild(document.createTextNode(this.analysisMethods[i].name));\n\t\t\twrappingLabel.appendChild(name);\n\t\t}\n\n\t\tvar actions = document.createElement('div');\n\t\tactions.className = 'mdl-dialog__actions';\n\t\tthis.analysisDialog.appendChild(actions);\n\n\t\tvar proceedButton = document.createElement('button');\n\t\tproceedButton.className = 'mdl-button';\n\t\tproceedButton.innerHTML = 'Proceed';\n\t\tproceedButton.addEventListener('click', function() {\n\t\t\t_this.processChosenAnalysis(function() {\n\t\t\t\t_this.analysisDialog.close();\n\t\t\t});\n\t\t});\n\t\tactions.appendChild(proceedButton);\n\n\t\tvar closeButton = document.createElement('button');\n\t\tcloseButton.className = 'mdl-button';\n\t\tcloseButton.innerHTML = 'Close';\n\t\tcloseButton.addEventListener('click', function() {\n\t\t\t_this.analysisDialog.close();\n\t\t});\n\t\tactions.appendChild(closeButton);\n\n\t\tdocument.body.appendChild(this.analysisDialog);\n\t\tcomponentHandler.upgradeDom();\n\t}\n\n\textractOffset_(str) {\n\t\treturn parseInt(str.slice(5));\n\t}\n\n\tgetCurrentOffset() {\n\t\treturn this.currentOffset;\n\t}\n\n\toncontextmenu(evt, offset) {\n\t\tthis.refreshContextMenu(offset);\n\t\tvar menu = document.getElementById('contextmenuDisasm');\n\t\tevt.preventDefault();\n\n\t\tif (this.contextMenuOpen) {\n\t\t\tmenu.classList.remove('active');\n\t\t} else {\n\t\t\tthis.currentOffset = offset;\n\t\t\tmenu.classList.add('active');\n\t\t\tmenu.style.left = evt.clientX + 'px';\n\t\t\tmenu.style.top = evt.clientY + 'px';\n\t\t}\n\n\t\tthis.contextMenuOpen = !this.contextMenuOpen;\n\t}\n\n\tonfctmenu(evt, fct) {\n\t\tevt.preventDefault();\n\n\t\tvar offset;\n\t\tr2.cmd('?v ' + fct, function(hex) {\n\t\t\toffset = hex;\n\t\t});\n\n\t\tvar newName = prompt('Rename?', fct);\n\t\tif (newName === null || newName === '') {\n\t\t\treturn;\n\t\t}\n\n\t\tr2.cmd('fr ' + newName + '@ ' + offset);\n\t}\n\n\tonvarmenu(evt, varName) {\n\t\tevt.preventDefault();\n\n\t\tvar newName = prompt('Rename?', varName);\n\t\tif (newName === null || newName === '') {\n\t\t\treturn;\n\t\t}\n\n\t\tr2.cmd('afvn ' + varName + ' ' + newName);\n\t}\n\n\trefreshContextMenu(offset) {\n\t\t// check with aoj first, if 'val' field exists: open\n\t\tvar isUndefined;\n\t\tr2.cmdj('aoj @' + offset, function(info) {\n\t\t\tisUndefined = typeof info[0].val === 'undefined';\n\t\t});\n\n\t\tthis.drawContextualMenu(!isUndefined);\n\t}\n\n\tgetPresentBlock() {\n\t\tvar blocks = [];\n\t\tvar bodyChildren = this.container.getBody();\n\t\tfor (var i = 0 ; i < bodyChildren.length ; i++) {\n\t\t\tblocks.push(this.extractOffset_(bodyChildren[i].className));\n\t\t}\n\t\treturn blocks;\n\t}\n\n\tdrawContent(dom, callback) {\n\t\tvar _this = this;\n\n\t\tvar list = this.nav.getShownOffset();\n\t\tvar isTopMax = (list[0] === 0);\n\n\t\t// If we are already at top\n\t\tif (this.isTopMax && isTopMax) {\n\t\t\treturn;\n\t\t} else {\n\t\t\tthis.isTopMax = isTopMax;\n\t\t}\n\n\t\t// reset container\n\t\tthis.container.getBody().innerHTML = '';\n\n\t\tfor (var i = 0 ; i < list.length ; i++) {\n\t\t\tvar domAnchor = document.createElement('span');\n\t\t\tthis.container.getBody().appendChild(domAnchor);\n\t\t\tthis.nav.get(list[i].offset, list[i].size, function(anchor, last) {\n\t\t\t\treturn function(chunk) {\n\t\t\t\t\t_this.drawChunk(chunk, anchor);\n\n\t\t\t\t\tif (last && typeof callback !== 'undefined') {\n\t\t\t\t\t\tcallback();\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}(domAnchor, (i === list.length - 1)));\n\t\t}\n\t}\n\n\t/**\n\t * Draw a chunk before or after the current content\n\t */\n\tdrawChunk(chunk, domAnchor) {\n\t\tdomAnchor.innerHTML = chunk.data;\n\t\t// TODO Dirty workaround, see with worker usage\n\t\tconst seekableElements = domAnchor.getElementsByClassName('r2seek');\n\t\tfor (const el of seekableElements) {\n\t\t\t(0,_helpers_Format__WEBPACK_IMPORTED_MODULE_6__.applySeek)(el);\n\t\t}\n\t\tvar pre = domAnchor.children[0];\n\t\tvar spans = pre.children;\n\t\tvar _this = this;\n\t\tfor (var i = 0 ; i < spans.length; i++) {\n\t\t\tif (spans[i].tagName === 'SPAN') {\n\t\t\t\tif (spans[i].className.indexOf('offset') !== -1) {\n\t\t\t\t\tspans[i].addEventListener('contextmenu', function(id) {\n\t\t\t\t\t\treturn function(evt) {\n\t\t\t\t\t\t\treturn _this.oncontextmenu(evt, id);\n\t\t\t\t\t\t};\n\t\t\t\t\t}(spans[i].id));\n\t\t\t\t} else if (spans[i].className.indexOf('fcn') !== -1) {\n\t\t\t\t\tspans[i].addEventListener('contextmenu', function(id) {\n\t\t\t\t\t\treturn function(evt) {\n\t\t\t\t\t\t\treturn _this.onfctmenu(evt, id);\n\t\t\t\t\t\t};\n\t\t\t\t\t}(spans[i].id));\n\t\t\t\t} else if (spans[i].className.indexOf('var') !== -1) {\n\t\t\t\t\tspans[i].addEventListener('contextmenu', function(id) {\n\t\t\t\t\t\treturn function(evt) {\n\t\t\t\t\t\t\treturn _this.onvarmenu(evt, id);\n\t\t\t\t\t\t};\n\t\t\t\t\t}(spans[i].id));\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Highligh current offset (seek)\n\t\tvar curElem = document.getElementById(this.nav.getSeekOffset());\n\t\tif (curElem !== null) {\n\t\t\tcurElem.classList.add('currentOffset');\n\t\t}\n\n\t\treturn document.getElementById(domAnchor);\n\t}\n\n\tinfiniteDrawingContent(where, pos, endCallback) {\n\t\tvar _this = this;\n\t\tvar firstVisibleOffset = this.firstVisibleOffset();\n\t\tthis.drawContent(this.container.getBody(), function() {\n\t\t\t_this.replaceScrollPosition(firstVisibleOffset);\n\t\t\tendCallback();\n\t\t}); // TODO Add stop scroll\n\t}\n\n\tdrawControls(dom) {\n\t\tdom.innerHTML = '';\n\n\t\tconst more = _helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.iconButton('list', 'Others representations');\n\t\tmore.id = 'disasm_more';\n\n\t\tconst moreMenu = document.createElement('ul');\n\t\tmoreMenu.className = 'mdl-menu mdl-menu--bottom-left mdl-js-menu mdl-js-ripple-effect';\n\t\tmoreMenu.setAttribute('for', 'disasm_more');\n\n\t\tconst subPanels = {\n\t\t\t'Toggle Bytes': () => { r2.cmd('e!asm.bytes', () => { _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_7__.r2Wrapper.seek('$$') })},\n\t\t\t'Graph': () => _core_UIContext__WEBPACK_IMPORTED_MODULE_3__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__.Widgets.DISASSEMBLY_GRAPH),\n\t\t\t'Infos': () => _core_UIContext__WEBPACK_IMPORTED_MODULE_3__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__.Widgets.DISASSEMBLY_INFOS),\n\t\t\t'Functions': () => _core_UIContext__WEBPACK_IMPORTED_MODULE_3__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__.Widgets.DISASSEMBLY_FUNCTIONS),\n\t\t\t'Functions (full)': () => _core_UIContext__WEBPACK_IMPORTED_MODULE_3__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__.Widgets.DISASSEMBLY_FUNCTIONS_FULL),\n\t\t\t'Blocks': () => _core_UIContext__WEBPACK_IMPORTED_MODULE_3__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__.Widgets.DISASSEMBLY_BLOCKS),\n\t\t\t'Decompile': () => _core_UIContext__WEBPACK_IMPORTED_MODULE_3__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__.Widgets.DISASSEMBLY_DECOMPILE),\n\t\t}\n\n\t\tfor (let subpanel in subPanels) {\n\t\t\tconst item = document.createElement('li');\n\t\t\titem.className = 'mdl-menu__item';\n\t\t\titem.textContent = subpanel;\n\t\t\titem.addEventListener('click', subPanels[subpanel])\n\t\t\tmoreMenu.appendChild(item);\n\t\t}\n\n\t\tconst container = document.createElement('div');\n\t\tcontainer.className = 'button-controls-disasm';\n\n\t\tcontainer.appendChild(more);\n\t\tcontainer.appendChild(moreMenu);\n\t\tcontainer.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.iconButton('mode_edit', 'Write', () => write()));\n\t\tcontainer.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.iconButton('find_replace', 'Open Analyze window', () => this.openAnalysisDialog()));\n\t\tdom.appendChild(container);\n\n\t\tcomponentHandler.upgradeDom(); // TODO should be called when controls are binded to DOM\n\n\t\tthis.history = document.createElement('ul');\n\t\tthis.history.id = 'disasm-history';\n\t\tdom.appendChild(this.history);\n\n\t\tthis.drawHistory(this.history);\n\t}\n\n\tdrawHistory(dom) {\n\t\tvar canGoBefore = (this.indexOffsetHistory > 0);\n\t\tvar canGoAfter = (this.indexOffsetHistory < this.offsetHistory.length - 1);\n\n\t\tvar _this = this;\n\t\tdom.innerHTML = '';\n\t\tfor (var i = 0 ; i < this.offsetHistory.length ; i++) {\n\t\t\tvar isCurrent = (i === this.indexOffsetHistory);\n\n\t\t\tvar li = document.createElement('li');\n\t\t\tli.className = (isCurrent) ? 'active' : '';\n\t\t\tli.i = i;\n\t\t\tli.x = this.offsetHistory[i];\n\t\t\tli.appendChild(document.createTextNode(this.offsetHistory[i]));\n\t\t\tli.addEventListener('click', (evt) => {\n\t\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_7__.r2Wrapper.seek(evt.target.x);\n\t\t\t});\n\n\t\t\tdom.appendChild(li);\n\t\t}\n\n\t\tvar li = document.createElement('li');\n\t\tli.title = 'Seek';\n\t\tli.appendChild(document.createTextNode('?'));\n\t\tli.addEventListener('click', function() {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_7__.r2Wrapper.seek();\n\t\t});\n\t\tdom.appendChild(li);\n\t}\n\n\topenAnalysisDialog() {\n\t\tthis.analysisDialog.showModal();\n\t}\n\n\t/**\n\t * We want to know the first offset currently visible at the moment\n\t * when the user ask for more data by scrolling\n\t */\n\tfirstVisibleOffset() {\n\t\t// Part of the container already scrolled\n\t\tvar hiddenContainerPart = this.container.getBody().scrollTop;\n\t\tif (hiddenContainerPart === 0) {\n\t\t\treturn;\n\t\t}\n\n\t\t// We want to isolate the chunk that it's visible on the first line visible\n\t\tvar curSum = 0;\n\t\tvar elements = this.container.getBody().children;\n\t\tvar selectedChunk = elements[0];\n\t\tfor (var i = 1 ; i < elements.length ; i++) {\n\t\t\tvar height = elements[i].getBoundingClientRect().height;\n\t\t\tcurSum += height;\n\t\t\t// When the current container start in the visible zone\n\t\t\t// we know it's occurs in the previous, we abort here\n\t\t\tif (curSum > hiddenContainerPart) {\n\t\t\t\t// We restore the previous value, we need it\n\t\t\t\tcurSum -= height;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tselectedChunk = elements[i];\n\t\t}\n\n\t\t// Then, we want to guess approximately which offset was that line\n\t\tvar visibleSpace = curSum - hiddenContainerPart;\n\t\tvar hiddenSpace = selectedChunk.getBoundingClientRect().height - visibleSpace;\n\n\t\tvar offsetRelatedToThatChunk = this.extractOffset_(selectedChunk.children[0].id);\n\n\t\tvar guessedOffset = offsetRelatedToThatChunk + Math.ceil(hiddenSpace / this.lineHeight);\n\n\t\treturn guessedOffset;\n\t}\n\n\t/**\n\t * We know the last approx. visible offset from firstVisibleOffset\n\t * we want to adjust the current view to set this same offset on\n\t * a near position.\n\t */\n\treplaceScrollPosition(offset) {\n\t\t//console.log(offset.toString(16));\n\t\tif (typeof offset === 'undefined') {\n\t\t\treturn;\n\t\t}\n\n\t\t// We select the chunk where the offset belongs\n\t\tvar position = this.nav.getChunkPositionFor(offset);\n\t\tif (position === -1) {\n\t\t\tconsole.log('Chunk position from offset not found');\n\t\t\treturn;\n\t\t}\n\n\t\tvar chunk = this.container.getBody().children[position];\n\n\t\tvar firstEligibleElement = 0;\n\t\twhile (typeof chunk.children[firstEligibleElement].id === 'undefined') {\n\t\t\tfirstEligibleElement++;\n\t\t}\n\t\tvar blockOffset = this.extractOffset_(chunk.children[firstEligibleElement].id);\n\t\tvar startFromTop = chunk.offsetTop;\n\t\tvar chunkHeight = chunk.getBoundingClientRect().height;\n\n\t\tvar progression = (offset - blockOffset) / this.nav.getSize(blockOffset);\n\t\tvar adjustment = Math.floor(progression * chunkHeight);\n\t\tvar requiredScroll = startFromTop + adjustment;\n\n\t\tthis.container.getBody().scrollTop = requiredScroll;\n\t}\n\n\tdrawContextualMenu(enableAoj) {\n\t\tvar _this = this;\n\n\t\tvar displayRes = function(offset, cmd) {\n\t\t\tvar output;\n\t\t\tvar fullCmd = cmd + ' @' + offset;\n\t\t\tr2.cmdj(fullCmd, function(d) {\n\t\t\t\toutput = d;\n\t\t\t});\n\n\t\t\tif (output === null || output.constructor !== Array) {\n\t\t\t\talert('No available ouput!');\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t_this.addLongListDialog(output);\n\t\t};\n\n\t\tvar applyOp = function(offset, cmd, prompting) {\n\t\t\tvar arg = '';\n\t\t\tif (typeof prompting !== 'undefined') {\n\t\t\t\targ = prompt(prompting + '?');\n\t\t\t\tif (arg === '') {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (arg !== '') {\n\t\t\t\tcmd += ' ' + arg;\n\t\t\t}\n\n\t\t\tr2.cmd(cmd + ' @' + offset);\n\t\t\t_this.nav.cleanOldData();\n\t\t\t_this.draw();\n\t\t};\n\n\t\t/**\n\t\t * Take a r2 cmd in parameter, will format output into a dialog to validate stuff\n\t\t */\n\t\tvar presentResults = function(offset, cmd, drawingFct, validationCallback) {\n\t\t\tvar output;\n\t\t\tr2.cmd(cmd + ' @' + offset, function(d) {\n\t\t\t\toutput = d;\n\t\t\t});\n\t\t\tdrawingFct(this.resultDialog, output, validationCallback);\n\t\t};\n\n\t\tvar items = [// can add: 'expand' property for expandable menu\n\t\t\t// { name: 'define flag size', shortcut: '$', fct: function(evt, offset) { return applyOp(offset, '$'); } },\n\t\t\t// { name: 'edit bits', shortcut: '1', fct: function(evt, offset) { return applyOp(offset, '1'); } },\n\t\t\t// { name: 'set as byte', shortcut: 'b', fct: function(evt, offset) { return applyOp(offset, 'b'); } },\n\t\t\t// { name: 'set as short word (2 bytes)', shortcut: 'B', fct: function(evt, offset) { return applyOp(offset, 'B'); } },\n\t\t\t// { name: 'set as code', shortcut: 'c', fct: function(evt, offset) { return applyOp(offset, 'c'); } },\n\t\t\t// { name: 'define flag color (fc)', shortcut: 'C', fct: function(evt, offset) { return applyOp(offset, 'C'); } },\n\t\t\t// { name: 'set as data', shortcut: 'd', fct: function(evt, offset) { return applyOp(offset, 'd'); } },\n\t\t\t// { name: 'end of function', shortcut: 'e', fct: function(evt, offset) { return applyOp(offset, 'e'); } },\n\t\t\t{ aoj: false, name: 'view graph', shortcut: 'G', fct: function loadgraph() { return _core_UIContext__WEBPACK_IMPORTED_MODULE_3__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__.Widgets.DISASSEMBLY_GRAPH);}},\n\t\t\t{ aoj: false, name: 'analyze function', shortcut: 'F', fct: function(evt, offset) { return applyOp(offset, 'af'); } },\n\t\t\t// { name: 'format', shortcut: 'F', fct: function(evt, offset) { return applyOp(offset, 'F'); } },\n\t\t\t{ aoj: true, name: 'immediate base...', shortcut: 'i', expand: [\n\t\t\t\t{\n\t\t\t\t\tname: 'binary',\n\t\t\t\t\tfct: function(evt, offset) { return applyOp(offset, 'ahi b'); }\n\t\t\t\t},{\n\t\t\t\t\tname: 'octal',\n\t\t\t\t\tfct: function(evt, offset) { return applyOp(offset, 'ahi o'); }\n\t\t\t\t},{\n\t\t\t\t\tname: 'decimal',\n\t\t\t\t\tfct: function(evt, offset) { return applyOp(offset, 'ahi d'); }\n\t\t\t\t},{\n\t\t\t\t\tname: 'hexadecimal',\n\t\t\t\t\tfct: function(evt, offset) { return applyOp(offset, 'ahi h'); }\n\t\t\t\t},{\n\t\t\t\t\tname: 'string',\n\t\t\t\t\tfct: function(evt, offset) { return applyOp(offset, 'ahi s'); }\n\t\t\t\t}] },\n\t\t\t// { name: 'merge down (join this and next functions)', shortcut: 'j', fct: function(evt, offset) { return applyOp(offset, 'j'); } },\n\t\t\t// { name: 'merge up (join this and previous function)', shortcut: 'k', fct: function(evt, offset) { return applyOp(offset, 'k'); } },\n\t\t\t// { name: 'highlight word', shortcut: 'h', fct: function(evt, offset) { return applyOp(offset, 'h'); } },\n\t\t\t// { name: 'manpage for current call', shortcut: 'm', fct: function(evt, offset) { return applyOp(offset, 'm'); } },\n\t\t\t{ aoj: false, name: 'add comment', shortcut: ';', fct: function(evt, offset) { return applyOp(offset, 'CC', 'Name'); } },\n\t\t\t{ aoj: false, name: 'set flag', shortcut: 'f', fct: function(evt, offset) { return applyOp(offset, 'f', 'Name'); } },\n\t\t\t{ aoj: true, name: 'rename flag', shortcut: 'n', fct: function(evt, offset) { return applyOp(offset, 'fr', 'Name'); } },\n\t\t\t// { name: 'rename function', shortcut: 'r', fct: function(evt, offset) { return applyOp(offset, 'r'); } },\n\t\t\t// { name: 'find references /r', shortcut: 'R', fct: function(evt, offset) { return applyOp(offset, 'R'); } },\n\t\t\t{ aoj: true, name: 'set string', shortcut: 's', fct: function(evt, offset) { return applyOp(offset, 'Cs'); } },\n\t\t\t// { name: 'set strings in current block', shortcut: 'S', fct: function(evt, offset) { return applyOp(offset, 'S'); } },\n\t\t\t// { name: 'undefine metadata here', shortcut: 'u', fct: function(evt, offset) { return applyOp(offset, 'u'); } },\n\t\t\t{ aoj: false, name: 'find xrefs', shortcut: 'x', fct: function(evt, offset) { return displayRes(offset, 'axtj'); } },\n\t\t\t{ aoj: false, name: 'as data', shortcut: 'D', fct: function(evt, offset) { return applyOp(offset, 'Cd ', 'Size'); } },\n\t\t\t{ aoj: false, name: 'as code', shortcut: 'F', fct: function(evt, offset) { return applyOp(offset, 'C-'); } },\n\t\t\t{ aoj: false, name: 'as string', shortcut: 'S', fct: function(evt, offset) { return applyOp(offset, 'Cs'); } },\n\t\t\t// { name: 'set as 32bit word', shortcut: 'w', fct: function(evt, offset) { return applyOp(offset, 'w'); } },\n\t\t\t// { name: 'set as 64bit word', shortcut: 'W', fct: function(evt, offset) { return applyOp(offset, 'W'); } }\n\t\t];\n\n\t\tvar menu = document.getElementById('contextmenuDisasm');\n\t\tif (menu === null) {\n\t\t\tvar menu = document.createElement('nav');\n\t\t\tmenu.id = 'contextmenuDisasm';\n\t\t\tmenu.classList.add('context-menu');\n\t\t} else {\n\t\t\tmenu.innerHTML = '';\n\t\t}\n\n\t\tvar ul = document.createElement('ul');\n\t\tmenu.appendChild(ul);\n\n\t\tvar _this = this;\n\t\tvar bindAction = function(element, action) {\n\t\t\telement.addEventListener('mousedown', (function(fct) {\n\t\t\t\treturn function(evt) {\n\t\t\t\t\tfct(evt, _this.getCurrentOffset());\n\t\t\t\t};\n\t\t\t}(action)));\n\t\t};\n\n\t\tfor (var i = 0 ; i < items.length ; i++) {\n\t\t\tvar li = document.createElement('li');\n\t\t\tul.appendChild(li);\n\t\t\tli.appendChild(document.createTextNode(items[i].name));\n\t\t\tli.isSubOpen = false;\n\n\t\t\tli.addEventListener('mouseenter', function(evt) {\n\t\t\t\t// Cleaning old \"active\"\n\t\t\t\tvar subactives = Array.prototype.slice.call(evt.target.parentNode.getElementsByClassName('subactive'));\n\t\t\t\tfor (var x = 0 ; x < subactives.length ; x++) {\n\t\t\t\t\tsubactives[x].classList.remove('subactive');\n\t\t\t\t\tsubactives[x].isSubOpen = false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// expandable menu\n\t\t\tif (typeof items[i].expand !== 'undefined' && (enableAoj && items[i].aoj || !items[i].aoj)) {\n\t\t\t\t// Make submenu reachable\n\t\t\t\tli.addEventListener('mouseenter', function(evt) {\n\t\t\t\t\tif (evt.target.isSubOpen) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tevt.target.isSubOpen = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar subMenu = evt.target.children[0];\n\t\t\t\t\tif (typeof subMenu === 'undefined') {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar dim = evt.target.getBoundingClientRect();\n\t\t\t\t\tvar indexOf = Array.prototype.slice.call(evt.target.parentNode.children).indexOf(evt.target);\n\t\t\t\t\tevt.target.classList.add('subactive');\n\t\t\t\t\tsubMenu.style.left = dim.width + 'px';\n\t\t\t\t\tsubMenu.style.top = indexOf * dim.height + 'px';\n\t\t\t\t});\n\n\t\t\t\t// Creating sub menu\n\t\t\t\tvar subUl = document.createElement('ul');\n\t\t\t\tli.appendChild(subUl);\n\t\t\t\tfor (var j = 0 ; j < items[i].expand.length ; j++) {\n\t\t\t\t\tvar subLi = document.createElement('li');\n\t\t\t\t\tsubUl.appendChild(subLi);\n\t\t\t\t\tsubLi.appendChild(document.createTextNode(items[i].expand[j].name));\n\t\t\t\t\tbindAction(subLi, items[i].expand[j].fct);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tif (enableAoj && items[i].aoj || !items[i].aoj) {\n\t\t\t\t\tbindAction(li, items[i].fct);\n\t\t\t\t} else {\n\t\t\t\t\tli.classList.add('disabled');\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tdocument.body.appendChild(menu);\n\t\tcomponentHandler.upgradeDom();\n\n\t\tvar _this = this;\n\t\tthis.contextMenuOpen = false;\n\t\tvar closeMenu = function() {\n\t\t\tif (!_this.contextMenuOpen) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tmenu.classList.remove('active');\n\t\t\t_this.contextMenuOpen = false;\n\t\t};\n\n\t\twindow.onkeyup = function(e) {\n\t\t\tif (e.keyCode === 27) {\n\t\t\t\tcloseMenu();\n\t\t\t}\n\t\t};\n\n\t\tdocument.addEventListener('click', function() {\n\t\t\tcloseMenu();\n\t\t});\n\t}\n\n\t/**\n\t * Show a list of element in a specific dialog\n\t */\n\taddLongListDialog(list) {\n\t\tvar _this = this;\n\t\tvar dialog = document.createElement('dialog');\n\t\tdialog.className = 'mdl-dialog';\n\n\t\tif (!dialog.showModal) {\n\t\t\tdialogPolyfill.registerDialog(dialog);\n\t\t}\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.className = 'mdl-dialog__content';\n\t\tdialog.appendChild(content);\n\n\t\tvar title = document.createElement('p');\n\t\ttitle.appendChild(document.createTextNode('Results'));\n\t\ttitle.className = 'mdl-typography--text-center';\n\t\tcontent.appendChild(title);\n\n\t\tvar container = document.createElement('div');\n\t\tcontainer.className = 'mdl-card__supporting-text';\n\t\tdialog.appendChild(container);\n\n\t\tvar table = document.createElement('table');\n\t\ttable.className = 'disasm-table-dialog';\n\t\ttable.style.width = '100%';\n\t\ttable.style.border = '1px dashed red';\n\t\tcontainer.appendChild(table);\n\n\t\tvar thead = document.createElement('thead');\n\t\ttable.appendChild(thead);\n\n\t\tvar keys = Object.keys(list[0]);\n\t\tfor (var i = 0 ; i < keys.length ; i++) {\n\t\t\tvar th = document.createElement('th');\n\t\t\tth.appendChild(document.createTextNode(keys[i]));\n\t\t\tthead.appendChild(th);\n\t\t}\n\n\t\tvar tbody = document.createElement('tbody');\n\t\ttable.appendChild(tbody);\n\n\t\tfor (var i = 0 ; i < list.length ; i++) {\n\t\t\tvar tr = document.createElement('tr');\n\t\t\ttbody.appendChild(tr);\n\n\t\t\tfor (var j = 0 ; j < keys.length ; j++) {\n\t\t\t\tvar td = document.createElement('td');\n\t\t\t\ttr.appendChild(td);\n\n\t\t\t\tif (keys[j] === 'opcode') {\n\t\t\t\t\ttd.appendChild((0,_helpers_Format__WEBPACK_IMPORTED_MODULE_6__.formatOffset)(list[i][keys[j]]));\n\t\t\t\t} else if (keys[j] === 'from') {\n\t\t\t\t\tconst hex = '0x' + list[i][keys[j]].toString(16);\n\t\t\t\t\ttd.appendChild((0,_helpers_Format__WEBPACK_IMPORTED_MODULE_6__.formatOffset)(hex));\n\t\t\t\t} else {\n\t\t\t\t\ttd.innerHTML = list[i][keys[j]];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tvar actions = document.createElement('div');\n\t\tactions.className = 'mdl-dialog__actions';\n\t\tdialog.appendChild(actions);\n\n\t\tvar closeButton = document.createElement('button');\n\t\tcloseButton.className = 'mdl-button';\n\t\tcloseButton.innerHTML = 'Close';\n\t\tcloseButton.addEventListener('click', function() {\n\t\t\tdialog.close();\n\t\t\tdocument.body.removeChild(dialog);\n\t\t});\n\t\tactions.appendChild(closeButton);\n\n\t\tdocument.body.appendChild(dialog);\n\t\tcomponentHandler.upgradeDom();\n\n\t\tdialog.showModal();\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/disasm/Disassembly.js?")},"./js/modules/disasm/DisassemblyNavigator.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DisassemblyNavigator\": () => (/* binding */ DisassemblyNavigator)\n/* harmony export */ });\n/* harmony import */ var _core_BlockNavigator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/BlockNavigator */ \"./js/core/BlockNavigator.js\");\n/* harmony import */ var _core_ChunkStatus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/ChunkStatus */ \"./js/core/ChunkStatus.js\");\n\n\n\n// Should refactor with HexPairNav and go/get methods\n/**\n * DisasmNavigator\n * Based on non-fixed size of \"chunk\"\n * will use:\n *\tthis.navigationData, as dictionnary [offset => {size, callback, data}]\n *\tthis.navigationOffsets, for all ordered [offset]\n * \tthis.currentlyShown, as currently shown [offset]\n */\n\nfunction line2offset(line) {\n\treturn line * 2;\n}\n\nclass DisassemblyNavigator extends _core_BlockNavigator__WEBPACK_IMPORTED_MODULE_0__.BlockNavigator {\n\n\tconstructor(howManyLines, startOffset) {\n\t\tsuper();\n\n\t\tthis.currentOffset = startOffset;\n\t\tthis.howManyLines = howManyLines;\n\t\tthis.gap = this.howManyLines * 2;\n\n\t\tthis.providerWorker = new Worker('disasmProvider.js');\n\n\t\tthis.optimalLines = this.howManyLines * 3;\n\t\tthis.MINFILL = this.optimalLines * 0.8;\n\n\t\tthis.items = [];\n\n\t\tthis.init();\n\t}\n\n\tinit() {\n\t\tsuper.init()\n\t\tthis.currentlyShown = [];\n\t\tthis.populateFirst();\n\t}\n\n\tconfigureWorker_() {\n\t\tvar _this = this;\n\t\tthis.providerWorker.onmessage = function(e) {\n\t\t\tvar item;\n\t\t\tfor (var i = 0 ; i < _this.items.length ; i++) {\n\t\t\t\tif (_this.items[i].offset === e.data.offset &&\n\t\t\t\t\t_this.items[i].size === e.data.size) {\n\t\t\t\t\titem = _this.items[i];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (typeof item === 'undefined') {\n\t\t\t\tconsole.log('Unable to find origin item');\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\titem.data = e.data.data;\n\t\t\titem.status = _core_ChunkStatus__WEBPACK_IMPORTED_MODULE_1__.ChunkStatus.COMPLETED;\n\t\t\tfor (var i = 0 ; i < item.callback.length ; i++) {\n\t\t\t\titem.callback[i](item);\n\t\t\t}\n\t\t\titem.callback = [];\n\t\t};\n\t}\n\n\tcleanOldData() {\n\t\tfor (var i = 0 ; i < this.items.length ; i++) {\n\t\t\tdelete this.items[i].data;\n\t\t\tdelete this.items[i].status;\n\t\t}\n\t}\n\n\tcrunchingData(onReadyCallback) {\n\t\tvar initWorker = new Worker('disasmNavProvider.js');\n\t\tvar _this = this;\n\n\t\tinitWorker.onmessage = function(e) {\n\t\t\t_this.navigationData = e.data;\n\t\t\t_this.navigationOffsets = Object.keys(e.data);\n\t\t\t_this.navigationOffsets.sort();\n\t\t\tinitWorker.terminate();\n\t\t\tonReadyCallback();\n\t\t};\n\n\t\tinitWorker.postMessage(true);\n\t}\n\n\tgetOverlappingIntervals(start, end) {\n\t\tlet intervals = [];\n\t\tfor (let offset in this.navigationData) {\n\t\t\tconst startInterval = offset;\n\t\t\tconst endInterval = offset + this.navigationData[offset].size;\n\t\t\tif (startInterval <= end && start <= endInterval) {\n\t\t\t\tintervals.push(offset);\n\t\t\t}\n\t\t}\n\t\treturn intervals;\n\t}\n\n\tpopulateFirst() {\n\t\treturn this.populateFrom(this.currentOffset);\n\t}\n\n\t/**\n\t * Create block between [start;end[\n\t */\n\tfillGap(start, end, artifical) {\n\t\tvar curSize = end - start;\n\t\t// FIX, can't cut everywhere: byte alignment (invalid lines)\n\t\treturn [{offset: start, size: curSize, artifical: artifical}];\n\t\tif (curSize > this.howManyLines) {\n\t\t\tvar half = Math.round(end / 2);\n\t\t\treturn [{\n\t\t\t\toffset: start,\n\t\t\t\tsize: Math.round(curSize / 2),\n\t\t\t\tartifical: artifical\n\t\t\t}].concat(this.fillGap(start + Math.round(curSize / 2), end));\n\t\t} else {\n\t\t\treturn [{\n\t\t\t\toffset: start,\n\t\t\t\tsize: curSize,\n\t\t\t\tartifical: artifical\n\t\t\t}];\n\t\t}\n\t}\n\n\tpopulateFrom(offset) {\n\t\t// From currentOffset\n\t\t// I want at least 80% of 3 screens\n\n\t\t// go up of 1 screen, take first in order\n\n\t\tvar fromOffset = offset - line2offset(this.howManyLines);\n\t\tvar endOffset = fromOffset + (3 * line2offset(this.howManyLines));\n\n\t\tvar existingIntervals = this.getOverlappingIntervals(fromOffset, endOffset);\n\n\t\tvar requestedIntervals = []; // {offset, size}\n\n\t\t// If they overlap between them, we merge\n\t\tfor (var i = 0 ; i < existingIntervals.length - 1 ; i++) {\n\t\t\tvar endCurrent = existingIntervals[i];\n\t\t\tvar startNext = existingIntervals[i + 1];\n\t\t\tif (startNext < endCurrent) {\n\t\t\t\tif (endNext <= endCurrent) { // inclusive\n\t\t\t\t\trequestedIntervals.push({\n\t\t\t\t\t\toffset: existingIntervals[i],\n\t\t\t\t\t\tsize: this.navigationData[existingIntervals[i]].size\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tvar endNext = startNext + this.navigationData[startNext].size;\n\t\t\t\t\trequestedIntervals.push({\n\t\t\t\t\t\toffset: existingIntervals[i],\n\t\t\t\t\t\tsize: endNext - existingIntervals[i]\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif (requestedIntervals.length > 0) {\n\t\t\t// If there is gap before\n\t\t\tif (requestedIntervals[0].offset !== fromOffset) {\n\t\t\t\trequestedIntervals = requestedIntervals.concat(this.fillGap(fromOffset, requestedIntervals[0].offset));\n\t\t\t}\n\n\t\t\t// If there is a gap after\n\t\t\tvar lastInterval = requestedIntervals[requestedIntervals.length - 1];\n\t\t\tvar lastOffsetInterval = (lastInterval.offset + lastInterval.size);\n\t\t\tif (lastOffsetInterval !== endOffset) {\n\t\t\t\trequestedIntervals = requestedIntervals.concat(this.fillGap(lastOffsetInterval + 1, endOffset));\n\t\t\t}\n\n\t\t\t// If there is a gap between\n\t\t\tfor (var i = 0 ; i < requestedIntervals.length - 1 ; i++) {\n\t\t\t\tvar endCurrent = existingIntervals[i];\n\t\t\t\tvar startNext = existingIntervals[i + 1];\n\n\t\t\t\tif (startNext - endCurrent > 1) {\n\t\t\t\t\trequestedIntervals = requestedIntervals.concat(this.fillGap(endCurrent + 1, startNext));\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\trequestedIntervals = this.fillGap(fromOffset, endOffset, true);\n\t\t}\n\n\t\tthis.currentlyShown = requestedIntervals;\n\n\t\t/****\n\t\tTODO: check if existing (data field), if not, ask provider\n\t\tdon't care about total length, but need to find approx. the line requested:\n\t\t\twhich interval, starting at? +lineHeight*diff\n\t\t*****/\n\t}\n\n\t/**\n\t * Returns the current chunks to display\n\t * Will be conciliated with offset (key)\n\t */\n\tgetShownOffset() {\n\t\treturn this.currentlyShown;\n\t}\n\n\tgetSize(offset) {\n\t\tfor (var i = 0 ; i < this.currentlyShown.length ; i++) {\n\t\t\tif (this.currentlyShown[i].offset === offset) {\n\t\t\t\treturn this.currentlyShown[i].size;\n\t\t\t}\n\t\t}\n\t\treturn -1;\n\t}\n\n\tgetChunkPositionFor(offset) {\n\t\tfor (var i = 0 ; i < this.currentlyShown.length ; i++) {\n\t\t\tif (offset >= this.currentlyShown[i].offset &&\n\t\t\t\toffset < this.currentlyShown[i].offset + this.currentlyShown[i].size) {\n\t\t\t\treturn i;\n\t\t\t}\n\t\t}\n\n\t\treturn -1;\n\t}\n\n\tget(offset, size, callback) {\n\t\t// TODO: retrieve data (async) and call\n\t\tvar item;\n\t\tfor (var i = 0 ; i < this.items.length ; i++) {\n\t\t\tif (this.items[i].offset === offset &&\n\t\t\t\tthis.items[i].size === size) {\n\t\t\t\titem = this.items[i];\n\t\t\t}\n\t\t}\n\n\t\tif (typeof item === 'undefined') {\n\t\t\titem = {\n\t\t\t\toffset: offset,\n\t\t\t\tsize: size\n\t\t\t};\n\t\t\tthis.items.push(item);\n\t\t}\n\n\t\tif (typeof item.data !== 'undefined') {\n\t\t\treturn callback(item);\n\t\t} else { // Not currently here\n\t\t\tif (typeof item.callback === 'undefined') {\n\t\t\t\titem.callback = [];\n\t\t\t}\n\t\t\t// Store in callback, could be retrieving or we will start it\n\t\t\titem.callback.push(callback);\n\t\t\tif (item.status !== _core_ChunkStatus__WEBPACK_IMPORTED_MODULE_1__.ChunkStatus.LAUNCHED) { // Need to be retrieved\n\t\t\t\titem.status = _core_ChunkStatus__WEBPACK_IMPORTED_MODULE_1__.ChunkStatus.LAUNCHED;\n\t\t\t\tthis.providerWorker.postMessage({\n\t\t\t\t\toffset: item.offset,\n\t\t\t\t\tsize: item.size\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}\n\n\tgo(dir) {\n\t\tthis.currentOffset += dir * (this.howManyLines * 2);\n\t\tthis.populateFrom(this.currentOffset);\n\t}\n\n\trefreshCurrentOffset() {\n\t\tvar _this = this;\n\t\tr2.cmd('s', function(offset) {\n\t\t\t_this.currentOffset = parseInt(offset, 16);\n\t\t});\n\t}\n\n\tgetSeekOffset() {\n\t\treturn this.currentOffset;\n\t}\n\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/disasm/DisassemblyNavigator.js?")},"./js/modules/hexdump/HexPairNavigator.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"HexPairNavigator\": () => (/* binding */ HexPairNavigator)\n/* harmony export */ });\n/* harmony import */ var _core_BlockNavigator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/BlockNavigator */ \"./js/core/BlockNavigator.js\");\n/* harmony import */ var _core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/NavigatorDirection */ \"./js/core/NavigatorDirection.js\");\n\n\n\n/**\n * howManyLines = how many lines per chunk\n * Careful at boundaries [0..end]\n */\nclass HexPairNavigator extends _core_BlockNavigator__WEBPACK_IMPORTED_MODULE_0__.BlockNavigator {\n\n\tconstructor(howManyLines, nbCols, startOffset) {\n\t\tsuper();\n\t\tthis.howManyBytes = howManyLines * 16;\n\t\tthis.gap = this.howManyBytes;\n\t\tthis.currentOffset = startOffset;\n\n\t\t// Define a double-linked list to navigate through chunks\n\t\tthis.curChunk;\n\n\t\tthis.providerWorker = new Worker('hexchunkProvider.js');\n\t\tthis.providerWorker.postMessage({\n\t\t\thowManyBytes: this.howManyBytes,\n\t\t\tnbCols: nbCols\n\t\t});\n\n\t\tthis.init();\n\t}\n\n\t/**\n\t * Force the configuration to be actualized on worker\n\t */\n\tchangeNbCols(nbCols) {\n\t\tthis.providerWorker.postMessage({\n\t\t\thowManyBytes: this.howManyBytes,\n\t\t\tnbCols: nbCols,\n\t\t\treset: true\n\t\t});\n\t\tthis.reset();\n\t}\n\n\t/**\n\t * Telling to r2 that we have a change\n\t * It's a one-byte modification so we don't reload and keep track\n\t */\n\treportChange(offset, value) {\n\t\tthis.smallModifications.push({\n\t\t\toffset: offset,\n\t\t\tvalue: value\n\t\t});\n\n\t\tr2.cmd('wx ' + value + ' @' + offset, function() {});\n\t}\n\n\t/**\n\t * Return if a value has been modified (edit function)\n\t */\n\thasNewValue(offset) {\n\t\tfor (var i = 0 ; i < this.smallModifications.length ; i++) {\n\t\t\tif (this.smallModifications[i].offset === offset) {\n\t\t\t\treturn this.smallModifications[i].value;\n\t\t\t}\n\t\t}\n\n\t\treturn null;\n\t}\n\n\t/**\n\t * Retrieve all modifications from r2\n\t */\n\tupdateModifications() {\n\t\tvar _this = this;\n\t\tthis.smallModifications = [];\n\t\tthis.modifiedBytes = [];\n\t\tr2.cmd('wcj', function(d) {\n\t\t\tvar d = JSON.parse(d);\n\t\t\tfor (var i = 0 ; i < d.length ; i++) {\n\t\t\t\tvar offset = d[i].addr;\n\t\t\t\tfor (var x = 0 ; x < d[i].size ; x++) {\n\t\t\t\t\t_this.modifiedBytes.push(offset + x);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n\n\t/**\n\t * Tell if the byte at the current offset has been modified\n\t */\n\tisModifiedByte(offset) {\n\t\treturn (this.modifiedBytes.indexOf(offset) > -1);\n\t}\n\n\t/**\n\t * Gets all visibles flags\n\t */\n\tgetFlags(minSize, callback) {\n\t\tvar filter = function(flags) {\n\t\t\tvar filteredFlags = [];\n\t\t\tfor (var i = 0 ; i < flags.length ; i++) {\n\t\t\t\tif (flags[i].size >= minSize) {\n\t\t\t\t\tfilteredFlags.push({\n\t\t\t\t\t\tname: flags[i].name,\n\t\t\t\t\t\tstart: flags[i].offset,\n\t\t\t\t\t\tend: flags[i].offset + flags[i].size\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// We want the biggest first\n\t\t\tfilteredFlags.sort(function(a, b) {\n\t\t\t\treturn (a.size > b.size) ? -1 : 1;\n\t\t\t});\n\t\t\treturn filteredFlags;\n\t\t};\n\n\t\tvar flags = [];\n\t\tvar pings = 0;\n\n\t\t// We don't care about order\n\t\tvar actuator = function() {\n\t\t\tpings++;\n\t\t\tif (pings < 3) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tcallback(filter(flags));\n\t\t};\n\n\t\tthis.get(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.CURRENT, function(chunk) {\n\t\t\tflags = flags.concat(chunk.flags);\n\t\t\tactuator();\n\t\t});\n\t\tthis.get(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE, function(chunk) {\n\t\t\tflags = flags.concat(chunk.flags);\n\t\t\tactuator();\n\t\t});\n\t\tthis.get(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.AFTER, function(chunk) {\n\t\t\tflags = flags.concat(chunk.flags);\n\t\t\tactuator();\n\t\t});\n\t}\n\n\tgetBytes(range) {\n\t\tvar bytes;\n\t\tr2.cmdj('p8j ' + (range.to - range.from + 1) + ' @' + range.from, function(list) {\n\t\t\tbytes = list;\n\t\t});\n\t\treturn bytes;\n\t}\n\n\trefreshChunk(which, callback) {\n\t\tvar modifications = [];\n\t\tvar _this = this;\n\t\tthis.get(which, function(chunk) {\n\t\t\tchunk.callback = [];\n\t\t\tmodifications = chunk.modified;\n\n\t\t\t_this.get(which, function(newChunk) {\n\t\t\t\tnewChunk.modified.concat(modifications);\n\t\t\t\tcallback(newChunk);\n\t\t\t}, true);\n\t\t});\n\t}\n\n\trefreshCurrent(callback) {\n\t\tvar pings = 0;\n\t\t// We don't care about order\n\t\tvar actuator = function() {\n\t\t\tpings++;\n\t\t\tif (pings < 3) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tcallback();\n\t\t};\n\n\t\tthis.refreshChunk(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.CURRENT, function() {\n\t\t\tactuator();\n\t\t});\n\t\tthis.refreshChunk(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE, function() {\n\t\t\tactuator();\n\t\t});\n\t\tthis.refreshChunk(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.AFTER, function() {\n\t\t\tactuator();\n\t\t});\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/hexdump/HexPairNavigator.js?")},"./js/modules/hexdump/Hexdump.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Hexdump\": () => (/* binding */ Hexdump)\n/* harmony export */ });\n/* harmony import */ var _HexPairNavigator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./HexPairNavigator */ \"./js/modules/hexdump/HexPairNavigator.js\");\n/* harmony import */ var _core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/NavigatorDirection */ \"./js/core/NavigatorDirection.js\");\n/* harmony import */ var _layout_RadareInfiniteBlock__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../layout/RadareInfiniteBlock */ \"./js/layout/RadareInfiniteBlock.js\");\n/* harmony import */ var _layout_FlexContainer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../layout/FlexContainer */ \"./js/layout/FlexContainer.js\");\n/* harmony import */ var _WordSizes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./WordSizes */ \"./js/modules/hexdump/WordSizes.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../widgets/Widgets */ \"./js/widgets/Widgets.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../helpers/Format */ \"./js/helpers/Format.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * UI management\n * Container should be currently sized for the purpose\n * lineHeight should be specified in pixels\n */\nclass Hexdump extends _layout_RadareInfiniteBlock__WEBPACK_IMPORTED_MODULE_2__.RadareInfiniteBlock {\n\t\n\tconstructor(containerElement, lineHeight, isBigEndian) {\n\t\tsuper();\n\t\tthis.container = new _layout_FlexContainer__WEBPACK_IMPORTED_MODULE_3__.FlexContainer(containerElement, 'hex');\n\t\tthis.lineHeight = lineHeight;\n\t\tthis.bigEndian = isBigEndian;\n\t\tthis.nbColumns = 16;\n\t\tthis.hexLength = _WordSizes__WEBPACK_IMPORTED_MODULE_4__.WordSizes.PAIRS;\n\t\tthis.init();\n\t\tthis.resetContainer(containerElement);\n\n\t\tthis.showFlags = true;\n\t\tthis.beingSelected = false;\n\t\tthis.selectionFirst;\n\t\tthis.selectionEnd;\n\n\t\tthis.lastColorUsed = -1;\n\t\tthis.bgColors = [\n\t\t\t'rgba(255,0,0,0.2)',\n\t\t\t'rgba(0,255,0,0.2)',\n\t\t\t'rgba(0,92,192,0.2)',\n\t\t\t'rgba(255,255,0,0.2)',\n\t\t\t'rgba(255,0,255,0.2)',\n\t\t\t'rgba(0,255,255,0.2)'\n\t\t];\n\n\t\tthis.flagColorAssociation = [];\n\t}\n\n\n\t/**\n\t * Define the behavior expected when a value is edited\n\t */\n\tsetOnChangeCallback(callback) {\n\t\tthis.onChangeCallback = callback;\n\t}\n\n\t/**\n\t * Fetch and initialize data\n\t */\n\tinit() {\n\t\tthis.refreshInitialOffset();\n\n\t\tr2.cmdj('ecj|', (colors) => { this.colors = colors; });\n\t\tr2.cmdj('ij|', (info) => { this.writable = info.core.iorw; });\n\t\tthis.selectionMode = !this.writable;\n\n\t\tfor (var key in this.colors) {\n\t\t\tthis.colors[key] = 'rgb(' + this.colors[key][0] + ',' + this.colors[key][1] + ',' + this.colors[key][2] + ')';;\n\t\t}\n\n\t\twindow.addEventListener('mousedown', (evt) => {\n\t\t\tif (evt.button !== 0 || this.contextMenuOpen) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tthis.cleanSelection();\n\t\t});\n\n\t\tthis.drawContextualMenu();\n\t\tthis.changeWritable();\n\t}\n\n\t/**\n\t * Generic definition of isWritable, if not, we are in select mode\n\t */\n\tisWritable() {\n\t\treturn this.writable && !this.selectionMode;\n\t}\n\n\t/**\n\t * On change on R/W status on document (!= this.isWritable)\n\t */\n\tchangeWritable() {\n\t\tvar items = Array.prototype.slice.call(document.getElementsByClassName('writableMenu'));\n\t\tvar opacity = (this.writable) ? 1.0 : 0.5;\n\n\t\tfor (var i = 0 ; i < items.length ; i++) {\n\t\t\titems[i].style.opacity = opacity;\n\t\t}\n\t}\n\n\t/**\n\t * Called when the frame need to be redrawn\n\t * Reset the container and draw the previous state\n\t * TODO: save DOM/Events when quitting widget to reload it faster\n\t */\n\tresetContainer(container) {\n\t\tthis.refreshInitialOffset();\n\n\t\tif (typeof this.nav !== 'undefined') {\n\t\t\tthis.nav.reset();\n\t\t}\n\n\t\tthis.container.replug(container);\n\n\t\t// TODO: cache, faster\n\t\tthis.container.reset();\n\n\t\tthis.container.drawBody((element) => {\n\t\t\telement.appendChild(document.createElement('div')); // offsets\n\t\t\telement.appendChild(document.createElement('div')); // hexpairs\n\t\t\telement.appendChild(document.createElement('div')); // ascii\n\t\t});\n\t\tthis.content = this.container.getBody();\n\t\tthis.defineInfiniteParams();\n\t}\n\n\tgetCurrentSelection() {\n\t\treturn this.currentSelection;\n\t}\n\n\t/**\n\t * Gather data and set event to configure infinite scrolling\n\t */\n\tdefineInfiniteParams() {\n\t\t_layout_RadareInfiniteBlock__WEBPACK_IMPORTED_MODULE_2__.RadareInfiniteBlock.prototype.defineInfiniteParams.call(this);\n\t\tthis.nav = new _HexPairNavigator__WEBPACK_IMPORTED_MODULE_0__.HexPairNavigator(this.howManyLines, this.nbColumns, this.initialOffset);\n\t\tthis.nav.updateModifications();\n\t}\n\n\t/**\n\t * Sequence to draw the whole UI\n\t */\n\tdraw() {\n\t\tthis.drawControls(this.container.getControls());\n\t\tthis.drawContent(this.container.getBody(), () => {\n\t\t\tthis.colorizeFlag();\n\t\t});\n\t}\n\n\t/**\n\t * Colorize a byte depending on 00/7f/ff and ASCII\n\t */\n\tcolorizeByte(elem, val) {\n\t\tif (val === '00' || val === 'ff' || val === '7f') {\n\t\t\telem.style.color = this.colors['b0x' + val];\n\t\t} else if (isAsciiVisible(parseInt(val, 16))) {\n\t\t\telem.style.color = 'rgb(192,192,192)';\n\t\t} else {\n\t\t\telem.style.color = 'inherit';\n\t\t}\n\t}\n\n\t/**\n\t * Return a color on a cyclic way\n\t */\n\tpickColor() {\n\t\treturn 'inherit'; // no random anoying colors\n\t\tthis.lastColorUsed = (this.lastColorUsed + 1) % this.bgColors.length;\n\t\treturn this.bgColors[this.lastColorUsed];\n\t}\n\n\t/** Assemble two pairs depending of endianness */\n\thonoringEndian(x, y) {\n\t\tif (this.bigEndian) {\n\t\t\treturn x + y\n\t\t} else {\n\t\t\treturn y + x;\n\t\t}\n\t}\n\n\t/**\n\t * Convert a pair to a word considering endian\n\t */\n\tpairs2words(list, wordLength) {\n\t\tif (wordLength === 1) {\n\t\t\treturn list;\n\t\t}\n\n\t\tlet newList = [];\n\t\tfor (let i = 0 ; i < list.length / 2 ; i++) {\n\t\t\tnewList.push(\n\t\t\t\tthis.honoringEndian(\n\t\t\t\t\tlist[i * 2],\n\t\t\t\t\tlist[(i * 2) + 1]\n\t\t\t\t)\n\t\t\t);\n\t\t}\n\n\t\treturn this.pairs2words(newList, wordLength / 2);\n\t}\n\n\t/**\n\t * Delete selection marks from the UI\n\t */\n\tcleanSelection(previsualization) {\n\t\tif (typeof previsualization === 'undefined') {\n\t\t\tprevisualization = false;\n\t\t}\n\n\t\tif (!previsualization) {\n\t\t\tthis.currentSelection = {};\n\t\t}\n\n\t\tvar elems;\n\t\tdo {\n\t\t\telems = this.listContent.getElementsByClassName('selected');\n\t\t\tfor (var i = 0 ; i < elems.length ; i++) {\n\t\t\t\telems[i].classList.remove('selected');\n\t\t\t}\n\t\t} while (elems.length > 0);\n\t}\n\n\t/**\n\t * Draw the selection (emulated)\n\t * Based on sibling\n\t */\n\tprocessSelection(isPrev) {\n\t\tif (isPrev) {\n\t\t\tthis.cleanSelection(true);\n\t\t}\n\n\t\tif (this.selectionFirst === this.selectionEnd) {\n\t\t\tthis.selectionFirst.classList.add('selected');\n\t\t\tthis.currentSelection = {\n\t\t\t\tfrom: this.selectionFirst.offset,\n\t\t\t\tto: this.selectionFirst.offset\n\t\t\t};\n\t\t}\n\n\t\tvar start = (this.selectionFirst.offset < this.selectionEnd.offset) ? this.selectionFirst : this.selectionEnd;\n\t\tvar end = (this.selectionFirst.offset < this.selectionEnd.offset) ? this.selectionEnd : this.selectionFirst;\n\n\t\tthis.currentSelection = {\n\t\t\tfrom: start.offset,\n\t\t\tto: end.offset\n\t\t};\n\n\t\tvar curNode = start;\n\t\tvar endFound = false;\n\t\twhile (!endFound) {\n\t\t\tvar sibling = curNode;\n\t\t\tcurNode.classList.add('selected');\n\n\t\t\twhile (sibling !== null) {\n\t\t\t\tif (sibling.offset === end.offset) {\n\t\t\t\t\tsibling.classList.add('selected');\n\t\t\t\t\tcurNode = sibling;\n\t\t\t\t\tendFound = true;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tdo {\n\t\t\t\t\tcurNode = sibling;\n\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t} while (typeof curNode.offset === 'undefined');\n\t\t\t\tcurNode.classList.add('selected');\n\t\t\t}\n\n\t\t\tvar nextLine = curNode.parentNode.parentNode.nextSibling;\n\t\t\tif (nextLine === null) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\twhile (nextLine.children.length <= 1) {\n\t\t\t\tif (nextLine === null) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tnextLine = nextLine.nextSibling;\n\t\t\t}\n\n\t\t\tcurNode = nextLine.children[1].children[0];\n\t\t}\n\t}\n\n\t//#region main draw\n/**\n\t * Draw 3 chunks on specified DOM node\n\t */\n\tdrawContent(dom, callback) {\n\t\tdom.innerHTML = '';\n\n\t\tthis.listContent = document.createElement('ul');\n\t\tthis.listContent.className = 'listContent';\n\t\tdom.appendChild(this.listContent);\n\n\t\tthis.listContent.addEventListener('contextmenu', (evt) => {\n\t\t\tif (typeof this.currentSelection === 'undefined' ||\n\t\t\t\ttypeof this.currentSelection.from === 'undefined' ||\n\t\t\t\ttypeof this.currentSelection.to === 'undefined') {\n\t\t\t\t// If undefined, we chose to have one-byte selection\n\t\t\t\tthis.currentSelection = {\n\t\t\t\t\tfrom: evt.target.offset,\n\t\t\t\t\tto: evt.target.offset\n\t\t\t\t};\n\t\t\t}\n\t\t\tevt.preventDefault();\n\t\t\tvar menu = document.getElementById('contextmenuHex');\n\n\t\t\tif (this.contextMenuOpen) {\n\t\t\t\tmenu.classList.remove('active');\n\t\t\t} else {\n\t\t\t\tmenu.classList.add('active');\n\t\t\t\tmenu.style.left = evt.clientX + 'px';\n\t\t\t\tmenu.style.top = evt.clientY + 'px';\n\t\t\t}\n\n\t\t\tthis.contextMenuOpen = !this.contextMenuOpen;\n\t\t});\n\n\t\tthis.nav.get(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.CURRENT, (chunk) => {\n\t\t\tthis.curChunk = chunk;\n\t\t});\n\n\t\tthis.nav.get(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE, (chunk) => {\n\t\t\tthis.isTopMax = chunk.offset === 0;\n\t\t\tthis.drawChunk(chunk);\n\t\t\tthis.firstElement = this.drawChunk(this.getCurChunk());\n\t\t});\n\n\t\tthis.nav.get(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.AFTER, (chunk) => {\n\t\t\tthis.drawChunk(chunk);\n\t\t\tthis.content.scrollTop = 0;\n\t\t\tthis.content.scrollTop = this.getFirstElement().getBoundingClientRect().top;\n\n\t\t\t// Everything has been drawn, maybe we should do something more\n\t\t\tif (typeof callback !== 'undefined') {\n\t\t\t\tcallback();\n\t\t\t}\n\t\t});\n\t}\n\n\t/**\n\t * Draw a chunk before or after the current content\n\t */\n\tdrawChunk(chunk, where) {\n\t\tif (chunk.offset === 0 && chunk.hex.length === 0) {\n\t\t\treturn this.firstElement;\n\t\t}\n\n\t\tvar drawMethod;\n\t\tvar size;\n\t\tif (this.hexLength === -1) {\n\t\t\tdrawMethod = this.drawPairs_;\n\t\t} else {\n\t\t\tdrawMethod = this.drawWords_;\n\t\t\tsize = this.hexLength;\n\t\t}\n\n\t\tif (typeof where === 'undefined') {\n\t\t\twhere = _core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.AFTER;\n\t\t}\n\n\t\tvar lines = [];\n\t\tvar firstElement;\n\t\tvar i;\n\t\tfor (var x = 0 ; x < chunk.hex.length ; x++) {\n\t\t\tconst line = document.createElement('li');\n\t\t\tline.className = 'block' + chunk.offset;\n\n\t\t\tif (where === _core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.AFTER) {\n\t\t\t\tthis.listContent.appendChild(line);\n\t\t\t\tlines.push(line);\n\t\t\t\ti = x;\n\t\t\t} else {\n\t\t\t\tthis.listContent.insertBefore(line, this.listContent.firstChild);\n\t\t\t\tlines.unshift(line);\n\t\t\t\ti = (chunk.hex.length - 1) - x;\n\t\t\t}\n\n\t\t\tline.addEventListener('mousedown', (evt) => { this.currentLine = line; });\n\n\t\t\tline.offset = {};\n\t\t\tline.offset.start = chunk.offset + (this.nbColumns * i);\n\t\t\tline.offset.end = line.offset.start + (this.nbColumns - 1);\n\n\t\t\tvar offset = document.createElement('ul');\n\t\t\tvar hexpairs = document.createElement('ul');\n\t\t\tvar asciis = document.createElement('ul');\n\n\t\t\toffset.classList.add('offset');\n\n\t\t\tvar offsetEl = document.createElement('li');\n\t\t\toffset.appendChild(offsetEl);\n\t\t\tconst hex = int2fixedHex(chunk.offset + (i * this.nbColumns), 8);\n\t\t\tconst offsetElA = document.createElement('a');\n\t\t\toffsetElA.innerHTML = hex;\n\t\t\t(0,_helpers_Format__WEBPACK_IMPORTED_MODULE_8__.applySeek)(offsetElA);\n\t\t\toffsetEl.appendChild(offsetElA);\n\n\t\t\toffsetEl.assoc = hexpairs;\n\n\t\t\thexpairs.classList.add('hexpairs');\n\n\t\t\tasciis.classList.add('ascii');\n\n\t\t\tline.appendChild(offset);\n\t\t\tline.appendChild(hexpairs);\n\t\t\tline.appendChild(asciis);\n\n\t\t\tdrawMethod.apply(\n\t\t\t\tthis,\n\t\t\t\t[hexpairs, asciis, chunk.hex[i], chunk.ascii[i], chunk.modified, chunk.offset + (this.nbColumns * i), size]\n\t\t\t);\n\n\t\t\tif (typeof firstElement === 'undefined') {\n\t\t\t\tfirstElement = line;\n\t\t\t}\n\t\t}\n\n\t\tthis.applyFlags(lines, chunk.offset, chunk.flags);\n\n\t\treturn firstElement;\n\t}\n\n\t/**\n\t * Trigerred by scrolling, determine and add content at the right place\n\t */\n\tinfiniteDrawingContent(where, pos, endCallback) {\n\t\tthis.nav.get(where, (chunk) => {\n\t\t\tif (where === _core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE) {\n\t\t\t\tthis.isTopMax = chunk.offset === 0;\n\t\t\t} else {\n\t\t\t\tif (this.isTopMax) {\n\t\t\t\t\tthis.nav.get(_core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE, (chunk) => {\n\t\t\t\t\t\tif (chunk.offset > 0) {\n\t\t\t\t\t\t\tthis.isTopMax = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (chunk.offset === 0 && chunk.hex.length === 0) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar removing;\n\t\t\tif (where === _core_NavigatorDirection__WEBPACK_IMPORTED_MODULE_1__.NavigatorDirection.BEFORE) {\n\t\t\t\tremoving = this.listContent.lastChild.className;\n\t\t\t} else {\n\t\t\t\tremoving = this.listContent.firstChild.className;\n\t\t\t}\n\t\t\tvar elements = Array.prototype.slice.call(document.getElementsByClassName(removing));\n\t\t\tfor (var i = 0 ; i < elements.length ; i++) {\n\t\t\t\telements[i].parentNode.removeChild(elements[i]);\n\t\t\t}\n\n\t\t\tthis.drawChunk(chunk, where);\n\t\t\tthis.content.scrollTop = pos;\n\t\t\tthis.colorizeFlag(true);\n\n\t\t\tendCallback(this.isTopMax); // pauseScrollEvent = false\n\t\t});\n\t}\n\n\t/**\n\t * mouse over event to highligh pair-ascii at the same time\n\t */\n\tshowPairs_(first, second, isOver) {\n\t\tif (isOver) {\n\t\t\tfirst.classList.add('active');\n\t\t\tsecond.classList.add('active');\n\t\t} else {\n\t\t\tfirst.classList.remove('active');\n\t\t\tsecond.classList.remove('active');\n\t\t}\n\t}\n\n\t/**\n\t * Generic method to draw words of any size\n\t */\n\tdrawWords_(hexpairs, asciis, pairs, chars, modifications, offset, size) {\n\t\tvar words = this.pairs2words(pairs, size);\n\t\thexpairs.classList.add('words');\n\n\t\tfor (var x = 0 ; x < pairs.length ; x++) {\n\t\t\tvar asciiEl = document.createElement('li');\n\t\t\tasciiEl.appendChild(document.createTextNode(chars[x]));\n\t\t\tasciis.appendChild(asciiEl);\n\n\t\t\tthis.colorizeByte(asciiEl, pairs[x]);\n\t\t}\n\n\t\tfor (var x = 0 ; x < words.length ; x++) {\n\t\t\tvar hexpairEl = document.createElement('li');\n\t\t\tvar contentNode;\n\t\t\tif (size === 2) {\n\t\t\t\tvar word = '' + new Int16Array([+words[x]])[0]\n\t\t\t\tif (word.length < 5) {\n\t\t\t\t\tword = Array(5 - word.length).join('_') + word\n\t\t\t\t}\n\t\t\t\tcontentNode = document.createTextNode(word);\n\t\t\t} else {\n\t\t\t\tcontentNode = document.createElement('a');\n\t\t\t\tcontentNode.innerHTML = '0x' + words[x];\n\t\t\t\t(0,_helpers_Format__WEBPACK_IMPORTED_MODULE_8__.applySeek)(contentNode);\n\t\t\t}\n\t\t\thexpairEl.appendChild(contentNode);\n\t\t\thexpairs.appendChild(hexpairEl);\n\t\t}\n\t}\n\n\t/**\n\t * Default drawing method to draw the pairs with all features\n\t */\n\tdrawPairs_(hexpairs, asciis, pairs, chars, modifications, offset) {\n\t\thexpairs.classList.add('pairs');\n\n\t\tvar editableHexEvent = {\n\t\t\tkeydown: (evt) => evt.keyCode === 13 && collectHexpair(evt.target),\n\t\t\tblur: (evt) => collectHexpair(evt.target)\n\t\t};\n\n\t\tvar editableAsciiEvent = {\n\t\t\tkeydown: (evt) => evt.keyCode === 13 && collectAscii(evt.target),\n\t\t\tblur: (evt) => collectAscii(evt.target)\n\t\t};\n\n\t\tvar collectHexpair = (target) => {\n\t\t\tif (target.busy) {\n\t\t\t\treturn; // Event has been already triggered elsewhere\n\t\t\t}\n\t\t\t// Don't need to set to false, in each case we remove the node\n\t\t\ttarget.busy = true;\n\n\t\t\t// Keep the first 2 valid hex characters\n\t\t\tvar regex = target.value.match(/$([a-fA-F0-9]{2})^/);\n\t\t\tif (regex === null) {\n\t\t\t\tif (typeof target.parentNode === 'undefined') {\n\t\t\t\t\t// Solving event conflict\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\talert('Wrong format, expected: [a-fA-F0-9]{2}');\n\t\t\t\ttarget.parentNode.innerHTML = target.initValue;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar value = regex[0];\n\t\t\ttarget = target.parentNode;\n\t\t\tvar initial = this.nav.reportChange(target.offset, value);\n\n\t\t\ttarget.innerHTML = value;\n\t\t\ttarget.assoc.innerHTML = hexPairToASCII(value);\n\t\t\tif (initial !== null) {\n\t\t\t\ttarget.classList.add('modified');\n\t\t\t\ttarget.assoc.classList.add('modified');\n\t\t\t\tthis.colorizeByte(target, value);\n\t\t\t\tthis.colorizeByte(target.assoc, value);\n\t\t\t\tthis.onChangeCallback(target.offset, initial, value);\n\t\t\t}\n\n\t\t\ttarget.removeEventListener('keydown', editableHexEvent.keydown);\n\t\t\ttarget.removeEventListener('blur', editableHexEvent.blur);\n\t\t};\n\n\t\tvar collectAscii = (target) => {\n\t\t\tvar value = target.value[0];\n\t\t\tvar hex = ASCIIToHexpair(value);\n\t\t\ttarget = target.parentNode;\n\t\t\tvar initial = this.nav.reportChange(target.assoc.offset, hex);\n\n\t\t\ttarget.innerHTML = value;\n\t\t\ttarget.assoc.innerHTML = hex;\n\t\t\tif (initial !== null) {\n\t\t\t\ttarget.classList.add('modified');\n\t\t\t\ttarget.assoc.classList.add('modified');\n\t\t\t\tthis.colorizeByte(target, value);\n\t\t\t\tthis.colorizeByte(target.assoc, value);\n\t\t\t\tthis.onChangeCallback(target.assoc.offset, target.assoc.innerHTML, hex);\n\t\t\t}\n\n\t\t\ttarget.removeEventListener('keydown', editableAsciiEvent.keydown);\n\t\t\ttarget.removeEventListener('blur', editableAsciiEvent.blur);\n\t\t};\n\n\t\tfor (var x = 0 ; x < pairs.length ; x++) {\n\t\t\tvar curOffset = offset + x;\n\n\t\t\t// If there is a one-byte modification (UI not refresh)\n\t\t\tvar checkModification = this.nav.hasNewValue(curOffset);\n\t\t\t// If there is a modification known by r2\n\t\t\tvar isModified = this.nav.isModifiedByte(curOffset);\n\t\t\t// If it's a small modification, we update content\n\t\t\tif (checkModification !== null) {\n\t\t\t\tpairs[x] = checkModification;\n\t\t\t\tchars[x] = hexPairToASCII(checkModification);\n\t\t\t\tisModified = true;\n\t\t\t}\n\n\t\t\tvar hexpairEl = document.createElement('li');\n\t\t\thexpairEl.appendChild(document.createTextNode(pairs[x]));\n\t\t\thexpairEl.offset = curOffset;\n\t\t\tif (isModified) {\n\t\t\t\thexpairEl.classList.add('modified');\n\t\t\t}\n\n\t\t\tvar asciiEl = document.createElement('li');\n\t\t\tasciiEl.appendChild(document.createTextNode(chars[x]));\n\t\t\tif (isModified) {\n\t\t\t\tasciiEl.classList.add('modified');\n\t\t\t}\n\n\t\t\tasciiEl.assoc = hexpairEl;\n\t\t\thexpairEl.assoc = asciiEl;\n\n\t\t\thexpairs.appendChild(hexpairEl);\n\t\t\tasciis.appendChild(asciiEl);\n\n\t\t\tthis.colorizeByte(hexpairEl, pairs[x]);\n\t\t\tthis.colorizeByte(asciiEl, pairs[x]);\n\n\t\t\thexpairEl.addEventListener('mouseenter', (evt) => this.showPairs_(evt.target, evt.target.assoc, true));\n\t\t\thexpairEl.addEventListener('mouseleave', (evt) => this.showPairs_(evt.target, evt.target.assoc, false));\n\n\t\t\tasciiEl.addEventListener('mouseenter', (evt) => this.showPairs_(evt.target, evt.target.assoc, true));\n\t\t\tasciiEl.addEventListener('mouseleave', (evt) => this.showPairs_(evt.target, evt.target.assoc, false));\n\n\t\t\tif (this.isWritable()) {\n\t\t\t\thexpairEl.addEventListener('click', (evt) => {\n\t\t\t\t\tif (evt.button !== 0) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tevt.preventDefault();\n\t\t\t\t\tvar form = document.createElement('input');\n\t\t\t\t\tform.maxLength = 2;\n\t\t\t\t\tform.initValue = evt.target.innerHTML;\n\t\t\t\t\tform.value = evt.target.innerHTML;\n\t\t\t\t\tform.pattern = '[a-fA-F0-9]{2}';\n\t\t\t\t\tevt.target.innerHTML = '';\n\t\t\t\t\tevt.target.appendChild(form);\n\t\t\t\t\tform.busy = false; // Race-flag\n\t\t\t\t\tform.addEventListener('keydown', editableHexEvent.keydown);\n\t\t\t\t\tform.addEventListener('blur', editableHexEvent.blur);\n\t\t\t\t\tform.focus();\n\t\t\t\t});\n\n\t\t\t\tasciiEl.addEventListener('click', (evt) => {\n\t\t\t\t\tif (evt.button !== 0) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tevt.preventDefault();\n\t\t\t\t\tvar form = document.createElement('input');\n\t\t\t\t\tform.maxLength = 1;\n\t\t\t\t\tform.value = evt.target.innerHTML;\n\t\t\t\t\tform.pattern = '(.){1}';\n\t\t\t\t\tevt.target.innerHTML = '';\n\t\t\t\t\tevt.target.appendChild(form);\n\t\t\t\t\tform.addEventListener('keydown', editableAsciiEvent.keydown);\n\t\t\t\t\tform.addEventListener('blur', editableAsciiEvent.blur);\n\t\t\t\t\tform.focus();\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\thexpairEl.addEventListener('click', () => {\n\t\t\t\t\tthis.beingSelected = false;\n\t\t\t\t\tthis.cleanSelection();\n\t\t\t\t});\n\n\t\t\t\tconst stopSelection = () => {\n\t\t\t\t\tthis.beingSelected = false;\n\t\t\t\t\twindow.removeEventListener('mouseup', stopSelection);\n\t\t\t\t};\n\n\t\t\t\thexpairEl.addEventListener('mousedown', (evt) => {\n\t\t\t\t\tif (evt.button !== 0) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tevt.preventDefault();\n\t\t\t\t\tthis.beingSelected = true;\n\t\t\t\t\tthis.selectionFirst = evt.target;\n\t\t\t\t\twindow.addEventListener('mouseup', stopSelection);\n\t\t\t\t});\n\n\t\t\t\thexpairEl.addEventListener('mouseover', (evt) => {\n\t\t\t\t\tif (!this.beingSelected) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tthis.selectionEnd = evt.target;\n\t\t\t\t\tthis.processSelection(true);\n\t\t\t\t});\n\n\t\t\t\thexpairEl.addEventListener('mouseup', (evt) => {\n\t\t\t\t\tif (!this.beingSelected) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tthis.selectionEnd = evt.target;\n\t\t\t\t\tthis.processSelection(false);\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t}\n\n\t//#endregion\n\n\t//#region aux draw\n/**\n\t * Populate the content of the contextual menu (on hexpair selection)\n\t */\n\tdrawContextualMenu() {\n\t\tvar exportOp = (name, range, command, ext) => {\n\t\t\tvar output;\n\t\t\tr2.cmd(command + ' ' + (range.to - range.from) + ' @' + range.from, (d) => { output = d; });\n\n\t\t\tvar dialog = this.createExportDialog('Export as ' + name + ':', output, () => {\n\t\t\t\tvar blob = new Blob([output], {type: 'text/plain'});\n\t\t\t\tvar fileName;\n\t\t\t\tr2.cmdj('ij', (d) => { fileName = basename(d.core.file); });\n\t\t\t\tfileName += '_0x' + range.from.toString(16) + '-0x' + range.to.toString(16) + '.' + ext;\n\t\t\t\tsaveAs(blob, fileName);\n\t\t\t});\n\n\t\t\tdocument.body.appendChild(dialog);\n\t\t\tcomponentHandler.upgradeDom();\n\t\t\tdialog.showModal();\n\t\t};\n\n\t\tvar bytes;\n\t\tvar exportAs = [\n\t\t\t{ name: 'Assembly', fct: (evt, range) => exportOp('ASM', range, 'pca', 'asm') },\n\t\t\t{ name: 'Disassembly', fct: (evt, range) => exportOp('DISASM', range, 'pD', 'disasm') },\n\t\t\t{ name: 'Hexpairs', fct: (evt, range) => exportOp('HEXPAIRS', range, 'p8', 'disasm') },\n\t\t\t{ name: 'Base64 Encode', fct: (evt, range) => exportOp('b64e', range, 'p6e', 'disasm') },\n\t\t\t{ name: 'Base64 Decode', fct: (evt, range) => exportOp('b64d', range, 'p6d', 'disasm') },\n\t\t\t{ name: 'Binary', fct: (evt, range) => { bytes = new Uint8Array(this.nav.getBytes(range));\n\t\t\t\tvar blob = new Blob([bytes], {type: 'application/octet-stream'});\n\t\t\t\tvar fileName;\n\t\t\t\tr2.cmdj('ij', (d) => { fileName = basename(d.core.file); });\n\t\t\t\tfileName += '_0x' + range.from.toString(16) + '-0x' + range.to.toString(16) + '.bin';\n\t\t\t\tsaveAs(blob, fileName);\n\t\t\t} },\n\t\t\t{ name: 'C', fct: (evt, range) => exportOp('C', range, 'pc', 'c') },\n\t\t\t{ name: 'C half-words (2 bytes)', fct: (evt, range) => exportOp('C', range, 'pch', 'c') },\n\t\t\t{ name: 'C words (4 bytes)', fct: (evt, range) => exportOp('C', range, 'pcw', 'c') },\n\t\t\t{ name: 'C dwords (8 bytes)', fct: (evt, range) => exportOp('C', range, 'pcd', 'c') },\n\t\t\t{ name: 'JavaScript', fct: (evt, range) => exportOp('JS', range, 'pcJ', 'js') },\n\t\t\t{ name: 'JSON', fct: (evt, range) => exportOp('JSON', range, 'pcj', 'json') },\n\t\t\t{ name: 'Python', fct: (evt, range) => exportOp('Python', range, 'pcp', 'py') },\n\t\t\t{ name: 'R2 commands', fct: (evt, range) => exportOp('R2 cmd', range, 'pc*', 'r2') },\n\t\t\t{ name: 'Shell script', fct: (evt, range) => exportOp('Shell script', range, 'pcS', 'txt') },\n\t\t\t{ name: 'String', fct: (evt, range) => exportOp('string', range, 'pcs', 'txt') }\n\t\t];\n\t\tvar applyOp = (range, operande) => {\n\t\t\tvar val = prompt('Value (valid hexpair):');\n\t\t\tvar op = operande + ' ' + val + ' ' + (range.to - range.from) + ' @' + range.from;\n\t\t\tr2.cmd(op, () => console.log('Call: ' + op));\n\t\t\tthis.nav.updateModifications();\n\n\t\t\t// Send modifications and reload\n\t\t\tthis.nav.refreshCurrent(() => this.draw());\n\t\t};\n\t\tvar operations = [\n\t\t\t{ name: 'addition', fct: (evt, range) => applyOp(range, 'woa') },\n\t\t\t{ name: 'and', fct: (evt, range) => applyOp(range, 'woA') },\n\t\t\t{ name: 'divide', fct: (evt, range) => applyOp(range, 'wod') },\n\t\t\t{ name: 'shift left', fct: (evt, range) => applyOp(range, 'wol') },\n\t\t\t{ name: 'multiply', fct: (evt, range) => applyOp(range, 'wom') },\n\t\t\t{ name: 'or', fct: (evt, range) => applyOp(range, 'woo') },\n\t\t\t{ name: 'shift right', fct: (evt, range) => applyOp(range, 'wor') },\n\t\t\t{ name: 'substraction', fct: (evt, range) => applyOp(range, 'wos') },\n\t\t\t{ name: 'write looped', fct: (evt, range) => applyOp(range, 'wow') },\n\t\t\t{ name: 'xor', fct: (evt, range) => applyOp(range, 'wox') },\n\t\t\t{ name: '2 byte endian swap', fct: (evt, range) => applyOp(range, 'wo2') },\n\t\t\t{ name: '4 byte endian swap', fct: (evt, range) => applyOp(range, 'wo4') }\n\t\t];\n\n\t\tvar items = [\n\t\t/*\n\t\t\tTODO\n\t\t\t{\n\t\t\t\tname: 'Copy length @offset to cmd-line',\n\t\t\t\tfct: function(evt, range) {\n\t\t\t\t\tconsole.log('Not implemented');\n\t\t\t\t}\n\t\t\t},\n\t\t\t{\n\t\t\t\tname: 'Copy bytes to cmd-line',\n\t\t\t\tfct: function(evt, range) {\n\t\t\t\t\tconsole.log('Not implemented');\n\t\t\t\t}\n\t\t\t},*/\n\t\t\t{\n\t\t\t\tname: 'Select line',\n\t\t\t\tfct: (evt, range) => {\n\t\t\t\t\tthis.selectionFirst = this.currentLine.children[1].children[0];\n\t\t\t\t\tthis.selectionEnd = this.currentLine.children[1].children[this.currentLine.children[1].children.length - 1];\n\t\t\t\t\tthis.processSelection(true);\n\t\t\t\t}\n\t\t\t},\n\t\t\t{\n\t\t\t\tname: 'Set flag',\n\t\t\t\tfct: (evt, range) => {\n\t\t\t\t\tvar name = prompt('Flag\\'s name:');\n\t\t\t\t\tr2.cmd('f ' + name + ' ' + (range.to - range.from + 1) + ' @' + range.from, () => {\n\t\t\t\t\t\tthis.nav.refreshCurrent(() => this.draw());\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\t\t\t{\n\t\t\t\tname: 'Export as...',\n\t\t\t\texpand: exportAs,\n\t\t\t\trequireWritable: false\n\t\t\t},\n\t\t\t{\n\t\t\t\tname: 'Operations...',\n\t\t\t\texpand: operations,\n\t\t\t\trequireWritable: true\n\t\t\t}\n\t\t];\n\n\t\tvar menu = document.createElement('nav');\n\t\tmenu.id = 'contextmenuHex';\n\t\tmenu.classList.add('context-menu');\n\n\t\tvar ul = document.createElement('ul');\n\t\tmenu.appendChild(ul);\n\n\t\t// var bindAction = function(element, action) {\n\t\t// \telement.addEventListener('mousedown', (function(fct) {\n\t\t// \t\treturn function(evt) {\n\t\t// \t\t\tfct(evt, _this.getCurrentSelection());\n\t\t// \t\t};\n\t\t// \t}(action)));\n\t\t// };\n\n\t\tvar bindAction = (element, action) => {\n\t\t\telement.addEventListener('mousedown', (evt) => {\n\t\t\t\taction(evt, this.getCurrentSelection());\n\t\t\t})\n\t\t};\n\n\t\tfor (var i = 0 ; i < items.length ; i++) {\n\t\t\tvar li = document.createElement('li');\n\t\t\tul.appendChild(li);\n\t\t\tli.appendChild(document.createTextNode(items[i].name));\n\t\t\tli.isSubOpen = false;\n\t\t\tli.requireWritable = items[i].requireWritable;\n\n\t\t\tif (items[i].requireWritable) {\n\t\t\t\tli.classList.add('writableMenu');\n\t\t\t}\n\n\t\t\tli.addEventListener('mouseenter', (evt) => {\n\t\t\t\t// Cleaning old \"active\"\n\t\t\t\tvar subactives = Array.prototype.slice.call(evt.target.parentNode.getElementsByClassName('subactive'));\n\t\t\t\tfor (var x = 0 ; x < subactives.length ; x++) {\n\t\t\t\t\tsubactives[x].classList.remove('subactive');\n\t\t\t\t\tsubactives[x].isSubOpen = false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// expandable menu\n\t\t\tif (typeof items[i].expand !== 'undefined') {\n\t\t\t\t// Make submenu reachable\n\t\t\t\tli.addEventListener('mouseenter', (evt) => {\n\t\t\t\t\t// If not available on read-only mode\n\t\t\t\t\tif (evt.target.requireWritable && !this.writable) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (evt.target.isSubOpen) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tevt.target.isSubOpen = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar subMenu = evt.target.children[0];\n\t\t\t\t\tif (typeof subMenu === 'undefined') {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar dim = evt.target.getBoundingClientRect();\n\t\t\t\t\tvar indexOf = Array.prototype.slice.call(evt.target.parentNode.children).indexOf(evt.target);\n\t\t\t\t\tevt.target.classList.add('subactive');\n\t\t\t\t\tsubMenu.style.left = dim.width + 'px';\n\t\t\t\t\tsubMenu.style.top = indexOf * dim.height + 'px';\n\t\t\t\t});\n\n\t\t\t\t// Creating sub menu\n\t\t\t\tvar subUl = document.createElement('ul');\n\t\t\t\tli.appendChild(subUl);\n\t\t\t\tfor (var j = 0 ; j < items[i].expand.length ; j++) {\n\t\t\t\t\tvar subLi = document.createElement('li');\n\t\t\t\t\tsubUl.appendChild(subLi);\n\t\t\t\t\tsubLi.appendChild(document.createTextNode(items[i].expand[j].name));\n\t\t\t\t\tbindAction(subLi, items[i].expand[j].fct);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tbindAction(li, items[i].fct);\n\t\t\t}\n\t\t}\n\n\t\tdocument.body.appendChild(menu);\n\t\tcomponentHandler.upgradeDom();\n\n\t\tthis.contextMenuOpen = false;\n\t\tvar closeMenu = () => {\n\t\t\tif (!this.contextMenuOpen) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tmenu.classList.remove('active');\n\t\t\tthis.contextMenuOpen = false;\n\t\t};\n\n\t\twindow.onkeyup = (e) =>  e.keyCode === 27 && closeMenu();\n\t\tdocument.addEventListener('click', () => closeMenu());\n\t}\n\n\t/**\n\t * Return the export dialog built\n\t * Don't forget to normalize the output by calling MDL processing\n\t */\n\tcreateExportDialog(label, output, save) {\n\t\tvar dialog = document.createElement('dialog');\n\t\tdialog.className = 'mdl-dialog';\n\n\t\tif (!dialog.showModal) {\n\t\t\tdialogPolyfill.registerDialog(dialog);\n\t\t}\n\n\t\t/*\tCONTENT  */\n\t\tvar content = document.createElement('div');\n\t\tcontent.className = 'mdl-dialog__content';\n\t\tdialog.appendChild(content);\n\n\t\tvar desc = document.createTextNode(label);\n\t\tcontent.appendChild(desc);\n\n\t\tvar textarea = document.createElement('textarea');\n\t\ttextarea.style.width = '100%';\n\t\ttextarea.style.height = '220px';\n\t\tcontent.appendChild(textarea);\n\t\ttextarea.value = output;\n\n\t\t/*  ACTIONS  */\n\t\tvar actions = document.createElement('div');\n\t\tactions.className = 'mdl-dialog__actions';\n\t\tdialog.appendChild(actions);\n\n\t\tvar saveButton = document.createElement('button');\n\t\tsaveButton.className = 'mdl-button';\n\t\tsaveButton.innerHTML = 'Save';\n\t\tsaveButton.addEventListener('click', () => {\n\t\t\tdialog.close();\n\t\t\tdialog.parentNode.removeChild(dialog);\n\t\t\tsave();\n\t\t});\n\t\tactions.appendChild(saveButton);\n\n\t\tvar closeButton = document.createElement('button');\n\t\tcloseButton.className = 'mdl-button';\n\t\tcloseButton.innerHTML = 'Close';\n\t\tcloseButton.addEventListener('click', () => {\n\t\t\tdialog.close();\n\t\t\tdialog.parentNode.removeChild(dialog);\n\t\t});\n\t\tactions.appendChild(closeButton);\n\n\t\treturn dialog;\n\t}\n\n\t/**\n\t * Draw the top-bar controls\n\t */\n\tdrawControls(dom) {\n\t\tdom.innerHTML = '';\n\n\t\tvar controlList = document.createElement('ul');\n\t\tcontrolList.classList.add('controlList');\n\t\tdom.appendChild(controlList);\n\n\t\tvar wordBlock = document.createElement('li');\n\t\tcontrolList.appendChild(wordBlock);\n\t\tvar nbColumnsBlock = document.createElement('li');\n\t\tcontrolList.appendChild(nbColumnsBlock);\n\t\tvar bigEndianBlock = document.createElement('li');\n\t\tcontrolList.appendChild(bigEndianBlock);\n\t\tvar selectionBlock = document.createElement('li');\n\t\tcontrolList.appendChild(selectionBlock);\n\t\tvar flagBlock = document.createElement('li');\n\t\tcontrolList.appendChild(flagBlock);\n\n\t\tvar selectWord = document.createElement('span');\n\t/*\n\t\tselectWord.appendChild(document.createTextNode('Word length: '));\n\t*/\n/*\n\t\tif (0) {\n\t\t\tvar div = document.createElement('div');\n\t\t\tdiv.className = 'mdl-selectfield mdl-js-selectfield mdl-selectfield--floating-label';\n\t\t\tselectWord.appendChild(div);\n\t\t\tvar select = document.createElement('select');\n\t\t\tdiv.appendChild(select);\n\t\t\tselect.className = 'mdl-selectfield__select';\n\t\t\tselectWord.appendChild(select);\n\t\t\n*/\n\t\tvar select = document.createElement('select');\n\t\tselect.className = 'mdl-selectfield mdl-js-selectfield mdl-selectfield--floating-label';\n\t\tselect.style = 'background-color:white;border:1px;color:black;';\n\t\tselectWord.appendChild(select);\n\n\t\tfor (var i in _WordSizes__WEBPACK_IMPORTED_MODULE_4__.WordSizes) {\n\t\t\tvar option = document.createElement('option');\n\t\t\toption.value = _WordSizes__WEBPACK_IMPORTED_MODULE_4__.WordSizes[i];\n\t\t\toption.text = _WordSizes__WEBPACK_IMPORTED_MODULE_4__.WordSizes[i] > 0 ? (_WordSizes__WEBPACK_IMPORTED_MODULE_4__.WordSizes[i] * 8) + ' bits' : 'pairs';\n\t\t\tif (_WordSizes__WEBPACK_IMPORTED_MODULE_4__.WordSizes[i] === this.hexLength) {\n\t\t\t\toption.selected = true;\n\t\t\t}\n\t\t\tselect.appendChild(option);\n\t\t}\n\n\t\tselect.addEventListener('change', (evt) => {\n\t\t\tthis.hexLength = parseInt(evt.target.value);\n\t\t\tthis.draw();\n\t\t}, false);\n\n\t\t// Nb columns\n\t\tconst nbCols = document.createElement('input');\n\t\tnbCols.className = 'mdl-textfield__input';\n\t\tnbCols.style.width = '26px';\n\t\tnbCols.style.display = 'inline';\n\t\tnbCols.pattern = '[0-9]+';\n\t\tnbCols.value = this.nbColumns;\n\n\t\tvar setNbCols = (dom) => {\n\t\t\tthis.nbColumns = nbCols;\n\t\t\tthis.nav.changeNbCols(nbCols);\n\t\t\tthis.draw();\n\t\t\tdom.value = nbCols;\n\t\t};\n\n\t\tvar selectColumns = document.createElement('span');\n\t\tselectColumns.title = 'Number of columns per line';\n\n\t\tvar buttonLess = document.createElement('button');\n\t\tbuttonLess.className = 'mdl-button mdl-js-button mdl-button--icon';\n\t\tbuttonLess.appendChild(document.createTextNode('-'));\n\t\tbuttonLess.addEventListener('click', () => setNbCols(this.nbColumns - 1));\n\n\t\tvar buttonMore = document.createElement('button');\n\t\tbuttonMore.className = 'mdl-button mdl-js-button mdl-button--icon';\n\t\tbuttonMore.appendChild(document.createTextNode('+'));\n\t\tbuttonMore.addEventListener('click', () => setNbCols(this.nbColumns + 1));\n\n\t\tnbCols.addEventListener('change', (evt) => {\n\t\t\tvar curVal = parseInt(evt.target.value);\n\t\t\tsetNbCols(curVal);\n\t\t});\n\n\t\tselectColumns.appendChild(buttonLess);\n\t\tselectColumns.appendChild(document.createTextNode(' '));\n\t\tselectColumns.appendChild(nbCols);\n\t\tselectColumns.appendChild(document.createTextNode(' '));\n\t\tselectColumns.appendChild(buttonMore);\n\n\n\t\t// Big endian\n\t\tvar checkboxBigEndian = document.createElement('input');\n\t\tcheckboxBigEndian.classList.add('mdl-checkbox__input');\n\t\tcheckboxBigEndian.type = 'checkbox';\n\t\tcheckboxBigEndian.checked = this.bigEndian;\n\n\t\tvar textBigEndian = document.createElement('span');\n\t\ttextBigEndian.classList.add('mdl-checkbox__label');\n\t\ttextBigEndian.appendChild(document.createTextNode('bigEndian'));\n\n\t\tvar labelCheckboxBE = document.createElement('label');\n\t\tlabelCheckboxBE.classList.add('mdl-checkbox');\n\t\tlabelCheckboxBE.classList.add('mdl-js-checkbox');\n\t\tlabelCheckboxBE.classList.add('mdl-js-ripple-effect');\n\t\tlabelCheckboxBE.appendChild(checkboxBigEndian);\n\t\tlabelCheckboxBE.appendChild(textBigEndian);\n\n\t\tcheckboxBigEndian.addEventListener('change', () => {\n\t\t\tthis.bigEndian = !this.bigEndian;\n\t\t\tthis.draw();\n\t\t});\n\n\t\t// Selection mode\n\t\tvar checboxSelection = document.createElement('input');\n\t\tchecboxSelection.classList.add('mdl-checkbox__input');\n\t\tchecboxSelection.type = 'checkbox';\n\t\tchecboxSelection.checked = this.isWritable();\n\n\t\tvar textSelection = document.createElement('span');\n\t\ttextSelection.classList.add('mdl-checkbox__label');\n\t\ttextSelection.appendChild(document.createTextNode('isEditable'));\n\n\t\tvar labelCheckboxSelection = document.createElement('label');\n\t\tlabelCheckboxSelection.classList.add('mdl-checkbox');\n\t\tlabelCheckboxSelection.classList.add('mdl-js-checkbox');\n\t\tlabelCheckboxSelection.classList.add('mdl-js-ripple-effect');\n\t\tlabelCheckboxSelection.appendChild(checboxSelection);\n\t\tlabelCheckboxSelection.appendChild(textSelection);\n\t\tif (!this.writable) {\n\t\t\tchecboxSelection.disabled = true;\n\t\t}\n\n\t\tchecboxSelection.addEventListener('change', () => {\n\t\t\tthis.selectionMode = !this.selectionMode;\n\t\t\tthis.draw();\n\t\t});\n\n\t\t// Big endian\n\t\tvar checkboxFlags = document.createElement('input');\n\t\tcheckboxFlags.classList.add('mdl-checkbox__input');\n\t\tcheckboxFlags.type = 'checkbox';\n\t\tcheckboxFlags.checked = this.showFlags;\n\n\t\tvar textFlags = document.createElement('span');\n\t\ttextFlags.classList.add('mdl-checkbox__label');\n\t\ttextFlags.appendChild(document.createTextNode('showFlags'));\n\n\t\tvar labelFlags = document.createElement('label');\n\t\tlabelFlags.classList.add('mdl-checkbox');\n\t\tlabelFlags.classList.add('mdl-js-checkbox');\n\t\tlabelFlags.classList.add('mdl-js-ripple-effect');\n\t\tlabelFlags.appendChild(checkboxFlags);\n\t\tlabelFlags.appendChild(textFlags);\n\n\t\tcheckboxFlags.addEventListener('change', () => {\n\t\t\tthis.showFlags = !this.showFlags;\n\t\t\tthis.draw();\n\t\t});\n\n\t\twordBlock.appendChild(selectWord);\n\t\tnbColumnsBlock.appendChild(selectColumns);\n\t\tbigEndianBlock.appendChild(labelCheckboxBE);\n\t\tselectionBlock.appendChild(labelCheckboxSelection);\n\t\tflagBlock.appendChild(labelFlags);\n\n\t\t// Call MDL\n\t\tcomponentHandler.upgradeDom();\n\t}\n\n\t//#endregion\n\n\t//#region flags\n/**\n\t * Returns the color associated with the flag\n\t */\n\tgetFlagColor(flagName) {\n\t\tfor (var i = 0 ; i < this.flagColorAssociation.length ; i++) {\n\t\t\tif (this.flagColorAssociation[i].name === flagName) {\n\t\t\t\treturn this.flagColorAssociation[i].color;\n\t\t\t}\n\t\t}\n\n\t\tvar color = this.pickColor();\n\t\tthis.flagColorAssociation.push({\n\t\t\tname: flagName,\n\t\t\tcolor: color\n\t\t});\n\n\t\treturn color;\n\t}\n\n\t/**\n\t * Draw the flags from the collection of lines (UI POV) currently displayed\n\t */\n\tapplyFlags(lines, blockInitialOffset, flags) {\n\t\tif (!this.showFlags) {\n\t\t\treturn;\n\t\t}\n\n\t\tfor (var i in flags) {\n\t\t\tvar line;\n\t\t\tvar flag = flags[i];\n\n\t\t\t// We select the first line concerned by the flag\n\t\t\tfor (var j = 0 ; j < lines.length ; j++) {\n\t\t\t\tif (lines[j].offset.start <= flag.offset &&\n\t\t\t\t\tlines[j].offset.end >= flag.offset) {\n\t\t\t\t\tline = lines[j];\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// If not found, we pick the next flag\n\t\t\tif (typeof line === 'undefined') {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tconst flagLine = document.createElement('li');\n\t\t\tconst theOffset = int2fixedHex(flag.offset, 8);\n\t\t\tflagLine.classList.add('block' + blockInitialOffset);\n\t\t\tflagLine.classList.add('flag');\n\t\t\tflagLine.offset = theOffset;\n\t\t\tflagLine.appendChild(document.createTextNode('[' + theOffset + '] ' + flag.name));\n\t\t\tflagLine.title = 'Go to Disassembly';\n\t\t\tflagLine.style.cursor = 'pointer';\n\t\t\tflagLine.style.marginTop = '8px'\n\t\t\tflagLine.addEventListener('click', () => _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_9__.r2Wrapper.seek(theOffset, _widgets_Widgets__WEBPACK_IMPORTED_MODULE_6__.Widgets.DISASSEMBLY));\n\t\t\tflagLine.title = '(' + flag.size + ' bytes) Seek ' + theOffset + ' on disassembly widget';\n\t\t\tflagLine.style.color = 'white'; // this.getFlagColor(flag.name);\n\t\t\tthis.listContent.insertBefore(flagLine, line);\n\t\t}\n\t}\n\n\t/**\n\t * Returns the index of the line who is containing the offset\n\t */\n\tindexOfLine_(offset) {\n\t\tvar list = [].slice.call(this.listContent.children);\n\t\tfor (var i = 0 ; i < list.length ; i++) {\n\t\t\tif (typeof list[i].offset !== 'undefined' &&\n\t\t\t\tlist[i].offset.start <= offset &&\n\t\t\t\tlist[i].offset.end >= offset) {\n\t\t\t\treturn i;\n\t\t\t}\n\t\t}\n\t\treturn -1;\n\t}\n\n\t/**\n\t * Add colorization on the pairs currently displayed\n\t * based on the length/color of the flags.\n\t * Small flags are \"painted\" at the end to ensure\n\t * better visibility (not masked by wide flags).\n\t */\n\tcolorizeFlag(reset) {\n\t\tif (!this.showFlags) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (typeof reset === 'undefined') {\n\t\t\treset = false;\n\t\t}\n\n\t\tvar list = [].slice.call(this.listContent.children);\n\n\t\tif (reset) {\n\t\t\tfor (var i = 0 ; i < list.length ; i++) {\n\t\t\t\tlist[i].backgroundColor = 'none';\n\t\t\t}\n\t\t}\n\n\t\t// Retrieving all flags with length greater than 2 sorted (small at end)\n\t\tthis.nav.getFlags(2, (flags) => {\n\t\t\tfor (var j = 0 ; j < flags.length ; j++) {\n\t\t\t\tvar end = false;\n\t\t\t\tvar initialLine = this.indexOfLine_(flags[j].start);\n\t\t\t\tif (initialLine === -1) {\n\t\t\t\t\tconsole.log('Undefined flag offset');\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tvar initialByte = flags[j].start - list[initialLine].offset.start;\n\n\t\t\t\t// We walk through lines\n\t\t\t\tfor (var i = initialLine ; i < list.length && !end ; i++) {\n\t\t\t\t\t// If it's a \"flag line\" we move on the next\n\t\t\t\t\tif (typeof list[i].offset === 'undefined' || list[i].classList.contains('flag')) {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar hexList = list[i].children[1].children;\n\t\t\t\t\tfor (var x = initialByte ; x < hexList.length ; x++) {\n\t\t\t\t\t\t// If reach the end, we stop here\n\t\t\t\t\t\tif (hexList[x].offset === flags[j].end) {\n\t\t\t\t\t\t\tend = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t\t// We color the byte\n\t\t\t\t\t\thexList[x].style.backgroundColor = this.getFlagColor(flags[j].name);\n\t\t\t\t\t}\n\n\t\t\t\t\tinitialByte = 0;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n\n\t//#endregion\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/hexdump/Hexdump.js?")},"./js/modules/hexdump/WordSizes.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "WordSizes": () => (/* binding */ WordSizes)\n/* harmony export */ });\n/** Size in number of bytes to make a word */\nconst WordSizes = {\n\tPAIRS: -1,\n\tHALF: 2, // 16 bits\n\tWORD: 4, // 32 bits\n\tQUADWORD: 8 // 64 bits\n};\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/hexdump/WordSizes.js?')},"./js/modules/overview/AnalysisCard.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"AnalysisCard\": () => (/* binding */ AnalysisCard)\n/* harmony export */ });\nclass AnalysisCard {\n\n\tget DOM() { return this.card; }\n\tset onAnalysis(value ) { this.analysisCallback = value; }\n\n\tconstructor() {\n\t\tthis.analysisMethods = [\n\t\t\t{ id: 'symbols', name: 'Analyse symbols', cmd: 'aa' },\n\t\t\t{ id: 'ref', name: 'Analyse References', cmd: 'aar' },\n\t\t\t{ id: 'calls', name: 'Analyse calls', cmd: 'e anal.calls=true;aac', disabledCmd: 'e anal.calls=false'  },\n\t\t\t{ id: 'emu', name: 'Emulate code', cmd: 'e asm.emu=1;aae;e asm.emu=0', disabledCmd: 'e asm.emu=false' },\n\t\t\t{ id: 'prelude', name: 'Find preludes', cmd: 'aap' },\n\t\t\t{ id: 'autoname', name: 'Autoname fcns', cmd: 'aan' },\n\t\t];\n\n\t\tthis.build();\n\t}\n\n\tbuild() {\n\t\tthis.card = document.createElement('div');\n\t\tthis.card.className = 'demo-options mdl-card mdl-color--teal-300 mdl-shadow--2dp mdl-cell mdl-cell--4-col mdl-cell--3-col-tablet mdl-cell--12-col-desktop';\n\n\t\tconst title = document.createElement('div');\n\t\ttitle.className = 'mdl-card__title mdl-card--expand mdl-color--teal-300';\n\t\ttitle.innerHTML = '<h2 class=\"mdl-card__title-text\">Analysis Options</h2>';\n\t\tthis.card.appendChild(title);\n\n\t\tconst content = document.createElement('div');\n\t\tcontent.className = 'mdl-card__supporting-text mdl-color-grey-600';\n\t\tthis.card.appendChild(content);\n\n\t\tconst choiceList = document.createElement('ul');\n\t\tcontent.appendChild(choiceList);\n\n\t\tconst action = document.createElement('div');\n\t\taction.className = 'mdl-card__actions mdl-card--border';\n\t\tthis.card.appendChild(action);\n\n\t\tconst analyseButton = document.createElement('a');\n\t\tanalyseButton.className = 'mdl-button mdl-js-button mdl-js-ripple-effect mdl-color--blue-grey-50 mdl-color-text--blue-greu-50';\n\t\tanalyseButton.textContent = 'Analyse',\n\t\tanalyseButton.addEventListener('click', () => this.analyse());\n\t\taction.appendChild(analyseButton);\n\n\t\tconst spacer = document.createElement('div');\n\t\tspacer.className = 'mdl-layout-spacer';\n\t\taction.appendChild(spacer);\n\n\t\tconst icon = document.createElement('i');\n\t\ticon.className = 'material-icons';\n\t\ticon.textContent = 'room';\n\t\taction.appendChild(icon);\n\n\t\tthis.addAnalysisOptions(choiceList);\n\t}\n\n\taddAnalysisOptions(dom) {\n\t\tfor (let i in this.analysisMethods)\n\t\t{\n\t\t\tconst method = this.analysisMethods[i];\n\t\t\tconst methodId = 'anal_' + method.id;\n\t\t\tconst li = document.createElement('li');\n\t\t\tdom.appendChild(li);\n\n\t\t\tconst label = document.createElement('label');\n\t\t\tlabel.className = 'mdl-checkbox mdl-js-checkbox mdl-js-ripple-effect';\n\t\t\tlabel.for = methodId;\n\t\t\tli.appendChild(label);\n\n\t\t\tconst checkbox = document.createElement('input');\n\t\t\tcheckbox.className = 'mdl-checkbox__input';\n\t\t\tcheckbox.id = methodId;\n\t\t\tcheckbox.type = 'checkbox';\n\t\t\tlabel.appendChild(checkbox);\n\n\t\t\tconst text = document.createElement('span');\n\t\t\ttext.className = 'mdl-checkbox__label';\n\t\t\ttext.innerHTML = method.name;\n\t\t\tlabel.appendChild(text);\n\t\t}\n\t}\n\n\trefresh() {\n\t\tvar collection = [].slice.call(this.card.getElementsByTagName('input'));\n\t\tcollection.forEach((checkbox) => checkbox.checked = false);\n\t}\n\n\tanalyse() {\n\t\tlet atLeastOneChecked = false;\n\t\tfor (let i in this.analysisMethods)\n\t\t{\n\t\t\tconst method = this.analysisMethods[i];\n\t\t\tconst methodId = 'anal_' + method.id;\n\t\t\tconst element = document.getElementById(methodId);\n\n\t\t\tif (element.checked) {\n\t\t\t\tr2.cmd(method.cmd);\n\t\t\t\tatLeastOneChecked = true;\n\t\t\t} else if (typeof method.disabledCmd !== 'undefined') {\n\t\t\t\tr2.cmd(method.cmd);\n\t\t\t}\n\t\t}\n\n\t\tif (atLeastOneChecked && typeof this.analysisCallback !== 'undefined') {\n\t\t\tthis.analysisCallback();\n\t\t}\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/overview/AnalysisCard.js?")},"./js/modules/overview/EntropyCard.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"EntropyCard\": () => (/* binding */ EntropyCard)\n/* harmony export */ });\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n/* harmony import */ var _widgets_Widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../widgets/Widgets */ \"./js/widgets/Widgets.js\");\n\n\n\nconst xmlns = \"http://www.w3.org/2000/svg\";\n\nclass EntropyCard {\n\n\tget DOM() { return this.card; }\n\n\tconstructor(width, height) {\n\t\tthis.width = width;\n\t\tthis.height = height;\n\t\tthis.entropy = [];\n\t\tthis.build();\n\t\tthis.refreshEntropy();\n\t\tthis.draw();\n\t}\n\n\tbuild() {\n\t\tthis.card = document.createElement('div');\n\t\tthis.card.className = 'demo-charts mdl-color--white mdl-shadow--2dp mdl-cell mdl-cell--12-col mdl-grid';\n\t\tthis.card.style.textAlign = 'center';\n\t\t\n\t\tthis.svg = document.createElementNS(xmlns, 'svg');\n\t\tthis.card.appendChild(this.svg);\n\t\tthis.svg.style.display = 'block';\n\t\tthis.svg.style.margin = 'auto';\n\t\tthis.svg.setAttribute('fill', 'currentColor');\n\t\tthis.svg.setAttribute('viewBox', '0 0 ' + this.width + ' ' + this.height);\n\t\tthis.svg.setAttribute('width', this.width + 'px');\n\t\tthis.svg.setAttribute('height',  this.height + 'px');\n\t\tthis.svg.setAttribute('title', 'Entropy graph');\n\t}\n\n\trefreshEntropy() {\n\t\tr2.cmdj('p=ej 50 $s @ $M|', (d) => {\n\t\t\tif (d && d.entropy) {\n\t\t\t\tthis.entropy = d.entropy;\n\t\t\t}\n\t\t});\n\t}\n\n\tdraw() {\n\t\tconst nbVals = this.entropy.length;\n\t\tif (nbVals < 1) {\n\t\t\treturn;\n\t\t}\n\t\tconst minVal = this.entropy.reduce((prev, curr) => (prev.value < curr.value) ? prev : curr).value;\n\t\tconst maxVal = this.entropy.reduce((prev, curr) => (prev.value > curr.value) ? prev : curr).value;\n\t\tconst width = this.width / nbVals;\n\t\tconst height = this.height;\n\n\t\tthis.svg.innerHTML = '';\n\t\tfor (let i in this.entropy)\n\t\t{\n\t\t\tconst cur = this.entropy[i];\n\t\t\tconst opacity = 0.1 + (1 - 0.1) * ((cur.value - minVal) / (maxVal - minVal));\n\n\t\t\tconst g = document.createElementNS(xmlns, 'g');\n\t\t\tg.addEventListener('click', () => { _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Wrapper.seek(cur.addr, _widgets_Widgets__WEBPACK_IMPORTED_MODULE_1__.Widgets.DISASSEMBLY); });\n\t\t\tthis.svg.appendChild(g);\n\n\t\t\tconst title = document.createElementNS(xmlns, 'title');\n\t\t\ttitle.textContent = '0x' + cur.addr.toString(16);\n\t\t\tg.appendChild(title);\n\n\t\t\tconst rect = document.createElementNS(xmlns, 'rect');\n\t\t\trect.setAttribute('x', width * i);\n\t\t\trect.setAttribute('y', 0);\n\t\t\trect.setAttribute('width', width);\n\t\t\trect.setAttribute('height', height);\n\t\t\trect.setAttribute('fill', '#000');\n\t\t\trect.setAttribute('fill-opacity', opacity);\n\n\t\t\tconst text = document.createElementNS(xmlns, 'text');\n\t\t\tconst color = (opacity > 0.4) ? '#EEEEEE' : 'black';\n\t\t\ttext.setAttribute('x', width * i + 2);\n\t\t\ttext.setAttribute('y', height + 10);\n\t\t\ttext.setAttribute('fill', color);\n\t\t\ttext.setAttribute('font-family', 'Roboto');\n\t\t\ttext.setAttribute('font-size', 12);\n\t\t\ttext.setAttribute('transform', 'rotate(-90, ' + width * i + ', ' + height + ')');\n\t\t\ttext.textContent = '0x' + cur.addr.toString(16);\n\n\t\t\tg.appendChild(rect);   \n\t\t\tg.appendChild(text);   \n\t\t}\n\t}\n\n\trefresh() {\n\t\tthis.refreshEntropy();\n\t\tthis.draw();\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/overview/EntropyCard.js?")},"./js/modules/overview/FortunesCard.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FortunesCard\": () => (/* binding */ FortunesCard)\n/* harmony export */ });\n/* harmony import */ var _helpers_Speak_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/Speak.js */ \"./js/helpers/Speak.js\");\n\n\nclass FortunesCard {\n\n\tget DOM() { return this.card; }\n\n\tconstructor() {\n\t\tthis.currentFortune = this.getNewFortune();\n\t\t(0,_helpers_Speak_js__WEBPACK_IMPORTED_MODULE_0__.speak)(this.currentFortune);\n\n\t\tthis.build();\n\t}\n\n\tbuild() {\n\t\tthis.card = document.createElement('div');\n\t\tthis.card.className = 'demo-updates mdl-card mdl-shadow--2dp mdl-cell mdl-cell--4-col mdl-cell--4-col-tablet mdl-cell--12-col-desktop';\n\n\t\tconst title = document.createElement('div');\n\t\ttitle.className = 'mdl-card__title mdl-card--expand mdl-color--teal-300';\n\t\ttitle.innerHTML = '<h2 class=\"mdl-card__title-text\">Fortunes</h2>';\n\n\t\tthis.fortuneBlock = document.createElement('div');\n\t\tthis.fortuneBlock.className = 'mdl-card__supporting-text mdl-color-text--grey-600';\n\t\tthis.fortuneBlock.innerHTML = this.currentFortune;\n\n\t\tconst action = document.createElement('div');\n\t\taction.className = 'mdl-card__actions mdl-card--border';\n\t\t\n\t\tconst refreshButton = document.createElement('a');\n\t\trefreshButton.className = 'mdl-button mdl-js-button mdl-js-ripple-effect';\n\t\trefreshButton.innerHTML = 'Next';\n\t\trefreshButton.addEventListener('click', () => this.refresh());\n\n\t\taction.appendChild(refreshButton);\n\n\t\tthis.card.appendChild(title);\n\t\tthis.card.appendChild(this.fortuneBlock);\n\t\tthis.card.appendChild(action);\n\t}\n\n\trefresh() {\n\t\tthis.currentFortune = this.getNewFortune();\n\t\tthis.fortuneBlock.innerHTML = this.currentFortune;\n\t\t(0,_helpers_Speak_js__WEBPACK_IMPORTED_MODULE_0__.speak)(this.currentFortune);\n\t}\n\n\tgetNewFortune() {\n\t\tlet fortune;\n\t\tr2.cmd('fo', function(d) {\n\t\t\tfortune = d;\n\t\t});\n\t\treturn fortune;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/overview/FortunesCard.js?")},"./js/modules/overview/GraphCard.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"GraphCard\": () => (/* binding */ GraphCard)\n/* harmony export */ });\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n/* harmony import */ var _widgets_Widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../widgets/Widgets */ \"./js/widgets/Widgets.js\");\n\n\n\n\nclass GraphCard {\n\n\tget DOM() { return this.card; }\n\n\tconstructor() {\n\t\tthis.build();\n\t}\n\n\tbuild() {\n\t\tthis.card = document.createElement('div');\n\t\tthis.card.className = 'demo-charts mdl-color--white mdl-shadow--2dp mdl-cell mdl-cell--12-col mdl-grid';\n\n\t\tconst codeChart = this.createChart('code', 'Go to assembly', undefined, 82, () => {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_1__.r2Wrapper.seek('entry0', _widgets_Widgets__WEBPACK_IMPORTED_MODULE_2__.Widgets.DISASSEMBLY);\n\t\t});\n\t\tconst dataChart = this.createChart('data', 'Go to hexdump', undefined, 22, () => {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_1__.r2Wrapper.seek('0x00', _widgets_Widgets__WEBPACK_IMPORTED_MODULE_2__.Widgets.HEXDUMP);\n\t\t});\n\t\tconst stringsChart = this.createChart('strings', 'Go to strings', undefined, 4, () => { _core_UIContext__WEBPACK_IMPORTED_MODULE_0__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_2__.Widgets.STRINGS); });\n\t\tconst functionsChart = this.createChart('functions', 'Go to functions', undefined, 82, () => { _core_UIContext__WEBPACK_IMPORTED_MODULE_0__.uiContext.navigateTo(_widgets_Widgets__WEBPACK_IMPORTED_MODULE_2__.Widgets.FUNCTIONS) });\n\n\t\tthis.card.appendChild(codeChart);\n\t\tthis.card.appendChild(dataChart);\n\t\tthis.card.appendChild(stringsChart);\n\t\tthis.card.appendChild(functionsChart);\n\t}\n\n\tcreateChart(name, title, color, value, onclick) {\n\t\tconst xmlns = \"http://www.w3.org/2000/svg\";\n\t\tconst svg = document.createElementNS(xmlns, 'svg');\n\t\tsvg.setAttribute('class', 'demo-chart mdl-cell mdl-cell--4-col mdl-cell--3-col-desktop');\n\t\tsvg.setAttribute('fill', 'currentColor');\n\t\tsvg.setAttribute('viewBox', '0 0 1 1');\n\t\tsvg.setAttribute('width', '200px');\n\t\tsvg.setAttribute('height', '200px');\n\t\tsvg.setAttribute('title', title);\n\n\t\tsvg.addEventListener('click', onclick);\n\n\t\tconst use = document.createElementNS(xmlns, 'use');\n\t\tuse.setAttributeNS('http://www.w3.org/1999/xlink', 'href', '#piechart');\n\t\tuse.setAttribute('mask', 'url(#piemask)');\n\t\tsvg.appendChild(use);\n\n\t\tconst textLegend = document.createElementNS(xmlns, 'text');\n\t\ttextLegend.setAttribute('x', '0.3');\n\t\ttextLegend.setAttribute('y', '0.2');\n\t\ttextLegend.setAttribute('font-family', 'Roboto');\n\t\ttextLegend.setAttribute('font-size', '0.1');\n\t\ttextLegend.setAttribute('fill', '#888');\n\t\ttextLegend.setAttribute('text-anchor', 'top');\n\t\ttextLegend.setAttribute('dy', '0.1');\n\t\ttextLegend.textContent = name;\n\t\tsvg.appendChild(textLegend);\n\n\t\tconst textValue = document.createElementNS(xmlns, 'text');\n\t\ttextValue.setAttribute('x', '0.5');\n\t\ttextValue.setAttribute('y', '0.5');\n\t\ttextValue.setAttribute('font-family', 'Roboto');\n\t\ttextValue.setAttribute('font-size', '0.3');\n\t\ttextValue.setAttribute('fill', '#888');\n\t\ttextValue.setAttribute('text-anchor', 'middle');\n\t\ttextValue.setAttribute('dy', '0.1');\n\t\ttextValue.textContent = value;\n\t\tsvg.appendChild(textValue);\n\n\t\tconst textPercentage = document.createElementNS(xmlns, 'tspan');\n\t\ttextPercentage.setAttribute('dy', '-0.07');\n\t\ttextPercentage.setAttribute('font-size', '0.2');\n\t\ttextPercentage.textContent = '%';\n\t\ttextValue.appendChild(textPercentage);\n\t\t\n\t\treturn svg;\n\t}\n\n\trefresh() {\n\t\t// Do nothing yet\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/overview/GraphCard.js?")},"./js/modules/overview/InfoCard.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"InfoCard\": () => (/* binding */ InfoCard)\n/* harmony export */ });\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/Format */ \"./js/helpers/Format.js\");\n/* harmony import */ var _widgets_Widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../widgets/Widgets */ \"./js/widgets/Widgets.js\");\n\n\n\nclass InfoCard {\n\n\tget DOM() { return this.card; }\n\tget nbTabs() { return this.headersCmd.length }\n\n\tconstructor(howManyPreload = 1) {\n\t\tthis.headersCmd = [\n\t\t\t{ name: 'HDR', title: 'Headers',     format: this.formatAsKeyValue, cmd: 'i|',   grep: null,   ready: false },\n\t\t\t{ name: 'SYM', title: 'Symbols',     format: this.fromatAsCode,     cmd: 'isq', grep: '!imp', ready: false },\n\t\t\t{ name: 'IMP', title: 'Imports',     format: this.fromatAsCode,     cmd: 'isq', grep: 'imp.', ready: false },\n\t\t\t{ name: 'REL', title: 'Relocations', format: this.fromatAsCode,     cmd: 'ir',  grep: null,   ready: false },\n\t\t\t{ name: 'SEC', title: 'Sections',    format: this.fromatAsCode,     cmd: 'iSq', grep: null,   ready: false },\n\t\t\t{ name: 'STR', title: 'Strings',     format: this.fromatAsCode,     cmd: 'izq', grep: null,   ready: false },\n\t\t\t{ name: 'SDB', title: 'Sdb',         format: this.fromatAsCode,     cmd: 'k bin/cur/***', grep: null, ready: false }\n\t\t];\n\n\t\tthis.build();\n\n\t\tthis.preloadTabs(howManyPreload);\n\t}\n\n\tbuild() {\n\t\tthis.card = document.createElement('div');\n\t\tthis.card.className = 'demo-graphs mdl-shadow--2dp mdl-color--white mdl-cell mdl-cell--8-col';\n\n\t\tconst tabContainer = document.createElement('div');\n\t\ttabContainer.className = 'mdl-tabs mdl-js-tabs';\n\n\t\tthis.card.appendChild(tabContainer);\n\n\t\tthis.tabs = document.createElement('div');\n\t\tthis.tabs.className = 'mdl-tabs__tab-bar overview-tabs';\n\n\t\tthis.content = document.createElement('div');\n\n\t\ttabContainer.appendChild(this.tabs);\n\t\ttabContainer.appendChild(this.content);\n\n\t\tthis.createTabs(this.headersCmd, this.tabs, this.content);\n\t}\n\n\tcreateTabs(items, tabsNode, contentNode) {\n\t\tlet first = true;\n\t\tfor (let i in items)\n\t\t{\n\t\t\tconst item = items[i];\n\t\t\tconst tabName = 'tab-' + item.name;\n\n\t\t\tconst tab = document.createElement('a');\n\t\t\ttab.classList.add('mdl-tabs__tab');\n\t\t\ttab.href = '#' + tabName;\n\t\t\ttab.title = item.title;\n\t\t\ttab.innerHTML = item.name;\n\n\t\t\tconst content = document.createElement('div');\n\t\t\tcontent.classList.add('mdl-tabs__panel');\n\t\t\tcontent.id = tabName;\n\n\t\t\tif (first) {\n\t\t\t\tcontent.classList.add('is-active');\n\t\t\t\ttab.classList.add('is-active');\n\t\t\t\tfirst = false;\n\t\t\t}\n\n\t\t\ttab.addEventListener('click', () => this.loadTab(content, item));\n\n\t\t\ttabsNode.appendChild(tab);\n\t\t\tcontentNode.appendChild(content);\n\t\t}\n\t}\n\n\tfixHeight(minHeight) {\n\t\t// First we reset height\n\t\tthis.content.style.height = '0px';\n\n\t\t// Then we measure\n\t\tconst paddings = 2 * 16;\n\t\tconst cardHeight = this.card.getBoundingClientRect().height;\n\t\tconst tabsHeight = this.tabs.getBoundingClientRect().height;\n\t\tconst height = cardHeight - tabsHeight - paddings;\n\t\tthis.content.style.height = ((height < minHeight) ? minHeight : height) + 'px';\n\t\tthis.content.style.overflow = 'auto';\n\t}\n\n\tpreloadTabs(nb) {\n\t\tnb = (nb > this.nbTabs) ? this.nbTabs : nb;\n\t\tfor (let i = 0 ; i < nb ; i++)\n\t\t\tthis.loadTab(this.content.children[i], this.headersCmd[i]);\n\t}\n\n\tloadTab(node, item) {\n\t\tif (item.ready) {\n\t\t\treturn;\n\t\t}\n\n\t\tlet cmd = item.cmd;\n\t\tif (item.grep) {\n\t\t\tcmd += '~' + item.grep;\n\t\t}\n\n\t\tr2.cmd(cmd, (d) => { \n\t\t\tnode.innerHTML = '';\n\t\t\tnode.appendChild(item.format(d));\n\t\t});\n\n\t\tif (item.cols > 1) {\n\t\t\tnode.style['-webkit-column-count'] = item.cols;\n\t\t\tnode.style['-moz-column-count'] = item.cols;\n\t\t\tnode.style['column-count'] = item.cols;\n\t\t}\n\n\t\titem.ready = true;\n\t}\n\n\trefresh() {\n\t\t// Reset all value ready=false\n\t\tfor (let i in this.headersCmd)\n\t\t\tthis.headersCmd[i].ready = false;\n\n\t\t// Reload current tab\n\t\tlet collection = [].slice.call(this.content.children);\n\t\tfor (let j in collection)\n\t\t{\n\t\t\tif (collection[j].className.indexOf('is-active') > -1)\n\t\t\t{\n\t\t\t\tthis.loadTab(collection[j], this.headersCmd[j]);\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t}\n\n\tfromatAsCode(txt) {\n\t\tconst pre = document.createElement('pre');\n\t\tpre.style.marge = '1.2em';\n\t\tpre.appendChild((0,_helpers_Format__WEBPACK_IMPORTED_MODULE_0__.formatOffsets)(txt, _widgets_Widgets__WEBPACK_IMPORTED_MODULE_1__.Widgets.DISASSEMBLY));\n\t\treturn pre;\n\t}\n\n\t/** Take a text input to give a HTML description list  */\n\tformatAsKeyValue(txt) {\n\t\tconst content = document.createElement('dl');\n\t\tcontent.classList.add('infocard');\n\n\t\tconst lines = txt.split(/\\n/g);\n\t\tfor (let i in lines) {\n\t\t\tconst line = lines[i].split(/ (.+)?/);\n\t\t\tif (line.length >= 2) {\n\t\t\t\tconst dt = document.createElement('dt');\n\t\t\t\tdt.textContent = line[0];\n\t\t\t\tcontent.appendChild(dt);\n\n\t\t\t\tconst dd = document.createElement('dd');\n\t\t\t\tdd.textContent = line[1];\n\t\t\t\tcontent.appendChild(dd);\n\t\t\t}\n\t\t}\n\t\t\n\t\treturn content;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/overview/InfoCard.js?")},"./js/modules/overview/Overview.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Overview\": () => (/* binding */ Overview)\n/* harmony export */ });\n/* harmony import */ var _AnalysisCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AnalysisCard */ \"./js/modules/overview/AnalysisCard.js\");\n/* harmony import */ var _EntropyCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./EntropyCard */ \"./js/modules/overview/EntropyCard.js\");\n/* harmony import */ var _FortunesCard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FortunesCard */ \"./js/modules/overview/FortunesCard.js\");\n/* harmony import */ var _GraphCard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./GraphCard */ \"./js/modules/overview/GraphCard.js\");\n/* harmony import */ var _InfoCard__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./InfoCard */ \"./js/modules/overview/InfoCard.js\");\n\n\n\n\n\n\nclass Overview {\n\n\tget DOM() { return this.dom; }\n\n\tconstructor() {\n\t\tthis.analysisCard = new _AnalysisCard__WEBPACK_IMPORTED_MODULE_0__.AnalysisCard();\n\t\tthis.entropyCard = new _EntropyCard__WEBPACK_IMPORTED_MODULE_1__.EntropyCard(600, 120);\n\t\tthis.fortuneCard = new _FortunesCard__WEBPACK_IMPORTED_MODULE_2__.FortunesCard();\n\t\tthis.graphCard = new _GraphCard__WEBPACK_IMPORTED_MODULE_3__.GraphCard();\n\t\tthis.infoCard = new _InfoCard__WEBPACK_IMPORTED_MODULE_4__.InfoCard();\n\n\t\tthis.build();\n\n\t\tthis.analysisCard.onAnalysis = () => {\n\t\t  this.entropyCard.refresh();\n\t\t  this.graphCard.refresh();\n\t\t  this.infoCard.refresh();\n\t\t};\n\t}\n\n\tbuild() {\n\t\tthis.dom = document.createElement('div');\n\t\tthis.dom.className = 'mdl-grid demo-content';\n\n\t\tconst rightPanelsContainer = document.createElement('div');\n\t\trightPanelsContainer.className = 'demo-cards mdl-cell mdl-cell--4-col mdl-cell--8-col-tablet mdl-grid mdl-grid--no-spacing';\n\n\t\tconst separator = document.createElement('div');\n\t\tseparator.className = 'demo-separator mdl-cell--1-col';\n\n\t\trightPanelsContainer.appendChild(this.fortuneCard.DOM);\n\t\trightPanelsContainer.appendChild(separator);\n\t\trightPanelsContainer.appendChild(this.analysisCard.DOM);\n\n\t\tthis.dom.appendChild(this.infoCard.DOM);\n\t\tthis.dom.appendChild(rightPanelsContainer);\n\t\tthis.dom.appendChild(this.entropyCard.DOM);\n\t\tthis.dom.appendChild(this.graphCard.DOM);\n\t}\n\n\trefresh() {\n\t\tthis.analysisCard.refresh();\n\t\tthis.entropyCard.refresh();\n\t\tthis.fortuneCard.refresh();\n\t\tthis.graphCard.refresh();\n\t\tthis.infoCard.refresh();\n\t}\n\n\tadjustLayout() {\n\t\twindow.addEventListener('resize', () => this.infoCard.fixHeight(300), true);\n\t\tthis.infoCard.fixHeight(300);\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/modules/overview/Overview.js?")},"./js/widgets/BasePreWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BasePreWidget\": () => (/* binding */ BasePreWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n/**\n * Very simple Widget designed to handle RAW content from R2\n * Would be eventually formatted then encapsulated with <pre> \n */\nclass BasePreWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\n\t/**\n\t * Creates an instance of BasePreWidget.\n\t * @param {any} name Name of the widget, displayed on the top bar\n\t * @param {any} formatFunc Function used to format the r2cmd output (used as innerHTML)\n\t * @param {any} r2cmd Command executed to obtain the output\n\t * @param {any} [backButton=null] Optional button to be inserted into the widget\n\t */\n\tconstructor(name, formatFunc, r2cmd, backButton = null) {\n\t\tsuper(name, 'dark');\n\t\tthis.formatFunc = formatFunc;\n\t\tthis.r2cmd = r2cmd;\n\t\tif (backButton !== null)\n\t\t\tthis.backButton = backButton;\n\t}\n\n\t/** @override */\n\tinit() {\n\t\tif (typeof this.backButton === 'undefined') {\n\t\t\treturn;\n\t\t}\n\t\tthis.backButton.style.position = 'absolute';\n\t\tthis.backButton.style.top = '1em';\n\t\tthis.backButton.style.left = '1em';\n\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.R2Actions.SEEK, () => {\n\t\t\tif (this.displayed) {\n\t\t\t\tthis.draw();\n\t\t\t}\n\t\t});\n\t}\n\n\t/** @override */\n\tdraw() {\n\t\tif (typeof this.backButton !== 'undefined') {\n\t\t\tthis.node.appendChild(this.backButton);\n\t\t}\n\t\tthis.node.appendChild(this.getPre());\n\t}\n\n\t/** Format text from registered r2cmd and provides a <pre> element */\n\tgetPre() {\n\t\tconst pre = document.createElement('pre');\n\t\tr2.cmd(this.r2cmd, output => {\n\t\t\tpre.appendChild(this.formatFunc(output));\n\t\t});\n\t\treturn pre;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/BasePreWidget.js?")},"./js/widgets/BaseWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BaseWidget\": () => (/* binding */ BaseWidget)\n/* harmony export */ });\n/**\n * BaseWidget is an abstract class which wrap a Widget\n * This abstraction ensure two concerns:\n *  - A Widget can be instanciated several times if we want\n *  - A Widget shouldn't be bothered by dimension change (TODO)\n */\nclass BaseWidget {\n\n\t/** Node provided by UIContext to draw content */\n\tget rootNode() { return this._rootNode; }\n\n\t/** Node provided by the Widget to draw content */\n\tget node() { return this._node; }\n\n\t/** Pass the widgetContainer instance with name of the widget */\n\tconstructor(name, ...classNames) {\n\t\tthis.name = name;\n\t\tthis.classNames = classNames;\n\t\tthis.classNames.push('rwidget');\n\t\tthis.init();\n\n\t\tthis.focused = false;\n\t\tthis.displayed = false;\n\t}\n\n\t/** Init the module used inside component, called once */\n\tinit() { }\n\n\t/** Define what should be done to render the Widget */\n\tdrawWidget(destinationNode, ...args) {\n\t\tthis._node = destinationNode;\n\t\tthis._rootNode = destinationNode;\n\t\tthis._rootNode.focus();\n\n\t\t// Set state\n\t\tthis.displayed = true;\n\t\tthis.focused = true;\n\n\t\t// Clear previous content\n\t\tthis._node.innerHTML = '';\n\t\tthis._node.className = '';\n\n\t\t// Apply CSS classes\n\t\tthis.classNames.forEach(className => this._rootNode.classList.add(className));\n\n\t\t// Insert content\n\t\tthis.draw(...args);\n\t}\n\n\t/** Method to insert content to Widget.node */\n\tdraw(...args) { }\n\n\t/** When focus is gained */\n\tgotFocus() {\n\t\tthis.gotDisplay();\n\t\tthis.focused = true;\n\t}\n\n\t/** When focus is lost */\n\tlostFocus() {\n\t\tthis.focused = false;\n\t}\n\n\t/** When widget is displayed */\n\tgotDisplay() {\n\t\tthis.displayed = true;\n\t}\n\n\t/** When widget is replaced */\n\tlostDisplay() {\n\t\tthis.lostFocus();\n\t\tthis.displayed = false;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/BaseWidget.js?")},"./js/widgets/CommentsWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"CommentsWidget\": () => (/* binding */ CommentsWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Widgets */ \"./js/widgets/Widgets.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _helpers_Table__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/Table */ \"./js/helpers/Table.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n\n\n\n\nclass CommentsWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Comments');\n\t}\n\n\tinit() {\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_5__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_5__.R2Actions.SEEK, () => {\n\t\t\tif (this.displayed) {\n\t\t\t\tthis.draw();\n\t\t\t}\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.node.innerHTML = '';\n\t\tthis.node.appendChild(this.getPanel());\n\t}\n\n\tgetPanel() {\n\t\tvar c = document.createElement('div');\n\n\t\tvar header = document.createElement('div');\n\t\theader.style.position = 'fixed';\n\t\theader.style.margin = '0.5em';\n\t\tc.appendChild(header);\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_3__.Inputs.button('Notes', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_2__.Widgets.NOTES)));\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.style.paddingTop = '70px';\n\t\tc.appendChild(content);\n\n\t\tr2.cmd('CC', (d) => {\n\t\t\tvar table = new _helpers_Table__WEBPACK_IMPORTED_MODULE_4__.Table(\n\t\t\t\t['+Offset', '~Comment'],\n\t\t\t\t[true, false],\n\t\t\t\t'commentsTable',\n\t\t\t\t(row, newVal) => {\n\t\t\t\t\tvar offset = row[0];\n\n\t\t\t\t\t// remove\n\t\t\t\t\tr2.cmd('CC- @ ' + offset);\n\n\t\t\t\t\t// add new\n\t\t\t\t\tr2.cmd('CCu base64:' + window.btoa(newVal) + ' @ ' + offset);\n\n\t\t\t\t\tthis.draw();\n\t\t\t\t},\n\t\t\t\t_Widgets__WEBPACK_IMPORTED_MODULE_2__.Widgets.HEXDUMP);\n\n\t\t\tvar lines = d.split(/\\n/); //clickable offsets (d).split (/\\n/);\n\t\t\tfor (var i in lines) {\n\t\t\t\tvar line = lines[i].split(/ (.+)?/);\n\t\t\t\tif (line.length >= 2) {\n\t\t\t\t\ttable.addRow([line[0], line[1]]);\n\t\t\t\t}\n\t\t\t}\n\t\t\ttable.insertInto(content);\n\t\t});\n\n\t\treturn c;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/CommentsWidget.js?")},"./js/widgets/DebuggerWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DebuggerWidget\": () => (/* binding */ DebuggerWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/Format */ \"./js/helpers/Format.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n\nclass DebuggerWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Debugger', 'dark');\n\t}\n\n\tinit() {\n\t\tthis.inColor = true; // TODO\n\t\tthis.nativeDebugger = false;\n\t\tr2.cmd('e cfg.debug', (x) => {\n\t\t\tthis.nativeDebugger = (x.trim() === 'true');\n\t\t});\n\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__.R2Actions.SEEK, () => {\n\t\t\tif (!this.displayed) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tthis.draw();\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.node.innerHTML = '';\n\t\tthis.node.scrollTop = 0;\n\t\tthis.node.appendChild(this.getPanel());\n\t}\n\n\tgetPanel() {\n\t\tvar c = document.createElement('div');\n\t\tif (this.inColor) {\n\t\t\tc.style.backgroundColor = '#202020';\n\t\t}\n\n\t\tvar header = document.createElement('div');\n\t\theader.style.position = 'fixed';\n\t\theader.style.margin = '0.5em';\n\t\tc.appendChild(header);\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.iconButton('keyboard_arrow_up', 'UP', () => r2.cmd('s--', () => this.draw())));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.iconButton('keyboard_arrow_down', 'DOWN', () => r2.cmd('s++', () => this.draw())));\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('PC', () => r2.cmd('sr pc', () => this.draw())));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Step', () => r2.cmd(this.nativeDebugger ? 'ds' : 'aes', () => this.draw())));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Cont', () => r2.cmd(this.nativeDebugger ? 'dc' : 'aec', () => this.draw())));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('BP', () => r2.cmd('db $$', () => this.draw())));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('REG', () => {\n\t\t\tvar expr = prompt('register=value');\n\t\t\tif (this.nativeDebugger) {\n\t\t\t\tr2.cmd('dr ' + expr + ';.dr*', () => this.draw());\n\t\t\t} else {\n\t\t\t\tr2.cmd('aer ' + expr + ';.ar*', () => this.draw());\n\t\t\t}\n\t\t}));\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.style.paddingTop = '50px';\n\t\tc.appendChild(content);\n\n\t\t// stack\n\t\tconst rcmd = (this.nativeDebugger) ? 'dr' : 'ar';\n\t\tr2.cmd('f cur;.' + rcmd + '*;sr sp;px 64', function(d) {\n\t\t\tconst pre = document.createElement('pre');\n\t\t\tpre.style.margin = '10px';\n\t\t\tpre.style.color = 'grey';\n\t\t\tpre.appendChild((0,_helpers_Format__WEBPACK_IMPORTED_MODULE_2__.formatOffsets)(d));\n\t\t\tcontent.appendChild(pre);\t\t\t\n\t\t});\n\t\tr2.cmd(rcmd + '=;s cur;f-cur;pd 128' + (this.inColor ? '|H' : ''), function(d) {\n\t\t\tconst pre = document.createElement('pre');\n\t\t\tpre.style.color = 'grey';\n\t\t\tpre.appendChild((0,_helpers_Format__WEBPACK_IMPORTED_MODULE_2__.formatOffsets)(d));\n\t\t\tcontent.appendChild(pre);\t\n\t\t});\n\n\t\treturn c;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/DebuggerWidget.js?")},"./js/widgets/DisassemblyBlocksWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "DisassemblyBlocksWidget": () => (/* binding */ DisassemblyBlocksWidget)\n/* harmony export */ });\n/* harmony import */ var _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BasePreWidget */ "./js/widgets/BasePreWidget.js");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ "./js/helpers/Inputs.js");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/UIContext */ "./js/core/UIContext.js");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Widgets */ "./js/widgets/Widgets.js");\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/Format */ "./js/helpers/Format.js");\n\n\n\n\n\n\n\nconst inColor = true; // TODO inColor\n\nclass DisassemblyBlocksWidget extends _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__.BasePreWidget {\n\tconstructor() {\n\t\tsuper(\n\t\t\t\'Blocks\',\n\t\t\tx => (0,_helpers_Format__WEBPACK_IMPORTED_MODULE_4__.formatOffsets)(x),\n\t\t\t\'pdr|H\',\n\t\t\t_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.iconButton(\'undo\', \'Back to Disassembly\', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_2__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.DISASSEMBLY)));\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/DisassemblyBlocksWidget.js?')},"./js/widgets/DisassemblyDecompileWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "DisassemblyDecompileWidget": () => (/* binding */ DisassemblyDecompileWidget)\n/* harmony export */ });\n/* harmony import */ var _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BasePreWidget */ "./js/widgets/BasePreWidget.js");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ "./js/helpers/Inputs.js");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/UIContext */ "./js/core/UIContext.js");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Widgets */ "./js/widgets/Widgets.js");\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/Format */ "./js/helpers/Format.js");\n\n\n\n\n\n\n\nconst inColor = true; // TODO inColor\n\nclass DisassemblyDecompileWidget extends _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__.BasePreWidget {\n\tconstructor() {\n\t\tsuper(\n\t\t\t\'Decompile\',\n\t\t\tx => (0,_helpers_Format__WEBPACK_IMPORTED_MODULE_4__.formatOffsets)(x),\n\t\t\t\'pdc|H\',\n\t\t\t_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.iconButton(\'undo\', \'Back to Disassembly\', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_2__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.DISASSEMBLY)));\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/DisassemblyDecompileWidget.js?')},"./js/widgets/DisassemblyFunctionsFullWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "DisassemblyFunctionsFullWidget": () => (/* binding */ DisassemblyFunctionsFullWidget)\n/* harmony export */ });\n/* harmony import */ var _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BasePreWidget */ "./js/widgets/BasePreWidget.js");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ "./js/helpers/Inputs.js");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/UIContext */ "./js/core/UIContext.js");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Widgets */ "./js/widgets/Widgets.js");\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/Format */ "./js/helpers/Format.js");\n\n\n\n\n\n\n\nconst inColor = true; // TODO inColor\n\nclass DisassemblyFunctionsFullWidget extends _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__.BasePreWidget {\n\tconstructor() {\n\t\tsuper(\n\t\t\t\'Functions (full)\',\n\t\t\tx => (0,_helpers_Format__WEBPACK_IMPORTED_MODULE_4__.formatOffsets)(x),\n\t\t\t\'pD $SS@$S@e:scr.color=2\',\n\t\t\t_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.iconButton(\'undo\', \'Back to Disassembly\', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_2__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.DISASSEMBLY)));\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/DisassemblyFunctionsFullWidget.js?')},"./js/widgets/DisassemblyFunctionsWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DisassemblyFunctionsWidget\": () => (/* binding */ DisassemblyFunctionsWidget)\n/* harmony export */ });\n/* harmony import */ var _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BasePreWidget */ \"./js/widgets/BasePreWidget.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Widgets */ \"./js/widgets/Widgets.js\");\n\n\n\n\n\n\nconst inColor = true; // TODO inColor\n\nclass DisassemblyFunctionsWidget extends _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__.BasePreWidget {\n\tconstructor() {\n\t\tsuper(\n\t\t\t'Functions',\n\t\t\tx => {\n\t\t\t\tconst container = document.createElement('span');\n\t\t\t\tcontainer.innerHTML = x;\n\t\t\t\treturn container;\n\t\t\t},\n\t\t\t'pdf @e:asm.lines.width=0|H',\n\t\t\t_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.iconButton('undo', 'Back to Disassembly', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_2__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.DISASSEMBLY)));\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/DisassemblyFunctionsWidget.js?")},"./js/widgets/DisassemblyGraphWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DisassemblyGraphWidget\": () => (/* binding */ DisassemblyGraphWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Widgets */ \"./js/widgets/Widgets.js\");\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/Format */ \"./js/helpers/Format.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n\n\n\n\nconst inColor = true; // TODO inColor\n\nclass DisassemblyGraphWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Graph', 'dark');\n\t}\n\n\tinit() {\n\t\tthis.backButton = _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.iconButton('undo', 'Back to Disassembly', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_2__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.DISASSEMBLY));\n\t\tthis.backButton.style.position = 'absolute';\n\t\tthis.backButton.style.top = '1em';\n\t\tthis.backButton.style.left = '1em';\n\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_5__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_5__.R2Actions.SEEK, () => {\n\t\t\tif (this.displayed) {\n\t\t\t\tthis.draw();\n\t\t\t}\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.node.appendChild(this.backButton);\n\t\tthis.node.appendChild(this.getGraph());\n\t}\n\n\tgetGraph() {\n\t\tconst graph = document.createElement('div');\n\t\tgraph.style.overflow = 'auto';\n\t\tgraph.setAttribute(\n\t\t\t'content',\n\t\t\t'user-scalable=yes, width=device-width, minimum-scale=1, maximum-scale=1'\n\t\t);\n\n\t\tvar tail = inColor ? '|H': '';\n\t\tr2.cmd('agf' + tail, (d) => {\n\t\t\tconst pre = document.createElement('pre');\n\t\t\tpre.style.color = inColor ? 'white' : 'black';\n\t\t\tpre.appendChild((0,_helpers_Format__WEBPACK_IMPORTED_MODULE_4__.formatOffsets)(d))\n\t\t\tgraph.appendChild(pre);\n\t\t});\n\n\t\treturn graph;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/DisassemblyGraphWidget.js?")},"./js/widgets/DisassemblyInfosWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DisassemblyInfosWidget\": () => (/* binding */ DisassemblyInfosWidget)\n/* harmony export */ });\n/* harmony import */ var _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BasePreWidget */ \"./js/widgets/BasePreWidget.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Widgets */ \"./js/widgets/Widgets.js\");\n\n\n\n\n\n\nconst inColor = true; // TODO inColor\n\nclass DisassemblyInfosWidget extends _BasePreWidget__WEBPACK_IMPORTED_MODULE_0__.BasePreWidget {\n\tconstructor() {\n\t\tsuper(\n\t\t\t'Infos',\n\t\t\tx => {\n\t\t\t\tconst container = document.createElement('span');\n\t\t\t\tcontainer.innerHTML = x;\n\t\t\t\treturn container;\n\t\t\t},\t\t\t'afi',\n\t\t\t_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.iconButton('undo', 'Back to Disassembly', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_2__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.DISASSEMBLY)));\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/DisassemblyInfosWidget.js?")},"./js/widgets/DisassemblyWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "DisassemblyWidget": () => (/* binding */ DisassemblyWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ "./js/widgets/BaseWidget.js");\n/* harmony import */ var _modules_disasm_Disassembly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../modules/disasm/Disassembly */ "./js/modules/disasm/Disassembly.js");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/R2Wrapper */ "./js/core/R2Wrapper.js");\n\n\n\n\nclass DisassemblyWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\n\tconstructor() {\n\t\tsuper(\'Disassembly\', \'disasmPanel\', \'dark\');\n\t}\n\n\tinit() {\n\t\tthis.firstTime = true;\n\t}\n\n\tdraw() {\n\t\tif (this.firstTime) {\n\t\t\tthis.disasm = new _modules_disasm_Disassembly__WEBPACK_IMPORTED_MODULE_1__.Disassembly(this.node, 24);\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.R2Actions.SEEK, () => {\n\t\t\t\tif (!this.displayed) return;\n\t\t\t\tthis.disasm.refreshInitialOffset();\n\t\t\t\tthis.disasm.resetContainer(this.node);\n\t\t\t\tthis.disasm.draw();\n\t\t\t\tthis.disasm.onSeek();\n\t\t\t});\n\t\t\tthis.firstTime = false;\n\t\t} else {\n\t\t\tthis.disasm.resetContainer(this.node);\n\t\t}\n\n\t\tthis.disasm.draw();\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/DisassemblyWidget.js?')},"./js/widgets/FlagsSpacesWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FlagsSpacesWidget\": () => (/* binding */ FlagsSpacesWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Widgets */ \"./js/widgets/Widgets.js\");\n/* harmony import */ var _helpers_Table__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/Table */ \"./js/helpers/Table.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n\n\n\n\n\n\n\n\nclass FlagsSpacesWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tactiveEls = [];\n\t\n\tconstructor() {\n\t\tsuper('Flag Spaces');\n\t}\n\n\tinit() {\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.R2Actions.SEEK, () => {\n\t\t\tif (!this.displayed) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tthis.draw();\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.node.innerHTML = '';\n\t\tthis.node.scrollTop = 0;\n\t\tthis.current = null;\n\t\tthis.node.appendChild(this.getPanel());\n\t}\n\t\n\tgetPanel() {\n\t\tvar c = document.createElement('div');\n\t\tif (this.inColor) {\n\t\t\tc.style.backgroundColor = '#202020';\n\t\t}\n\n\t\tvar header = document.createElement('div');\n\t\theader.style.position = 'fixed';\n\t\theader.style.margin = '0.5em';\n\t\tc.appendChild(header);\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.iconButton('undo', 'Back to flags', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.FLAGS)));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.button('Deselect', () => { this.current = null; r2.cmd('fs *', () => this.draw()); } ));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.button('Add', () => this.setFlagspace()));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.button('Delete', () => this.delFlagspace()));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.button('Rename', () => this.renameFlagspace()));\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.appendChild(document.createTextNode('Click on a row to select it.'));\n\t\tcontent.style.paddingTop = '70px';\n\t\tc.appendChild(content);\n\n\t\tr2.cmd('fsj', (d) => {\n\t\t\tconst data = JSON.parse(d);\n\t\t\tconst table = new _helpers_Table__WEBPACK_IMPORTED_MODULE_4__.Table(\n\t\t\t\t['+Flags', 'Flagspace'],\n\t\t\t\t[true, false],\n\t\t\t\t'flagspaceTable');\n\n\t\t\tthis.activeEls = this.activeEls.filter(e => {\n\t\t\t\te.classList.remove(['active']);\n\t\t\t\treturn false;\n\t\t\t});\n\n\t\t\tdata.map( x => {\n\t\t\t\tconst a = document.createElement('a');\n\t\t\t\ta.textContent = x.name;\n\t\t\t\tif (x.selected){\n\t\t\t\t\ta.classList.add(['active']);\n\t\t\t\t\tthis.activeEls.push(a);\n\t\t\t\t}\n\n\t\t\t\ta.addEventListener('click', (e) => {\n\t\t\t\t\tconsole.log(x.name, e);\n\t\t\t\t\tr2.cmd('fs ' + x.name, (h)=>{\n\t\t\t\t\t\tthis.activeEls = this.activeEls.filter(e => {\n\t\t\t\t\t\t\te.classList.remove(['active']);\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t});\n\t\t\t\t\t\ta.classList.add(['active']);\n\t\t\t\t\t\tthis.activeEls.push(a);\n\t\t\t\t\t});\n\t\t\t\t\tthis.draw();\n\t\t\t\t});\n\n\t\t\t\tconst row = table.addRow([x.count, a]);\n\t\t\t\trow.addEventListener('click', () => {\n\t\t\t\t\ttable.getRows().forEach((curRow) => {\n\t\t\t\t\t\tcurRow.classList.remove('active');\n\t\t\t\t\t});\n\t\t\t\t\trow.classList.add('active');\n\t\t\t\t\tthis.current = x.name;\n\t\t\t\t});\n\t\t\t});\n\t\t\ttable.insertInto(content);\n\t\t});\n\n\t\treturn c;\n\t}\n\n\tsetFlagspace() {\n\t\tlet fs = this.current;\n\t\tif (!fs) {\n\t\t\tfs = prompt('name');\n\t\t}\n\t\tif (!fs) {\n\t\t\treturn;\n\t\t}\n\t\tr2.cmd('fs ' + fs, () => {\n\t\t\tthis.draw();\n\t\t});\n\t}\n\n\trenameFlagspace() {\n\t\tlet fs = this.current;\n\t\tif (!fs) {\n\t\t\tfs = prompt('name');\n\t\t}\n\t\tif (!fs) {\n\t\t\treturn;\n\t\t}\n\t\tr2.cmd('fsr ' + fs, () => {\n\t\t\tthis.draw();\n\t\t});\n\t}\n\n\n\tdelFlagspace() {\n\t\tlet fs = this.current;\n\t\tif (!fs) {\n\t\t\tfs = '.';\n\t\t}\n\t\tif (!fs) {\n\t\t\treturn;\n\t\t}\n\t\tr2.cmd('fs-' + fs, () => {\n\t\t\tthis.draw();\n\t\t});\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/FlagsSpacesWidget.js?")},"./js/widgets/FlagsWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FlagsWidget\": () => (/* binding */ FlagsWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Widgets */ \"./js/widgets/Widgets.js\");\n/* harmony import */ var _helpers_Table__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/Table */ \"./js/helpers/Table.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n\n\n\n\n\n\n\n\nclass FlagsWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Flags');\n\t}\n\n\tinit() {\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.R2Actions.SEEK, () => {\n\t\t\tif (!this.displayed) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tthis.draw();\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.node.innerHTML = '';\n\t\tthis.node.scrollTop = 0;\n\t\tthis.node.appendChild(this.getPanel());\n\t}\n\t\n\tgetPanel() {\n\t\tvar c = document.createElement('div');\n\t\tif (this.inColor) {\n\t\t\tc.style.backgroundColor = '#202020';\n\t\t}\n\n\t\tvar header = document.createElement('div');\n\t\theader.style.position = 'fixed';\n\t\theader.style.margin = '0.5em';\n\t\tc.appendChild(header);\n\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.button('Spaces', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.FLAGS_SPACE)));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_5__.Inputs.button('Delete All', () => r2.cmd('f-*', () => this.draw())));\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.style.paddingTop = '50px';\n\t\tc.appendChild(content);\n\n\t\tr2.cmd('fj', function(d) {\n\t\t\tlet data = JSON.parse(d);\n\t\t\tvar table = new _helpers_Table__WEBPACK_IMPORTED_MODULE_4__.Table(\n\t\t\t\t['+Offset', 'Size', 'Name'],\n\t\t\t\t[true, true, false],\n\t\t\t\t'flagsTable',\n\t\t\t\tnull,\n\t\t\t\t_Widgets__WEBPACK_IMPORTED_MODULE_3__.Widgets.HEXDUMP);\n\n\t\t\tdata.map(x => {\n\t\t\t\ttable.addRow(['0x'+x.offset.toString(16), x.size, x.name])\n\t\t\t\t//table.addRow(Object.values(x))\n\t\t\t});\n\t\t\ttable.insertInto(content);\n\t\t});\n\n\t\treturn c;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/FlagsWidget.js?")},"./js/widgets/FunctionsWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FunctionsWidget\": () => (/* binding */ FunctionsWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _helpers_Table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/Table */ \"./js/helpers/Table.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n/* harmony import */ var _widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../widgets/Widgets */ \"./js/widgets/Widgets.js\");\n\n\n\n\n\n\nclass FunctionsWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Functions');\n\t}\n\n\tinit() {\n\t\tthis.inColor = true; // TODO\n\t\t// r2.cmd('e scr.utf8=false');\n\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__.R2Actions.SEEK, () => {\n\t\t\tif (!this.displayed) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tthis.draw();\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.node.innerHTML = '';\n\t\tthis.node.scrollTop = 0;\n\t\tthis.node.appendChild(this.getPanel());\n\t}\n\n\tgetPanel() {\n\t\tvar c = document.createElement('div');\n\n\t\tvar header = document.createElement('div');\n\t\theader.style.position = 'fixed';\n\t\theader.style.margin = '0.5em';\n\t\tc.appendChild(header);\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Symbols', () => {\n\t\t\tstatusMessage('Analyzing symbols...');\n\t\t\tr2.cmd('aa', () => {\n\t\t\t\tstatusMessage('done');\n\t\t\t\tthis.draw();\n\t\t\t});\n\t\t}));\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Calls', () => {\n\t\t\tstatusMessage('Analyzing calls...');\n\t\t\tr2.cmd('aac', () => {\n\t\t\t\tstatusMessage('done');\n\t\t\t\tthis.draw();\n\t\t\t});\n\t\t}));\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Function', () => {\n\t\t\tstatusMessage('Analyzing function...');\n\t\t\tr2.cmd('af', () => {\n\t\t\t\tstatusMessage('done');\n\t\t\t\tthis.draw();\n\t\t\t});\n\t\t}));\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Refs', () => {\n\t\t\tstatusMessage('Analyzing references...');\n\t\t\tr2.cmd('aar', () => {\n\t\t\t\tstatusMessage('done');\n\t\t\t\tthis.draw();\n\t\t\t});\n\t\t}));\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('AutoName', () => {\n\t\t\tstatusMessage('Analyzing names...');\n\t\t\tr2.cmd('.afna @@ fcn.*', () => {\n\t\t\t\tstatusMessage('done');\n\t\t\t\tthis.draw();\n\t\t\t});\n\t\t}));\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.style.paddingTop = '70px';\n\t\tc.appendChild(content);\n\n\t\tr2.cmd('afl', function(d) {\n\t\t\tvar table = new _helpers_Table__WEBPACK_IMPORTED_MODULE_2__.Table(\n\t\t\t\t['+Address', 'Name', 'Size', 'CC'],\n\t\t\t\t[false, true, false, false],\n\t\t\t\t'functionTable',\n\t\t\t\tnull,\n\t\t\t\t_widgets_Widgets__WEBPACK_IMPORTED_MODULE_4__.Widgets.DISASSEMBLY);\n\n\t\t\tvar lines = d.split(/\\n/); //clickable offsets (d).split (/\\n/);\n\t\t\tfor (var i in lines) {\n\t\t\t\tvar items = lines[i].match(/^(0x[0-9a-f]+)\\s+([0-9]+)\\s+([0-9]+(\\s+\\-&gt;\\s+[0-9]+)?)\\s+(.+)$/);\n\t\t\t\tif (items !== null) {\n\t\t\t\t\ttable.addRow([items[1], items[5], items[2], items[3]]);\n\t\t\t\t}\n\t\t\t}\n\t\t\ttable.insertInto(content);\n\t\t});\n\n\t\treturn c;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/FunctionsWidget.js?")},"./js/widgets/HexdumpWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"HexdumpWidget\": () => (/* binding */ HexdumpWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _modules_hexdump_Hexdump__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../modules/hexdump/Hexdump */ \"./js/modules/hexdump/Hexdump.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\nclass HexdumpWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Hexdump', 'dark');\n\t}\n\n\tinit() {\n\t\tr2.cmd('e cfg.bigendian', b => { this.isBigEndian = (b === 'true'); });\n\t\tthis.firstTime = true;\n\t}\n\n\tdraw() {\n\t\tif (this.firstTime) {\n\t\t\tthis.firstTime = false;\n\t\t\tthis.hexdump = new _modules_hexdump_Hexdump__WEBPACK_IMPORTED_MODULE_1__.Hexdump(this.node, 16, this.isBigEndian);\n\t\t\tthis.hexdump.setOnChangeCallback(function (offset, before, after) {\n\t\t\t\tconsole.log('changed');\n\t\t\t});\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.R2Actions.SEEK, () => {\n\t\t\t\tif (!this.displayed) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tthis.hexdump.refreshInitialOffset();\n\t\t\t\tthis.hexdump.resetContainer(this.node);\n\t\t\t\tthis.hexdump.draw();\n\t\t\t});\n\t\t} else {\n\t\t\tthis.hexdump.resetContainer(this.node);\n\t\t}\n\n\t\tthis.hexdump.draw();\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/HexdumpWidget.js?")},"./js/widgets/NotesWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"NotesWidget\": () => (/* binding */ NotesWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Widgets */ \"./js/widgets/Widgets.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n\n\n\nclass NotesWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Notes');\n\t}\n\n\tinit() {\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_4__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_4__.R2Actions.SEEK, () => {\n\t\t\tif (this.displayed) {\n\t\t\t\tthis.draw();\n\t\t\t}\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.node.appendChild(this.getPanel());\n\t}\n\n\tgetPanel() {\n\t\tvar c = document.createElement('div');\n\n\t\tvar header = document.createElement('div');\n\t\theader.style.position = 'fixed';\n\t\theader.style.margin = '0.5em';\n\t\tc.appendChild(header);\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_3__.Inputs.iconButton('undo', 'Back to Comments', () => _core_UIContext__WEBPACK_IMPORTED_MODULE_1__.uiContext.navigateTo(_Widgets__WEBPACK_IMPORTED_MODULE_2__.Widgets.COMMENTS)));\n\n\t\tvar content = document.createElement('div');\n\t\tcontent.style.paddingTop = '70px';\n\t\tcontent.innerHTML = '<textarea rows=32 style=\"width:100%;height:100%\"></textarea>';\n\t\tc.appendChild(content);\n\n\t\treturn c;\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/NotesWidget.js?")},"./js/widgets/OverviewWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "OverviewWidget": () => (/* binding */ OverviewWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ "./js/widgets/BaseWidget.js");\n/* harmony import */ var _modules_overview_Overview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../modules/overview/Overview */ "./js/modules/overview/Overview.js");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/R2Wrapper */ "./js/core/R2Wrapper.js");\n\n\n\n\n/**\n * @class OverviewWidget\n * @extends {BaseWidget}\n */\nclass OverviewWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\n\t/** Creates an instance of OverviewWidget */\n\tconstructor() {\n\t\tsuper(\'Overview\');\n\t}\n\n\t/** @override*/\n\tinit() {\n\t\tthis.overview = new _modules_overview_Overview__WEBPACK_IMPORTED_MODULE_1__.Overview();\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_2__.R2Actions.SEEK, () => {\n\t\t\tif (this.displayed) {\n\t\t\t\tthis.draw();\n\t\t\t}\n\t\t});\n\t}\n\n\t/** @override*/\n\tdraw(...args) {\n\t\tthis.node.appendChild(this.overview.DOM);\n\t\tthis.overview.adjustLayout();\n\t\tcomponentHandler.upgradeDom();\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/OverviewWidget.js?')},"./js/widgets/ScriptWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ScriptWidget\": () => (/* binding */ ScriptWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _core_UIContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/UIContext */ \"./js/core/UIContext.js\");\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Widgets */ \"./js/widgets/Widgets.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n\n\n\nclass ScriptWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Script');\n\t}\n\n\tinit() {\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_4__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_4__.R2Actions.SEEK, () => {\n\t\t\tif (this.displayed) {\n\t\t\t\tthis.draw();\n\t\t\t}\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.toggleFoo = '';\n\t\tthis.node.appendChild(this.getPanel());\n\t}\n\n\tgetPanel() {\n\t\tvar c = document.createElement('div');\n\n\t\tc.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_3__.Inputs.button('Run', () => this.runScript()));\n\t\tc.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_3__.Inputs.button('Indent', () => this.indentScript()));\n\t\tc.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_3__.Inputs.button('Output', () => this.toggleScriptOutput()));\n\t\t// c.appendChild(Inputs.button('Console', () => uiContext.navigateTo(Widgets.CONSOLE)));\n\n\t\tc.appendChild(document.createElement('br'));\n\n\t\tconst textarea = document.createElement('textarea');\n\t\ttextarea.id = 'script';\n\t\ttextarea.rows = 20;\n\t\ttextarea.className = 'pre';\n\t\ttextarea.style.width = '100%';\n\t\tc.appendChild(textarea);\n\n\t\tc.appendChild(document.createElement('br'));\n\n\t\tconst output = document.createElement('div');\n\t\toutput.id = 'scriptOutput';\n\t\toutput.className = 'output';\n\t\tc.appendChild(output);\n\t\t\n\t\tvar localScript = localStorage.getItem('script');\n\t\tif (!localScript) {\n\t\t\tlocalScript = 'r2.cmd(\"?V\", log);';\n\t\t}\n\t\ttextarea.value = localScript;\n\n\t\treturn c;\n\t}\n\n\ttoggleScriptOutput() {\n\t\tvar o = document.getElementById('scriptOutput');\n\t\tif (o) {\n\t\t\tif (this.toggleFoo === '') {\n\t\t\t\tthis.toggleFoo = o.innerHTML;\n\t\t\t\to.innerHTML = '';\n\t\t\t} else {\n\t\t\t\to.innerHTML = this.toggleFoo;\n\t\t\t\tthis.toggleFoo = '';\n\t\t\t}\n\t\t}\n\t}\n\n\tindentScript() {\n\t\tvar str = document.getElementById('script').value;\n\t\tvar indented = /* NOT DEFINED js_beautify*/ (str);\n\t\tdocument.getElementById('script').value = indented;\n\t\tlocalStorage.script = indented;\n\t}\n\n\trunScript() {\n\t\tvar str = document.getElementById('script').value;\n\t\tlocalStorage.script = str;\n\t\tdocument.getElementById('scriptOutput').innerHTML = '';\n\t\ttry {\n\t\t\tvar msg = '\"use strict\";' +\n\t\t\t'function log(x) { var a = ' +\n\t\t\t'document.getElementById(\\'scriptOutput\\'); ' +\n\t\t\t'if (a) a.innerHTML += x + \\'\\\\n\\'; }\\n';\n\t\t\t// CSP violation here\n\t\t\teval(msg + str);\n\t\t} catch (e) {\n\t\t\talert(e);\n\t\t}\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/ScriptWidget.js?")},"./js/widgets/SearchWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"SearchWidget\": () => (/* binding */ SearchWidget)\n/* harmony export */ });\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n/* harmony import */ var _helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/Inputs */ \"./js/helpers/Inputs.js\");\n/* harmony import */ var _helpers_Format__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/Format */ \"./js/helpers/Format.js\");\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n\n\n\n\n\nfunction searchResults(d) {\n\tconst node = document.getElementById('search_output');\n\tnode.innerHTML = \"\";\n\tnode.appendChild((0,_helpers_Format__WEBPACK_IMPORTED_MODULE_2__.formatOffsets)(d));\n}\n\nclass SearchWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_0__.BaseWidget {\n\tconstructor() {\n\t\tsuper('Search');\n\t}\n\n\tinit() {\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_3__.R2Actions.SEEK, () => {\n\t\t\tif (this.displayed) {\n\t\t\t\tthis.draw();\n\t\t\t}\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.node.appendChild(this.getPanel());\n\t}\n\n\tgetPanel() {\n\t\tconst c = document.createElement('div');\n\t\tvar header = document.createElement('div');\n\t\theader.style.margin = '0.5em';\n\t\tc.appendChild(header);\n\n\t\tconst form = document.createElement('input');\n\t\tform.id = 'search_input';\n\t\tform.className = 'mdl-card--expand mdl-textfield__input';\n\t\tform.style.backgroundColor = 'white';\n\t\tform.style.paddingLeft = '10px';\n\t\tform.style.top = '3.5em';\n\t\tform.style.height = '1.8em';\n\t\tform.addEventListener('keypress', (e) => this.searchKey(e.keyCode));\n\n\t\theader.appendChild(form);\n\t\theader.appendChild(document.createElement('br'));\n\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Hex', () => this.runSearch()));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('String', () => this.runSearchString()));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Code', () => this.runSearchCode()));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('ROP', () => this.runSearchROP()));\n\t\theader.appendChild(_helpers_Inputs__WEBPACK_IMPORTED_MODULE_1__.Inputs.button('Magic', () => this.runSearchMagic()));\n\n\t\tconst content = document.createElement('div');\n\t\tcontent.id = 'search_output';\n\t\tcontent.style.paddingTop = '50px';\n\t\tcontent.style.color = 'black';\n\t\tcontent.className = 'pre';\n\t\tc.appendChild(content);\n\n\t\treturn c;\n\t}\n\n\tsearchKey(keyCode) {\n\t\tvar inp = document.getElementById('search_input');\n\t\tif (keyCode === 13) {\n\t\t\tthis.runSearch(inp.value);\n\t\t\tinp.value = '';\n\t\t}\n\t}\n\n\trunSearchMagic() {\n\t\tr2.cmd('/m', searchResults);\n\t}\n\n\trunSearchCode(text) {\n\t\tif (!text) {\n\t\t\ttext = document.getElementById('search_input').value;\n\t\t}\n\t\tr2.cmd('\"/c ' + text + '\"', searchResults);\n\t}\n\n\trunSearchString(text) {\n\t\tif (!text) {\n\t\t\ttext = document.getElementById('search_input').value;\n\t\t}\n\t\tr2.cmd('/ ' + text, searchResults);\n\t}\n\n\trunSearchROP(text) {\n\t\tif (!text) {\n\t\t\ttext = document.getElementById('search_input').value;\n\t\t}\n\t\tr2.cmd('\"/R ' + text + '\"', searchResults);\n\t}\n\n\trunSearch(text) {\n\t\tif (!text) {\n\t\t\ttext = document.getElementById('search_input').value;\n\t\t}\n\t\tif (text.startsWith('\"') && text.endsWith('\"')) {\n\t\t\tconst a = text.replace(/\"/g, '');\n\t\t\tr2.cmd('/ ' + a, searchResults);\n\t\t} else {\n\t\t\tr2.cmd('\"/x ' + text + '\"', searchResults);\n\t\t}\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/SearchWidget.js?")},"./js/widgets/SettingsWidget.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"SettingsWidget\": () => (/* binding */ SettingsWidget)\n/* harmony export */ });\n/* harmony import */ var _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/R2Wrapper */ \"./js/core/R2Wrapper.js\");\n/* harmony import */ var _BaseWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BaseWidget */ \"./js/widgets/BaseWidget.js\");\n\n\n\n\nclass SettingsWidget extends _BaseWidget__WEBPACK_IMPORTED_MODULE_1__.BaseWidget {\n\n\tconstructor() {\n\t\tsuper('Settings');\n\t}\n\n\tinit() {\n\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Wrapper.registerListener(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.R2Actions.SEEK, () => {\n\t\t\tif (this.displayed) {\n\t\t\t\tthis.draw();\n\t\t\t}\n\t\t});\n\t}\n\n\tdraw() {\n\t\tthis.grid = document.createElement('div');\n\t\tthis.grid.className = 'mdl-grid';\n\t\tthis.node.appendChild(this.grid);\n\n\t\tthis.addGrid('Platform', (dom) => this.drawPlatform(dom));\n\t\tthis.addGrid('Disassembly', (dom) => this.drawDisassembly(dom));\n\t\tthis.addGrid('Core/IO', (dom) => this.drawCoreIO(dom));\n\t\tthis.addGrid('Analysis', (dom) => this.drawAnalysis(dom));\n\t\tthis.addGrid('Colors', (dom) => this.drawColors(dom));\n\t\tthis.addGrid('TTS', (dom) => this.drawTTS(dom));\n\t\tthis.addGrid('Reset configuration', (dom) => this.drawReset(dom));\n\t\tthis.addGrid('Emulator', (dom) => this.drawEmulator(dom));\n\n\t\tcomponentHandler.upgradeDom();\n\t}\n\n\tdrawPlatform(dom) {\n\t\t// TODO: Use aLj instead , see https://github.com/radareorg/radare2/issues/19982\n\t\tvar archs = ['x86', 'arm', 'mips', 'java', 'dalvik', '6502', '8051', 'h8300', 'hppa', 'i4004', 'i8008', 'lh5801',\n\t\t\t'lm32', 'm68k', 'mcs96', 'msp430', 'nios2', 'ppc', 'rar', 'sh', 'snes', 'sparc', 'spc700', 'sysz',\n\t\t\t'tms320', 'v810', 'v850', 'ws', 'xcore', 'prospeller', 'gb', 'z80', 'arc', 'avr', 'bf', 'cr16', 'cris', 'csr',\n\t\t\t'dcpu16', 'ebc'];\n\t\tuiSelect(dom, 'Platform', archs, archs.indexOf(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.PLATFORM)), function(item) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.PLATFORM, item);\n\t\t});\n\n\t\tvar bits = ['64', '32', '16', '8'];\n\t\tuiSelect(dom, 'Bits', bits, bits.indexOf(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.BITS)), function(item) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.BITS, item);\n\t\t});\n\n\t\tvar os = ['Linux', 'Windows', 'Android', 'iOS', 'Darwin', 'QNX', 'macOS'];\n\t\tuiSelect(dom, 'OS', os, os.indexOf(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.OS)), function(item) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.OS, item);\n\t\t});\n\t}\n\n\tdrawDisassembly(dom) {\n\t\tvar sizes = ['S', 'M', 'L'];\n\t\tuiSelect(dom, 'Size', sizes, sizes.indexOf(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.SIZE)), function(item) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.SIZE, item);\n\t\t});\n\t\tvar decoding = ['Pseudo', 'Opcodes', 'ATT'];\n\t\tuiSelect(dom, 'Decoding', decoding, decoding.indexOf(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.DECODING)), function(item) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.DECODING, item);\n\t\t});\n\t\tuiSwitch(dom, 'Utf8', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.UTF8), function(param, state) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.UTF8, state);\n\t\t});\n\t\tuiSwitch(dom, 'UpperCase', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.UCASE), function(param, state) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.UCASE, state);\n\t\t});\n\t\tuiSwitch(dom, 'Show Bytes', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.BYTES), function(param, state) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.BYTES, state);\n\t\t});\n\t\tuiSwitch(dom, 'DescribeOps', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.DESCRIBE), function(param, state) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.DESCRIBE, state);\n\t\t});\n\t}\n\n\tdrawEmulator(dom){\n\t\tuiSwitch(dom, 'Enable ESIL', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ASMEMU), function(param, state) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ASMEMU, state);\n\t\t});\n\t\tuiSwitch(dom, 'Enable ESIL (Strings Only)', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ASMEMUSTR), function(param, state) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ASMEMUSTR, state);\n\t\t});\n\t}\n\n\tdrawCoreIO(dom) {\n\t\tvar mode = ['PA', 'VA', 'PAVA', 'Debug'];\n\t\tuiSelect(dom, 'Mode', mode, mode.indexOf(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.MODE)), function(item) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.MODE, item);\n\t\t});\n\t}\n\n\tdrawAnalysis(dom) {\n\t\tvar configAnal = function(param, state, key) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(key, state);\n\t\t};\n\n\t\tuiSwitch(dom, 'HasNext', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ANAL_HAS_NEXT), function(param, state) {\n\t\t\treturn configAnal(param, state, _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ANAL_HAS_NEXT);\n\t\t});\n\t\tuiSwitch(dom, 'Skip Nops', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ANAL_SKIP_NOPS), function(param, state) {\n\t\t\treturn configAnal(param, state, _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ANAL_SKIP_NOPS);\n\t\t});\n\t\tuiSwitch(dom, 'NonCode', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ANAL_NON_CODE), function(param, state) {\n\t\t\treturn configAnal(param, state, _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.ANAL_NON_CODE);\n\t\t});\n\t}\n\n\tdrawColors(dom) {\n\t\tvar colors;\n\t\tr2.cmdj('ecoj', function(data) {\n\t\t\tcolors = data;\n\t\t});\n\n\t\tuiSwitch(dom, 'Colors', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.COLORS), function(param, state) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.COLORS, state);\n\t\t});\n\n\t\t// Randomize\n\t\tuiActionButton(dom, function() {\n\t\t\tr2.cmd('ecr', function() {\n\t\t\t\t// TODO: tmp, should be replaced by event \"color has changed\"\n\t\t\t\tuiContext.widgetContainer.updateManagers.updates.apply();\n\t\t\t});\n\t\t}, 'Randomize');\n\n\t\t// Set default\n\t\tuiActionButton(dom, function() {\n\t\t\tr2.cmd('ecd', function() {\n\t\t\t\t// TODO: tmp, should be replaced by event \"color has changed\"\n\t\t\t\tuiContext.widgetContainer.updateManagers.updates.apply();\n\t\t\t});\n\t\t}, 'Reset colors');\n\n\t\tuiSelect(dom, 'Theme', colors, colors.indexOf(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.THEME)), function(theme) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.THEME, theme);\n\t\t});\n\t}\n\n\n\tdrawTTS(dom) {\n\t\tuiSwitch(dom, 'Use TTS', _core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.getItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.USE_TTS), function(param, state) {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.setItem(_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.keys.USE_TTS, state);\n\t\t});\n\t}\n\n\tdrawReset(dom) {\n\t\tuiActionButton(dom, function() {\n\t\t\t_core_R2Wrapper__WEBPACK_IMPORTED_MODULE_0__.r2Settings.resetAll();\n\t\t\t// TODO, tmp (+ currently, would update only focused panel -> settings)\n\t\t\tuiContext.widgetContainer.updateManagers.updates.apply();\n\t\t}, 'RESET');\n\t}\n\n\taddGrid(name, drawFunc) {\n\t\tvar div = document.createElement('div');\n\t\tdiv.className = 'mdl-cell mdl-color--white mdl-shadow--2dp mdl-cell--4-col';\n\t\tdiv.style.padding = '10px';\n\t\tthis.grid.appendChild(div);\n\n\t\tvar title = document.createElement('span');\n\t\ttitle.className = 'mdl-layout-title';\n\t\ttitle.innerHTML = name;\n\t\tdiv.appendChild(title);\n\n\t\tvar content = document.createElement('div');\n\t\tdiv.appendChild(content);\n\n\t\tdrawFunc(content);\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/SettingsWidget.js?")},"./js/widgets/WidgetFactory.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "WidgetFactory": () => (/* binding */ WidgetFactory)\n/* harmony export */ });\n/* harmony import */ var _Widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Widgets */ "./js/widgets/Widgets.js");\n/* harmony import */ var _OverviewWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./OverviewWidget */ "./js/widgets/OverviewWidget.js");\n/* harmony import */ var _HexdumpWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./HexdumpWidget */ "./js/widgets/HexdumpWidget.js");\n/* harmony import */ var _DebuggerWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DebuggerWidget */ "./js/widgets/DebuggerWidget.js");\n/* harmony import */ var _FunctionsWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./FunctionsWidget */ "./js/widgets/FunctionsWidget.js");\n/* harmony import */ var _FlagsWidget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./FlagsWidget */ "./js/widgets/FlagsWidget.js");\n/* harmony import */ var _FlagsSpacesWidget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FlagsSpacesWidget */ "./js/widgets/FlagsSpacesWidget.js");\n/* harmony import */ var _SearchWidget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SearchWidget */ "./js/widgets/SearchWidget.js");\n/* harmony import */ var _ScriptWidget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ScriptWidget */ "./js/widgets/ScriptWidget.js");\n/* harmony import */ var _CommentsWidget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./CommentsWidget */ "./js/widgets/CommentsWidget.js");\n/* harmony import */ var _NotesWidget__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./NotesWidget */ "./js/widgets/NotesWidget.js");\n/* harmony import */ var _SettingsWidget__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./SettingsWidget */ "./js/widgets/SettingsWidget.js");\n/* harmony import */ var _DisassemblyWidget__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./DisassemblyWidget */ "./js/widgets/DisassemblyWidget.js");\n/* harmony import */ var _DisassemblyGraphWidget__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./DisassemblyGraphWidget */ "./js/widgets/DisassemblyGraphWidget.js");\n/* harmony import */ var _DisassemblyInfosWidget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./DisassemblyInfosWidget */ "./js/widgets/DisassemblyInfosWidget.js");\n/* harmony import */ var _DisassemblyFunctionsWidget__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./DisassemblyFunctionsWidget */ "./js/widgets/DisassemblyFunctionsWidget.js");\n/* harmony import */ var _DisassemblyFunctionsFullWidget__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./DisassemblyFunctionsFullWidget */ "./js/widgets/DisassemblyFunctionsFullWidget.js");\n/* harmony import */ var _DisassemblyBlocksWidget__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./DisassemblyBlocksWidget */ "./js/widgets/DisassemblyBlocksWidget.js");\n/* harmony import */ var _DisassemblyDecompileWidget__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./DisassemblyDecompileWidget */ "./js/widgets/DisassemblyDecompileWidget.js");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass WidgetFactory {\n\n\tconstructor() {\n\t\tthis.widgets = {};\n\t}\n\n\tget(widget) {\n\t\tif (!this.contains(widget)) {\n\t\t\tthis.instanciate_(widget);\n\t\t}\n\n\t\treturn this.widgets[widget];\n\t}\n\n\tcontains(widget) {\n\t\treturn typeof this.widgets[widget] !== \'undefined\';\n\t}\n\n\tinstanciate_(widget) {\n\t\tswitch (widget) {\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.OVERVIEW:\n\t\t\tthis.widgets[widget] = new _OverviewWidget__WEBPACK_IMPORTED_MODULE_1__.OverviewWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.DISASSEMBLY:\n\t\t\tthis.widgets[widget] = new _DisassemblyWidget__WEBPACK_IMPORTED_MODULE_12__.DisassemblyWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.DISASSEMBLY_GRAPH:\n\t\t\tthis.widgets[widget] = new _DisassemblyGraphWidget__WEBPACK_IMPORTED_MODULE_13__.DisassemblyGraphWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.DISASSEMBLY_INFOS:\n\t\t\tthis.widgets[widget] = new _DisassemblyInfosWidget__WEBPACK_IMPORTED_MODULE_14__.DisassemblyInfosWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.DISASSEMBLY_FUNCTIONS:\n\t\t\tthis.widgets[widget] = new _DisassemblyFunctionsWidget__WEBPACK_IMPORTED_MODULE_15__.DisassemblyFunctionsWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.DISASSEMBLY_FUNCTIONS_FULL:\n\t\t\tthis.widgets[widget] = new _DisassemblyFunctionsFullWidget__WEBPACK_IMPORTED_MODULE_16__.DisassemblyFunctionsFullWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.DISASSEMBLY_BLOCKS:\n\t\t\tthis.widgets[widget] = new _DisassemblyBlocksWidget__WEBPACK_IMPORTED_MODULE_17__.DisassemblyBlocksWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.DISASSEMBLY_DECOMPILE:\n\t\t\tthis.widgets[widget] = new _DisassemblyDecompileWidget__WEBPACK_IMPORTED_MODULE_18__.DisassemblyDecompileWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.HEXDUMP:\n\t\t\tthis.widgets[widget] = new _HexdumpWidget__WEBPACK_IMPORTED_MODULE_2__.HexdumpWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.DEBUGGER:\n\t\t\tthis.widgets[widget] = new _DebuggerWidget__WEBPACK_IMPORTED_MODULE_3__.DebuggerWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.FUNCTIONS:\n\t\t\tthis.widgets[widget] = new _FunctionsWidget__WEBPACK_IMPORTED_MODULE_4__.FunctionsWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.FLAGS:\n\t\t\tthis.widgets[widget] = new _FlagsWidget__WEBPACK_IMPORTED_MODULE_5__.FlagsWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.FLAGS_SPACE:\n\t\t\tthis.widgets[widget] = new _FlagsSpacesWidget__WEBPACK_IMPORTED_MODULE_6__.FlagsSpacesWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.SEARCH:\n\t\t\tthis.widgets[widget] = new _SearchWidget__WEBPACK_IMPORTED_MODULE_7__.SearchWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.SCRIPTS:\n\t\t\tthis.widgets[widget] = new _ScriptWidget__WEBPACK_IMPORTED_MODULE_8__.ScriptWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.COMMENTS:\n\t\t\tthis.widgets[widget] = new _CommentsWidget__WEBPACK_IMPORTED_MODULE_9__.CommentsWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.NOTES:\n\t\t\tthis.widgets[widget] = new _NotesWidget__WEBPACK_IMPORTED_MODULE_10__.NotesWidget();\n\t\t\tbreak;\n\t\tcase _Widgets__WEBPACK_IMPORTED_MODULE_0__.Widgets.SETTINGS:\n\t\t\tthis.widgets[widget] = new _SettingsWidget__WEBPACK_IMPORTED_MODULE_11__.SettingsWidget();\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tconsole.error(\'Not instanciable widget: \' + widget);\n\t\t}\n\t\t\n\t}\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/WidgetFactory.js?')},"./js/widgets/Widgets.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Widgets\": () => (/* binding */ Widgets)\n/* harmony export */ });\nconst Widgets = {\n\tOVERVIEW: 'overview',\n\tDISASSEMBLY: 'disassembly',\n\tDISASSEMBLY_GRAPH: 'disasm_graph',\n\tDISASSEMBLY_INFOS: 'disasm_infos',\n\tDISASSEMBLY_INFOS_FULL: 'disasm_infos_full',\n\tDISASSEMBLY_FUNCTIONS: 'disasm_functions',\n\tDISASSEMBLY_BLOCKS: 'disasm_blocks',\n\tDISASSEMBLY_DECOMPILE: 'disasm_decompile',\n\tHEXDUMP: 'hexdump',\n\tDEBUGGER: 'debugger',\n\tFUNCTIONS: 'functions',\n\tCLASSES: 'classes',\n\tFLAGS: 'flags',\n\tFLAGS_SPACE: 'flags_space',\n\tSEARCH: 'search',\n\tSCRIPTS: 'scripts',\n\tCOMMENTS: 'comments',\n\tNOTES: 'notes',\n\tSETTINGS: 'settings'\n}\n\n\n//# sourceURL=webpack://radare2-webui-material/./js/widgets/Widgets.js?")}},__webpack_module_cache__={};function __webpack_require__(t){var e=__webpack_module_cache__[t];if(void 0!==e)return e.exports;var n=__webpack_module_cache__[t]={exports:{}};return __webpack_modules__[t](n,n.exports,__webpack_require__),n.exports}__webpack_require__.d=(t,e)=>{for(var n in e)__webpack_require__.o(e,n)&&!__webpack_require__.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},__webpack_require__.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),__webpack_require__.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__("./js/app.js")})();
