# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class RulesService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """RulesService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def get_notification_rules_id_query(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a notification rule query.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_rules_id_query(rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: FluxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_rules_id_query_with_http_info(rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_rules_id_query_with_http_info(rule_id, **kwargs)  # noqa: E501
            return data

    def get_notification_rules_id_query_with_http_info(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a notification rule query.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_rules_id_query_with_http_info(rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: FluxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_notification_rules_id_query_prepare(rule_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}/query', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='FluxResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_notification_rules_id_query_async(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a notification rule query.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: FluxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_notification_rules_id_query_prepare(rule_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}/query', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='FluxResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_notification_rules_id_query_prepare(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['rule_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_notification_rules_id_query', all_params, local_var_params)
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in local_var_params or
                local_var_params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `get_notification_rules_id_query`")  # noqa: E501

        path_params = {}
        if 'rule_id' in local_var_params:
            path_params['ruleID'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
