/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.menu;

import com.projectlibre1.pm.graphic.IconManager;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.MenuFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;

public class ExtMenuFactory
extends MenuFactory {
    private Hashtable menuItems = new Hashtable();
    public static final String ICON_SUFFIX = ".icon";
    public static final String ACTION_SUFFIX = ".action";
    ActionMap actions;

    ExtMenuFactory(ActionMap actionMap, ResourceBundle ... resourceBundleArray) {
        super(actionMap, resourceBundleArray);
        this.actions = actionMap;
    }

    JMenuItem getMenuItemFromId(String string) {
        String string2 = this.getActionStringFromId(string);
        JMenuItem jMenuItem = null;
        if (string2 != null) {
            jMenuItem = (JMenuItem)this.menuItems.get(string2);
        }
        if (jMenuItem == null) {
            jMenuItem = (JMenuItem)this.menuItems.get(string);
        }
        return jMenuItem;
    }

    @Override
    protected void initializeJMenuItem(JMenuItem jMenuItem, String string) throws ResourceFormatException, MissingListenerException {
        super.initializeJMenuItem(jMenuItem, string);
        String string2 = this.getActionStringFromId(string);
        if (string2 != null) {
            this.menuItems.put(string2, jMenuItem);
        }
        try {
            String string3 = this.getString(string + ICON_SUFFIX);
            ImageIcon imageIcon = IconManager.getIcon(string3);
            if (imageIcon != null) {
                jMenuItem.setIcon(imageIcon);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public Action getActionFromId(String string) {
        return this.actions.getAction(this.getActionStringFromId(string));
    }

    public String getStringFromAction(Action action) {
        return this.actions.getStringFromAction(action);
    }

    public String getActionStringFromId(String string) {
        String string2 = null;
        try {
            string2 = this.getString(string + ACTION_SUFFIX);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public String getTextForId(String string) {
        return this.getString(string + ".text");
    }
}

