/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 * Test that the shm_unlink() function returns zero upon successful completion.
 */


#include <stdio.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "posixtest.h"

#define SHM_NAME "posixtest_6-1"

int main() {
	int fd;
	
	fd = shm_open(SHM_NAME, O_RDWR|O_CREAT, S_IRUSR|S_IWUSR);
	if(fd == -1) {
		perror("An error occurs when calling shm_open()");
		return PTS_UNRESOLVED;
	}

	if(shm_unlink(SHM_NAME) == 0 ) {
		printf("Test PASSED\n");
		return PTS_PASS;
	} else {
		perror("shm_unlink() does not return zero");
		return PTS_FAIL;
	}
	
}
